unit UnitOtherQueue;

{
    Purpose:
        Create a queue of arbitrary clipboard types

    Updates:
        New TClipQueue heavily simplifies this queue
}
interface

uses Classes, Windows, Graphics, UnitClipQueue;


type TOtherQueue = class(TClipQueue)
    private
        qClipsizeLimit : cardinal;
    public
        constructor Create;
        procedure SetClipSizeLimit(size : cardinal);
        procedure InsertAtStart(ci : TClipItem); overload;
        procedure AddNoSizeCheck(s : string; ci : TClipItem); override;
end;

var OtherQueue  : TOtherQueue;

implementation

uses clipbrd, unitfrmclipboardmanager, unitfrmmainpopup,  sysutils,
forms {for application object}, Dialogs;


/////////////////////
// Public Interface
/////////////////////

procedure TOtherQueue.AddNoSizeCheck(s: string; ci: TClipItem);
begin
    //inherited;

    sl.AddObject(s, ci);
end;

constructor TOtherQueue.Create;
begin
    inherited;
    self.qClipsizeLimit := $FFFFFFFF;
end;

procedure TOtherQueue.InsertAtStart(ci: TClipItem);
begin

    // enforce the max data size
    // use the format name for the "text version" of the clip
    if ci.GetDataSize <= self.qClipsizeLimit then begin
        ci.OverrideTextVersionOfItem(ci.GetFormatName);

        sl.InsertObject(0, ci.GetAsPlaintext, ci);
        self.SetQueueSize(self.qSize);
    end;
end;

procedure TOTherQueue.SetClipSizeLimit(size : cardinal);
begin
    qClipsizeLimit := size;
end;


initialization
   OtherQueue := TOtherQueue.Create;
end.
