unit UnitJS;

interface

uses UnitPaste;

type
TJavaScript = class(TObject)
    protected
        fRequiresFocus : boolean;
        function createJSLitteralString(const str : string) : string;
        function MacroToJS(const macro : string) : string;
    public
        procedure executeJS(hnd : THandle; paste : TPaste; javascript : string);
        class function getStartMacro : string;
        class function getEndMacro : string;
        class function getStartNoMacro : string;
        class function getEndNoMacro : string;

        class function getMacroString : string;
        function requiresFocus : boolean;
        class function isJavaScript(str : string) : boolean;
end;





implementation

uses UnitToken, SysUtils, StrUtils, Windows, UnitMisc, UnitFrmDebug, IOUtils,
Classes, Forms, VCL.Clipbrd, Dialogs, UnitClipQueue;


// The user will only see this function
const
JS_NL = #13#10;
JS_START_MACRO = 'start_ac_macro:'#13#10;
JS_END_MACRO = 'end_ac_macro:'#13#10;

JS_POPUP_CLIPS = 'popupClips';
JS_SET_POPUP_CLIPS = '//@set '+JS_POPUP_CLIPS+'[]=';
JS_SET_ON = '"on"';
JS_SET_OFF = '"off"';

JS_MAIN_HEADER =
    'function main(clipboardStr) {' + JS_NL +
    JS_SET_POPUP_CLIPS + JS_SET_OFF + JS_NL +
    '//change to "on" to include the Popup Clips list as a string array' + JS_NL +
    '//' + JS_NL +
    '// use manuallyExecuteMacro(string) for dynamically built macros' + JS_NL +
    '// use saveToPopupClips(string) to save text to the Popup Clips list' + JS_NL;
JS_MAIN_FOOTER =
    '}';
JS_MAIN_HEADER_W_MACRO =
    JS_MAIN_HEADER +
    JS_START_MACRO;
JS_MAIN_FOOTER_W_MACRO =
    JS_END_MACRO +
    JS_END_MACRO;

class function TJavaScript.isJavaScript(str : string) : boolean;
var i : integer;
begin
    i := ansiPos('function main(clipboardStr)', str);
    result := (i > 0) and (i<10);
end;

class function TJavaScript.getStartMacro : string;
begin
    result := JS_MAIN_HEADER_W_MACRO;
end;
class function TJavaScript.getEndMacro : string;
begin
    result := JS_MAIN_FOOTER_W_MACRO;
end;
class function TJavaScript.getMacroString : string;
begin
    result := getStartMacro + getEndMacro;
end;
class function TJavaScript.getStartNoMacro : string;
begin
    result := JS_MAIN_HEADER;
end;
class function TJavaScript.getEndNoMacro : string;
begin
    result := JS_MAIN_FOOTER;
end;



// the script will write AC Macros to the named pipe for communication
const PIPE_NAME = 'ACJavaScript';
const NL = JS_NL;
const
JS_FILE_HEADER =
    'var fs = new ActiveXObject("Scripting.FileSystemObject");     ' + NL +
    'var pipe = fs.OpenTextFile("\\\\.\\pipe\\'+PIPE_NAME+'", 8, false, 0);' +
    'function manuallyExecuteMacro(macro) {pipe.Write(macro);}' + JS_NL +
    'function saveToPopupClips(clip) {pipe.Write(''[newclip=\"''+clip.replace(''"'',''""'')+''\""]'');}' +JS_NL;
// insert statically instantiated objects here
//    function main() {
JF_MAIN_FOOTER =
//    '} // end main()
    'main(clipboardStr);' +  NL +
    'pipe.Write("END");' + NL +
    'pipe.Close();' +
    'WScript.Quit(1)';




function TJavaScript.createJSLitteralString(const str : string) : string;
begin
    result := str;
    if result[length(result)] = #0 then begin
        delete(result,length(result),1);
    end;
    result := ReplaceText(result, '\', '\\');
    result := ReplaceText(result, '''', '\''');
    result := ReplaceText(result, '"', '\"');
    result := ReplaceText(result, #13, '\r');
    result := ReplaceText(result, #10, '\n');
    result := '"' + result + '"';
end;
function TJavaScript.MacroToJS(const macro : string) : string;
var
    s : string;
begin
    s := macro;
    if macro[length(macro)] = #10 then begin
        delete(s,length(s)-1, 2);
    end;
    s := createJSLitteralString(s);
    result := 'pipe.Write('+ s +');' + NL;
end;
procedure TJavaScript.executeJS(hnd : THandle;paste : TPaste; javascript : string);
var s : string;
    macro : string;
    path : string;
    sl : TStringList;
    clipfile : string;
    h : THandle;
    function createPipe(name : string) : THandle;
    var
        s : string;
    const
        MAX_BUFFERS = 100;
        KILOBYTES = 1024;
        MAX_SECONDS = 10;
        MILLISECONDS = 1000;
        MAX_INSTANCES = 10;

    begin
        s := '\\.\pipe\' + name;
        result := CreateNamedPipe(
            PChar(S),
            PIPE_ACCESS_DUPLEX Or FILE_FLAG_WRITE_THROUGH,
            PIPE_WAIT Or PIPE_TYPE_MESSAGE Or PIPE_READMODE_MESSAGE,
            MAX_INSTANCES,
            MAX_BUFFERS * KILOBYTES, MAX_BUFFERS * KILOBYTES,
            MAX_SECONDS * MILLISECONDS,
            nil
        );
    end;

    function encodeACMacros(javascript : string) : string;
    var
        s : string;
    begin
        while (javascript <> '') do begin
            result := result + TokenString(javascript,JS_START_MACRO,false);
            if (javascript <> '') then begin
                macro := TokenString(javascript,JS_END_MACRO,false);
                result := result + macroToJS(macro);
            end;
        end;
    end;
    function wrapEncodedMacros(encodedMacros : string) : string;
    var
        i : integer;
        cnt : integer;
    begin
        result := '';
        cnt := ClipQueue.GetQueueCount;
        if PosI(JS_SET_POPUP_CLIPS+JS_SET_ON, encodedMacros) <> 0 then begin
            result := 'var '+JS_POPUP_CLIPS+'= [' ;
            for i:= 0 to cnt - 1  do begin
                result := result + self.createJSLitteralString(ClipQueue.GetClipItem(i).GetAsPlaintext);
                if (i<>(cnt - 1)) then begin
                    result := result + ',';
                end;
            end;
            result := result + '];' + JS_NL;
        end;
        result := result +

        JS_FILE_HEADER +
        'var clipboardStr = '+ createJSLitteralString(Clipboard.AsText) + ';'+ JS_NL +
        encodedMacros + JS_NL +

        JF_MAIN_FOOTER;


    end;

    function getErrorSize(errLog : string) : integer;
    var
        i : integer;
        ok : boolean;
        fs : TFileStream;
    begin
        i := 0;
        result := 0;
        repeat
            try
                ok := false;
                fs := TFileStream.Create(errLog, fmOpenRead);
                result := fs.Size;
                myfree(fs);
                ok := true;
            except
            end;
            inc(i);
        until ok or (i>20);
    end;
var
    byteCount : DWORD;
    bytesRead : Cardinal;
    buffer : array[0..1000*100] of byte;
    inMacro : string;
    endFound, emptyBuffer : boolean;
    fore : THandle;


    errLog : string;
    sz : int64;
begin
    s := encodeACMacros(javascript);
    s := wrapEncodedMacros(s);

    path := TPath.Combine(GetAppPath, 'JavaScript');
    if not DirectoryExists(path) then begin
        ForceDirectories(path);
    end;

    path := TPath.Combine(path, 'main.js');
    sl := TStringList.Create;
    sl.Add(s);
    sl.SaveToFile(path);
    myfree(sl);



    h := createPipe(PIPE_NAME);
    Application.ProcessMessages;
    fore := GetForegroundWindow;
    errLog := TPath.Combine(GetAppPath,'JavaScript\err.txt');
    DeleteFile(PChar(errLog));
    if UnitMisc.ShellExecute(
        hnd,
        'cmd /c cscript "'+path+'" 2> "'+errLog+'"'
    )= 0 then begin
        sz := getErrorSize(errLog);
        if sz = 0 then begin
            ConnectNamedPipe(h, nil);
            ForceForeground(fore);
            repeat
                inMacro := '';
                if ReadFile(h,buffer,sizeof(buffer),bytesRead,nil) then begin
                    buffer[bytesRead] := 0;
                    inMacro := inMacro + string(pansichar(@buffer));
                end;

                endFound := (inMacro = 'END');
                if not endFound then begin
                    Paste.SendTextWithKeystrokes(KEYS_STR+inMacro);
                end;
            until endFound or emptyBuffer;
            DisconnectNamedPipe(h);
        end else begin
            sl := TStringList.Create;
            sl.LoadFromFile(errLog);
            ShowMessage(sl.Text);
            myfree(sl);
        end;
    end;
   CloseHandle(h);


end;

function TJavaScript.requiresFocus : boolean;
begin
    result := fRequiresFocus;
end;
end.
