unit UnitFrmSearch;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, Contnrs, UnitClipQueue, UnitMenuItemTagdata;

type
  TfrmSearch = class(TForm)
    lvResults: TListView;
    timTypePause: TTimer;
    StatusBar1: TStatusBar;
    Panel1: TPanel;
    txtFind: TLabeledEdit;
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure txtFindKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure timTypePauseTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure lvResultsClick(Sender: TObject);
    procedure lvResultsMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lvResultsKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure lvResultsDrawItem(Sender: TCustomListView; Item: TListItem;
      Rect: TRect; State: TOwnerDrawState);
    procedure txtFindKeyPress(Sender: TObject; var Key: Char);
    procedure CreateParams(var Params: TCreateParams); override;
     procedure WMActivate(Var msg:tMessage); message WM_ACTIVATE;
  private
    { Private declarations }
        LastFind : string;
        TextToPaste : string;
        ObjectList : TObjectList;
        finitialtop : integer;
        SkipCleanup : boolean;
        LastClip : TClipITem;
        LastClipType : TItemType;
        FreeLastClip : boolean;
        fClipboardOnly : boolean;
        procedure StoreSelectedClip;
        procedure ClearResults;
  public
    { Public declarations }
        procedure ShowAutomatted(foregroundwindow : THandle=0);
        procedure ShowAutomattedPasteOnly;
        function GetTextToPaste : string;
        function GetClipToPaste : TClipItem;
        property initialtop : integer read finitialtop;
        property ClipboardOnly : boolean read fClipboardOnly write fClipboardOnly;
  end;

type
    TSearchItems = class(TThread)
private
    fabort : boolean;
    faborted : boolean;
protected
    procedure Execute; override;
public
    procedure Abort;
    procedure WaitAbort;
    property Aborted : boolean read faborted;
end;

var
  frmSearch: TfrmSearch;

implementation

uses UnitFrmPermanentNew,  UnitPaste, UnitTWideChar, UnitMisc,
   UnitFrmMainPopup, UnitPopupGenerate, Math, StrUtils, UnitFrmClipboardManager,
  UnitClipDatabase;

{$R *.dfm}

var src : TSearchItems;

const WIDTH_FUDGE = 2;
type TMenuItemTagData = class(TObject)
    caption : string;
    name : string;
    text : string;
    clip : TClipItem;
    prefix : string;
    itemtype : TItemType;
    itemindex : integer;
    icon : HICON;
    PermanentGroupID : integer;

    public
        constructor Create();
end;
constructor TMenuItemTagData.Create;
begin
    caption := '';
    name := '';
    text := '';
    prefix := '';
    clip := nil;
    itemtype := IT_NONE;
    itemindex := -1;
    icon := 0;
    PermanentGroupID := -1;
end;


procedure TfrmSearch.ClearResults;
var i : integer;
    mitd : TMenuItemTagData;
begin
  	//
    // Clips from the Remove Clips list are generated new
    // As are complex permanent clips
    // - not deleting them leaks memory
    // - don't delete the stored clip
    for I := 0 to objectlist.count - 1 do begin
        mitd := TMenuItemTagData(self.ObjectList.Items[i]);
        if mitd.itemtype = IT_TEMP then begin
            if (lastclip = nil) then begin
            	myfree(mitd.clip);
            end else if (mitd.clip.CData.Hash <> lastclip.CData.Hash)  then
                myfree(mitd.clip);
        end else if mitd.itemtype = IT_PERMANENT then begin
        	if mitd.clip <> nil then begin
            	myfree(mitd.clip);
            end;
        end;
    end;
    ObjectList.Clear;
    lvResults.Clear;
end;


procedure TfrmSearch.CreateParams(var Params: TCreateParams);
begin
    inherited;

    if CheckWin32Version(6, 0) then
       params.WindowClass.Style := params.WindowClass.style or CS_DROPSHADOW;

end;

procedure TfrmSearch.WMActivate(Var msg:tMessage);
begin
     {ignore all the inactive messages that appear until we've had a chance
    to paint and be visible to the user}
	if Msg.WParam = WA_INACTIVE then begin
        if Self.ModalResult  = mrNone then
            self.ModalResult := mrCancel;
    end;
end;

procedure TfrmSearch.FormCreate(Sender: TObject);
begin
    src := TSearchItems.Create(true);
    src.Priority := tpHigher;

    ObjectList := TObjectList.Create;

    lvResults.Columns[0].width := lvResults.ClientWidth - WIDTH_FUDGE;
end;


procedure TfrmSearch.ShowAutomatted(foregroundwindow:Thandle=0);
var
    h : THandle;
begin
	h := GetForegroundWindow;
    ForceForeground(self.Handle);

    TextToPaste := '';
    if (h=0) and (foregroundwindow=0) then begin
      	frmsearch.StatusBar1.Panels[1].Text := 'Pasting to Clipboard only';
        fClipboardOnly := true;
    end;
    self.SkipCleanup := true;
    if frmSearch.Visible = false then frmSearch.ShowModal;

    if foregroundwindow=0 then begin
    	ForceForeground(h);
    end else begin
        ForceForeground(foregroundwindow);
    end;


    if FrmSearch.ModalResult = mrOK then begin
    	if fClipboardOnly then begin
        	paste.SetClipboardOnlyOnce;
        end else begin
            if LastClipType = IT_TEMP then
                frmClipboardManager.DisablePasteProtectionOnce;
        end;
        if (uppercase(leftstr(self.TextToPaste,6))  = KEYS_STR) and (self.LastClipType = IT_PERMANENT) then begin
            Paste.SendTextWithKeystrokes(TextToPaste);
        end else begin
            Paste.SendText(self.TextToPaste, self.LastClip);
        end;
    end;

    fClipboardOnly := false;
end;
procedure TfrmSearch.ShowAutomattedPasteOnly;
var
    h : Thandle;
begin

	h := GetForegroundWindow;
    ForceForeground(self.Handle);
    TextToPaste := '';

    frmsearch.StatusBar1.Panels[1].Text := 'Pasting to Clipboard only';
    fClipboardOnly := true;

    self.SkipCleanup := true;
    if frmSearch.Visible = false then frmSearch.ShowModal;

    ForceForeground(h);


    if FrmSearch.ModalResult = mrOK then begin
    	if fClipboardOnly then begin
        	paste.SetClipboardOnlyOnce;
        end;
        if (uppercase(leftstr(self.TextToPaste,6))  = KEYS_STR) and (self.LastClipType = IT_PERMANENT) then begin
            Paste.SendTextWithKeystrokes(TextToPaste);
        end else begin
            Paste.SendText(self.TextToPaste, self.LastClip);
        end;
    end;

    fClipboardOnly := false;
end;

function TfrmSearch.GetClipToPaste: TClipItem;
begin
    result := self.LastClip;
end;
function TfrmSearch.GetTextToPaste: string;
begin
    result := TextToPaste;
end;


procedure TfrmSearch.FormShow(Sender: TObject);
var h : THandle;
begin
    h := Windows.GetForegroundWindow;
    if h <> self.Handle then begin
        if UnitMisc.ThreadAttach(h) then begin
            Windows.SetForegroundWindow(self.handle);
            UnitMisc.ThreadDetach;
        end;
    end;


    if (LastClip <> nil) then begin
    	if FreeLastClip then begin
        	myfree(LastClip);
        end;
    	LastClip := nil;
    end;
    StatusBar1.panels[0].text := 'Keys:  [Up/Down]  [Pageup/Pagedown]  [Enter/Esc]';


    frmsearch.Top := (screen.Height div 2) - (frmsearch.clientheight div 2);
    frmsearch.left := (screen.Width div 2) - (frmsearch.Width div 2);

    Application.ProcessMessages;
    finitialtop := self.BoundsRect.top;
    self.ClearResults;
    txtFind.SetFocus;
    txtFind.SelectAll;
    if txtfind.Text <> '' then begin
        src.Abort;
        src.Execute;
    end;
end;
procedure TfrmSearch.FormHide(Sender: TObject);
begin
    if not src.Suspended then begin
        src.Abort;
        src.WaitFor;
    end;

    if self.ModalResult = mrOK then self.StoreSelectedClip;
    self.ClearResults;
end;
procedure TfrmSearch.StoreSelectedClip;
var     mitd : TMenuItemTagData;
    i : integer;

    newclip : string;
    location : string;
begin
    FreeLastClip := false;

    if lvResults.Selected = nil then EXIT;

    i := integer(lvResults.Selected.data);
    mitd := TMenuItemTagData(self.ObjectList.Items[ i  ]);


    newclip := mitd.caption;
    LastClipType := mitd.itemtype;
    case mitd.itemtype of
        IT_POPUPCLIP, IT_TEMP: begin
            LastClip := mitd.clip;
        end;
        IT_PERMANENT: begin
            location := frmPermanent.PermFoldersGetItem( mitd.PermanentGroupID  );
            LastClip := TClipItem.Create;
            TClipDatabase.LoadPermanent(LastClip,mitd.itemindex, location);
            FreeLastClip := true;
        end;
    end;
end;
procedure TfrmSearch.lvResultsDrawItem(Sender: TCustomListView; Item: TListItem;Rect: TRect; State: TOwnerDrawState);
var wc : TWideChar;
    ci : TClipItem;
    c : TColor;
    mitd : TMenuItemTagData;
    ico : HICON;
    h, th : integer;

    cnv : TCanvas;
begin
	cnv := TListView(Sender).Canvas;
    cnv.Brush.Style := bsClear;

    h := (rect.Bottom - rect.top) + 1;
    th := cnv.TextHeight('ALKJDFIOJ');


    c := cnv.Pen.Color;
    if Item.Selected  then begin
        cnv.Pen.Color := clHighlight;
        cnv.Brush.Color := dimcolor(clWindow);
    end else begin
        cnv.Pen.Color := clWindow;
        cnv.Brush.Color := clWindow;
    end;
        {rect.left := 0;
        rect.Right := rect.left + (lvResults.Width);}
    cnv.Rectangle(rect);
    InflateRect(rect,-1,-1);
    cnv.FillRect(rect);
    InflateRect(rect,1+WIDTH_FUDGE,1);

    cnv.Pen.Color := c;

    mitd := TMenuItemTagData(ObjectList.items[integer(item.data)]);
    if UnitMisc.UniSupported then begin
        wc := TWideChar.Create;

        case mitd.itemtype of
            IT_POPUPCLIP: wc.Append('[Popup]:    ');
            IT_TEMP: wc.Append('[Removed]:  ');
            IT_PERMANENT: wc.Append('[Permanent]: ');
        end;
        if mitd.clip = nil then begin
            wc.AppendUnicode(mitd.caption);
            ico := UnitClipQueue.ClipDataDefaultIcon;
        end else begin
            ci := mitd.clip;
            wc.AppendUnicode(ci.GetAsPlaintext);

            ico := ci.CData.GetHICON;
        end;

        DrawIconEX(
            cnv.handle
            , rect.Left+2, rect.Top+1, ico,
            h-2, h-2,
            0,0,DI_NORMAL
        );

        if (h  <=  th) then begin
            Windows.TextOutW(
                cnv.Handle ,
                rect.Left + h + 3, rect.Top, wc.Memory, wc.StrLength
            );
        end else begin
            Windows.TextOutW(
                cnv.Handle ,
                rect.Left + h + 3, floor((h-th)/2) + rect.Top, wc.Memory, wc.StrLength
            );
        end;
    end else begin
        Windows.TextOut(
            cnv.Handle,
            rect.Left, rect.Top, pchar(mitd.caption) , length(mitd.caption)
            );
    end;

end;

{mouse keyboard interactions}
procedure TfrmSearch.timTypePauseTimer(Sender: TObject);
begin
    timTypePause.Enabled := false;
    if txtFind.text = '' then lvResults.Items.Clear;
    if lastfind <> txtFind.text then begin
        self.ClearResults;
        if not src.Suspended then begin
        	src.Abort;
            src.WaitFor;
        end;
        Src.Execute;
    end;

    lastFind := txtFind.text;
end;
procedure TfrmSearch.txtFindKeyDown(Sender: TObject; var Key: Word;Shift: TShiftState);
begin
    timTypePause.Enabled := false;
    timTypePause.Enabled := true;

    if (key = VK_RETURN) or (key = VK_ESCAPE) then begin
        key := 0;
    end;
end;
procedure TfrmSearch.txtFindKeyPress(Sender: TObject; var Key: Char);
begin
    if (key=chr(vk_return)) or (key=chr(VK_ESCAPE)) then begin
        key := #0;
    end;
end;
procedure TfrmSearch.FormKeyDown(Sender: TObject; var Key: Word;Shift: TShiftState);
begin
    if key = VK_ESCAPE  then begin
        key := 0;
        self.ModalResult := mrCancel;
    end;
    if lvresults.Items.Count = 0 then EXIT;

    case key of
    VK_UP:
        begin
        if lvresults.Selected.Index <> 0 then begin
            lvresults.Selected := lvresults.items[lvresults.Selected.index -1];
        end;
        lvresults.Selected.MakeVisible(false);
        key := 0;
        end;
    VK_DOWN:
        begin
        if lvresults.Selected.Index <> (lvresults.items.count-1) then begin
            lvresults.Selected := lvresults.items[lvresults.Selected.index +1];
        end;
        lvresults.Selected.MakeVisible(false);
        
        key := 0;
        end;
    VK_RETURN:
        begin
            key := 0;

            self.TextToPaste := '';
            if lvresults.Selected <> nil then begin
                self.TextToPaste := lvResults.Selected.caption;
                self.modalresult := mrOK;
            end;
        end;
    VK_NEXT: // page down
        begin
            lvResults.Scroll(0,lvResults.height -50);
            lvResults.Selected := lvResults.TopItem;
        end;
    VK_PRIOR: // page up
        begin
            lvResults.Scroll(0,-lvResults.height +50);
            lvResults.Selected := lvResults.TopItem;            
        end;

    end;
end;
procedure TfrmSearch.lvResultsClick(Sender: TObject);
begin
    txtFind.SetFocus;
end;
procedure TfrmSearch.lvResultsKeyDown(Sender: TObject; var Key: Word;Shift: TShiftState);
begin
    if key=VK_ESCAPE then begin
        key := 0;
        self.ModalResult := mrCancel;
    end;
    txtFind.SetFocus;
end;
procedure TfrmSearch.lvResultsMouseDown(Sender: TObject; Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
  var li : TListItem;
begin
    li := lvResults.GetItemAt(x,y);
    if li <> nil then begin
        self.TextToPaste := li.caption;
        self.ModalResult := mrOK;
    end;
end;

{ TSearchItems }

procedure TSearchItems.Abort;
begin
    self.fabort := true;
end;
procedure TSearchItems.WaitAbort;
begin
	{WaitFor does the same thing?}
    self.Abort;
    while not self.Aborted do mysleep(10);
end;
procedure TSearchItems.Execute;
var i,j, x, TestCnt : integer;
    find, text,textNobreak : string;
    li : TListItem;
label    AbortExit;

    function TestText(sub, source : string) : boolean;
    var res : integer;
        original : string;
        mitd : TMenuItemTagData;
    begin
    	if (testCnt mod 10) = 0 then Application.ProcessMessages;

        original := source;
        sub := lowercase(sub);
        source := lowercase(source);

        // favor items with searchstring at the start
        res := pos(sub, source);
        li := nil;
        if (res > 0) and (res < 5) then begin
            li := FrmSearch.lvResults.Items.Insert(0);
        end else if (res > 0) then begin
            li := frmSearch.lvResults.Items.Add;
        end;
        result := false;
        if (li <> nil) then begin
        	inc(TestCnt);
			li.Caption := Original;
            result := true;
        	mitd := TMenuItemTagData.Create;
            li.Data := Pointer(frmsearch.ObjectList.add(mitd));
        end;
    end;
var mitd : TMenuItemTagData;
    lasthint : string;
    ci : TClipItem;
    cl : TClipList;
    caption : string;
begin
    inherited;
    fabort := false;
    faborted := false;

    lasthint := frmsearch.StatusBar1.Panels[1].Text;
    frmsearch.StatusBar1.Panels[1].Text := 'Searching ...';
    frmsearch.lvResults.Height := 145;
    frmsearch.AutoSize := false;
    frmsearch.Height := 100;
    frmsearch.AutoSize := true;
    Application.ProcessMessages;

    TestCnt := 0;
    find := frmSearch.txtFind.Text;

    if find <> '' then begin
        // search both name and contents of Perm Items
        TClipDatabase.StartBatch;
        cl := TClipList.Create(true);
        for i := 0 to FrmPermanent.PermFoldersGetCount - 1 do begin
            TClipDatabase.LoadPermanentClips(cl, frmPermanent.PermFoldersGetItem(i));
            for j := 0 to cl.Count - 1 do begin
                ci := cl[j];
                text := ci.getDisplayText;
                if not TestText(find, text) then begin
                    if (ci.GetFormatType = FT_UNICODE) then begin
                        text := ci.GetAsPlaintext;
                        if TestText(find, text) then begin
                            mitd := TMenuItemTagData(frmsearch.ObjectList.Items[integer(li.data)]);
                            mitd.caption := text;
                            mitd.itemtype := IT_PERMANENT;
                            mitd.PermanentGroupID := i;
                            mitd.itemindex := j;
                       end;
                    end;
                end else begin
                    li.caption := ci.GetAsPlaintext;
                    mitd := TMenuItemTagData(frmsearch.ObjectList.Items[integer(li.data)]);
                    mitd.caption := li.caption;
                    mitd.itemtype := IT_PERMANENT;
                    mitd.PermanentGroupID := i;
                    mitd.itemindex := j;
                    mitd.clip := TClipItem.Create;
                    TClipDatabase.LoadPermanent(mitd.clip,j, frmPermanent.PermFoldersGetItem(i));
                end;

                if self.fabort then BREAK;
            end;
            cl.Clear;
            if self.fabort then goto AbortExit;
        end;
        myfree(cl);

        for i := 0 to ClipQueue.GetQueueCount - 1 do begin
            text := ClipQueue.GetItemText(i);
            if TestText(find, text) then begin
                mitd := TMenuItemTagData(frmsearch.ObjectList.Items[integer(li.data)]);
                mitd.caption := text;
                mitd.clip := ClipQueue.GetClipItem(i);
                mitd.itemtype := IT_POPUPCLIP;
                mitd.itemindex := i;
            end;
            if self.fabort then goto AbortExit;
        end;
        TClipDatabase.EndBatch;

        TClipDatabase.StartTextOnlyData;
        i := 0;
        textNobreak := StringReplace(find, chr($20), chr($a0),[rfReplaceAll]);
        while (TClipDatabase.LoadNextText(text)) do begin
            if TestText(textNobreak, text) then begin
                mitd := TMenuItemTagData(frmsearch.ObjectList.Items[integer(li.data)]);
                mitd.caption := text;
                mitd.itemtype := IT_TEMP;
                mitd.clip := RemovedQueue.GetItemClip(i);
                mitd.itemindex := i;
            end;
            if self.fabort then begin
                TClipDatabase.EndTextOnlyData;
                goto AbortExit;
            end;
            inc(i);
        end;
        TClipDatabase.EndTextOnlyData;
    end;

AbortExit:

    if fabort then faborted := true;
    frmsearch.StatusBar1.Panels[1].Text := lasthint;
    Application.ProcessMessages;
    if fabort then EXIT;

    frmsearch.lvresults.align := alnone;
    frmsearch.lvresults.clientheight := 200;
    frmsearch.Top := (screen.Height div 2) - ((frmsearch.BoundsRect.Bottom - frmsearch.BoundsRect.Top) div 2);
    frmsearch.left := (screen.Width div 2) - (frmsearch.clientWidth div 2);

    if frmsearch.lvResults.selected = nil then begin
        if frmsearch.lvResults.Items.Count > 0 then begin
            frmsearch.lvResults.selected := frmsearch.lvResults.items[0];
        end;
    end;
    Application.ProcessMessages;
    x := frmsearch.lvResults.Canvas.TextHeight('ABCDEFGHIJLKMNONQ');
    while (frmsearch.lvResults.VisibleRowCount < frmsearch.lvResults.Items.Count) and
        (frmsearch.height < 650) do begin
        frmsearch.lvResults.clientheight := frmsearch.lvResults.clientheight + X + 2;
        Application.ProcessMessages;
        frmsearch.Top := frmsearch.top - 6;
    end;


    frmsearch.AutoSize := false;
    frmsearch.height := frmsearch.lvResults.ClientHeight + frmsearch.Panel1.height + frmsearch.StatusBar1.Height - 100;
    frmsearch.AutoSize := true;


    Application.ProcessMessages;
    frmsearch.lvResults.clientheight := frmsearch.lvResults.clientheight + X * 2;
    frmsearch.lvresults.align := alclient;

    frmsearch.Top := (screen.Height div 2) - ((frmsearch.BoundsRect.Bottom - frmsearch.BoundsRect.Top) div 2);
    frmsearch.left := (screen.Width div 2) - (frmsearch.clientWidth div 2);

end;


end.
