unit UnitFrameImport;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes,
  Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ComCtrls,
  Vcl.Menus, Vcl.ExtCtrls;

type
  TFrameImport = class(TFrame)
    cbxNames: TComboBox;
    pcImport: TPageControl;
    tsPopup: TTabSheet;
    tsRemoved: TTabSheet;
    tsPerm: TTabSheet;
    lbPopup: TListBox;
    lbPermanent: TListBox;
    lbRemoved: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    pmContext: TPopupMenu;
    MICopy1: TMenuItem;
    MICopytoRemoved1: TMenuItem;
    N1: TMenuItem;
    MIImportPermanent1: TMenuItem;
    cbxClips: TComboBox;
    pnl1: TPanel;
    lblSizeHeader: TLabel;
    lblLocalSize: TLabel;
    lblCompact: TLabel;
    procedure cbxNamesClick(Sender: TObject);
    procedure lbPopupMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure pmContextPopup(Sender: TObject);
    procedure MICopy1Click(Sender: TObject);
    procedure MICopytoRemoved1Click(Sender: TObject);
    procedure MIImportPermanent1Click(Sender: TObject);
    procedure cbxClipsChange(Sender: TObject);
    procedure lblCompactClick(Sender: TObject);
  private
    { Private declarations }
    clickedLB : TListBox;
  public
    { Public declarations }
    procedure load;
  end;

implementation

{$R *.dfm}

uses UnitClipDatabase, UnitMisc, UnitClipQueue, UnitPaste, StrUtils,
  UnitFrmPermanentNew, UnitFrmClipboardManager, UnitFrmDatabaseUpdate;


procedure TFrameImport.load;
var
    sl : TStringList;
    s : string;
    i : integer;
begin
    lblLocalSize.Caption := Format('%n KB',[TClipDatabase.getSizeBytes / 1024]);

    sl := TStringList.Create;
    TClipDatabase.getDBNames(sl);

    for i := 0 to pcImport.PageCount - 1 do begin
        pcImport.Pages[i].TabVisible := false;
    end;
    pcImport.ActivePageIndex := 0;

    if sl.Count = 0 then EXIT;


    lbPopup.Clear;
    lbRemoved.Clear;
    lbPermanent.Clear;

    cbxNames.Items.Clear;
    for s in sl do begin
        cbxNames.Items.Add(s)
    end;
    cbxNames.ItemIndex := -1;



    cbxClips.ItemIndex := 0;
end;



procedure TFrameImport.cbxNamesClick(Sender: TObject);
var
    sl : TStringList;
    s : string;
begin
    lbPopup.Clear;
    lbRemoved.Clear;
    lbPermanent.Clear;

    sl := TStringList.Create;
    TClipDatabase.getPopupCaptions(cbxNames.Text, sl);
    for s in sl do begin
        lbPopup.Items.Add(s);
    end;
    sl.Clear;

    TClipDatabase.getRemovedCaptions(cbxNames.Text, sl);
    for s in sl do begin
        lbRemoved.Items.Add(s);
    end;
    sl.Clear;

    TClipDatabase.getPermanentCaptions(cbxNames.Text, sl);
    for s in sl do begin
        lbPermanent.Items.Add(s);
    end;
    sl.Clear;

    myfree(sl);
end;

procedure TFrameImport.cbxClipsChange(Sender: TObject);
begin
    pcImport.ActivePageIndex := cbxClips.ItemIndex;
end;

procedure TFrameImport.lblCompactClick(Sender: TObject);
begin
    frmDatabaseUpdate.MyShow;
    TClipDatabase.vacuum;
    frmDatabaseUpdate.MyHide;

    self.load;
end;

procedure TFrameImport.lbPopupMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
    lb : TListBox;
begin
    lb := TListBox(Sender);
    clickedLB := lb;

    lb.ItemIndex := lb.ItemAtPos(point(x,y),true);
    if lb.ItemIndex >= 0 then begin
        if lb.Selected[lb.ItemIndex] then begin

        end else begin
            lb.Selected[lb.ItemIndex] := true;
        end;
    end;


    if (button = mbRight) then begin
        pmContext.Popup(mouse.CursorPos.X+5,mouse.CursorPos.Y+5);
    end;
end;


procedure TFrameImport.MICopy1Click(Sender: TObject);
var
    ci : TClipItem;
    i, x : integer;
begin
    ci := TClipItem.Create;
    for i:=0 to clickedLB.Count-1 do begin
        if clickedLB.Selected[i] then begin
            x := i;
            BREAK;
        end;
    end;


    TClipDatabase.StartBatch(cbxNames.Text);
    if (clickedLB = lbPopup) then begin
        TClipDatabase.LoadNormal(ci, x);
    end else if (clickedLB = lbRemoved) then begin
        TClipDatabase.LoadRemoved(ci, x);
    end;
    TClipDatabase.EndBatch;

    Paste.SetClipboardOnlyOnce;
    FrmClipboardManager.DisablePasteProtectionOnce;
    Paste.SendText('', ci);
    myfree(ci);
end;

procedure TFrameImport.MICopytoRemoved1Click(Sender: TObject);
var
    ci : TClipItem;
    cl : TClipList;
    i : integer;
begin
    cl := TClipList.Create(true);
    TClipDatabase.StartBatch(cbxNames.Text);
    for i := 0 to clickedLB.Count-1 do begin
        if clickedLB.Selected[i] then begin
            ci := TClipItem.Create;
            if (clickedLB = lbPopup) then begin
                TClipDatabase.LoadNormal(ci, i);
            end else if (clickedLB = lbRemoved) then begin
                TClipDatabase.LoadRemoved(ci, i);
            end;
            ci.CData.setTimeStamp(Now);
            cl.Add(ci);
        end;
    end;
    TClipDatabase.EndBatch;

    for i:=0 to cl.Count-1 do begin
        ci := cl[i];
        RemovedQueue.InsertAtStart(ci);
    end;
    cl.Clear;
    myfree(cl);
end;

procedure TFrameImport.MIImportPermanent1Click(Sender: TObject);
var
    ci : TClipItem;
    cl : TClipList;
    sl, slGroups : TStringList;
    i,j, x : integer;
    group, s, lastGroup : string;
begin
    group := '';
    j := 0;

    cl := TClipList.Create(true);
    sl := TStringList.Create;
    TClipDatabase.StartBatch(cbxNames.Text);
    for i := 0 to clickedLB.Count-1 do begin
        s := clickedLB.Items[i];
        x := Pos(':',s)-1;
        group := MidStr(s,1,x);
        if (i=0) then begin
            lastGroup := group;
        end;


        if (group <> lastGroup) and (lastGroup <> '') then begin
            j := 0;
            lastGroup := group;
        end;
        if clickedLB.Selected[i] then begin
            ci := TClipItem.Create;
            TClipDatabase.LoadPermanent(ci, j, group);
            cl.Add(ci);
            sl.Add(group);
        end;
        inc(j);
    end;
    TClipDatabase.EndBatch;

    TClipDatabase.StartBatch;
    slGroups := TStringList.Create;
    TClipDatabase.LoadPermanentGroups(slGroups);

    for i := 0 to cl.Count-1 do begin
        ci := cl[i];
        group := sl[i];
        x := TClipDatabase.getCountPermanent(group);
        if (slGroups.IndexOf(group)=-1) then begin
            TClipDatabase.SavePermanentGroup(group, 0);
        end;
        TClipDatabase.SavePermanent(ci,x,group);
    end;

    myfree(slgroups);
    TClipDatabase.EndBatch;

    myfree(cl);
    myfree(sl);
end;

procedure TFrameImport.pmContextPopup(Sender: TObject);
begin
    MIImportPermanent1.Enabled := false;
    MICopy1.Enabled := true;
    MICopytoRemoved1.Enabled := true;

    if (clickedLB = lbPopup) or (clickedLB = lbRemoved) then begin
        MICopy1.Enabled := clickedLB.SelCount = 1;
    end else if (clickedLB = lbPermanent) then begin
        MICopy1.Enabled := false;
        MICopytoRemoved1.Enabled := false;
        MIImportPermanent1.Enabled := true;
    end;
end;

end.
