unit UnitDrawGesture;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls;

type
  TFrmDrawGesture = class(TForm)
    imgScratch: TImage;
  private
    { Private declarations }
    img2 : Timage;
  public
    { Public declarations }
        procedure GetImage(gesture : string; c : Tcanvas; wd,ht : integer);
  end;

var
  FrmDrawGesture: TFrmDrawGesture;

implementation

uses UnitFrmMouseMonitor, Math, UnitMisc;

{$R *.dfm}

procedure TFrmDrawGesture.GetImage(gesture: string; c : Tcanvas; wd,ht:integer);
var i,j, x,y,  z, maxX, maxY, minX, minY,
    startX,startY,endX,endY, a, xcount,ycount,
    gestwd, gestht : integer;
    g : TMouseDirection;
    //bm : TBitmap;
    lastd : TMouseDirection;
    ar : integer;
    len : integer;
begin
    //self.Show;


    len := 50;
    i := trunc(imgScratch.Height / 2);
    j := trunc(imgScratch.Width / 2);
    maxX := 0;
    maxY := 0;
    lastD := mdNone;
    c.Pen.Style := psSolid;
    c.Rectangle(c.ClipRect);
    c.Pen.Color := clBlack;
    c.Pen.Width := 1;
    c.Pen.Style := psDot;

    //imgScratch.Canvas.pen.Style := psInsideFrame;
    startX := i;
    starty := j;
    xcount := 0;
    ycount := 0;
    //imgScratch.Canvas.MoveTo(i,j);
    for z := 1 to length(gesture) do begin
        g := TMouseDirection(StrToInt(gesture[z]));
        x := i;
        y := j;
        if z = 1 then begin
            minX := x;
            minY := y;
            maxX := x;
            maxY := y;
        end;

        case g of
            mdUp: y := j - len;
            mdDown: y := j + len;
            mdLeft: x := i -len;
            mdRight: x := i + len;
            mdNE: begin
                y := j - len;
                x := i + len;
            end;
            mdNW: begin
                y := j - len;
                x := i - len;
            end;
            mdSW: begin
                y := j + len;
                x := i - len;

            end;
            mdSE: begin
                y := j + len;
                x := i + len;
            end;
        end;
        if z <> 1 then begin

        if (g in [mdup, mddown]) and (lastd in [mdup, mddown])  then begin
            //Canvas.MoveTo(i+8,j);
            x := x + 8;
        end;
        if (g in [mdRight, mdLeft]) and (lastd in [mdRight, mdLeft])  then begin
            //imgScratch.Canvas.MoveTo(i,j+8);
            y := y + 8;
        end;
        end;


        i := x;
        j := y;

        maxX := max(maxX, x);
        maxY := max(maxY, y);
        minX := min(minX, X);
        minY := min(minY, Y);
        lastd := g;
    end;
    endx := i;
    endy := j;
    dec(minx, 4);
    dec(miny, 4);
    inc(maxx, 4);
    inc(maxy, 4);
    len := trunc(max((maxy-miny),(maxx-minx))/50);

    len := trunc((max(wd,ht)-25)/len);
    len := len - 1;


    i := trunc(ht / 2);
    j := trunc(wd / 2);
    lastD := mdNone;


    gestwd := maxx - minx;
    gestht := maxy - miny;

    // change origin
    startx := trunc(((startx - min(minx, maxx)) / gestwd) * wd);
    starty := trunc(((starty - min(miny,maxy)) / gestht) * wd);


    if startx < endx then begin
        i := startx + 3;
    end else begin
        i := startx - 3;
    end;
    if starty < endy then begin
        j := starty + 3;
    end else begin
        j := starty - 3;
    end;
 


    c.MoveTo(i,j);
    for z := 1 to length(gesture) do begin
        g := TMouseDirection(StrToInt(gesture[z]));
        x := i;
        y := j;
        if z = 1 then begin
            minX := x;
            minY := y;
            maxX := x;
            maxY := y;
        end;

        case g of
            mdUp: y := j - len;
            mdDown: y := j + len;
            mdLeft: x := i -len;
            mdRight: x := i + len;
             mdNE: begin
                y := j - len;
                x := i + len;
            end;
            mdNW: begin
                y := j - len;
                x := i - len;
            end;
            mdSW: begin
                y := j + len;
                x := i - len;

            end;
            mdSE: begin
                y := j + len;
                x := i + len;
            end;
        end;
        if z <> 1 then begin

        if (g in [mdup, mddown]) and (lastd in [mdup, mddown])  then begin
            c.LineTo(i+8,j);
            x := x + 8;
        end;
        if (g in [mdRight, mdLeft]) and (lastd in [mdRight, mdLeft])  then begin
            c.LineTo(i,j+8);
            y := y + 8;
        end;
        end;


        i := x;
        j := y;

        c.LineTo(i,j);
        c.brush.color := clBlack;
        c.FillRect(rect(i-2,y-2,i+2,y+2));
        c.brush.color := clWhite;
        lastd := g;
    end;

end;

end.
