@echo off
title Festplattenprfung mit CHKDSK

:: Fenster auf vernnftige Gre bringen
mode con: cols=80 lines=25

:: Benutzername und Desktop ermitteln
set "logfile=%USERPROFILE%\Desktop\CHKDSK_Log.txt"

:: Startbildschirm
cls
echo ============================================
echo      Festplatte auf Fehler prfen (CHKDSK)
echo ============================================
echo.
echo Welche Festplatte soll geprft werden?
echo (Nur den Laufwerksbuchstaben eingeben, z.B. D)
echo.
wmic logicaldisk get name,volumename,filesystem
echo.
set /p drive=Bitte Laufwerksbuchstaben eingeben (ohne Doppelpunkt): 

:: Eingabe validieren
if "%drive%"=="" (
    echo Ungltige Eingabe. Script wird beendet.
    pause
    exit /b
)

:: Laufwerksbuchstaben in Grobuchstaben umwandeln
for %%A in (%drive%) do set "drive=%%~A"
set "drive=%drive:~0,1%"
set "drive=%drive::=%"

:: Finaler Laufwerksbuchstabe
set "target=%drive%:"

:: Prfung starten
cls
echo Starte CHKDSK auf Laufwerk %target%
echo Bitte warten  dies kann je nach Festplattengre einige Zeit dauern...

echo ================================ > "%logfile%"
echo CHKDSK Protokoll fr Laufwerk %target% >> "%logfile%"
echo Datum: %DATE% Uhrzeit: %TIME% >> "%logfile%"
echo ================================ >> "%logfile%"
echo. >> "%logfile%"

:: Prfung mit Fehlerbehebung und Sektorprfung
chkdsk %target% /f /r >> "%logfile%"

echo. >> "%logfile%"
echo ================================ >> "%logfile%"
echo Prfung abgeschlossen. >> "%logfile%"

echo.
echo Die berprfung von %target% ist abgeschlossen.
echo Das Protokoll wurde auf dem Desktop gespeichert:
echo %logfile%
pause
exit
