function AccountExport(account) {
	var account = accountManager.getAccount(account);
  var server = account.incomingServer;
//  var identity = account.defaultIdentity;

  var DateiName = null;

  if (server.type == "pop3" || server.type == "imap") {
    DateiName = server.type + "_" + server.prettyName;
  } else if (server.type == "nntp") {
    DateiName = server.type + "_" + server.hostName;    
  } else if (server.type == "none") {
    DateiName = server.prettyName;
  }
  DateiName = DateiName + ".rdf";

  filePicker.init(window, strbundle.getString("SaveFile"), nsIFilePicker.modeSave);

  filePicker.appendFilter(strbundle.getString("AccountFile") + " (*.rdf)","*.rdf;");
  filePicker.defaultString=DateiName;

  nResult=filePicker.show();
  if(nResult == nsIFilePicker.returnOK || nResult == nsIFilePicker.returnReplace) {
  /*****************************************************************************************************
  * allgemeine einstellungen exportieren
  ******************************************************************************************************/
    data = "<?xml version=\"1.0\"?>" + NewLine(1);
    data += "<rdf:RDF xmlns:rdf=\"" + NC + "\">" + NewLine(2);
    data += Space(2) + "<rdf:Description about=\"http://accountex/global\">" + NewLine(1);
    data += Space(4) + "<rdf:fileversion>1.2</rdf:fileversion>" + NewLine(1);
    data += Space(4) + "<rdf:accountex>0.2.2</rdf:accountex>" + NewLine(1);
    data += Space(4) + "<rdf:os>" + OS() + "</rdf:os>" + NewLine(1);
    data += Space(4) + "<rdf:vendorSub>" + navigator.vendorSub + "</rdf:vendorSub>" + NewLine(1);
    data += Space(4) + "<rdf:productSub>" + navigator.productSub + "</rdf:productSub>" + NewLine(1);
    data += Space(4) + "<rdf:type>" + server.type + "</rdf:type>" + NewLine(1);

    if (server.type != "none") {
      data += Space(4) + "<rdf:identities>" + account.identities.Count() + "</rdf:identities>" + NewLine(1);
    }
    data += Space(2) + "</rdf:Description>" + NewLine(2);  	

    switch(server.type) {
      case "none":
        data += Space(2) + "<rdf:Description about=\"http://accountex/server\">" + NewLine(1);
        data += Space(4) + "<rdf:localPath>" + server.localPath.QueryInterface(Components.interfaces.nsIFile).path + "</rdf:localPath>" + NewLine(1);
        data += Space(4) + "<rdf:emptyTrashOnExit>" + server.emptyTrashOnExit + "</rdf:emptyTrashOnExit>" + NewLine(1);
        data += Space(4) + "<rdf:prettyName>" + server.prettyName + "</rdf:prettyName>" + NewLine(1);
        data += Space(2) + "</rdf:Description>" + NewLine(2);
        break;
      case "imap":
        data += Space(2) + "<rdf:Description about=\"http://accountex/server\">" + NewLine(1);
        data += Space(4) + "<rdf:hostName>" + server.hostName + "</rdf:hostName>" + NewLine(1);
        data += Space(4) + "<rdf:username>" + server.username + "</rdf:username>" + NewLine(1);
        data += Space(4) + "<rdf:port>" + server.port + "</rdf:port>" + NewLine(1);
		    data += Space(4) + "<rdf:socketType>" + server.socketType + "</rdf:socketType>" + NewLine(1);
        data += Space(4) + "<rdf:isSecure>" + Number(server.isSecure) + "</rdf:isSecure>" + NewLine(1);
        data += Space(4) + "<rdf:useSecAuth>" + Number(server.useSecAuth) + "</rdf:useSecAuth>" + NewLine(1);
        data += Space(4) + "<rdf:loginAtStartUp>" + Number(server.loginAtStartUp) + "</rdf:loginAtStartUp>" + NewLine(1);
        data += Space(4) + "<rdf:biffMinutes>" + server.biffMinutes + "</rdf:biffMinutes>" + NewLine(1);
        data += Space(4) + "<rdf:downloadOnBiff>" + Number(server.downloadOnBiff) + "</rdf:downloadOnBiff>" + NewLine(1);
        data += Space(4) + "<rdf:emptyTrashOnExit>" + Number(server.emptyTrashOnExit) + "</rdf:emptyTrashOnExit>" + NewLine(1);      
        data += Space(4) + "<rdf:localPath>" + server.localPath.QueryInterface(Components.interfaces.nsIFile).path + "</rdf:localPath>" + NewLine(1);
        data += Space(4) + "<rdf:prettyName>" + server.prettyName + "</rdf:prettyName>" + NewLine(1);
        data += Space(2) + "</rdf:Description>" + NewLine(2);  
       
        var imap = server.QueryInterface(Components.interfaces.nsIImapIncomingServer);   
        data += Space(2) + "<rdf:Description about=\"http://accountex/imap\">" + NewLine(1);
        data += Space(4) + "<rdf:capabilityPref>" + imap.capabilityPref + "</rdf:capabilityPref>" + NewLine(1);
        data += Space(4) + "<rdf:personalNamespace>" + imap.personalNamespace + "</rdf:personalNamespace>" + NewLine(1);
        data += Space(4) + "<rdf:publicNamespace>" + imap.publicNamespace + "</rdf:publicNamespace>" + NewLine(1);
        data += Space(4) + "<rdf:otherUsersNamespace>" + imap.otherUsersNamespace + "</rdf:otherUsersNamespace>" + NewLine(1);
        data += Space(4) + "<rdf:downloadBodiesOnGetNewMail>" + Number(imap.downloadBodiesOnGetNewMail) + "</rdf:downloadBodiesOnGetNewMail>" + NewLine(1);
        data += Space(4) + "<rdf:maximumConnectionsNumber>" + imap.maximumConnectionsNumber + "</rdf:maximumConnectionsNumber>" + NewLine(1);
        data += Space(4) + "<rdf:timeOutLimits>" + imap.timeOutLimits + "</rdf:timeOutLimits>" + NewLine(1);
        data += Space(4) + "<rdf:doingLsub>" + Number(imap.doingLsub) + "</rdf:doingLsub>" + NewLine(1);
        data += Space(4) + "<rdf:storeReadMailInPFC>" + Number(imap.storeReadMailInPFC) + "</rdf:storeReadMailInPFC>" + NewLine(1);
        data += Space(4) + "<rdf:overrideNamespaces>" + Number(imap.overrideNamespaces) + "</rdf:overrideNamespaces>" + NewLine(1);
        data += Space(4) + "<rdf:fetchByChunks>" + Number(imap.fetchByChunks) + "</rdf:fetchByChunks>" + NewLine(1);
        data += Space(4) + "<rdf:mimePartsOnDemand>" + Number(imap.mimePartsOnDemand) + "</rdf:mimePartsOnDemand>" + NewLine(1);
        data += Space(4) + "<rdf:isAOLServer>" + Number(imap.isAOLServer) + "</rdf:isAOLServer>" + NewLine(1);
        data += Space(4) + "<rdf:usingSubscription>" + Number(imap.usingSubscription) + "</rdf:usingSubscription>" + NewLine(1);
        data += Space(4) + "<rdf:cleanupInboxOnExit>" + Number(imap.cleanupInboxOnExit) + "</rdf:cleanupInboxOnExit>" + NewLine(1);
        data += Space(4) + "<rdf:storeSentMailInPFC>" + Number(imap.storeSentMailInPFC) + "</rdf:storeSentMailInPFC>" + NewLine(1);
        data += Space(4) + "<rdf:offlineDownload>" + Number(imap.offlineDownload) + "</rdf:offlineDownload>" + NewLine(1);
        data += Space(4) + "<rdf:dualUseFolders>" + Number(imap.dualUseFolders) + "</rdf:dualUseFolders>" + NewLine(1);
        data += Space(4) + "<rdf:aOLMailboxView>" + Number(imap.aOLMailboxView) + "</rdf:aOLMailboxView>" + NewLine(1);
        data += Space(4) + "<rdf:serverDirectory>" + imap.serverDirectory + "</rdf:serverDirectory>" + NewLine(1);
        data += Space(4) + "<rdf:adminUrl>" + imap.adminUrl + "</rdf:adminUrl>" + NewLine(1);
        data += Space(4) + "<rdf:manageMailAccountUrl>" + imap.manageMailAccountUrl + "</rdf:manageMailAccountUrl>" + NewLine(1);
        data += Space(4) + "<rdf:deleteModel>" + imap.deleteModel + "</rdf:deleteModel>" + NewLine(1);
        data += Space(4) + "<rdf:emptyTrashThreshhold>" + imap.emptyTrashThreshhold + "</rdf:emptyTrashThreshhold>" + NewLine(1);
        data += Space(4) + "<rdf:redirectorType>" + imap.redirectorType + "</rdf:redirectorType>" + NewLine(1);
        data += Space(4) + "<rdf:timeOutLimits>" + imap.timeOutLimits + "</rdf:timeOutLimits>" + NewLine(1);
        data += Space(2) + "</rdf:Description>" + NewLine(2);

        for (var i = 0; i < account.identities.Count(); i++) {
          var identity = account.identities.QueryElementAt(i, Components.interfaces.nsIMsgIdentity);
          data += Space(2) + "<rdf:Description about=\"http://accountex/identity" + i + "\">" + NewLine(1);

          data += Space(4) + "<rdf:autoQuote>" + identity.autoQuote + "</rdf:autoQuote>" + NewLine(1);
          data += Space(4) + "<rdf:bccList>" + identity.bccList + "</rdf:bccList>" + NewLine(1);
          data += Space(4) + "<rdf:bccOthers>" + identity.bccOthers + "</rdf:bccOthers>" + NewLine(1);
          data += Space(4) + "<rdf:bccSelf>" + identity.bccSelf + "</rdf:bccSelf>" + NewLine(1);
          data += Space(4) + "<rdf:composeHtml>" + identity.composeHtml + "</rdf:composeHtml>" + NewLine(1);
          data += Space(4) + "<rdf:directoryServer>" + identity.directoryServer + "</rdf:directoryServer>" + NewLine(1);
          data += Space(4) + "<rdf:draftFolder>" + identity.draftFolder + "</rdf:draftFolder>" + NewLine(1);
          data += Space(4) + "<rdf:draftsFolderPickerMode>" + identity.draftsFolderPickerMode + "</rdf:draftsFolderPickerMode>" + NewLine(1);
          data += Space(4) + "<rdf:doFcc>" + identity.doFcc + "</rdf:doFcc>" + NewLine(1);
          data += Space(4) + "<rdf:fccFolder>" + identity.fccFolder + "</rdf:fccFolder>" + NewLine(1);
          data += Space(4) + "<rdf:fccFolderPickerMode>" + identity.fccFolderPickerMode + "</rdf:fccFolderPickerMode>" + NewLine(1);
          data += Space(4) + "<rdf:fullName>" + identity.fullName + "</rdf:fullName>" + NewLine(1);
          data += Space(4) + "<rdf:organization>" + identity.organization + "</rdf:organization>" + NewLine(1);
          data += Space(4) + "<rdf:overrideGlobalPref>" + Number(identity.overrideGlobalPref) + "</rdf:overrideGlobalPref>" + NewLine(1);
          data += Space(4) + "<rdf:replyOnTop>" + identity.replyOnTop + "</rdf:replyOnTop>" + NewLine(1);
          data += Space(4) + "<rdf:replyTo>" + identity.replyTo + "</rdf:replyTo>" + NewLine(1);
          data += Space(4) + "<rdf:requestReturnReceipt>" + identity.requestReturnReceipt + "</rdf:requestReturnReceipt>" + NewLine(1);
          data += Space(4) + "<rdf:sigBottom>" + identity.sigBottom + "</rdf:sigBottom>" + NewLine(1);
          data += Space(4) + "<rdf:stationeryFolder>" + identity.stationeryFolder + "</rdf:stationeryFolder>" + NewLine(1);
          data += Space(4) + "<rdf:email>" + identity.email + "</rdf:email>" + NewLine(1);
          data += Space(4) + "<rdf:smtpServerKey>" + identity.smtpServerKey + "</rdf:smtpServerKey>" + NewLine(1);
          data += Space(4) + "<rdf:tmplFolderPickerMode>" + identity.tmplFolderPickerMode + "</rdf:tmplFolderPickerMode>" + NewLine(1);
          data += Space(4) + "<rdf:attachSignature>" + Number(identity.attachSignature) + "</rdf:attachSignature>" + NewLine(1);
          data += Space(4) + "<rdf:attachVCard>" + Number(identity.attachVCard) + "</rdf:attachVCard>" + NewLine(1);
          data += Space(4) + "<rdf:valid>" + Number(identity.valid) + "</rdf:valid>" + NewLine(1);

          data += Space(2) + "</rdf:Description>" + NewLine(2);
        }

      break;

      case "pop3":
        data += Space(2) + "<rdf:Description about=\"http://accountex/server\">" + NewLine(1);
        data += Space(4) + "<rdf:hostName>" + server.hostName + "</rdf:hostName>" + NewLine(1);
        data += Space(4) + "<rdf:username>" + server.username + "</rdf:username>" + NewLine(1);
        data += Space(4) + "<rdf:port>" + server.port + "</rdf:port>" + NewLine(1);
        data += Space(4) + "<rdf:socketType>" + server.socketType + "</rdf:socketType>" + NewLine(1);
        data += Space(4) + "<rdf:isSecure>" + Number(server.isSecure) + "</rdf:isSecure>" + NewLine(1);
        data += Space(4) + "<rdf:useSecAuth>" + Number(server.useSecAuth) + "</rdf:useSecAuth>" + NewLine(1);
        data += Space(4) + "<rdf:loginAtStartUp>" + Number(server.loginAtStartUp) + "</rdf:loginAtStartUp>" + NewLine(1);
        data += Space(4) + "<rdf:biffMinutes>" + server.biffMinutes + "</rdf:biffMinutes>" + NewLine(1);
        data += Space(4) + "<rdf:downloadOnBiff>" + Number(server.downloadOnBiff) + "</rdf:downloadOnBiff>" + NewLine(1);
        data += Space(4) + "<rdf:emptyTrashOnExit>" + Number(server.emptyTrashOnExit) + "</rdf:emptyTrashOnExit>" + NewLine(1);      
        data += Space(4) + "<rdf:localPath>" + server.localPath.QueryInterface(Components.interfaces.nsIFile).path + "</rdf:localPath>" + NewLine(1);
        data += Space(4) + "<rdf:prettyName>" + server.prettyName + "</rdf:prettyName>" + NewLine(1);
        data += Space(2) + "</rdf:Description>" + NewLine(2);      

        var pop3 = server.QueryInterface(Components.interfaces.nsIPop3IncomingServer);
        data += Space(2) + "<rdf:Description about=\"http://accountex/pop3\">" + NewLine(1);
        data += Space(4) + "<rdf:headersOnly>" + Number(pop3.headersOnly) + "</rdf:headersOnly>" + NewLine(1);
        data += Space(4) + "<rdf:leaveMessagesOnServer>" + Number(pop3.leaveMessagesOnServer) + "</rdf:leaveMessagesOnServer>" + NewLine(1);
        data += Space(4) + "<rdf:deleteByAgeFromServer>" + Number(pop3.deleteByAgeFromServer) + "</rdf:deleteByAgeFromServer>" + NewLine(1);
        data += Space(4) + "<rdf:numDaysToLeaveOnServer>" + pop3.numDaysToLeaveOnServer + "</rdf:numDaysToLeaveOnServer>" + NewLine(1);
        data += Space(4) + "<rdf:deleteMailLeftOnServer>" + Number(pop3.deleteMailLeftOnServer) + "</rdf:deleteMailLeftOnServer>" + NewLine(1);
        data += Space(4) + "<rdf:deferGetNewMail>" + Number(pop3.deferGetNewMail) + "</rdf:deferGetNewMail>" + NewLine(1);
        

        if (pop3.deferredToAccount != "") {
          var DefAccount = accountManager.getAccount(pop3.deferredToAccount);
          var DefServer = DefAccount.incomingServer;

          data += Space(4) + "<rdf:deferredToAccount>1</rdf:deferredToAccount>" + NewLine(1);
          data += Space(4) + "<rdf:deferredToAccountType>" + DefServer.type + "</rdf:deferredToAccountType>" + NewLine(1);
          data += Space(4) + "<rdf:deferredToAccountName>" + DefServer.prettyName + "</rdf:deferredToAccountName>" + NewLine(1);
//          break;
        } else {
          data += Space(4) + "<rdf:deferredToAccount>0</rdf:deferredToAccount>" + NewLine(1); 
        }
        data += Space(2) + "</rdf:Description>" + NewLine(2);

        for (var i = 0; i < account.identities.Count(); i++) {
          var identity = account.identities.QueryElementAt(i, Components.interfaces.nsIMsgIdentity);
          data += Space(2) + "<rdf:Description about=\"http://accountex/identity" + i + "\">" + NewLine(1);
          data += Space(4) + "<rdf:bccList>" + identity.bccList + "</rdf:bccList>" + NewLine(1);
          data += Space(4) + "<rdf:draftFolder>" + identity.draftFolder + "</rdf:draftFolder>" + NewLine(1);
          data += Space(4) + "<rdf:draftsFolderPickerMode>" + identity.draftsFolderPickerMode + "</rdf:draftsFolderPickerMode>" + NewLine(1);
          data += Space(4) + "<rdf:fccFolder>" + identity.fccFolder + "</rdf:fccFolder>" + NewLine(1);
          data += Space(4) + "<rdf:fccFolderPickerMode>" + identity.fccFolderPickerMode + "</rdf:fccFolderPickerMode>" + NewLine(1);
          data += Space(4) + "<rdf:fullName>" + identity.fullName + "</rdf:fullName>" + NewLine(1);
          data += Space(4) + "<rdf:organization>" + identity.organization + "</rdf:organization>" + NewLine(1);
          data += Space(4) + "<rdf:replyTo>" + identity.replyTo + "</rdf:replyTo>" + NewLine(1);
          data += Space(4) + "<rdf:smtpServerKey>" + identity.smtpServerKey + "</rdf:smtpServerKey>" + NewLine(1);
          data += Space(4) + "<rdf:stationeryFolder>" + identity.stationeryFolder + "</rdf:stationeryFolder>" + NewLine(1);
          data += Space(4) + "<rdf:tmplFolderPickerMode>" + identity.tmplFolderPickerMode + "</rdf:tmplFolderPickerMode>" + NewLine(1);
          data += Space(4) + "<rdf:email>" + identity.email + "</rdf:email>" + NewLine(1);
          data += Space(2) + "</rdf:Description>" + NewLine(2);
        }
        break;
    }

    data += "</rdf:RDF>" + NewLine(2);

 /*****************************************************************************************************
  * Datei schreiben
  ******************************************************************************************************/
    var file = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);

    file.initWithPath(filePicker.file.path)
    var foStream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
    foStream.init(file, 0x20|0x02|0x08, 0666, 0);
    foStream.write(data, data.length);

    foStream.close();

  /*****************************************************************************************************
  * Dialog abschlieﻉen
  ******************************************************************************************************/
/*    deck.setAttribute("selectedIndex", "2");
    var finishFile = document.getElementById("finishFile");
    finishFile.value = filePicker.file.path;
    backButton.setAttribute("disabled", true); 
    forwardButton.label = forwardButton.getAttribute("finishedval");
    forwardButton.setAttribute("dlgtype", "finish");
    cancelButton.setAttribute("disabled", true);  
    checkExportFinish = document.getElementById("checkExportFinish");
    checkExportFinish.checked = false; */
    var finishFiles = document.getElementById("finishFiles");
    finishFiles.appendItem(filePicker.file.path);
  }
}

/*****************************************************************************************************
* Zeilenumbruch in String einfuegen
******************************************************************************************************/
function NewLine(num) {
tmpNewline = "\r\n";
  for (var i = 1; i < num; ++i) {
    tmpNewline += "\r\n";
  }
	return tmpNewline;
}

/*****************************************************************************************************
* Leerzeichen in String einfuegen
******************************************************************************************************/
function Space(num) {
tmpSpace = " ";
  for (var i = 1; i < num; ++i) {
    tmpSpace += " ";
  }
	return tmpSpace;
}
