/**
 * Additional Folders View, http://www.legege.com
 * Copyright (C) 2006-2007 All Rights Reserved.
 * Author: Georges-Etienne Legendre (legege@legege.com)
 */

var gAFViewOverlay = {
  folderViews: [
    {ref: "mailnewsunreadfolders:/", label: "folderPaneHeader_unread",
     datasource: Components.classes[unreadFoldersDSContractID].getService()},
    {ref: "mailnewsfavefolders:/", label: "folderPaneHeader_favorites",
     datasource: Components.classes[favoriteFoldersDSContractID].getService()},
    {ref: "mailnewsrecentfolders:/", label: "folderPaneHeader_recent",
     datasource: Components.classes[recentFoldersDSContractID].getService()}
  ],

  onLoad: function(aEvent) {
    if (aEvent.target != document || !window.getBrowser)
      return;

    addEventListener("unload", function(aEvent) { gAFViewOverlay.onUnload(aEvent); }, false);

    this.wrapFunctions();

    var ft = document.getElementById("folderTree");
    ft.addEventListener("mousedown", gAFViewOverlay.additionalFolderTree.clearSelection, true);

    var aft = document.getElementById("additionalFolderTree");
    aft.addEventListener("mousedown", gAFViewOverlay.mainFolderTree.clearSelection, true);
    aft.addEventListener("mousedown", gAFViewOverlay.additionalFolderTree.onMouseDown, true);

    // Observe some events...
    var folderTreeBuilder = aft.builder.QueryInterface(Components.interfaces.nsIXULTreeBuilder);
    folderTreeBuilder.addObserver(gAFViewFolderObserver);

    // And finally!
    this.loadFolderView(gAFView.pref.folderPaneView);
    
    setTimeout(function() { gAFViewOverlay.refreshAdditionalView(); }, 0);
  },

  onUnload: function(aEvent) {
    var aft = gAFViewOverlay.additionalFolderTree.ref();

    // Remove the observer...
    var folderTreeBuilder = aft.builder.QueryInterface(Components.interfaces.nsIXULTreeBuilder);
    folderTreeBuilder.removeObserver(gAFViewFolderObserver);
  },

  wrapFunctions: function() {
    // We have to wrap some functions to always have the folders list in sync.

    // We overload this function for all the popup context menu actions...
    if (gAFViewOverlay.__old__GetFolderTree != GetFolderTree) {
      gAFViewOverlay.wrapGetFolderTreeEnabled = true;
      gAFViewOverlay.__old__GetFolderTree = GetFolderTree;
      GetFolderTree = function() {
        var atf = gAFViewOverlay.additionalFolderTree.ref();
        if (gAFViewOverlay.wrapGetFolderTreeEnabled && atf.view.selection.count > 0) {
          return atf;
        }
        else {
          return gAFViewOverlay.__old__GetFolderTree();
        }
      }
    }

    // Now, we need to get some input when a folder is becoming or not a favorite folder.
    if (gAFViewOverlay.__old__ToggleFavoriteFolderFlag != ToggleFavoriteFolderFlag) {
      gAFViewOverlay.__old__ToggleFavoriteFolderFlag = ToggleFavoriteFolderFlag;
      ToggleFavoriteFolderFlag = function() {
        gAFViewOverlay.__old__ToggleFavoriteFolderFlag();
        gAFViewOverlay.refreshAdditionalView();
      }
    }

    try {
      if (gAFViewOverlay.__old__MsgAddToFavorites != MsgAddToFavoritess) {
        gAFViewOverlay.__old__MsgAddToFavorites = MsgAddToFavorites;
        MsgAddToFavorites = function() {
          gAFViewOverlay.__old__MsgAddToFavorites();
          gAFViewOverlay.refreshAdditionalView();
        }
      }
    }
    catch(e) {}

    try {
      if (gAFViewOverlay.__old__MsgRemoveFromFavorites != MsgRemoveFromFavorites) {
        gAFViewOverlay.__old__MsgRemoveFromFavorites = MsgRemoveFromFavorites;
        MsgRemoveFromFavorites = function() {
          gAFViewOverlay.__old__MsgRemoveFromFavorites();
          gAFViewOverlay.refreshAdditionalView();
        }
      }
    }
    catch(e) {}

    // The cycler should only affect the main folder tree.
    // Lets disable temporarily the wrap for GetFolderTree.
    if (gAFViewOverlay.__old__CycleFolderView != CycleFolderView) {
      gAFViewOverlay.__old__CycleFolderView = CycleFolderView;
      CycleFolderView = function(aCycleForward) {
        var tmp = gAFViewOverlay.wrapGetFolderTreeEnabled;
        gAFViewOverlay.wrapGetFolderTreeEnabled = false;
        gAFViewOverlay.__old__CycleFolderView(aCycleForward);
        gAFViewOverlay.wrapGetFolderTreeEnabled = tmp;
      }
    }

    // Same thing for canDrop in folderObserver.
    if (gAFViewOverlay.__old__FolderObserver_canDrop != folderObserver.canDrop) {
      gAFViewOverlay.__old__FolderObserver_canDrop = folderObserver.canDrop;
      folderObserver.canDrop = function(aIndex, aOrientation) {
        var tmp = gAFViewOverlay.wrapGetFolderTreeEnabled;
        gAFViewOverlay.wrapGetFolderTreeEnabled = false;
        var ret = gAFViewOverlay.__old__FolderObserver_canDrop(aIndex, aOrientation);
        gAFViewOverlay.wrapGetFolderTreeEnabled = tmp;
        return ret;
      }
    }

    // Same thing for canDrop in folderObserver.
    if (gAFViewOverlay.__old__FolderObserver_onDrop != folderObserver.onDrop) {
      gAFViewOverlay.__old__FolderObserver_onDrop = folderObserver.onDrop;
      folderObserver.onDrop = function(aRow, aOrientation) {
        var tmp = gAFViewOverlay.wrapGetFolderTreeEnabled;
        gAFViewOverlay.wrapGetFolderTreeEnabled = false;
        gAFViewOverlay.__old__FolderObserver_onDrop(aRow, aOrientation);
        gAFViewOverlay.wrapGetFolderTreeEnabled = tmp;
      }
    }
    
    // With the Folder Location Picker, we should disable this also.
    if (gAFViewOverlay.__old__SelectFolder != SelectFolder) {
      gAFViewOverlay.__old__SelectFolder = SelectFolder;
      SelectFolder = function(folderUri) {
        var tmp = gAFViewOverlay.wrapGetFolderTreeEnabled;
        gAFViewOverlay.wrapGetFolderTreeEnabled = false;
        gAFViewOverlay.additionalFolderTree.clearSelection();
        gAFViewOverlay.__old__SelectFolder(folderUri);
        gAFViewOverlay.wrapGetFolderTreeEnabled = tmp;
      }
    }
  },

  loadFolderView: function(aNewFolderView) {
    var aft = this.additionalFolderTree.ref();
    var database = aft.database;

    if (this.currentFolderView != undefined) {
      database.RemoveDataSource(this.folderViews[this.currentFolderView].datasource);
    }

    database.AddDataSource(this.folderViews[aNewFolderView].datasource);
    aft.setAttribute("ref", this.folderViews[aNewFolderView].ref);

    var messengerBundle = document.getElementById("bundle_messenger");
    document.getElementById("additionalFolderPaneTitle").value
      = messengerBundle.getString(this.folderViews[aNewFolderView].label);

    this.currentFolderView = aNewFolderView;
    gAFView.pref.folderPaneView = aNewFolderView;
  },

  refreshAdditionalView: function() {
    this.additionalFolderTree.ref().builder.rebuild();
  },

  cycleFolderView: function(aCycleForward) {
    var offset = aCycleForward ? 1 : this.folderViews.length - 1;
    this.loadFolderView((this.currentFolderView + offset) % this.folderViews.length);
  },

  initViewFolderViewsMenu: function(aEvent) {
    var layoutStyleMenuitem = aEvent.target.childNodes[this.currentFolderView];
    if (layoutStyleMenuitem)
      layoutStyleMenuitem.setAttribute("checked", "true");
  },

  mainFolderTree: {
    ref: function() {
      return document.getElementById("folderTree");
    },

    clearSelection: function() {
      var ref = gAFViewOverlay.mainFolderTree.ref();
      ref.view.selection.clearSelection();
    }
  },

  additionalFolderTree: {
    ref: function() {
      return document.getElementById("additionalFolderTree");
    },

    clearSelection: function() {
      var ref = gAFViewOverlay.additionalFolderTree.ref();
      ref.view.selection.clearSelection();
    },

    onSelect: function(aEvent) {
      var tmp = GetFolderTree;
      GetFolderTree = gAFViewOverlay.additionalFolderTree.ref;
      FolderPaneSelectionChange(aEvent);
      GetFolderTree = tmp;
    },

    onMouseDown: function(aEvent) {
      var tmp = GetFolderTree;
      GetFolderTree = gAFViewOverlay.additionalFolderTree.ref;
      TreeOnMouseDown(aEvent);
      GetFolderTree = tmp;
    }
  }
};

var gAFViewFolderObserver = {
  canDrop: function(index, orientation) {
    var tmp = GetFolderTree;
    GetFolderTree = gAFViewOverlay.additionalFolderTree.ref;
    var ret = CanDropOnFolderTree(index, orientation);
    GetFolderTree = tmp;
    return ret;
  },

  onDrop: function(row, orientation) {
    var tmp = GetFolderTree;
    GetFolderTree = gAFViewOverlay.additionalFolderTree.ref;
    DropOnFolderTree(row, orientation);
    GetFolderTree = tmp;
  },

  onToggleOpenState: function() {},

  onCycleHeader: function(colID, elt) {},

  onCycleCell: function(row, colID) {},

  onSelectionChanged: function() {},

  onPerformAction: function(action) {},

  onPerformActionOnRow: function(action, row) {},

  onPerformActionOnCell: function(action, row, col) {}
}

addEventListener("load", function(aEvent) { gAFViewOverlay.onLoad(aEvent); }, false);