<?xml version="1.0" encoding="utf-8"?>
<SPSSchema xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns="http://spsconsortium.net/schema/SPS.xsd">
  <ProgramName>Wireshark portable (x64)</ProgramName>
  <Version>3.4.6-17</Version>
  <ReleaseDate>2021-06-18</ReleaseDate>
  <Category>System - Network</Category>
  <Description>+++ World's foremost network protocol analyzer +++

Wireshark lets you see what's happening on your network at a microscopic level and is the de-facto-standard across many commercial and non-profit enterprises, government agencies, and educational institutions.

It lets you capture and interactively browse the traffic running on a computer network, while providing a rich and powerfull feature set, which includes the following:

  ◆ Deep inspection of hundreds of protocols, with
      more being added all the time
  ◆ Live capture and offline analysis
  ◆ Standard three-pane packet browser
  ◆ Multi-platform: Runs on Windows, Linux, macOS,
      Solaris, FreeBSD, NetBSD, and many others
  ◆ Captured network data can be browsed via a GUI, or
      via the TTY-mode TShark utility
  ◆ The most powerful display filters in the industry
  ◆ Rich VoIP analysis
  ◆ Read/write many different capture file formats:
      tcpdump (libpcap), Pcap NG, Catapult DCT2000,
      Cisco Secure IDS iplog, Microsoft Network Monitor,
      Network General Sniffer® - (un-)compressed,
      Sniffer® Pro, and NetXray®, Network Instruments
      Observer, NetScreen snoop, Novell LANalyzer,
      RADCOM WAN/LAN Analyzer, Shomiti/Finisar
      Surveyor, Tektronix K12xx, Visual Networks Visual
      UpTime, WildPackets EtherPeek/TokenPeek/
      AiroPeek, and many others
  ◆ Capture files compressed with gzip can be
      decompressed on the fly
  ◆ Live data can be read from Ethernet, IEEE 802.11,
      PPP/HDLC, ATM, Bluetooth, USB, Token Ring,
      Frame Relay, FDDI, and others
  ◆ Decryption support for many protocols, including IPsec,
      ISAKMP, Kerberos, SNMPv3, SSL/TLS, WEP and
      WPA/WPA2
  ◆ Coloring rules can be applied to the packet list for
      quick, intuitive analysis
  ◆ Output can be exported to XML, PostScript®, CSV, or plain text

There is more detailed information published on the official
web site, including sophisticated learning resources.

******************************************************************

This portable version of the app is made by Portapps, Inc., an open source project, self-funded &amp; developed by CrazyMax, an experienced developer of open source software.

Compared to the original release it includes some modifications, which where made to ensure portability. Please follow the link to the publisher web site for details.

An overview of all applications published by Portapps, Inc. is available at
https://portapps.io/apps/</Description>
  <License>GNU General Public License v2.0</License>
  <ProgramPublisherName>Wireshark Foundation &amp; Portapps, Inc.</ProgramPublisherName>
  <ProgramPublisherWebSite>https://portapps.io/app/wireshark-portable/</ProgramPublisherWebSite>
  <PackerFormat>7z</PackerFormat>
  <InstallationArguments />
  <MainExeNames>
    <Exe>
      <ExeFullRelativePath>wireshark-portable.exe</ExeFullRelativePath>
      <ExeName>Wireshark Portable (x64)</ExeName>
    </Exe>
  </MainExeNames>
  <UpdateNoCopyFiles>data;log;*.yml</UpdateNoCopyFiles>
  <CleanUpdate>false</CleanUpdate>
  <Dependency>Microsoft Visual C++ Redistributable Package (required);Npcap (recommended);USBPcap (optional)</Dependency>
  <BuiltInUpdater>false</BuiltInUpdater>
  <DownloadUrl>https://github.com/portapps/wireshark-portable/releases/download/3.4.6-17/wireshark-portable-win64-3.4.6-17.7z</DownloadUrl>
  <DownloadSizeKb>53987</DownloadSizeKb>
  <ProgramIconBase64>iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOvAAADrwBlbxySQAAA4JJREFUOE+F0n9Qk3UcB/Bv/QHPoARPS7O6i+v8xzK9foCeUMcaDKFiBZgbAfNH0EAsiuEoCQwl58Y2ONjgYAMmje5STywQChBjij+2BIagLEWCuefZJnjnnZed4913x7yu64/ed88fz933de/P9wf5v/j9DwmRzpLWi/fCpZb5V/j1PvHrGu/+DSqvNq7WuzO47L8xDS8Qwn9IDvTcXVNwbEEm0PtOrz3IuVbvdz9Yrri9GLHvNtZWuo8Hl/872e0+ssviZXK+m89ON90Z2ajk/MtL5hD22R/g7b0FpnAakUW3uJjDc/wgWYp74T5JMniIqMmzUtTkqxPqvfdfKHMhjCJewQ3wZE7w8qbAy72O579wdrQNeUOCdCmCOo4kG7inthq8HfE13OLqEtqYT2EA7Z4Eb+dVMFIHwnc4/OvkkzmhOWNBSZPWxJH0ZjYsvtbTkGLwLD63bwbMI7hjHEz2KJiPfgMjsSEiy35nk2J842tyxxKu+MlLSOwc2aJhZVv1nj9frqDNARxoDMBMO5jtl8BkDINJO4cV4vPXU8pHn3n3QHCCGJWbvKVj172p437fcsSFZflTYAI4awSM+PISfN8KJvUsQt8ZwMqMQbuobiJKYJxcRYqPe8nYzPzjMWpWx9e6sebzG//g7RSnnQ/CfoQm9SAyvQ8b5IN3hY2jDmHL1DmyWe0mcVr3S7EadvbVylmE514DkzNGm21g0oM4+ReEJHRhlaQPsVVWKLQm5KrakdDouEgvfTawhdL4R+2BA8ukh5VxAYzoV4RQHJnShWfFPYirGUeSwQaFxoi8I+a/3q63F5PURjZyk5o9G/3tHJ7Io+3ZtD0w+gdWhKT040VJL6pMVkhMDiS2OCGkX2LDCBINV07S/xV0fDZus5r1RSnoC9s1gWXSUURkXsKTaUN4mu5XUTOIknY7ktsopDjB5ARfdRnvlfXlv1HYTUi0mlVEK93+9eUzEByexofam5BUT2Fb1ThEZTZkVfSBf7AXAuM1pJqd2GO+gszSLhQd6m16cI97jAjrPSfEJi/2WjgUtLqwxziDouabkDc7UWwYQ5deB3PVNxCp+lHXaYP+6Bl8/NUpfFrZPaE0/BxFyk+6Sst+mG4pbL7atrvW3v6J7oJFVj3UIa0c6FA1HOv2fS9zDTfIOzXG0wOnus9Yv1SeMJcqO1u/rv6xXnHIsv5vizwN54qFlRUAAAAASUVORK5CYII=</ProgramIconBase64>
  <SPSPublisherName>mimic</SPSPublisherName>
  <SPSLicense>CC Attribution-NonCommercial-ShareAlike 4.0 International</SPSLicense>
  <SPSProgramReport>mailto:portapps@online.de</SPSProgramReport>
  <VirusTotalResult>
    <Permalink>https://www.virustotal.com/gui/file/9093e626b055deaf91a9d2111170cf089a30935ce477a8da1efcd41dedfd2b8f/detection/f-9093e626b055deaf91a9d2111170cf089a30935ce477a8da1efcd41dedfd2b8f-1625025287</Permalink>
    <DetectionRatio>0/52</DetectionRatio>
  </VirusTotalResult>
</SPSSchema>