<?xml version="1.0" encoding="utf-8"?>
<SPSSchema xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns="http://spsconsortium.net/schema/SPS.xsd">
  <ProgramName>Android Studio portable (x64)</ProgramName>
  <Version>4.2.1-17</Version>
  <ReleaseDate>2021-05-22</ReleaseDate>
  <Category>Programming - IDEs</Category>
  <Description>+++ Official IDE for the Android operating system +++

Android Studio provides the fastest tools for building apps on every type of Android device.

◆ Visual layout editor:
~~~~~~~~~~~~~~~
Create complex layouts with ConstraintLayout by adding constraints from each view to other views and guidelines. Then preview your layout on any screen size by selecting one of various device configurations or by simply resizing the preview window.

◆ APK Analyzer:
~~~~~~~~~~~
Find opportunities to reduce your Android app size by inspecting the contents of your app APK file, even if it wasn't built with Android Studio. Inspect the manifest file, resources, and DEX files. Compare two APKs to see how your app size changed between app versions.

◆ Fast emulator:
~~~~~~~~~~~
Install and run your apps faster than with a physical device and simulate different configurations and features, including ARCore, Google's platform for building augmented reality experiences.

◆ Intelligent code editor:
~~~~~~~~~~~~~~~~
Write better code, work faster, and be more productive with an intelligent code editor that provides code completion for Kotlin, Java, and C/C++ languages.

◆ Flexible build system:
~~~~~~~~~~~~~~~~
Powered by Gradle, Android Studio's build system allows you to customize your build to generate multiple build variants for different devices from a single project.

◆ Realtime profilers:
~~~~~~~~~~~~~~
The built-in profiling tools provide realtime statistics for your app's CPU, memory, and network activity. Identify performance bottlenecks by recording method traces, inspecting the heap and allocations, and see incoming and outgoing network payloads.

For more information on Android Studio please visit the official web site at https://developer.android.com/studio

******************************************************************

This portable version of the app is made by Portapps, Inc., an open source project, self-funded &amp; developed by CrazyMax, an experienced developer of open source software.

Compared to the original release it includes some modifications, which where made to ensure portability. Please follow the link to the publisher web site for details.

An overview of all applications published by Portapps, Inc. is available at
https://portapps.io/apps/</Description>
  <License>MIT License

https://github.com/portapps/android-studio-portable/blob/master/LICENSE</License>
  <ProgramPublisherName>Google LLC &amp; Portapps Inc.</ProgramPublisherName>
  <ProgramPublisherWebSite>https://portapps.io/app/android-studio-portable/</ProgramPublisherWebSite>
  <PackerFormat>InnoSetup</PackerFormat>
  <InstallationArguments />
  <MainExeNames>
    <Exe>
      <ExeFullRelativePath>android-studio-portable.exe</ExeFullRelativePath>
      <ExeName>Android Studio Portable (x64)</ExeName>
    </Exe>
  </MainExeNames>
  <UpdateNoCopyFiles>data;log;*.yml</UpdateNoCopyFiles>
  <CleanUpdate>false</CleanUpdate>
  <BuiltInUpdater>false</BuiltInUpdater>
  <DownloadUrl>https://github.com/portapps/android-studio-portable/releases/download/4.2.1-17/android-studio-portable-win64-4.2.1-17-setup.exe</DownloadUrl>
  <DownloadSizeKb>830832</DownloadSizeKb>
  <Note>VirusTotal analysis:

https://www.virustotal.com/gui/file-analysis/NTYyYjFmMzBkYTk5ZjMxNGJlOTExZmY0ZTI4ZmZmNmM6MTYyMTcxNzk5MA==/detection</Note>
  <ProgramIconBase64>iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOvgAADr4B6kKxwAAAA45JREFUOE9tkmlslEUAhkcTY43xhyb9YQNB6w8SNUaimBAxKt399u6e0FaUINWCQUxJCDECCZLSvc8KttgjEeTQckhbZE0qECzrdm337l7f0dLDtlu2W03ZVeu+ft/SX8Y3eTLJZJ53JjND/pu9Nz3klaKFGJLORzUZR6U67ajUJuwVBC3kwyHH6qr/yc6gh6jGnURHuyo1rLNJxTquKFl7UMHaQ3LG1idnrB8rMtanxRMWsjVkW7VW817MQ2onXETPuDdoWNeNWs65ouIcUHB2yHlkrA1S1vqPhLHckdKWTW9PmYk6ankggzBEy7iEnZ/j5YCac4EvgGrcgU1nDmJj+35IU2ZIOSso1gKKMUclafMLFG0m23+2EqJPOUlD2P6wmnV6BFFAkbRh4xf7sU5fhzUyHV5q2QNR6DgozgIxY4aYNnXL4qZHpEkTIWraIfBsLedgywXjTkhGjHhGX4/qbXWofqceVRIt3rj6KfhdywUixjQjTpueF2X4Av6iiIqxU0rOUeSBkj86NdKKdVvr8KrpI7zWtg9Vci1e//YAakLHIMoYUcOYVmroVt0WxsifYNYloFPPuVZ4IKDkbHi5eTfWKg1Yo9Jj/fZ3sWXwEI7Q3+PoRD8kd+2gIl8fojyT1US36Ca6nPstbd6zzANN3o3GpR6cjo5ic+Mn2FC/C56BfjTFOuDNTuJELAXq/HeQdA7/IenODBHdAv8CWVeVdtEdF2SBjnwAQ7NZGLxGqLyfYyATx+DUOLoi92Do8OG4pwt7LKch6oj1Ef20g2zGSaLJuY6o8s7S3vxZBJeWcWNmGoeTvfiMvYhrk0lcji9Bf5YDdSKAZlsPdpjP/V7THmko/wX1gpMo5q2V+lzb1Qv5BG7PzKHvbga/zC8iMp3DTyMJ7Dyfhrg7A0lPBuJT8ZL4VMxD9dCPlQt89BTxLeXJrdzc++FcoXBw9Jv78sAxNIW/RGdwAPv6fbxIg+Jlnr8k3el2cWfyKaorVfZJPFsksWyhIrVYuh5b+POS4Y5JJg4ftcjGWnp3+U1BuedKSfRVorTtTAqtA/G40ztWZf8x+UAWEpm7T6Lzhcdj2WJz+Lfl9VG+EMEGMhbd/WSuq7HvgvHwPW3b4LmLt0ZjwyOhk4EE94Q/Tq/afK7748Q7PCaMD80C5bm/fR8IvFi81Hiz0LtD4/PdfvPXYf+BIZ+/Yvmai/wQSPCrCPkXh506lDkIVI0AAAAASUVORK5CYII=</ProgramIconBase64>
  <SPSPublisherName>mimic</SPSPublisherName>
  <SPSLicense>CC Attribution-NonCommercial-ShareAlike 4.0 International</SPSLicense>
  <SPSProgramReport>mailto:portapps@online.de</SPSProgramReport>
</SPSSchema>