library sure_copy;

{sure_copy.wcx -    Total Commander.
:   aka Antikiller.D1P

 ,    ,       .
  .
      .
     ,   ,  ,  .
   -  .
  - .

 -  forum.wincmd.ru  ICQ 215168320
20.03.2008
}

uses
  Windows,
  Classes,
  SysUtils,
  IniFiles,
  StrUtils,
  WcxHead,
  config in 'config.pas' {SCCFG};

{$E wcx}

{$R *.res}



var
  PackerChangeVolProc:TChangeVolProc;
  PackerProcessDataProc:TProcessDataProc;
  x:Pchar;


(*-------------------------  ---------------------------*)
//  ,    

function Are2FilesEqual(const File1, File2: TFileName): Boolean; 
var
ms1, ms2: TMemoryStream;
begin
Result := False;
ms1 := TMemoryStream.Create;
if not fileexists (File1) then exit; //     -  
try
   ms1.LoadFromFile(File1);
   ms2 := TMemoryStream.Create;
   try
     ms2.LoadFromFile(File2);
     if ms1.Size = ms2.Size then
       Result := CompareMem(ms1.Memory, ms2.memory, ms1.Size);
   finally
     ms2.Free;
   end;
finally
   ms1.Free;
end
end;

(*-------------------------  ---------------------------*)



Procedure Log (Text:String);
var
LF:TextFile;
begin
try
if not fileexists (ReadSettings.LogFileName) then
 begin
 FileClose(FileCreate (ReadSettings.LogFileName));
 end;
If Not FileExists (ReadSettings.LogFileName) then exit;
AssignFile (LF,ReadSettings.LogFileName);
Append (LF);
WriteLn (LF,'[',DateToStr(now),'-',TimeToStr(now),'] ',Text);
CloseFile (LF);
except end;
end;

function GetPackerCaps():integer;stdcall
begin
result:=PK_CAPS_NEW+PK_CAPS_MODIFY+PK_CAPS_DELETE+PK_CAPS_HIDE;
end;

function OpenArchive (ArchiveData:tOpenArchiveData):thandle;stdcall;
Begin
Result := 0;
ArchiveData.OpenResult := E_UNKNOWN_FORMAT;
End;

function ReadHeader (hArcData: THandle; HeaderData:tHeaderData):integer;stdcall;
begin
Result := E_BAD_ARCHIVE;
end;

function ProcessFile (hArcData: THandle; Operation:Integer;  DestPath, DestName:pchar):integer;stdcall
Begin
Result := E_BAD_ARCHIVE;
end;

function CloseArchive (hArcData: THandle):integer;stdcall;
Begin
Result:=0;
End;

procedure SetChangeVolProc (hArcData:THandle; ChangeVolProc:tChangeVolProc);stdcall;
begin
PackerChangeVolProc:=ChangeVolProc;
end;

procedure SetProcessDataProc (hArcData:THandle; ProcessDataProc:tProcessDataProc);stdcall;
begin
PackerProcessDataProc:=ProcessDataProc;
end;

procedure ConfigurePacker (Parent:HWND;Dllinstance:THandle);stdcall;
var
SCCFG: TSCCFG;
begin
SCCFG:=TSCCFG.Create (nil);
//SCCFG.ParentWindow:=Parent;
SCCFG.ShowModal;
SCCFG.Free;
end;

Function GetShortName (Const LongName:String):String;
var i :Integer;
x:String;
begin
SetLength(Result,Length(LongName));
i := GetShortPathName(pChar(LongName),pChar(result),Length(LongName));
if i > Length(Result)  then begin
   SetLength(Result,i);
   i := GetShortPathName(pChar(LongName),pChar(Result),Length(Result));
end;
SetLength(Result,i);
end;

Function DoCopy (F_IN,F_OUT:String;CopyAtt:Integer=0):Boolean;
Begin
result:=false;
//  
copyfile (pchar(F_IN),pchar(F_OUT),false);
// 
//GetShortName       DOS-. , ,  ,       

if not Are2FilesEqual (GetShortName(F_IN),GetShortName(F_OUT)) then
 begin
 //  
 Log ('BAD('+IntToStr(CopyAtt)+'): '+ F_IN+' =/= '+F_OUT);
 end else
 begin
 if not ReadSettings.LogOnlyBad then Log ('OK: '+ F_IN+' -> '+F_OUT);
 result:=true;
 end;
end;

function PackFiles (PackedFile,SubPath,SrcPath,AddList:Pchar; Flags:Integer):integer;stdcall;
var
p: PChar;
CopyedFile,TargetPath:String;
i:integer;
begin
Result := 0;
p := AddList;
//source files
while (p^ <> #0) do
 begin
 CopyedFile := String(SrcPath) + String(p);
 TargetPath:=ExtractFilePath(PackedFile)+ExtractFilepath(String(p));
 ForceDirectories (TargetPath);
 if Not DirectoryExists (CopyedFile) then
  begin
  For i:=0 to ReadSettings.CopyAtt-1 do
   begin
   if DoCopy (CopyedFile,TargetPath+ExtractFilename(String(p)),i+1) then break;
   end;
  end;
  PackerProcessDataProc (Pchar(CopyedFile),0);
  if Flags>0 then //  
   begin
//   DeleteFile (pchar (CopyedFile));
   end;
 p := StrEnd(p)+1;
 end;
end;

exports
  GetPackerCaps,
  OpenArchive,
  Readheader,
  ProcessFile,
  CloseArchive,
  SetChangeVolProc,
  SetProcessDataProc,
  ConfigurePacker,
  PackFiles;

begin
GetMem (x,max_path);
GetModuleFilename (hInstance,x,max_path);
PluginPath:=x;
Windows.GetEnvironmentVariable ('commander_path',x,max_path);
tcdir:=lowercase({includetrailingbackslash}(x));
freemem (x);
end.

