unit config;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TSCCFG = class(TForm)
    LOG_Caption: TLabel;
    LOG_BTN: TButton;
    LOG_NAME: TEdit;
    LOG_OPEN: TOpenDialog;
    CMP_LABEL: TLabel;
    CMP_METHOD: TComboBox;
    ATT_LABEL: TLabel;
    ATT_SELECT: TComboBox;
    OK_BTN: TButton;
    CNC_BTN: TButton;
    LOG_BAD: TCheckBox;
    Bevel1: TBevel;
    procedure LOG_BTNClick(Sender: TObject);
    procedure OK_BTNClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;



implementation
uses wcxhead;

{$R *.dfm}

procedure TSCCFG.LOG_BTNClick(Sender: TObject);
begin
if (LOG_OPEN.execute) and (LOG_OPEN.FileName<>'') then LOG_NAME.Text :=LOG_OPEN.FileName;  
end;

procedure TSCCFG.OK_BTNClick(Sender: TObject);
var
TMP:TSettings;
begin
TMP.LogFileName :=LOG_NAME.Text;
TMP.LogOnlyBad :=LOG_BAD.Checked;
TMP.CmpMethod :=CMP_METHOD.ItemIndex;
TMP.CopyAtt :=ATT_SELECT.ItemIndex;
WriteSettings (TMP);
end;

procedure TSCCFG.FormCreate(Sender: TObject);
var
TMP:TSettings;
begin
TMP:=ReadSettings;
LOG_NAME.Text:=TMP.LogFileName;
LOG_BAD.Checked:=TMP.LogOnlyBad;
CMP_METHOD.ItemIndex:=TMP.CmpMethod;
ATT_SELECT.ItemIndex:=TMP.CopyAtt;

end;

end.
