/*****************************************************************************
**
**  FILE   :	CreateHardLink.cpp
**
**  PURPOSE:	Plugin for Windows Commander 5.0
**				Creates hardlink for specified file.
**
**	Author:		Andrey Titov
**
*****************************************************************************/

#include <windows.h>
#include <winbase.h>

#include <stdlib.h>
#include <stdio.h>
#include <limits.h>

#include "wcxapi.h"
#include "wcxhead.h"


/*****************************************************************************
	Variable:     ProcessDataProc
------------------------------------------------------------------------------
	Description: 
		ProcessDataProc used to notify user about the progress when 
        you un/pack files


*****************************************************************************/

tProcessDataProc ProcessDataProc = NULL;


/*****************************************************************************
	Routine:     GetPackerCaps
------------------------------------------------------------------------------
	Description: 
		GetPackerCaps tells WinCmd what features your packer plugin supports
  
	Arguments:  

	Return Value:


*****************************************************************************/

WCX_API int STDCALL
	GetPackerCaps ()
{
    return 0 
        | PK_CAPS_NEW           /* Can create new archives              */
        // | PK_CAPS_MODIFY        /* Can modify exisiting archives        */
        // | PK_CAPS_MULTIPLE      /* Archive can contain multiple files   */
        // | PK_CAPS_DELETE        /* Can delete files                     */
        // | PK_CAPS_OPTIONS       /* Has options dialog                   */
        // | PK_CAPS_MEMPACK       /* Supports packing in memory           */
        // | PK_CAPS_BY_CONTENT    /* Detect archive type by content       */
        // | PK_CAPS_SEARCHTEXT    /* Allow searching for text in archives */
        //                        /* created with this plugin}            */
        | PK_CAPS_HIDE          /* Show as normal files (hide packer    */
                                /* icon), open with Ctrl+PgDn, not Enter*/
        ;    
}

/*****************************************************************************
	Routine:     PackFiles
------------------------------------------------------------------------------
	Description: 
		PackFiles specifies what should happen when a user creates, 
		or adds files to the archive.
  
	Arguments:  

	Return Value:

*****************************************************************************/

WCX_API int STDCALL 
	PackFiles (
		char *PackedFile, 
		char *SubPath, 
		char *SrcPath, 
		char *AddList, 
		int Flags
        )
{
    char *SrcPathFull = NULL;
    size_t SrcPathFullLen = 0;
    size_t SrcPathFullSize = 0;
    size_t SrcPathLen = 0;
    size_t AddListLen = 0;
    errno_t unsuccess = 1;
    BOOL success = FALSE;

    static int count;

    if( Flags & PK_PACK_MOVE_FILES )
    {
        return E_NOT_SUPPORTED;
    }

    if( !PackedFile || (!SubPath && !AddList) )
    {
        return E_ECREATE;
    }

    if( SrcPath )
    {
        SrcPathLen = strlen(SrcPath);
    }

    if( AddList )
    {
        AddListLen = strlen(AddList);
    }

    SrcPathFullLen = SrcPathLen + AddListLen;

    if( !(SrcPathFullLen > 0) )
    {
        return E_ECREATE;
    }

    SrcPathFull = (char *)malloc(SrcPathFullLen + 1);

    if( !SrcPathFull )
    {
        return E_ECREATE;
    }

    if(SrcPathLen)
    {
        unsuccess = strcpy_s(SrcPathFull, SrcPathFullLen + 1, SrcPath);

        if(unsuccess)
        {
            free(SrcPathFull);
            return E_ECREATE;
        }
    }

    if(AddListLen)
    {
        unsuccess = strcpy_s(SrcPathFull + SrcPathLen, AddListLen + 1, AddList);

        if(unsuccess)
        {
            free(SrcPathFull);
            return E_ECREATE;
        }
    }

    if(ProcessDataProc && !(count++ & 31))
    {
       ProcessDataProc(SrcPathFull, 0);
    }
    
    success = CreateHardLinkA(PackedFile, SrcPathFull, NULL);

    free(SrcPathFull);

    if(!success)
    {
        return E_ECREATE;
    }

    return 0;
}
/*****************************************************************************
	Routine:     OpenArchive
------------------------------------------------------------------------------
	Description: 
				OpenArchive should perform all 
				necessary operations when an archive is to be opened

	Arguments:  

	Return Value:


*****************************************************************************/

WCX_API HANDLE STDCALL 
	OpenArchive (
		tOpenArchiveData *ArchiveData
		)
{
    return NULL;
}

/*****************************************************************************
	Routine:     ReadHeader
------------------------------------------------------------------------------
	Description: 
				WinCmd calls ReadHeader 
				to find out what files are in the archive

	Arguments:  

	Return Value:


*****************************************************************************/

WCX_API	int STDCALL 
	ReadHeader (
		HANDLE hArcData, 
		tHeaderData *HeaderData
		)
{
    return E_END_ARCHIVE;
}

/*****************************************************************************
	Routine:     ProcessFile
------------------------------------------------------------------------------
	Description: 
  
	Arguments:  

	Return Value:


*****************************************************************************/

WCX_API int STDCALL 
	ProcessFile (
		HANDLE hArcData, 
		int Operation, 
		char *DestPath, 
		char *DestName
		)
{
	return ( 0 );
}

/*****************************************************************************
	Routine:     CloseArchive
------------------------------------------------------------------------------
	Description: 
  
	Arguments:  

	Return Value:


*****************************************************************************/

WCX_API int STDCALL 
	CloseArchive (
		HANDLE hArcData
		)
{
    return 0;
}

/*****************************************************************************
	Routine:     SetChangeVolProc
------------------------------------------------------------------------------
	Description: 
  
	Arguments:  

	Return Value:


*****************************************************************************/

WCX_API void STDCALL
	SetChangeVolProc (
		HANDLE hArcData, 
		tChangeVolProc pChangeVolProc1
		)
{
	return;
}

/*****************************************************************************
	Routine:     SetProcessDataProc
------------------------------------------------------------------------------
	Description: 
  
	Arguments:  

	Return Value:


*****************************************************************************/

WCX_API void STDCALL
	SetProcessDataProc (
		HANDLE hArcData, 
		tProcessDataProc pProcessDataProc
		)
{
	ProcessDataProc = pProcessDataProc;
}

/*****************************************************************************
	Routine:     ConfigurePacker
------------------------------------------------------------------------------
	Description: 
			ConfigurePacker gets called when the user clicks the Configure 
			button from within "Pack files..." dialog box in WinCmd
  
	Arguments:  

	Return Value:


*****************************************************************************/

WCX_API void STDCALL
	ConfigurePacker (
		HWND Parent, 
		HINSTANCE DllInstance
		)
{
}



