::__________________________________________________________________________
::
::              INIT
::__________________________________________________________________________
::

    @setlocal
    @echo off
    rem debug echo on
::  Go to folder of this script
    pushd "%~dp0"
:: Get Volume label of bootdisk to identify this system (and put it in environment variable %DISKID% )
    for /f "usebackq tokens=5" %%x in (`VOL %SystemDrive%`) do  set DISKID=%%x
:: Strip surrounding "" quotes from parameter
    set parm1=%~1

    set VERSION=0.9
    mode 110,60

::__________________________________________________________________________
::
::              PARAMETER CHECK
::__________________________________________________________________________
::
:: First time usage?
    if not exist "????-???? --*" (
        call :SHOWHELP
        choice /M "Continue?   "
        if ERRORLEVEL 2 goto :EOF
    )

::  Regular indexing?
    if "%parm1%" == ""  (
        call :NEWSYSTEM
        call :INDEX
        goto :EOF
    )

:: HELP WANTED?
    set SHOWHELP=0
    if /i "%parm1%" == "/?" set SHOWHELP=1
    if /i "%parm1%" == "-?" set SHOWHELP=1
    if /i "%parm1%" == "/h" set SHOWHELP=1
    if /i "%parm1%" == "-?" set SHOWHELP=1

    if %SHOWHELP% == 1 (
        call :SHOWHELP
        pause
        goto :EOF
    )

:: Browse readonly database?
    if exist "%parm1%" call :BROWSE "%parm1%"

:: No more things to do. Just quit
    goto :EOF

::==================================================================
::==================================================================
::==================================================================

::__________________________________________________________________________
::
              :SHOWHELP
::__________________________________________________________________________
::
    echo.____________________________________________________[ HELP ]_________________________________________________
    echo.                                                                                     Version %VERSION% by Maarten
    echo.   STARTEVERYTHING [/?^|/h] [ "DISKID_folder" ]
    echo.
    echo.   The script  handles 2 variations:
    echo.
    echo.       1. Index the current system
    echo.          Start STARTEVERYTHING without parameters.
    echo.          If the current system wasn't indexed before, it will ask you:
    echo.          (1) a description, (2) to scan all local drives and (3) to scan all available network drives
    echo.
    echo.           Use Ctrl-Shift-Z to open the Everything search window; Ctrl-F5 to update the index
    echo.
    echo.
    echo.       2. Show the contents of an already indexed system in read-only mode
    echo.          Start STARTEVERYTHING with the system's foldername as parameter.
    echo.          Easiest way to do this, is to drag/drop the foldername to this script using Explorer
    echo.
    echo.       These two can run side-by-side; multiple read-only databases are possible
    echo.

goto :EOF

::__________________________________________________________________________
::
              :BROWSE
::__________________________________________________________________________
::

:: If the command line parameter is supposed to be the foldername of an already indexed
::  disk, start the database in read-only mode in a new instance (named after the folder)

    set DBFOLDER=%~nx1
    for /f "tokens=1" %%x in ("%DBFOLDER% DUMMY") do set DISKID=%%x

    IF exist "%DBFOLDER%\%DISKID%.ini" (
        start "" Everything.exe  -read-only -instance "%DBFOLDER%" -db "%CD%\%DBFOLDER%\%DISKID%.db"  -config "%CD%\%DBFOLDER%\%DISKID%.INI"
    ) ELSE (
        echo.
        echo Wrong Folder !!!
        echo.
        pause
    )
goto :EOF


::__________________________________________________________________________
::
              :NEWSYSTEM
::__________________________________________________________________________
::
:: If Everything has never indexed this disk before, create the neccessary file and folder structure.
:: If it already exists, we're done here
    if exist "%DISKID% --*"  goto :EOF
::
:: GIVE SYSTEM DESCRIPTION
::

    echo.
    echo.____________________________________________________[ DESCRIPTION ]__________________________________________
    echo.
    echo.          Describe this system so you can identify it later
    echo.          (like: Uncle John's laptop or: PC123)
    echo.   
    set /p DESCRIPTION=Description :  
    set FOLDERNAME=%DISKID% -- %DESCRIPTION%
    echo.
::
:: ADD LOCAL DRIVES?
::
    echo.____________________________________________________[ LOCAL DISKS ]__________________________________________
    echo.
    SETLOCAL enabledelayedexpansion
        set AA=
        for /f "skip=1 usebackq" %%X in (`"wmic logicaldisk where (drivetype=3) get deviceid"`) do (
            set AA=%%X !AA!
        )

        echo.          Found Local Drives: %AA%
        echo.          Choose N to index only %SystemDrive% ; Y to index all
        echo.
        choice /m "Add all local drives ?"
        if ERRORLEVEL 2 set AA=%SystemDrive%
    ENDLOCAL & set LOCALDRIVES=%AA%
    echo.

::
:: ADD NETWORK DRIVES?
::
    echo.____________________________________________________[ NETWORK DRIVES ]_______________________________________
    echo.
    SETLOCAL enabledelayedexpansion
        set AA=
        for /f "skip=1 usebackq" %%X in (`"wmic logicaldisk where (drivetype=4) get deviceid"`) do (
            set AA=%%X !AA!
        )

       echo.          Found Network Drives: %AA%
        echo.
        choice /m "Add all network drives ?"
        if ERRORLEVEL 2 set AA=
    ENDLOCAL & set NETWORKDRIVES=%AA%
    echo.



::
:: CONFIRM SETTINGS
::
    echo.____________________________________________________[ CONFIRM SETTINGS ]_____________________________________
    echo.
    echo.          Description      : "%DESCRIPTION%"
    echo.          Drives to index  : %LOCALDRIVES% %NETWORKDRIVES%
    echo.
    echo.          Choose Y to run Everything with these settings
    echo.          Choose N to quit
    echo.
    choice /m "Continue? " 
    if errorlevel 2 EXIT
    
::
:: WRITE THESE SETTINGS TO Everything's INI file
::

    rem INI entry layout: folders="C:\\","X:\\"
    md "%FOLDERNAME%"
    copy BASE_INI.ini "%FOLDERNAME%\%DISKID%.INI" >nul

    SETLOCAL enabledelayedexpansion

        for %%X in ( %NETWORKDRIVES% %LOCALDRIVES% ) do set TOINI="%%X\\",!TOINI!

    ENDLOCAL & set TOINI=%TOINI%

    echo. >> "%FOLDERNAME%\%DISKID%.INI"
    echo Folders=%TOINI% >> "%FOLDERNAME%\%DISKID%.INI"

:: Example how to add a folder dynamically to the INI file
    set exclude_folders="%windir%\SoftwareDistribution","%windir%\winsxs"
    :: replace \ with \\ 
    set exclude_folders=%exclude_folders:\=\\%
    echo exclude_folders=%exclude_folders% >> "%FOLDERNAME%\%DISKID%.INI"

goto :EOF


        
::__________________________________________________________________________
::
              :INDEX
::__________________________________________________________________________
::
:: If we end up here, that means that there was no parameter given.
:: In that case we're going to start a "live" Everything to index the current disk.
:: Run Everything.exe to index this system with specific database and INI settings ..

    for /D %%X in (%DISKID%*) do set FULLPATH=%%~dpnxX
    start "" everything.exe -db "%FULLPATH%\%DISKID%.db" -config "%FULLPATH%\%DISKID%.INI"
goto :EOF

