<?xml version="1.0" encoding="utf-8"?>
<SPSSchema xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns="http://spsconsortium.net/schema/SPS.xsd">
  <ProgramName>Phyrox Developer Edition portable (x64)</ProgramName>
  <Version>93.0b6-43</Version>
  <ReleaseDate>2021-09-20</ReleaseDate>
  <Category>Internet - Web Browsers</Category>
  <Description>+++ Portable Developer Edition of Firefox Browser +++

Build for the open web with all the latest developer tools, experimental features &amp; fast performance. Mozilla's testing and development platform is based on the Beta Channel of Firefox, delivering features like...

◆ Inactive CSS ◆
~~~~~~~~~~~~
Firefox DevTools now grays out CSS declarations that don’t have an effect on the page. When you hover over the info icon, you’ll see a useful message about why the CSS is not being applied, including a hint about how to fix the problem. 

◆ Firefox DevTools ◆
~~~~~~~~~~~~~~~
The new Firefox DevTools are powerful, flexible, and best of all, hackable. This includes a best-in-class JavaScript debugger, which can target multiple browsers and is built in React and Redux. 

◆ Master CSS Grid ◆
~~~~~~~~~~~~~~
Firefox is the only browser with tools built specifically for building and designing with CSS Grid. These tools allow you to visualize the grid, display associated area names, preview transformations on the grid and much more. 

◆ Fonts Panel ◆
~~~~~~~~~~~
The new fonts panel in Firefox DevTools gives developers quick access to all of the information they need about the fonts being used in an element. It also includes valuable information such as the font source, weight, style and more. 

For more information on Mozilla Firefox Developer Edition please have a look at the official Mozilla web site under
https://www.mozilla.org/en-US/firefox/developer

******************************************************************

This portable version of the app is made by Portapps, Inc., an open source project, self-funded &amp; developed by CrazyMax, an experienced developer of open source software.

Compared to the original release, following modifications have been made through policies to ensure portability:

  -&gt; Disable updater : Firefox Developer Edition updates are turned off
  -&gt; Don’t check default browser : Stops checking at startup
  -&gt; Profile: Profile path is overwritten to data\profile folder (see below).
  -&gt; Created Shortcut (launch) allows native notifications (removed closing)

The documentation, an overview of all portable applications published by Portapps, as well as the posibility to submit a request if your favourite app is missing, are available at https://portapps.io/.

Big Thanks to CrazyMax! IMHO this is worth at least a star (or some more) at github, or maybe also a small donation to support future development.</Description>
  <License>Mozilla Public License 2.0</License>
  <ProgramPublisherName>Mozilla Foundation &amp; Portapps, Inc.</ProgramPublisherName>
  <ProgramPublisherWebSite>https://portapps.io/app/phyrox-developer-portable/</ProgramPublisherWebSite>
  <PackerFormat>7z</PackerFormat>
  <InstallationArguments />
  <MainExeNames>
    <Exe>
      <ExeFullRelativePath>phyrox-developer-portable.exe</ExeFullRelativePath>
      <ExeName>Phyrox Developer Portable (x64)</ExeName>
    </Exe>
  </MainExeNames>
  <UpdateNoCopyFiles>data;log;*.yml</UpdateNoCopyFiles>
  <CleanUpdate>false</CleanUpdate>
  <BuiltInUpdater>false</BuiltInUpdater>
  <DownloadUrl>https://github.com/portapps/phyrox-developer-portable/releases/download/93.0b6-43/phyrox-developer-portable-win64-93.0b6-43.7z</DownloadUrl>
  <DownloadSizeKb>57052</DownloadSizeKb>
  <Note>Phyrox Developer Edition portable can be configured through the main YAML configuration file. Read more at https://portapps.io/doc/configuration/

Furthermore you can use custom policies by creating a data/policies.json file. The documentation can be found at https://support.mozilla.org/en-US/kb/customizing-firefox-using-policiesjson</Note>
  <ProgramIconBase64>iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOvAAADrwBlbxySQAAA2JJREFUOE9dU39MlHUcfl5Oki2bLF3Txmqr/miDrdZq5eTQ9EDSGqAScFg4QvlhSKuhJnKScAh3ntxxetedeIwfBqVzrcZ03SlxGonBEXdw6N2aqbFqbs5qrqPlnj7vcfVHz/bZ+333vs/zfT7P5/vFfzh+A4rj5grFcSNVkfW/0PTcg2YwBsV5a0mS6ydNknsu8eX/UEmOH5+D7do+bNyVgdWFWVJaPK97GrW9K9ARrlU6I0sUezRBSEA56AWeeQHY8uEyFNRXo+niz6h230GV+z7qTt3HDsct7O4bhykworT4lyqNPiSRCbaKl/NUcjrWbz+DdWV/Yu/nxJEQ0TFLWK/JOkiYJonWb/9AwR4TCg88ibXbgCpXQkDfkobsik+xofIBth1myqELTD9+hYvME0Ke4lMmLx9tHRbBMFHYGMMafQ/0zY+JUELg9boKZJXcRd77RLmVDxuGuKrjHJNtYSqWIAvcPma0DxG2CHHIT5S23hPHZcivB4qbRGDd290SFsUWsXkv0Xxp4ecTvxCuOWqaLlKRkpCJo9OEwUfU9gyIi0Wo6RKBzDe/kSI2vRt3AOdtwnNXBH5l8rEIUyzSf/u4mgElYOLAeSoN50LP2gIZr3muP6EKhOMC2e8Qu3uJbiGrIpZpJreNcbHpqri6LGTJ4aNhPmK8xPS24XmdM3BzQ3d0XBW4jNVbCW2xGhIlXaphoq6f2NpAVHfJ7mOE8QqXWyaotY3SYD3JGnMvda7gKKAtMscFVBf65oVWtEWErpx4JZ9Ldzm4zB7kStv31HZFmOuc4AcWDytM/bH1jkAtsLb0JWQW3pYxEo3eBbvlNmLLfmKnkyWDAXr80yw5Ncuc7ijFNrNdIampT+Q9FSgyaGTXFhQd/BtmCawzKnZHxY2RqeVt7PQGePirKHOFqArkeKIPcjyRM9knr6fJWqagzjO/fqXMdgDvDfwVH5X9h/goNbZZruqfYd6xr6k7Eebmvgj3nJ2erBoIPl41GELWkRG5C2uKgU3SSm5lmrRhxPajM9LKb3IKY4vtM/M2t52ftTb8/obV+2XfhcnZ0/7Ax6VnZx7aPzSlHsMFaAw+NUzg1bdS5PkiNtbsgL59n85oNd45XRmKDZbtHPH7Mr+7OmY0n59azrkvkOyYFybwDyEpx3GqFugQAAAAAElFTkSuQmCC</ProgramIconBase64>
  <SPSPublisherName>mimic</SPSPublisherName>
  <SPSLicense>CC Attribution-NonCommercial-ShareAlike 4.0 International</SPSLicense>
  <SPSProgramReport>mailto:portapps@online.de</SPSProgramReport>
  <VirusTotalResult>
    <Permalink>https://www.virustotal.com/gui/file/58e23b9d966323c296099be5b44c5f38ff9ca0771ea8456a7cba70638d659574/detection/f-58e23b9d966323c296099be5b44c5f38ff9ca0771ea8456a7cba70638d659574-1632221618</Permalink>
    <DetectionRatio>0/51</DetectionRatio>
  </VirusTotalResult>
</SPSSchema>