var oRDFService=Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
var oLocalFile=Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
var oIOService=Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
var oAccountManager=Components.classes["@mozilla.org/messenger/account-manager;1"].getService(Components.interfaces.nsIMsgAccountManager);
var oThreadManager=Components.classes["@mozilla.org/thread-manager;1"].getService(Components.interfaces.nsIThreadManager)
var oFileProtocolHandler=oIOService.getProtocolHandler("file").QueryInterface(Components.interfaces.nsIFileProtocolHandler);
var oFilePicker=Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
var oAccounts=new Array();
const NC_LENGTH=NC.length;

// array indexes
const ENUM_ID=0;
const ENUM_FILEPATH=1;
const ENUM_DATASOURCE=2;
const ENUM_READED=3;
const ENUM_GLOBAL=4;
const ENUM_SERVER=5;
const ENUM_IMPORTED=6;
const LAST_ENUM=7;

//----------------------------------------------------------------------------------------------------------------
/**
*	Request user which account files should be import.
*
*	@internal
*		- fill the global array oAccounts,
*		- after this start the asynchron read process by calling readFile(),
*		- are all files readed function allReaded() is called
*/
function requestAccountFiles() {
	// create file open dialog
	oFilePicker.init(window, strbundle.getString("OpenFile"), nsIFilePicker.modeOpenMultiple);
	oFilePicker.appendFilter(strbundle.getString("AccountFile") + " (*.rdf)","*.rdf;");  

	if(oFilePicker.show() == nsIFilePicker.returnOK) {
		var tFiles=oFilePicker.files;
		var tAccounts=new Array();

		var nIndex=0;
		while(tFiles.hasMoreElements()) {
			var tAccount=new Array(LAST_ENUM);
			tAccount[ENUM_ID]=nIndex;
			tAccount[ENUM_FILEPATH]=tFiles.getNext().QueryInterface(Components.interfaces.nsILocalFile).path;
			tAccount[ENUM_DATASOURCE]=oRDFService.GetDataSource("file://"+tAccount[ENUM_FILEPATH]);
			tAccount[ENUM_READED]=false;
			tAccount[ENUM_GLOBAL]=0;
			tAccount[ENUM_SERVER]=0;
			tAccount[ENUM_IMPORTED]=false;
			oAccounts[nIndex]=tAccount;
			nIndex=nIndex+1;
		}
		
		nIndex=0;
		while(nIndex < oAccounts.length) {
			readFile(nIndex);
			nIndex=nIndex+1;
		}
	}
}

//----------------------------------------------------------------------------------------------------------------
/**
*	Read the account file @p aIndex.
*
*	@param aIndex The index of the RDF datasource, which capsulate the account file.
*
*	@internal
*		- @p aIndex is the index of the RDF datasource in the global array oAccounts
*		- if the datasource finished loaded readFileFinished() is called
*/
function readFile(aIndex) {
	// Data sources load asynchronously, so we have to wait until it's loaded.
	// This is the object that will observe the XML/RDF load progress.
	var tRdfObserver={
		onBeginLoad: function(sink){},
		onInterrupt: function(sink){},
		onResume: function(sink){},
		onEndLoad: function(sink){ readFileFinished(aIndex); },
		onError: function(sink, status, errorMsg){ alert("RDF LOADING FAILED: " + errorMsg); }
	};
	// XML/RDF files requires this "sink" thing, according to mozilla documentation.
	var tRemoteState=oAccounts[aIndex][ENUM_DATASOURCE].QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
	if(tRemoteState.loaded) {
		// If the load is already complete, cool.
		readFileFinished(aIndex);
	} else {
		// XML/RDF files requires this "sink" thing, according to mozilla documentation.
		oAccounts[aIndex][ENUM_DATASOURCE].QueryInterface(Components.interfaces.nsIRDFXMLSink).addXMLSinkObserver(tRdfObserver);
	}
}

//----------------------------------------------------------------------------------------------------------------
/**
*	Called if the loading of the RDF datasource at index @p aIndex is finished.
*
*	@param aIndex The index of the RDF datasource, which capsulate the account file.
*
*	@internal
*		- @p aIndex is the index of the datasource in the global array oAccounts
*		- on the same position a readed flag for the datasource is set
*		- with every calling all datasources are checked
*		- are all readed flags set allReaded() is called
*/
function readFileFinished(aIndex) {
	oAccounts[aIndex][ENUM_READED]=true;
	var nIndex=0;
	while(nIndex < oAccounts.length) {
		if(oAccounts[nIndex] && !oAccounts[nIndex][ENUM_READED]) {
			return;
		}
		nIndex=nIndex+1;
	}
	allReaded();
}

//----------------------------------------------------------------------------------------------------------------
/**
*	Called after all account files are readed.
*
*	@internal
*		- for every RDF datasource in oAccounts readGlobalData() and readServerData() is called
*		- is there an account for the local folder import it first by calling accountImport()
*		- after this all other accounts are importing by calling accountImport()
*		- at end accountImportFinish() is called
*/
function allReaded() {
	var nIndex=0;
	while(nIndex < oAccounts.length) {
		oAccounts[nIndex][ENUM_GLOBAL]=readGlobalData(nIndex);
		oAccounts[nIndex][ENUM_SERVER]=readServerData(nIndex);
		nIndex=nIndex+1;
	}
	// check one account is a local folder and import him
	nIndex=0;
	while(nIndex < oAccounts.length) {
		if(oAccounts[nIndex][ENUM_GLOBAL].type == "none") {
			accountImport(nIndex);
			oAccounts[nIndex][ENUM_IMPORTED]=true;
			break;
		}
		nIndex=nIndex+1;
	}
	// import all other accounts
	nIndex=0;
	while(nIndex < oAccounts.length) {
		if(!oAccounts[nIndex][ENUM_IMPORTED]) {
			accountImport(nIndex);
			oAccounts[nIndex][ENUM_IMPORTED]=true;
		}
		nIndex=nIndex+1;
	}
	// finish message
	accountImportFinish();
}

//----------------------------------------------------------------------------------------------------------------
/**
*	Read the global data part of the account file.
*
*	@param aIndex The index of the RDF datasource, which capsulate the account file.
*	@return Array The global data key/value pair array.
*
*	@internal
*		- the global data part of the account file at index @p aIndex is readed and
*		- saved in a key/value pair array
*/
function readGlobalData(aIndex) {
	var tGlobal=new Object;
	var tRdfGlobal=oRDFService.GetResource("http://accountex/global");
	var tArcs=oAccounts[aIndex][ENUM_DATASOURCE].ArcLabelsOut(tRdfGlobal);

	if(!tArcs.hasMoreElements()) {
		alert(oAccounts[aIndex][ENUM_FILEPATH]+"\n"+strbundle.getString("0002"));
	} else {
		while(tArcs.hasMoreElements()) {
			var tArc=tArcs.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
			var sArcName=tArc.Value;
			sArcName=sArcName.substring(NC_LENGTH, sArcName.length);
			tGlobal[sArcName]=oAccounts[aIndex][ENUM_DATASOURCE].GetTarget(tRdfGlobal, tArc, true).QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
		}
	}
	return tGlobal;
}

//----------------------------------------------------------------------------------------------------------------
/**
*	Read the server data part of the account file.
*
*	@param aIndex The index of the RDF datasource, which capsulate the account file.
*	@return Array The server data key/value pair array.
*
*	@internal
*		- the server data part of the account file at index @p aIndex is readed and
*		- saved in a key/value pair array
*/
function readServerData(aIndex) {
	var tServer=new Object;
	var tRdfServer=oRDFService.GetResource("http://accountex/server");
	var tArcs=oAccounts[aIndex][ENUM_DATASOURCE].ArcLabelsOut(tRdfServer);

	while(tArcs.hasMoreElements()) {
		var tArc=tArcs.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
		var sArcName=tArc.Value;
		sArcName=sArcName.substring(NC_LENGTH, sArcName.length);
		tServer[sArcName]=oAccounts[aIndex][ENUM_DATASOURCE].GetTarget(tRdfServer, tArc, true).QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
	}
	return tServer;
}

//----------------------------------------------------------------------------------------------------------------
/**
*	Imports the account data by checking the data of the global and server arrays at index @p aIndex.
*
*	@param aIndex The index of the RDF datasource, which capsulate the account file.
*
*	@internal
*		- this function makes really the work
*/
function accountImport(aIndex) {
	switch(oAccounts[aIndex][ENUM_GLOBAL].type) {
		//--------------------------------------------------------------------------------------------------------
		case "none":
			checkLocalFolder(aIndex);

			var tLocalServer=null;
			try {
				tLocalServer=oAccountManager.localFoldersServer;
			} catch(ex) {
				tLocalServer=null;
			}

			var tServer=null;
			if(tLocalServer == null) {
				tServer=oAccountManager.createIncomingServer("nobody", "Local Folders", "none");
			} else {
				tServer=oAccountManager.localFoldersServer
			}

			oLocalFile.path=oAccounts[aIndex][ENUM_SERVER].localPath;
			tServer.localPath=oLocalFile;
			tServer.emptyTrashOnExit=oAccounts[aIndex][ENUM_SERVER].emptyTrashOnExit;

			tServer.prettyName=oAccounts[aIndex][ENUM_SERVER].prettyName;

			var tLocalAccount=oAccountManager.createAccount();
			tLocalAccount.incomingServer=tServer;

			break;
		//--------------------------------------------------------------------------------------------------------
		case "pop3":
			var tPop3=readPopData(aIndex);

			if(AccountExists(oAccounts[aIndex][ENUM_SERVER].username, oAccounts[aIndex][ENUM_SERVER].hostName, oAccounts[aIndex][ENUM_GLOBAL].type)) {
				alert(strbundle.getString("0004"));
				break;
			}

			var tmpDefferedAccount="";
			if(tPop3.deferredToAccount == 1) {
				if(accountNameExists(tPop3.deferredToAccountName) == false) {
					var tResult=promptService.confirmEx(
						 window
						,strbundle.getString("TitleImport")
						,strbundle.getString("0005")
						,promptService.BUTTON_TITLE_IS_STRING
							* promptService.BUTTON_POS_0
							+ promptService.BUTTON_TITLE_CANCEL
							* promptService.BUTTON_POS_1
							+ promptService.BUTTON_TITLE_IS_STRING
							* promptService.BUTTON_POS_2
						,strbundle.getString("Wizard01")
						,null
						,strbundle.getString("Wizard02")
						,null
						,{value:0}
					);
					switch(tResult) {
						case 0:
							//Separater Posteingang
							tmpDefferedAccount="";
							break;
						case 1:
							//Abbruch
							break;
						case 2:
							//Lokaler Ordner
							if(checkLocalFolder(aIndex)) {
								var tLocalFoldersServer=oAccountManager.localFoldersServer;
								var tLocalFoldersAccount=oAccountManager.findAccountForServer(tLocalFoldersServer);
								var tDefferedAccount=tLocalFoldersAccount.key;
								break;
							}
					}
				} else {
					var tDefferedAccount=accountKey(tPop3.deferredToAccountName); 
				}
			}

			checkLocalFolder(aIndex);
		 
			var tNewServer=oAccountManager.createIncomingServer(oAccounts[aIndex][ENUM_SERVER].username, oAccounts[aIndex][ENUM_SERVER].hostName, oAccounts[aIndex][ENUM_GLOBAL].type);
			var tNewPop3=tNewServer.QueryInterface(Components.interfaces.nsIPop3IncomingServer);
			
			tNewPop3.deferredToAccount=tmpDefferedAccount;
		 
			tNewPop3.headersOnly=Number(tPop3.headersOnly);
			tNewPop3.leaveMessagesOnServer=Number(tPop3.leaveMessagesOnServer);
			tNewPop3.deleteByAgeFromServer=Number(tPop3.deleteByAgeFromServer);
			tNewPop3.numDaysToLeaveOnServer=tPop3.numDaysToLeaveOnServer;
			tNewPop3.deleteMailLeftOnServer=Number(tPop3.deleteMailLeftOnServer);
			tNewPop3.deferGetNewMail=Number(tPop3.deferGetNewMail);

			tNewServer.port=oAccounts[aIndex][ENUM_SERVER].port;
      tNewServer.socketType=Number(oAccounts[aIndex][ENUM_SERVER].socketType);
      tNewServer.isSecure=Number(oAccounts[aIndex][ENUM_SERVER].isSecure);
			tNewServer.useSecAuth=Number(oAccounts[aIndex][ENUM_SERVER].useSecAuth);
			tNewServer.loginAtStartUp=Number(oAccounts[aIndex][ENUM_SERVER].loginAtStartUp);
			tNewServer.biffMinutes=oAccounts[aIndex][ENUM_SERVER].biffMinutes;
			tNewServer.downloadOnBiff=Number(oAccounts[aIndex][ENUM_SERVER].downloadOnBiff);
			tNewServer.emptyTrashOnExit=Number(oAccounts[aIndex][ENUM_SERVER].emptyTrashOnExit);      
			oLocalFile.path=oAccounts[aIndex][ENUM_SERVER].localPath;
//			tNewServer.localPath=oLocalFile;
			tNewServer.prettyName=oAccounts[aIndex][ENUM_SERVER].prettyName;

			var tPop3Account=oAccountManager.createAccount();
			for(var i=0; i < oAccounts[aIndex][ENUM_GLOBAL].identities; i++) {
				var tIdentity=oAccountManager.createIdentity();

				var tObjIdentity=new Object;
					  
				var tRdfIdentity=oRDFService.GetResource("http://accountex/identity" + i);
				var tArcs=oAccounts[aIndex][ENUM_DATASOURCE].ArcLabelsOut(tRdfIdentity);
				
				while(tArcs.hasMoreElements()) {
					var tArc=tArcs.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
					var sArcName=tArc.Value;
					sArcName=sArcName.substring(NC_LENGTH, sArcName.length);
					tObjIdentity[sArcName]=oAccounts[aIndex][ENUM_DATASOURCE].GetTarget(tRdfIdentity, tArc, true).QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
					tIdentity[sArcName]=tObjIdentity[sArcName];
				}                
						
				tPop3Account.addIdentity(tIdentity);
			}

			tNewServer.valid=false;
			tPop3Account.incomingServer=tNewServer;
			tNewServer.valid=true;
				
			break;
		//--------------------------------------------------------------------------------------------------------
		case "imap":
			var tImap=readImapData(aIndex);

			if(AccountExists(oAccounts[aIndex][ENUM_SERVER].username, oAccounts[aIndex][ENUM_SERVER].hostName, oAccounts[aIndex][ENUM_GLOBAL].type)) {
				alert(strbundle.getString("0004"));
				break;
			}

			checkLocalFolder(aIndex);

			var tNewServer=oAccountManager.createIncomingServer(oAccounts[aIndex][ENUM_SERVER].username, oAccounts[aIndex][ENUM_SERVER].hostName, oAccounts[aIndex][ENUM_GLOBAL].type);
			var tNewImap=tNewServer.QueryInterface(Components.interfaces.nsIImapIncomingServer);

			tNewImap.capabilityPref=tImap.capabilityPref;
			tNewImap.personalNamespace=tImap.personalNamespace;
			tNewImap.publicNamespace=tImap.publicNamespace;
			tNewImap.otherUsersNamespace=tImap.otherUsersNamespace;
			tNewImap.downloadBodiesOnGetNewMail=Number(tImap.downloadBodiesOnGetNewMail);
			tNewImap.maximumConnectionsNumber=tImap.maximumConnectionsNumber;
			tNewImap.timeOutLimits=tImap.timeOutLimits;
			tNewImap.doingLsub=Number(tImap.doingLsub);
			if(tNewImap.storeReadMailInPFC !== undefined)
				tNewImap.storeReadMailInPFC=tImap.storeReadMailInPFC;
			tNewImap.overrideNamespaces=Number(tImap.overrideNamespaces);
			tNewImap.fetchByChunks=Number(tImap.fetchByChunks);
			tNewImap.mimePartsOnDemand=Number(tImap.mimePartsOnDemand);
			tNewImap.isAOLServer=Number(tImap.isAOLServer);
			tNewImap.usingSubscription=Number(tImap.usingSubscription);
			tNewImap.cleanupInboxOnExit=Number(tImap.cleanupInboxOnExit);
			if(tNewImap.storeSentMailInPFC !== undefined)
				tNewImap.storeSentMailInPFC=tImap.storeSentMailInPFC;
			tNewImap.offlineDownload=Number(tImap.offlineDownload);
			tNewImap.dualUseFolders=Number(tImap.dualUseFolders);
			tNewImap.aOLMailboxView=Number(tImap.aOLMailboxView);
			tNewImap.serverDirectory=tImap.serverDirectory;
			tNewImap.adminUrl=tImap.adminUrl;
			tNewImap.manageMailAccountUrl=tImap.manageMailAccountUrl;
			tNewImap.deleteModel=tImap.deleteModel;
			tNewImap.emptyTrashThreshhold=tImap.emptyTrashThreshhold;
			if(tNewImap.redirectorType !== undefined)
				tNewImap.redirectorType=tImap.redirectorType;
			tNewImap.timeOutLimits=tImap.timeOutLimits;

			tNewServer.port=oAccounts[aIndex][ENUM_SERVER].port;
      tNewServer.socketType=Number(oAccounts[aIndex][ENUM_SERVER].socketType);
			tNewServer.isSecure=Number(oAccounts[aIndex][ENUM_SERVER].isSecure);
			tNewServer.useSecAuth=Number(oAccounts[aIndex][ENUM_SERVER].useSecAuth);
			tNewServer.loginAtStartUp=Number(oAccounts[aIndex][ENUM_SERVER].loginAtStartUp);
			tNewServer.biffMinutes=oAccounts[aIndex][ENUM_SERVER].biffMinutes;
			tNewServer.downloadOnBiff=Number(oAccounts[aIndex][ENUM_SERVER].downloadOnBiff);
			tNewServer.emptyTrashOnExit=Number(oAccounts[aIndex][ENUM_SERVER].emptyTrashOnExit);      
			tNewServer.prettyName=oAccounts[aIndex][ENUM_SERVER].prettyName;

			var tImapAccount=oAccountManager.createAccount();

			for (var i=0; i < oAccounts[aIndex][ENUM_GLOBAL].identities; i++) {
				var tIdentity=oAccountManager.createIdentity();

				var tObjIdentity=new Object;

				var tRdfIdentity=oRDFService.GetResource("http://accountex/identity" + i);
				var tArcs=oAccounts[aIndex][ENUM_DATASOURCE].ArcLabelsOut(tRdfIdentity);

				while (tArcs.hasMoreElements()) {
					var tArc=tArcs.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
					var sArcName=tArc.Value;
					sArcName=sArcName.substring(NC_LENGTH, sArcName.length);
					tObjIdentity[sArcName]=oAccounts[aIndex][ENUM_DATASOURCE].GetTarget(tRdfIdentity, tArc, true).QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
					tIdentity[sArcName]=tObjIdentity[sArcName];
				}                
				tImapAccount.addIdentity(tIdentity);
			}

			tNewServer.valid=false;
			tImapAccount.incomingServer=tNewServer;
			tNewServer.valid=true;

			break;
	}
}

//----------------------------------------------------------------------------------------------------------------
function readImapData(aIndex) {
	var tImap=new Object;
	var tRdfImap=oRDFService.GetResource("http://accountex/imap");
	var tArcs=oAccounts[aIndex][ENUM_DATASOURCE].ArcLabelsOut(tRdfImap);

	while(tArcs.hasMoreElements()) {
		var tArc=tArcs.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
		var sArcName=tArc.Value;
		sArcName=sArcName.substring(NC_LENGTH, sArcName.length);
		tImap[sArcName]=oAccounts[aIndex][ENUM_DATASOURCE].GetTarget(tRdfImap, tArc, true).QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
	}
	return tImap;
}

//----------------------------------------------------------------------------------------------------------------
function readPopData(aIndex) {
	var tPop3=new Object;
	var tRdfPop3=oRDFService.GetResource("http://accountex/pop3");
	var tArcs=oAccounts[aIndex][ENUM_DATASOURCE].ArcLabelsOut(tRdfPop3);

	while(tArcs.hasMoreElements()) {
		var tArc=tArcs.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
		var sArcName=tArc.Value;
		sArcName=sArcName.substring(NC_LENGTH, sArcName.length);
		tPop3[sArcName]=oAccounts[aIndex][ENUM_DATASOURCE].GetTarget(tRdfPop3, tArc, true).QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
	}
	return tPop3;
}

//----------------------------------------------------------------------------------------------------------------
function accountNameExists(aAccountName) {
	var bDefferedAccountExists=false;

	var tOriginalAccounts=PrefValue("mail.accountmanager.accounts");
	if(tOriginalAccounts) {
		var tAccounts=tOriginalAccounts.split(",");
		var nAccountCount=tAccounts.length;
		for(var i=0; i < nAccountCount; i++) {
			var tAccount=oAccountManager.getAccount(tAccounts[i]);
			var tServer=tAccount.incomingServer;
			if(tServer.prettyName == aAccountName) {
				bDefferedAccountExists=true;
				break;
			}
		}
	}
	return bDefferedAccountExists;
}

//----------------------------------------------------------------------------------------------------------------
function accountKey(aAccountName) {
	var sAccountKey="";

	var tOriginalAccounts=PrefValue("mail.accountmanager.accounts");
	if(tOriginalAccounts) {
		var tAccounts=tOriginalAccounts.split(",");
		var nAccountCount=tAccounts.length;
		for(var i=0; i < nAccountCount; i++) {
			var tAccount=oAccountManager.getAccount(tAccounts[i]);
			var tServer=tAccount.incomingServer;
			if(tServer.prettyName == aAccountName) {
				sAccountKey=tAccount.key;
				break;
			}
		}
	}
	return sAccountKey;
}

//----------------------------------------------------------------------------------------------------------------
function checkLocalFolder(aIndex){
	var tLocalFoldersServer=false;
	try {
		tLocalFoldersServer=oAccountManager.localFoldersServer;
	} catch(ex) {
		tLocalFoldersServer=false;
	}
	if(oAccounts[aIndex][ENUM_GLOBAL].type == "none") {
		if(tLocalFoldersServer != false) {
			var tResult=promptService.confirmEx(
				 window
				,strbundle.getString("TitleImport")
				,strbundle.getString("0001")
				,promptService.BUTTON_TITLE_IS_STRING
					* promptService.BUTTON_POS_0
					+ promptService.BUTTON_TITLE_IS_STRING
					* promptService.BUTTON_POS_1
				,strbundle.getString("WizardContinue")
				,strbundle.getString("WizardExit")
				,null
				,null
				,{value:0}
			);
			if(tResult == 1) {
			}  
		}
	} else {
		if(tLocalFoldersServer == false) {
			var tResult=promptService.confirmEx(
				 window
				,strbundle.getString("TitleImport")
				,strbundle.getString("0003")
				,promptService.BUTTON_TITLE_IS_STRING
					* promptService.BUTTON_POS_0
					+ promptService.BUTTON_TITLE_IS_STRING
					* promptService.BUTTON_POS_1
				,strbundle.getString("WizardContinue")
				,strbundle.getString("WizardExit")
				,null
				,null
				,{value:0}
			);
			if(tResult == 1) {
				tLocalFoldersServer=false;
			} else {
				oAccountManager.createLocalMailAccount();
				tLocalFoldersServer=true;
			}
		}
	} 
	return tLocalFoldersServer;
}

//----------------------------------------------------------------------------------------------------------------
function accountImportFinish() {
	deck.setAttribute("selectedIndex", "4");
	var tFinishFile=document.getElementById("finishFile");
	//tFinishFile.value=filePicker.file.path;
	backButton.setAttribute("disabled", true); 
	forwardButton.label=forwardButton.getAttribute("finishedval");
	forwardButton.setAttribute("dlgtype", "finish");
	cancelButton.setAttribute("disabled", true);  
	checkImportFinish=document.getElementById("checkExportFinish");
	checkImportFinish.checked=false;
}
