/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
var rdf = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);

//var uri = kPersonalAddressbookURI;

//var directory = rdf.GetResource(uri).QueryInterface(Components.interfaces.nsIAbDirectory);


function lookUpSenders(event)
{
  var loadedFolder = GetLoadedMsgFolder();
  var messageArray = GetSelectedMessages();
  var emailArray = new Array;
  if(messageArray){
    for(var msg in messageArray){
      var messageUri = messageArray[msg];
      var hdr = messenger.messageServiceFromURI(messageUri).messageURIToMsgHdr(messageUri);
      senderAddress = hdr.author;
      unformattedAddress = senderAddress;
      formattedAddress = emailCleanup(unformattedAddress);
      primaryEmail = formattedAddress[0];
      emailArray.push(primaryEmail);
  
    }
    lookUpInBooks(emailArray);
  }
}

function lookUpRecipients(event)
{
  var addressArray = new Array;
  addressArray = getRecipients(event);
  addressArray = makeSortedList(addressArray);
  addressArray = simplifyAddresses(addressArray);
  lookUpInBooks(addressArray);
}

function lookUpCard(emailNode)
{
  if(emailNode){
    var email = emailNode.getAttribute("emailAddress");
    var emailArray = new Array;
    emailArray.push(email);
    lookUpInBooks(emailArray);
  }
}
  
  

function lookUpInBooks(emailArray){
  for(var i in emailArray){
      
    var rdfService = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
  
  // enumerate all of the address books on this system
    var parentDir = rdfService.GetResource("moz-abdirectory://").QueryInterface(Components.interfaces.nsIAbDirectory);
    var enumerator = parentDir.childNodes;
    if (enumerator) {
        var matchFound = false;
        while (enumerator.hasMoreElements()) {
            var addrbook = enumerator.getNext();  // an addressbook directory
            addrbook.QueryInterface(Components.interfaces.nsIAbDirectory);
            var searchUri = addrbook.directoryProperties.URI + "?(or(PrimaryEmail,c," + emailArray[i] + "))";  // search for the address in this book
            var directory = rdfService.GetResource(searchUri).QueryInterface(Components.interfaces.nsIAbDirectory);
            // directory will now be a subset of the addressbook containing only those cards that match the searchstring 'address'
            try {
                var ChildCards = directory.childCards;
                ChildCards.first();
                var CurrentItem = ChildCards.currentItem();
            } catch(e) {
                var ChildCards = directory.childNodes;
                if (ChildCards.hasMoreElements()) var CurrentItem = ChildCards.getNext();
            }
            // if the directory has *any* items, they will be matches of the address
            try {
                var CurrentCard = CurrentItem.QueryInterface(Components.interfaces.nsIAbCard);
                // current card is now the addressbook card of a contact that has 'address'
                if (CurrentCard.primaryEmail.toLowerCase() == emailArray[i].toLowerCase()) {
                    // open the 'edit contact dialog for this card
                    var CurrentBookURI = addrbook.directoryProperties.URI;
                    window.openDialog("chrome://messenger/content/addressbook/abEditCardDialog.xul", "", "chrome,resizable=no,modal,titlebar,centerscreen",{abURI:CurrentBookURI, card:CurrentCard, okCallback:null});
                    matchFound = true;
                    break;
                }
            }  catch (e)  {
                // we would be here if the directory contained no items
            }
          // if no match found above
          // lets now search the 'second email' of all the contacts in this addressBook
            var searchUri=addrbook.directoryProperties.URI + "?(or(SecondEmail,c," + emailArray[i] + "))";
            var directory = rdfService.GetResource(searchUri).QueryInterface(Components.interfaces.nsIAbDirectory);
            try {
                var ChildCards = directory.childCards;
                ChildCards.first();
                var CurrentItem = ChildCards.currentItem();
            } catch(e) {
                var ChildCards = directory.childNodes;
                if (ChildCards.hasMoreElements()) var CurrentItem = ChildCards.getNext();
            }
            try {
                var CurrentCard = CurrentItem.QueryInterface(Components.interfaces.nsIAbCard);
                if (CurrentCard.secondEmail.toLowerCase() == emailArray[i].toLowerCase()) {
                    // open the 'edit contact dialog for this card
                    var CurrentBookURI = addrbook.directoryProperties.URI;
                    window.openDialog("chrome://messenger/content/addressbook/abEditCardDialog.xul", "", "chrome,resizable=no,modal,titlebar,centerscreen", {abURI:CurrentBookURI, card:CurrentCard,  okCallback:null});
                    matchFound = true;
                    break;
                }
            }  catch (e)  {
              // we would be here if the directory contained no items
            }
        }
    }
    if(!matchFound){
      if(confirm("No match found for " + emailArray[i] + ". Add to Address Book?")){
        window.openDialog("chrome://addresscontext/content/aCNewCardDialog.xul", "", "chrome,titlebar,modal,resizable=no", {primaryEmail:emailArray[i]});
      }
    }
  }
}


function addSenderAsCard(event)
{
  var loadedFolder = GetLoadedMsgFolder();
  var messageArray = GetSelectedMessages();
  var senderAddress = null;
  var displayName;
  var primaryEmail;
  if (messageArray && messageArray.length > 0){
    uri = "";
    for (var i = 0; i < messageArray.length; i ++)
    {
      var messageUri = messageArray[i];
      var hdr = messenger.messageServiceFromURI(messageUri).messageURIToMsgHdr(messageUri);
      senderAddress = hdr.author;
      unformattedAddress = senderAddress;
      formattedAddress = emailCleanup(unformattedAddress);
      primaryEmail = formattedAddress[0];
      displayName = formattedAddress[1];
      firstName = formattedAddress[2];
      lastName = formattedAddress[3];
      window.openDialog("chrome://addresscontext/content/aCNewCardDialog.xul", "", "chrome,titlebar,modal,resizable=no", {primaryEmail:primaryEmail, displayName:displayName, firstName:firstName, lastName:lastName });
    }
  }
}

function addRecipientsAsCards(event)
{
  messageArray = getRecipients(event);
  if (messageArray && messageArray.length > 0){
    uri = "";
    for (var i = 0; i < messageArray.length; i ++)
    {
      senderAddress = messageArray[i];
      unformattedAddress = senderAddress;
      formattedAddress = emailCleanup(unformattedAddress);
      primaryEmail = formattedAddress[0];
      displayName = formattedAddress[1];
      firstName = formattedAddress[2];
      lastName = formattedAddress[3];
      window.openDialog("chrome://addresscontext/content/aCNewCardDialog.xul", "", "chrome,titlebar,modal,resizable=no", {primaryEmail:primaryEmail, displayName:displayName, firstName:firstName, lastName:lastName });
    }
  }
}

function addSendersAsList(event)
{
  var loadedFolder = GetLoadedMsgFolder();
  var messageArray = GetSelectedMessages();
  var allSenders = null;
  if (messageArray && messageArray.length > 0){
    for (var i = 0; i < messageArray.length; i++){
      var messageURI = messageArray[i];
      var hdr = messenger.messageServiceFromURI(messageURI).messageURIToMsgHdr(messageURI);
      if (allSenders == null) {
        allSenders = hdr.author;
			}
			else {
				allSenders += ', ';
				allSenders += hdr.author;
			}
		}
		addressArray = new Array;
		addressArray = createAddressList(allSenders);
    addressArray = makeSortedList(addressArray);
    addressArray = simplifyAddresses(addressArray);
		window.openDialog("chrome://addresscontext/content/aCListDialog.xul","", "chrome,resizable=no,titlebar,modal,centerscreen", {addressArray:addressArray});
  }
}
			 

function getRecipients(event)
{
  var loadedFolder = GetLoadedMsgFolder();
  var messageArray = GetSelectedMessages();
  var longRecipients = null;
  if (messageArray && messageArray.length > 0){
    for (var i = 0; i < messageArray.length; i ++){
      var messageURI = messageArray[i];
      var hdr = messenger.messageServiceFromURI(messageURI).messageURIToMsgHdr(messageURI);
      if (longRecipients == null){
        longRecipients = hdr.recipients;
      }
      else{
        longRecipients += ', ';
        longRecipients += hdr.recipients;
      }
      if (hdr.ccList){
        ccPeople = hdr.ccList;
        if (longRecipients == null){
          longRecipients = hdr.ccList;
        }
        else{
          longRecipients += ', ';
          longRecipients += ccPeople;
        }
      }
    }
    addressArray = new Array;
    addressArray = createAddressList(longRecipients);
    return addressArray;
  }
}

function addRecipientsAsList(event)
{
  addressArray = getRecipients(event);
  addressArray = makeSortedList(addressArray);
  addressArray = simplifyAddresses(addressArray);
  window.openDialog("chrome://addresscontext/content/aCListDialog.xul","", "chrome,resizable=no,titlebar,modal,centerscreen", {addressArray:addressArray});
}

function emailCleanup(unformattedAddress)
{
  var primaryEmail;
  var displayName = null;
  if (unformattedAddress.search('<')!= -1){
    var beginpos = unformattedAddress.search('<');
    var endpos = unformattedAddress.search('>');
    beginpos--;
    displayName = unformattedAddress.slice(0, beginpos);
    beginpos = beginpos + 2;
    primaryEmail = unformattedAddress.slice(beginpos, endpos);
  }
  if (/\"/.test(displayName)){
    leftofquote = displayName.indexOf("\"") + 1;
    rightofquote = displayName.lastIndexOf("\"");
    displayName = displayName.substring(leftofquote, rightofquote);
  }
  if (displayName){
		lastName = /\w+$/.exec([displayName])
    firstName = displayName.replace(lastName, "")
		firstName = firstName.replace(/\s$/, "")
		formattedAddress = new Array;
    formattedAddress[0] = primaryEmail;
    formattedAddress[1] = displayName;
    formattedAddress[2] = firstName;
    formattedAddress[3] = lastName;
  }
  if (!displayName){
    primaryEmail = unformattedAddress;
    formattedAddress = new Array;
    formattedAddress[0] = primaryEmail;
    formattedAddress[1] = null;
    formattedAddress[2] = null;
    formattedAddress[3] = null;
  }
  return formattedAddress;
}

function createAddressList(addressList)
{
  var arrayElement = 0;
  while (addressList != ""){
    var commaDeclare = ",";
    if (addressList.search(commaDeclare) != -1){
      var blank = "";
      var commaPlace = addressList.indexOf("\,");
      var firstEntry = addressList.substr(0, commaPlace);
      currentName = firstEntry.replace(/\s$/, "");
       //check for case of "Last Name, First Name" <email@address.com>
       if (/\"(?=\w+$)/.test(currentName) == true){
         commaPlace++;
         addressList = addressList.substr(commaPlace);
         if (addressList.search(commaDeclare) == -1){
           var secondEntry = addressList;
           firstName = currentName;
           currentName = firstName + "\,\ " + secondEntry;
           addressArray[arrayElement] = currentName;
           return addressArray;
         }
         else{
           newCommaPlace = addressList.indexOf("\,");
           var secondEntry = addressList.substr(0, newCommaPlace);
         }
         addressList = addressList.replace(secondEntry, blank);
         firstName = currentName;
         currentName = firstName + "\,\ " + secondEntry;
         addressArray[arrayElement] = currentName;
       }
       else{
         addressArray[arrayElement] = currentName;
         commaPlace = commaPlace + 2;
         addressList = addressList.substr(commaPlace);
       }  
    }
    else if (addressList.search(commaDeclare) == -1 && addressList.length != 0){
      addressArray[arrayElement] = addressList;
      return addressArray;
    }
    arrayElement++;
  }
}

function prepareMailWindow()
{
  var selectedAB = null;
  selectedAB = kPersonalAddressbookURI;
  //  gAddressBookBundle = document.getElementById("bundle_addressBook");
  // set popup with address book names
  var abPopup = document.getElementById('abPopup');
  if ( abPopup ){
    var menupopup = document.getElementById('abPopup-menupopup');
    if ( selectedAB && menupopup && menupopup.childNodes ){
      for ( var index = menupopup.childNodes.length - 1; index >= 0; index-- ){
        if ( menupopup.childNodes[index].getAttribute('value') == selectedAB ){
          //abPopup.label = menupopup.childNodes[index].getAttribute('label');
          abPopup.value = menupopup.childNodes[index].getAttribute('value');
          break;
        }
      }
    }
  }
  document.getElementById('ListName').value = "New List";
  AppendNewRowAndSetFocus();
  awFitDummyRows(1);
  var total = window.arguments[0].addressArray.length;
  if (total){
    var listbox = document.getElementById('addressingWidget');
    var newListBoxNode = listbox.cloneNode(false);
    var templateNode = listbox.getElementsByTagName("listitem")[0];
    top.MAX_RECIPIENTS = 0;
    for ( var i = 0;  i < total; i++ ){
      if (window.arguments[0].addressArray[i] !== null){
      address = window.arguments[0].addressArray[i];
      SetInputValue(address, newListBoxNode, templateNode);}
    }
      var parent = listbox.parentNode;
      parent.replaceChild(newListBoxNode, listbox);
  }

}

function newCardFromContext()
{
  OnLoadNewCard();
  fillNames();
}

function makeSortedList(addressArray)
{
  i = 0;
  unsortedAddresses = new Array;
  for (i; i < addressArray.length; i++){
    var currentAddress = addressArray[i];
    unsortedAddresses[i] = new Array;
    unsortedAddresses[i] = emailCleanup(currentAddress);
  }
  sortedAddresses = new Array;
  sortedAddresses = unsortedAddresses.sort(addressSortFunction);
  addressArray = checkDuplicates(sortedAddresses);
  return addressArray;
}

function checkDuplicates(sortedAddresses)
{
  //count the duplicates
  i = 0;
  k = 0;
  noDupes = new Array;
  for (i; i < (sortedAddresses.length);)
  {
    j = i + 1;
    if (j < (sortedAddresses.length)){
      counter = 0;
      while (sortedAddresses[i][0] == sortedAddresses[j][0])
      {
        counter++;
        j++;
        if (j == (sortedAddresses.length)){
          break}
      }
    }
    noDupes[k] = sortedAddresses[i];
    i = j;
    k++;
  }
  return noDupes;
}
// function checkDuplicates(addressArray)
// {
   // i = 0;
   // for (i; i < (addressArray.length - 1); i++){
     // j = i + 1;
     // for (j; j < addressArray.length; j++){
       // if (addressArray[i] !== null && addressArray[j] !== null){
         // var firstEmail = addressArray[i];
         // var secondEmail = addressArray[j];
         // firstToCompare = new Array;
         // secondToCompare = new Array;
         // var unformattedAddress;
         // firstToCompare = emailCleanup(firstEmail);
         // secondToCompare = emailCleanup(secondEmail);
         // if (firstToCompare[0] == secondToCompare[0]){
           // if (firstToCompare[1] !== null && secondToCompare[1] !== null){
             // if (firstToCompare[1].length > secondToCompare[1].length){
               // addressArray[j] = null}
             // else {
               // addressArray[i] = addressArray[j];
               // addressArray[j] = null};
           // }
           // else if (firstToCompare[1] !== null && secondToCompare[1] == null){
            // addressArray[j] = null}
           // else if (firstToCompare[1] == null && secondToCompare[1] !== null){
            // addressArray[i] = addressArray[j];
            // addressArray[j] = null}
           // else if (firstToCompare[1] == null && secondToCompare[1] == null){
            // addressArray[j] = null}
         // }
       // }
     // }
   // }
   // return addressArray;
// }

function simplifyAddresses(addressArray)
{
  simplifiedAddresses = new Array;
  i = 0;
  for (i;i<addressArray.length;i++)
  {
    if (addressArray[i][1] == null){
      simplifiedAddresses[i] = addressArray[i][0];
    }
    else{
      simplifiedAddresses[i] = addressArray[i][1] + ' <' + addressArray[i][0] + '>';
    }
  }
  return simplifiedAddresses;
}

function addressSortFunction(a,b) {
  if (a[0]<b[0]) return -1;
  if (a[0]>b[0]) return 1;
  return 0;
}

function fillNames()
{
  if ("firstName" in window.arguments[0])
  document.getElementById('FirstName').value = window.arguments[0].firstName;
  if ("lastName" in window.arguments[0] && "firstName" in window.arguments[0])
  document.getElementById('LastName').value = window.arguments[0].lastName;
}
