/**
 * Additional Folders View, http://www.legege.com
 * Copyright (C) 2006-2007 All Rights Reserved.
 * Author: Georges-Etienne Legendre (legege@legege.com)
 */

var gAFView = {

  /**
   * Preferences
   */
  pref: {
    PREF_BRANCH: "extensions.afview.",
    PREF_FOLDERPANE_VIEW: "folderpane.view",
    PREF_FOLDERPANE_POSITION: "folderpane.position",
    _prefService: Components.classes["@mozilla.org/preferences-service;1"]
                            .getService(Components.interfaces.nsIPrefService),

    /**
     * @return Returns the preferences branch.
     */
    get branch() {
      return this._prefService.getBranch(this.PREF_BRANCH);
    },

    /**
     * @return Returns the folder pane view.
     */
    get folderPaneView() {
      try {
        return this.branch.getIntPref(this.PREF_FOLDERPANE_VIEW);
      }
      catch (e) {
        this.branch.setIntPref(this.PREF_FOLDERPANE_VIEW, 1);
        return 1;
      }
    },

    /**
     * Set the folder pane view.
     * @param v The view number
     */
    set folderPaneView(v) {
      this.branch.setIntPref(this.PREF_FOLDERPANE_VIEW, v);
    },

    /**
     * @return Returns the folder pane position.
     */
    get folderPanePosition() {
      try {
        return this.branch.getCharPref(this.PREF_FOLDERPANE_POSITION);
      }
      catch (e) {
        this.branch.setCharPref(this.PREF_FOLDERPANE_POSITION, "top");
        return "top";
      }
    },

    /**
     * Set the folder pane position.
     * @param v The position name
     */
    set folderPanePosition(v) {
      this.branch.setCharPref(this.PREF_FOLDERPANE_POSITION, v);
    }
  }
}

