//*****************************************************************************************************
//* Funktionen
//*****************************************************************************************************
var PrefService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
var PrefBranch = PrefService.getBranch(null).QueryInterface(Components.interfaces.nsIPrefBranchInternal);
var filePicker = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
var nsIFilePicker = Components.interfaces.nsIFilePicker;
var accountManager = Components.classes["@mozilla.org/messenger/account-manager;1"].getService(Components.interfaces.nsIMsgAccountManager);
var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService);

//*****************************************************************************************************
//* Konstanten
//*****************************************************************************************************
const NC = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";

//*****************************************************************************************************
//* Variablen
//*****************************************************************************************************
var strbundle;
var strmessenger;
var ExportRadioGroup;
var ImportRadioGroup;
var forwardButton;
var backButton;
var cancelButton;
var deck;
var accountList;
var ServerPath;

//Start
function OnLoad() {

    strbundle=document.getElementById("strings");
    strmessenger=document.getElementById("strings-messenger");
    deck = document.getElementById("mainDeck");

    document.title = strbundle.getString("Title");
    ExportRadioGroup = document.getElementById("export");
    ImportRadioGroup = document.getElementById("import");
    forwardButton = document.getElementById("forward");
    backButton = document.getElementById("back");
    cancelButton = document.getElementById("cancel");
    accountList = document.getElementById("profiles");
    ServerPath = document.getElementById("ServerPath");
    ServerPathNew = document.getElementById("ServerPathNew");
    desc_import = document.getElementById("desc_import");
    forwardButton.label = forwardButton.getAttribute("nextval");
    forwardButton.setAttribute("dlgtype", "next");
  
    try {
        originalAccounts = PrefValue("mail.accountmanager.accounts");
        var accounts = originalAccounts.split(",");
        accountCount = accounts.length;

    } catch (ex) {
        accountCount = 0;
    }

    if (accountCount == 1) {
        ExportRadioGroup.setAttribute("selected", false);
        ImportRadioGroup.setAttribute("selected", true);
        ExportRadioGroup.setAttribute("disabled", true);
        ImportRadioGroup.setAttribute("value", "2");
    } else {
        ExportRadioGroup.setAttribute("disabled", false);
        ExportRadioGroup.setAttribute("selected", true);
        ExportRadioGroup.setAttribute("value", "1");
        ImportRadioGroup.setAttribute("selected", false);
    }
//alert(accountCount);
}

//Schaltflche "weiter"
function next() {
    var index = deck.getAttribute("selectedIndex");

    switch (index) {
        case "0":
            document.title = strbundle.getString("Title");
            var bExportDisabled=ExportRadioGroup.getAttribute("disabled");
            var bExportSelected=ExportRadioGroup.getAttribute("selected");
            var bImportSelected=ImportRadioGroup.getAttribute("selected");
            if((ExportRadioGroup.getAttribute("disabled") == "false") && (ExportRadioGroup.getAttribute("selected") == "true")) {
                InitExport();
                deck.setAttribute("selectedIndex", "1");
                document.title = strbundle.getString("TitleExport");
                forwardButton.setAttribute("disabled", true);
            } else if (ImportRadioGroup.getAttribute("selected")) {
                document.title = strbundle.getString("TitleImport");
                requestAccountFiles();
                break;
            }
            backButton.removeAttribute("disabled");
            break;
        case "1":
            theListbox = document.getElementById("profiles");
            for(var i=0; i < theListbox.selectedCount; ++i)
            {
                AccountExport(theListbox.getSelectedItem(i).getAttribute("value"));
            }
            deck.setAttribute("selectedIndex", "2");
            backButton.setAttribute("disabled", true);
            forwardButton.label = forwardButton.getAttribute("finishedval");
            forwardButton.setAttribute("dlgtype", "finish");
            cancelButton.setAttribute("disabled", true);
            checkExportFinish = document.getElementById("checkExportFinish");
            checkExportFinish.checked = false;
            break;
        case "2":
            checkExportFinish = document.getElementById("checkExportFinish");
            if (checkExportFinish.checked) {
                OnLoad();
                deck.setAttribute("selectedIndex", "0");
            } else {
                close();
            }
            break;
        case "3":
//            tServer.localPath = ServerPathNew.value;
//            CheckServerData(tServer);
            setServerPath(ServerPathNew.value);
            break;
        case "4":
            checkImportFinish = document.getElementById("checkImportFinish");
            if (checkImportFinish.checked) {
                OnLoad();
                deck.setAttribute("selectedIndex", "0");
            } else {
                close();
            }
            break;
    }
}

//Schaltflche "zurck"
function back() {
    document.title = strbundle.getString("Title");

    var backIndex = deck.getAttribute("selectedIndex") -1;
    backButton.setAttribute("disabled", "true");
    forwardButton.label = forwardButton.getAttribute("nextval");
    forwardButton.removeAttribute("disabled");
    deck.setAttribute("selectedIndex", backIndex);
}

//ListboxKlick
function ListClick(index) {
    forwardButton.setAttribute("disabled", false);
    SelectedAccount = accountList.getItemAtIndex(index).getAttribute("value");
}

//ListboxKlick
function ListClick() {
    forwardButton.setAttribute("disabled", accountList.selectedCount == 0);
}

//Listbox mit konten fllen
function InitExport() {
    ClearListbox(accountList);

    try {
        originalAccounts = PrefValue("mail.accountmanager.accounts");
        var allServers = accountManager.allServers;
        var accounts = originalAccounts.split(",");

        for (var i = 0; i < accounts.length; ++i) {
            for (var ii=0; ii < allServers.Count(); ii++) {
                var currentServer = allServers.GetElementAt(ii).QueryInterface(Components.interfaces.nsIMsgIncomingServer);
                var type = currentServer.type;

                if ( accounts[i] == accountManager.FindAccountForServer(currentServer).key) {
                    //          if (type == "none" || type == "pop3" || type == "imap" || type == "rss") {
                    if (type == "none" || type == "pop3" || type == "imap") {
                        if (type == "none") {
                            var theListitem = accountList.appendItem("[" + strmessenger.getString("localFolders") + "] - " + currentServer.prettyName, accounts[i]);
                        } else {
                            var theListitem = accountList.appendItem("[" + type + "] - " + currentServer.prettyName, accounts[i]);
                        }
                        theListitem.setAttribute("class", "folderMenuItem listitem-iconic")
                        theListitem.setAttribute("ServerType",type);
                        theListitem.setAttribute("IsServer",true);
                        theListitem.setAttribute("IsSecure",currentServer.isSecure);
                    }
                }
            }
        }
    } catch (ex) {}
}

//Werte aus der prefs.js auslesen
function PrefValue(PrefName) {
    switch (PrefBranch.getPrefType(PrefName)) {
        case PrefBranch.PREF_BOOL:
            return PrefBranch.getBoolPref(PrefName).toString();
            break;
        case PrefBranch.PREF_INT:
            return PrefBranch.getIntPref(PrefName).toString();
            break;
        case PrefBranch.PREF_STRING:
            return PrefBranch.getCharPref(PrefName);
            break;
    }
}

//Inhalt einer Listbox lschen (Original von EdDialogCommon)
function ClearListbox(listbox) {
    if (listbox) {
        listbox.clearSelection();
        while (listbox.firstChild)listbox.removeChild(listbox.firstChild);
    }
}

//Betriebssystem ermitteln
function OS() {
    var platform = window.navigator.platform.toLowerCase();
    if (platform.indexOf("win") != -1) {
        return "win";
    } else if (platform.indexOf("mac") != -1) {
        return "mac";
    } else if (platform.indexOf("unix") != -1 || platform.indexOf("linux") != -1 || platform.indexOf("sun") != -1) {
        return "unix";
    }
}

function LocalFolder() {

    filePicker.init(window, document.getElementById("ServerPathNew").getAttribute("filepickertitle"), nsIFilePicker.modeGetFolder);

    if(filePicker.show() == nsIFilePicker.returnOK) {
        var allServers = accountManager.allServers;

        for (var i=0; i < allServers.Count(); i++) {
            var currentServer = allServers.GetElementAt(i).QueryInterface(Components.interfaces.nsIMsgIncomingServer);
            var localPath = currentServer.localPath;
        //      if (currentServer.key != gServer.key && fp.file.path == localPath.nativePath) {
        //        var directoryAlreadyUsed = top.gPrefsBundle.getString("directoryUsedByOtherServer");
        //        promptService.alert(window, null, directoryAlreadyUsed);
        //        return;
        //      }
        }
    }

    //  // convert the nsILocalFile into a nsIFileSpec
    ServerPathNew.value = filePicker.file.path;
    forwardButton.setAttribute("disabled", false);
//  objServer.localPath = filePicker.file.path;
}
