var FireShotUtils =
{
	addonVersion : "0.0",
	
	fixFlash: function (flashObjects, flashModes)
	{
		flashObjects.length = 0;
		flashModes.length = 0;

		var flashTags = this.getTopWindow().document.getElementsByTagName("embed");
		for (var i = 0; i < flashTags.length; i++)
		{
			var flash = flashTags[i];
			var attr = flash.getAttribute("wmode");
			var type = flash.getAttribute("type");
			if (type != "application/pdf" && (attr == "window" || attr == null || attr == ""))
			{
				flashObjects.push(flash);
				flashModes.push(attr);
			}
		}

		for (var i = 0; i < flashObjects.length; i++)
		{
			var flash = flashObjects[i];
			flash.setAttribute("wmode", "opaque");
			var parent = flash.parentNode;
			parent.removeChild(flashObjects[i]);
			parent.appendChild(flash);
		}

		return;
	},

	restoreFlash: function (flashObjects, flashModes)
	{
		for (var i = 0; i < flashObjects.length; i++)
		{
			var flash = flashObjects[i];
			flash.setAttribute("wmode", flashModes[i]);
			var parent = flash.parentNode;
			parent.removeChild(flashObjects[i]);
			parent.appendChild(flash);
		}

		flashObjects.length = 0;
		flashModes.length = 0;
	},

	getTopWindow: function ()
	{
		return window.content;

		var mediator = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);
		if (mediator)
		{
			var wList = mediator.getZOrderDOMWindowEnumerator("navigator:browser", true);

			if (wList.hasMoreElements()) return wList.getNext().getBrowser().contentWindow;
		}
		else return top.getBrowser().contentWindow;
	},

	getSBHeight: function (window)
	{
		this.myAlert(101);
		if (window.scrollMaxX > 0)
		{
			this.myAlert(102);
			var spacer = window.document.createElement("div");
			this.myAlert(103);
			spacer.setAttribute("style", "position: fixed; margin: 0px; padding: 0px; border: none; visibility: hidden;  top: 0px; left: 0px; width: 1px; height: 100%; z-index: -1;");
			this.myAlert(104);
			window.document.body.appendChild(spacer);
			this.myAlert(105);

			var sbHeight = window.innerHeight - spacer.offsetHeight;
			this.myAlert(106);
			window.document.body.removeChild(spacer);
			this.myAlert(107);
			return sbHeight > 0 && sbHeight < 40 ? sbHeight : 0;
		}
		else return 0;
	},

	openPage: function (URI)
	{
		if (this.isThunderbird())
		{
			var messenger = Components.classes['@mozilla.org/messenger;1'].createInstance();
			messenger = messenger.QueryInterface(Components.interfaces.nsIMessenger);
			messenger.launchExternalURL(URI);
		}
		else if (this.isSeamonkey())
		{
			var tabBrowser = top.getBrowser();
			if (tabBrowser)
			{
				var owner = tabBrowser.selectedTab;
				var tab = tabBrowser.addTab(URI, null, null, null, owner, false);
				tabBrowser.selectedTab = tab;
				window.focus();
			}
		}
		else
		{
			var tabBrowser = top.getBrowser();
			if (tabBrowser)
			{
				var tab = tabBrowser.loadOneTab(URI, null, null, null, false, false);
				window.focus();
			}
		}
	},

	openLinks: function (linksString)
	{
		var vLinks = linksString.split("\n");
		for (i = 0; i < vLinks.length; i++)
		{
			if (vLinks[i] != "") this.openPage(vLinks[i]);
		}
	},

	myAlert: function (message)
	{
		return;
		alert(message);
	},

	playSound: function ()
	{
		try
		{
			var ioService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
			var sndURI = ioService.newURI("chrome://fireshot/skin/camera.wav", null, null);
			var sndPlayer = Components.classes["@mozilla.org/sound;1"].createInstance(Components.interfaces.nsISound);
			sndPlayer.init();
			sndPlayer.play(sndURI);
		}
		catch (e)
		{
		}
	},

	isDefined: function (variable)
	{
		return (typeof(variable) != "undefined");
	},

	getUAExtra: function ()
	{
		var extVersion = this.getBuildVersion();
		return "FireShot/" + extVersion;
	},
	
	geckoGetRv: function()
	{
	  if (navigator.product != 'Gecko')
	  {
		return -1;
	  }
	  var rvValue = 0;
	  var ua      = navigator.userAgent.toLowerCase();
	  var rvStart = ua.indexOf('rv:');
	  var rvEnd   = ua.indexOf(')', rvStart);
	  var rv      = ua.substring(rvStart+3, rvEnd);
	  var rvParts = rv.split('.');
	  var exp     = 1;

	  for (var i = 0; i < rvParts.length; i++)
	  {
		var val = parseInt(rvParts[i]);
		rvValue += val / exp;
		exp *= 100;
	  }

	  return rvValue;
	},


	getBuildVersion: function ()
	{
		if (this.geckoGetRv() < 2)
		{
			try
			{
				var extMgr = Components.classes["@mozilla.org/extensions/manager;1"].getService(Components.interfaces.nsIExtensionManager);
				if (extMgr)
				{
					var extInfo = extMgr.getItemForID("{0b457cAA-602d-484a-8fe7-c1d894a011ba}");
					if (extInfo && extInfo.version != "") this.addonVersion = extInfo.version;
					else
					{
						extInfo = extMgr.getItemForID("fireshot@screenshot-program.com");
						if (extInfo) this.addonVersion = extInfo.version == "" ? "0.0" : extInfo.version;
					}
				}
			}
			catch (err)
			{
			};
		}
		else
		{
			/*
			try
			{
				AddonManager.getAddonByID("fireshot@screenshot-program.com", function(addon) {
					if (addon.version != "") 
					{
						alert(1);
						FireShotUtils.addonVersion = addon.version;
					}
				}); 
				
				if (extInfo && extInfo.version != "") extVersion = extInfo.version;
					else
					{
						extInfo = extMgr.getItemForID("fireshot@screenshot-program.com");
						if (extInfo) extVersion = extInfo.version == "" ? "0.0" : extInfo.version;
					}
				}
			}
			catch (err)
			{
				alert(err);
			};*/
		}
		return this.addonVersion;
	},

	isFirefox: function ()
	{
		return navigator.userAgent.search(/Firefox/gi) != -1;
	},
		
	isThunderbird: function ()
	{
		return navigator.userAgent.search(/Thunderbird/gi) != -1;
	},
	
	isSeamonkey: function ()
	{
		return navigator.userAgent.search(/SeaMonkey/gi) != -1;
	},

	getTBVersion: function ()
	{
		return navigator.userAgent.search(/Thunderbird\/3/gi) > -1 ? 3 : 2;
	},

	getFFVersion: function ()
	{
		var sub = navigator.userAgent.match(/Firefox\/\d\.\d/i);
		if (sub == null) return -1;
		sub = sub.join().match(/\d\.\d/i);
		if (sub == null) return -1;
		return parseInt(sub.join().replace(/\./i, ''));
	},
	
	getLoadedMessage: function()
	{
		if (typeof GetLoadedMessage == 'function') return GetLoadedMessage();
		else return gMessageDisplay.folderDisplay.selectedMessageUris ? gMessageDisplay.folderDisplay.selectedMessageUris[0] : null;
	},

};