var FireShotSelection = 
{
	holder 		: undefined,
	wrapper		: undefined,
	info		: undefined,
	doc			: undefined,
	body		: undefined,
	onSelected	: undefined,
	cursor  	: undefined,
	borders		: [],
	outer		: [],
	x1			: 0,
	y1			: 0,
	x2			: 0,
	y2			: 0,
	
	makeSelection : function(onSelected)
	{
		this.onSelected = onSelected;
		with (this)
		{
			x1 = x2 = y1 = y2 = 0;
			
			doc	=  document.commandDispatcher.focusedWindow.document;
			body = doc.body;

			cursor = doc.body.style.cursor;
			doc.body.style.cursor = "crosshair";
			
			holder = doc.createElement('div');
			holder.style.cssText = "position: absolute; left: 0px; top: 0px; width: 0px; height: 0px; z-index: 2147483640; cursor: crosshair;";
			
			info = doc.createElement('div');
			info.style.cssText = "font-family: Tahoma; font-size:14px; color: #fff; left: 5px; top: 5px; width:auto; height:auto; padding: 3px; background: #000; opacity: 0.8; position:absolute; border:#333 solid 1px; cursor: crosshair;";
			
			wrapper = doc.createElement('div');
		
			wrapper.style.cssText = "position: absolute; left: 0px; top: 0px; opacity: 0; cursor: crosshair; z-index: 2147483641;";
		
			doc.body.appendChild(wrapper);
			
			for (var i = 0; i < 4; i ++)
			{
				borders.push(doc.createElement('div'));
				
				var cssText;
				
				switch (i)
				{
					case 0: cssText = "background: url('data:image/gif;base64,R0lGODlhAQAGAKEAAP///wAAADY2Nv///yH/C05FVFNDQVBFMi4wAwEAAAAh/hpDcmVhdGVkIHdpdGggYWpheGxvYWQuaW5mbwAh+QQACgD/ACwAAAAAAQAGAAACAxQuUgAh+QQBCgADACwAAAAAAQAGAAACA5SAUgAh+QQBCgADACwAAAAAAQAGAAACA5SBBQAh+QQBCgADACwAAAAAAQAGAAACA4QOUAAh+QQBCgADACwAAAAAAQAGAAACAwSEUAAh+QQBCgADACwAAAAAAQAGAAACA4SFBQA7') repeat-y left top;"; break;
					case 1: cssText = "background: url('data:image/gif;base64,R0lGODlhBgABAKEAAP///wAAADY2Nv///yH/C05FVFNDQVBFMi4wAwEAAAAh/hpDcmVhdGVkIHdpdGggYWpheGxvYWQuaW5mbwAh+QQACgD/ACwAAAAABgABAAACAxQuUgAh+QQBCgADACwAAAAABgABAAACA5SAUgAh+QQBCgADACwAAAAABgABAAACA5SBBQAh+QQBCgADACwAAAAABgABAAACA4QOUAAh+QQBCgADACwAAAAABgABAAACAwSEUAAh+QQBCgADACwAAAAABgABAAACA4SFBQA7') repeat-x left top;"; break;
					case 2: cssText = "background: url('data:image/gif;base64,R0lGODlhAQAGAKEAAP///wAAADY2Nv///yH/C05FVFNDQVBFMi4wAwEAAAAh/hpDcmVhdGVkIHdpdGggYWpheGxvYWQuaW5mbwAh+QQACgD/ACwAAAAAAQAGAAACAxQuUgAh+QQBCgADACwAAAAAAQAGAAACA5SAUgAh+QQBCgADACwAAAAAAQAGAAACA5SBBQAh+QQBCgADACwAAAAAAQAGAAACA4QOUAAh+QQBCgADACwAAAAAAQAGAAACAwSEUAAh+QQBCgADACwAAAAAAQAGAAACA4SFBQA7') repeat-y right top;"; break;
					case 3: cssText = "background: url('data:image/gif;base64,R0lGODlhBgABAKEAAP///wAAADY2Nv///yH/C05FVFNDQVBFMi4wAwEAAAAh/hpDcmVhdGVkIHdpdGggYWpheGxvYWQuaW5mbwAh+QQACgD/ACwAAAAABgABAAACAxQuUgAh+QQBCgADACwAAAAABgABAAACA5SAUgAh+QQBCgADACwAAAAABgABAAACA5SBBQAh+QQBCgADACwAAAAABgABAAACA4QOUAAh+QQBCgADACwAAAAABgABAAACAwSEUAAh+QQBCgADACwAAAAABgABAAACA4SFBQA7') repeat-x left bottom;"; break;
				}
				
				borders[i].style.cssText = cssText + " opacity: 0.5; position: absolute; cursor: crosshair;";
				holder.appendChild(borders[i]);
				
				outer.push(doc.createElement('div'));
				outer[i].style.cssText = "position: absolute; background: #000; opacity: 0.3; z-index: 2147483640; cursor: crosshair;";
				
				doc.body.appendChild(outer[i]);
			}
			
			holder.appendChild(info);
			doc.body.appendChild(holder);

			update();
			
			wrapper.addEventListener('mousedown', wrapperMouseDown, true);
			doc.addEventListener('keydown', onKeyDown, false);
		}
	},
	
	wrapperMouseDown: function(e)
	{
		if (e.button == 0) 
		{
			FireShotSelection.wrapper.removeEventListener('mousedown', FireShotSelection.wrapperMouseDown, true);
			
			function wrapperMouseMove(e) 
			{
				FireShotSelection.x2 = e.pageX;
				FireShotSelection.y2 = e.pageY;
				FireShotSelection.update();
				FireShotSelection.autoScroll(e);
			}
			
			function wrapperMouseUp(e) {
				
				FireShotSelection.x2 = e.pageX;
				FireShotSelection.y2 = e.pageY;

				FireShotSelection.wrapper.removeEventListener('mousemove', wrapperMouseMove, true);
				FireShotSelection.wrapper.removeEventListener('mouseup', wrapperMouseUp, false);
				FireShotSelection.update();
				FireShotSelection.completed();
			}
			
			FireShotSelection.x1 = e.pageX;
			FireShotSelection.y1 = e.pageY;
			
			FireShotSelection.wrapper.addEventListener('mousemove', wrapperMouseMove, true);
			FireShotSelection.wrapper.addEventListener('mouseup', wrapperMouseUp, false);
		}		
	},
	
	onKeyDown: function(e) 
	{
		if (e.keyCode == 27) 
		{
			FireShotSelection.onSelected = 0;
			FireShotSelection.completed();
		}
	},

	update: function()
	{
		with (this)
		{
			var docWidth = doc.compatMode == "CSS1Compat" ? doc.documentElement.scrollWidth : body.scrollWidth;
			var docHeight = doc.compatMode == "CSS1Compat" ? doc.documentElement.scrollHeight : body.scrollHeight;
			
			var left = Math.min(x1, x2), top = Math.min(y1, y2), width = Math.abs(x2 - x1), height = Math.abs(y2 - y1);
			
			holder.style.left = left + "px";
			holder.style.top = top + "px";
			holder.style.width = width + "px";
			holder.style.height = height + "px";
			
			wrapper.style.width = docWidth + "px";
			wrapper.style.height = docHeight + "px";
			
			
			outer[0].style.left = 0 + "px" ;
			outer[0].style.top = 0 + "px";
			outer[0].style.width = docWidth + "px";
			outer[0].style.height = holder.style.top;

			outer[1].style.left = 0 + "px";
			outer[1].style.top = top + height + "px";
			outer[1].style.width = docWidth + "px";
			outer[1].style.height = docHeight - (top + height) + "px";
			
			outer[2].style.left = 0 + "px";
			outer[2].style.top = top + "px";
			outer[2].style.width = left + "px";
			outer[2].style.height = height + "px";
		
			outer[3].style.left = left + width + "px";
			outer[3].style.top = top + "px";
			outer[3].style.width = docWidth - (left + width) + "px";
			outer[3].style.height = height + "px";
			
			for (var i = 0; i < 4; i ++)
			{
				borders[i].style.left = 0 + "px";
				borders[i].style.top = 0 + "px";
				borders[i].style.right = 0 + "px";
				borders[i].style.bottom = 0 + "px";
			}
			
			info.innerHTML = width + " x " + height;
			info.style.visibility = info.scrollWidth + 11 < width && info.scrollHeight + 11 < height ? "visible" : "hidden";
		}
	},
	
	autoScroll: function(e) 
	{
		with (this)
		{
			if (e.clientX < 100) body.scrollLeft -= (100 - e.clientX) / 4;
			if (e.clientY < 100) body.scrollTop -=  (100 - e.clientY) / 4;

			var dX = window.innerWidth - e.clientX;
			if (dX < 100) body.scrollLeft += (100 - dX) / 4; 

			var dY = window.innerHeight - e.clientY;
			if (dY < 100) doc.body.scrollTop += (100 - dY) / 4; 
		}
	},
	
	completed: function()
	{
		with (this)
		{
			wrapper.removeEventListener('mousedown', wrapperMouseDown, true);
			doc.removeEventListener('keydown', onKeyDown, false);
			
			doc.body.style.cursor = cursor;
			doc.body.removeChild(holder);
			doc.body.removeChild(wrapper);
			
			for (var i = 0; i < 4; i ++)
				doc.body.removeChild(outer[i]);
				
			if (onSelected)
				onSelected({left: Math.min(x1, x2), top: Math.min(y1, y2), right: Math.max(x1, x2), bottom: Math.max(y1, y2)});
		}
	}
}
