//var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);

const cPrefPrefix = "fireshot.";
const cFirstTimeRun = cPrefPrefix + "firstTimeRunFlag";
const cCurrentVersion = cPrefPrefix + "curVersion";
const cToolbarCreated = cPrefPrefix + "toolbarCreated";
const cWelcomePageURI = "http://screenshot-program.com/fireshot/installed.php?ver=";
const cAboutURI = "http://screenshot-program.com/fireshot/";
const cDemoURI = "http://screenshot-program.com/fireshot/demo.php";
const cSupportURI = "http://screenshot-program.com/sup/frm12.htm";
const cReviewURI = "http://screenshot-program.com/fireshot/review.php";
const cDonateURI = "http://screenshot-program.com/fireshot/donate.php";
const cUpdatedURI = "http://screenshot-program.com/fireshot/updated.php?ver=";
const cUpgradeURI = "http://screenshot-program.com/fireshot/upgrade.php";
const cRegisterURI = "http://screenshot-program.com/fireshot/register.php";
const cUpgradedSuccessfullyURI = "http://screenshot-program.com/fireshot/upgraded.php";
const cAPIURI = "http://screenshot-program.com/fireshot/api_demo.php";
//const cErrorCheckerURI = "http://screenshot-program.com/registry-checker.php";
const cErrorCheckerURI = "http://screenshot-program.com/registry-checker-lnk5.php";
const cIntegrateToChrome = "http://screenshot-program.com/fireshot/integrate-chrome.php";

const cCapVisible 	= 0;
const cCapEntire	= 1;
const cCapSelected	= 2;

const cActionEdit = 0;
const cActionSave = 1;
const cActionClipboard = 2;
const cActionEMail = 3;
const cActionPaint = 4;
const cActionUpload = 5;
const cActionPrint = 7;
const cBASE64Content = 8;

const prefAreaType = cPrefPrefix + "areaType";
const prefActionType = cPrefPrefix + "actionType";
const prefPlaySound = cPrefPrefix + "playSound";
const prefCaptureFlash = cPrefPrefix + "captureFlash";

const prefContextMenu = cPrefPrefix + "contextMenu";
const prefToolsMenu = cPrefPrefix + "toolsMenu";
const prefStatusBar = cPrefPrefix + "statusBar";
const prefNavigationPanel = cPrefPrefix + "navigationPane";

const prefResizeAction = cPrefPrefix + "resizeAction";
const prefResizeWidth = cPrefPrefix + "resizeWidth";
const prefResizeHeight = cPrefPrefix + "resizeHeight";
const prefResizePercentage = cPrefPrefix + "resizePercentage";
const prefFlashCapDelay                = cPrefPrefix + "flashCapDelay";
const prefIsProMode        = cPrefPrefix + "isProMode";
const prefIsRegistered     = cPrefPrefix + "isRegistered";
const prefCaptureFullMode        = cPrefPrefix + "captureModeSB";

/**
 * FireShotPrefs - a wrapper around nsIPrefService. Provides built in
 *                 exception handling to make preferences access simpler.
 **/
var FireShotPrefs = {
  get mPrefService()
    {
      return Components.classes["@mozilla.org/preferences-service;1"]
                       .getService(Components.interfaces.nsIPrefBranch);
    },

  setBoolPref: function (aPrefName, aPrefValue)
    {
      try
        {
          this.mPrefService.setBoolPref(aPrefName, aPrefValue);
        }
      catch(e)
        {
        }
    },

  getBoolPref: function (aPrefName, aDefVal)
    {
	  try
        {
          return this.mPrefService.getBoolPref(aPrefName);
        }
      catch(e)
        {
          return aDefVal != undefined ? aDefVal : null;
        }
      return null;        // quiet warnings
    },

  setUnicharPref: function (aPrefName, aPrefValue)
    {
      try
        {
          var str = Components.classes["@mozilla.org/supports-string;1"]
                              .createInstance(Components.interfaces.nsISupportsString);
          str.data = aPrefValue;
          this.mPrefService.setComplexValue(aPrefName,
                                            Components.interfaces.nsISupportsString, str);
        }
      catch(e)
        {
        }
    },

  copyUnicharPref: function (aPrefName, aDefVal)
    {
      try
        {
          return this.mPrefService.getComplexValue(aPrefName,
                                                   Components.interfaces.nsISupportsString).data;
        }
      catch(e)
        {
          return aDefVal != undefined ? aDefVal : null;
        }
      return null;        // quiet warnings
    },

  setIntPref: function (aPrefName, aPrefValue)
    {
      try
        {
          this.mPrefService.setIntPref(aPrefName, aPrefValue);
        }
      catch(e)
        {
        }
    },

  getIntPref: function (aPrefName, aDefVal)
    {
      try
        {
          return this.mPrefService.getIntPref(aPrefName);
        }
      catch(e)
        {
          return aDefVal != undefined ? aDefVal : null;
        }
      return null;        // quiet warnings
    },

  getLocalizedUnicharPref: function (aPrefName, aDefVal)
    {
      try
        {
          return this.mPrefService.getComplexValue(aPrefName,
                                                   Components.interfaces.nsIPrefLocalizedString).data;
        }
      catch(e)
        {
          return aDefVal != undefined ? aDefVal : null;
        }
      return null;        // quiet warnings
    },

	storePrefs: function ()
	{
		this.mPrefService.savePrefFile(null);
	}
};

var FireShotSettings ={
	restore:function()
	{
	        document.getElementById("area-type").selectedItem =
	                document.getElementById(FireShotPrefs.getLocalizedUnicharPref(prefAreaType, "at-entire"));

	        document.getElementById("action-type").selectedItem =
	                document.getElementById(FireShotPrefs.getLocalizedUnicharPref(prefActionType, "at-edit"));

	        document.getElementById("play-sound").checked =
	                FireShotPrefs.getBoolPref(prefPlaySound, true);

	        document.getElementById("chk-capture-flash").checked =
	                FireShotPrefs.getBoolPref(prefCaptureFlash, true);

	        document.getElementById("integrate-context").checked =
	                FireShotPrefs.getBoolPref(prefContextMenu, true);

			document.getElementById("integrate-tools").checked =
	                FireShotPrefs.getBoolPref(prefToolsMenu, true);

			document.getElementById("integrate-status").checked =
	                FireShotPrefs.getBoolPref(prefStatusBar, true);

			document.getElementById("integrate-navigation").checked =
	                FireShotPrefs.getBoolPref(prefNavigationPanel, true);

	        document.getElementById("resize-action").selectedIndex =
	                FireShotPrefs.getIntPref(prefResizeAction, 0);

	        document.getElementById("resize-input-width").value =
	                FireShotPrefs.getLocalizedUnicharPref(prefResizeWidth, "800");

	        document.getElementById("resize-input-height").value =
	                FireShotPrefs.getLocalizedUnicharPref(prefResizeHeight, "600");

	        document.getElementById("resize-input-percentage").value =
	                FireShotPrefs.getLocalizedUnicharPref(prefResizePercentage, "75");

	        document.getElementById("flashcap-input").value =
	                FireShotPrefs.getIntPref(prefFlashCapDelay, "0");
	},

	store:function()
	{
	        FireShotPrefs.setUnicharPref(prefAreaType, document.getElementById("area-type").selectedItem.id);
	        FireShotPrefs.setUnicharPref(prefActionType, document.getElementById("action-type").selectedItem.id);

	        FireShotPrefs.setBoolPref(prefPlaySound, document.getElementById("play-sound").checked);
	        FireShotPrefs.setBoolPref(prefCaptureFlash, document.getElementById("chk-capture-flash").checked);

	        FireShotPrefs.setBoolPref(prefContextMenu, document.getElementById("integrate-context").checked);
			FireShotPrefs.setBoolPref(prefToolsMenu, document.getElementById("integrate-tools").checked);
			FireShotPrefs.setBoolPref(prefStatusBar, document.getElementById("integrate-status").checked);
			FireShotPrefs.setBoolPref(prefNavigationPanel, document.getElementById("integrate-navigation").checked);

	        FireShotPrefs.setIntPref(prefResizeAction, document.getElementById("resize-action").selectedIndex);

	        FireShotPrefs.setUnicharPref(prefResizeWidth, document.getElementById("resize-input-width").value);
	        FireShotPrefs.setUnicharPref(prefResizeHeight, document.getElementById("resize-input-height").value);
	        FireShotPrefs.setUnicharPref(prefResizePercentage, document.getElementById("resize-input-percentage").value);
	        FireShotPrefs.setIntPref(prefFlashCapDelay, document.getElementById("flashcap-input").value);
	}
}
	function checkAccessibility()
	{
	var k = document.getElementById("resize-action").selectedIndex;
	document.getElementById("resize-input-width").hidden = (k
	< 5) || (k == 6);
		document.getElementById("resize-input-height").hidden = (k
		< 6);
			document.getElementById("resize-input-percentage").hidden = k != 4;
			document.getElementById("resize-label-x").hidden = (k
			< 7);
				document.getElementById("resize-label-pixels").hidden = (k
				< 5);
					document.getElementById("resize-label-percentage").hidden = k != 4;
					document.getElementById("resize-label-height-comment").hidden = k != 5;
					document.getElementById("resize-label-width-comment").hidden = k != 6;
					document.getElementById("flashcap-label").disabled = !document.getElementById("chk-capture-flash").checked;
					document.getElementById("flashcap-input").disabled = !document.getElementById("chk-capture-flash").checked;
	}
	function tabSelected(anObject)
	{
	if (anObject.selectedIndex == 1)
	checkAccessibility();
	}
