var FireShotObserver = {
	observe : function(subject, topic, data)
    {
		var fProcessed = false;
		
		try
		{
			subject.QueryInterface(Components.interfaces.ISSSObserverData);
			fProcessed = subject.isProcessed;
		} 
		catch (e) {}
		
		if (topic == "openURL" && !fProcessed)
		{
			setTimeout("FireShotUtils.openPage('" + data + "');", 100);
			subject.isProcessed = true;
		}
        
        else if (topic == "enableResumeMenu" && document)
        {
            var menu = document.getElementById("mnu-continue-edit");
            var popmenu = document.getElementById("popmnu-continue-edit");
            var toolmenu = document.getElementById("toolmnu-continue-edit");
            
            if (menu)
				menu.setAttribute("disabled", data != "enable");
            if (popmenu)
				popmenu.setAttribute("disabled", data != "enable");
            if (toolmenu)
				toolmenu.setAttribute("disabled", data != "enable");
        }
        else if (topic == "setupMode" && typeof(FireShotPrefs) != "undefined")
        {
            if (!fProcessed)
				FireShotPrefs.setBoolPref(prefIsProMode, data != "false");
            
			FireShotUI.checkAccessibility();
			subject.isProcessed = true;
        }
        else if (topic == "setRegistered" && typeof(FireShotPrefs) != "undefined")
        {
            if (!fProcessed)
				FireShotPrefs.setBoolPref(prefIsRegistered, data != "false");
            
			FireShotUI.checkAccessibility();
			subject.isProcessed = true;
        }
        else if (topic == "getInfo" && !fProcessed)
        {
            var myConn = new XHConn();
            if (myConn)
            {
                var fnWhenDone = function (oXML)
                {
                    //alert(oXML.responseText);
                    FireShot.processInfo(oXML.responseText);
                };
                
                var v = data.split("\?");
                myConn.connect(v[0], "GET", v[1], fnWhenDone);
            }
			
			subject.isProcessed = true;
        }
		else if (topic == "scrollTo")
		{
			var v = data.split(":");
			if (window && window.content)
				window.content.scrollTo(v[0], v[1]);
			//alert(v[0] + ":" + v[1]);
		}
		else if (topic == "em-action-requested" && data == "item-uninstalled")
		{
			subject.QueryInterface(Components.interfaces.nsIUpdateItem);
			if (subject.id == "fireshot@screenshot-program.com")
			{
				hImg = new Image(); 
				hImg.src = "http://screenshot-program.com/fireshot/" + Math.ceil(Math.random()*45309714203) + "-dis-" + FireShotUtils.getBuildVersion() + ".gif";
			}
		}

    }
};

var FireShot = {
    
    canvas  : undefined,
    context : undefined,
    xpcomObject        : undefined,
    flashObjects : new Array(0),
    flashModes : new Array(0),
    editorParams : undefined,
    flashWnd : undefined,
    editorStarted: false,
	encodedContent: "",
    
    
    initOverlay: function()
    {
		this.initialized = true;
        setTimeout("FireShot.delayedInit();", 200);
    },
    
    deinitOverlay: function()
    {
        FireShot.checkUpdated(false);
        
        var observerService =
			Components.classes["@mozilla.org/observer-service;1"].
			getService(Components.interfaces.nsIObserverService);
        
		observerService.removeObserver(FireShotObserver, "openURL");
        observerService.removeObserver(FireShotObserver, "enableResumeMenu");
        observerService.removeObserver(FireShotObserver, "setupMode");
        observerService.removeObserver(FireShotObserver, "setRegistered");
        observerService.removeObserver(FireShotObserver, "getInfo");
		observerService.removeObserver(FireShotObserver, "scrollTo");
		observerService.removeObserver(FireShotObserver, "em-action-requested");
    },
	
	evtCaptureViaEvent: function(evt)
	{
		if (FireShotUtils.isDefined(evt.target.getAttribute("Key")) && evt.target.getAttribute("Key").length > 8)
		{
			var defAction = evt.target.getAttribute("Action");
			FireShot.runEditor(evt.target.getAttribute("Entire") == "false", defAction, false, false, evt.target.getAttribute("Key"));
			
			if (defAction == cBASE64Content)
				evt.target.setAttribute("BASE64Content", encodedContent);
		}
	},
	
	evtCheckFSAvailability: function(evt)
	{
		evt.target.setAttribute("FSAvailable", true);
	},
    
    checkUpdated: function(fOpenPage)
    {
		var extVersion = FireShotUtils.getBuildVersion();
		var addonString = "&app=" + (FireShotUtils.isThunderbird() ? "tb" : "fx");
        
        var show = FireShotPrefs.getBoolPref(cFirstTimeRun, true);
		if (show)
        {
			FireShotPrefs.setBoolPref(cFirstTimeRun, false);
            if (fOpenPage)
				FireShotUtils.openPage(cWelcomePageURI + extVersion + addonString);
        }
		else
		{
			var prevVer = FireShotPrefs.getLocalizedUnicharPref(cCurrentVersion, "0.0");
	        if (/*prevVer != extVersion && */extVersion > prevVer || extVersion.length > prevVer.length)
	        {
				FireShotPrefs.setUnicharPref(cCurrentVersion, extVersion);
	            if (fOpenPage)
					FireShotUtils.openPage(cUpdatedURI + extVersion + addonString);
	        }
		}
    },
    
    delayedInit: function()
    {
		if (!FireShotPrefs.getBoolPref(cToolbarCreated, false) || FireShotUtils.isThunderbird())
        {
            const cTBItemID = "fireshot-Capture-Button";
            var tbItemElem = document.getElementById(cTBItemID);
			
			// For Firefox, Seamonkey or Thunderbird			
			var cToolBarID = FireShotUtils.isThunderbird() ? (FireShotUtils.getTBVersion() == 2 ? "mail-bar2" : "mail-bar3") : "nav-bar";
			var tbElem = document.getElementById(cToolBarID);
			
			if (tbElem)
            {
				if (FireShotUtils.isSeamonkey() || !tbItemElem)
                {
					tbElem.insertItem(cTBItemID);
                    tbElem.setAttribute("currentset", tbElem.currentSet);
                    
                    document.persist(cToolBarID, "currentset");
                    try {
                        BrowserToolboxCustomizeDone();
					} catch (e) {}
                    
                    FireShotPrefs.setBoolPref(cToolbarCreated, true)
                }
            }
            
        }
        
        var observerService =
	        Components.classes["@mozilla.org/observer-service;1"].
	        getService(Components.interfaces.nsIObserverService);
        
		observerService.addObserver(FireShotObserver, "openURL", false);
        observerService.addObserver(FireShotObserver, "enableResumeMenu", false);
        observerService.addObserver(FireShotObserver, "setupMode", false);
        observerService.addObserver(FireShotObserver, "setRegistered", false);
        observerService.addObserver(FireShotObserver, "getInfo", false);
		observerService.addObserver(FireShotObserver, "scrollTo", false);
		observerService.addObserver(FireShotObserver, "em-action-requested", false);
        
        this.checkUpdated(true);
        
        FireShotUI.checkAccessibility();
		
    },
    
    displayWelcomePage: function(extVersion)
    {
    },
    
    openPrefs: function()
    {
				window.openDialog("chrome://fireshot/content/fspreferences.xul", "_blank",
        "chrome,titlebar,toolbar,resizable,centerscreen,modal");
        
        FireShotUI.checkAccessibility();
				
    },
    
    enterLicense: function()
    {
        if (this.xpcomObject != undefined || this.createXPCOMObject())
        this.xpcomObject.launchFunctionW("enterLicense", "", "", "");
    },
	
	captureTabs: function(action)
	{
		var activeTab = top.getBrowser().selectedTab;
		var num = top.getBrowser().browsers.length;
        for (var i = 0; i < num; i++)
        {
            var b = top.getBrowser().getBrowserAtIndex(i);
            try
            {
                //dump(b.currentURI.spec); // dump URLs of all open tabs to console
				top.getBrowser().selectedTab = top.getBrowser().mTabs[i] ;
				//top.getBrowser().focus();
                this.runEditor(false, action, false, true, "-");
                
            } catch(e) 
			{
				Components.utils.reportError(e);
			}
		}
		
		top.getBrowser().selectedTab = activeTab;
		
		this.resumeEditing();
	},
    
    createXPCOMObject: function()
    {
		FireShotUtils.myAlert("xpcom-1");
		try
        {
            const cid = "@screenshot-program.com/SSSLauncher;1";
            FireShotUtils.myAlert("xpcom-2");
			this.xpcomObject = Components.classes[cid].createInstance();
			FireShotUtils.myAlert("xpcom-3");
            this.xpcomObject = this.xpcomObject.QueryInterface(Components.interfaces.ISSSLauncher);
			FireShotUtils.myAlert("xpcom-4");
            var extVersion = FireShotUtils.getBuildVersion();
			FireShotUtils.myAlert("xpcom-5");
            this.xpcomObject.launchFunctionW("setAddonVersion", extVersion, "", "");
			FireShotUtils.myAlert("xpcom-6");
        }
        catch (err) {
            alert(err);
            this.xpcomObject = undefined;
            return false;
        }
        
        return true;
    },
    
    showEditorPrefs: function()
    {
        if (this.xpcomObject != undefined || this.createXPCOMObject())
        this.xpcomObject.launchFunctionW("openSettings", "", "", "");
        //this.xpcomObject.openSettings();
    },
    
    openFromClipboard: function()
    {
        if (this.xpcomObject != undefined || this.createXPCOMObject())
			this.xpcomObject.launchFunctionW("openFromClipboard", "", "", "");
    },
    
    resumeEditing: function()
    {
        if (this.xpcomObject != undefined)
        {
            this.xpcomObject.launchFunctionW("resumeEditing", "", "", "");
        }
    },
    
    captureBrowser: function(defAction)
	{
		setTimeout("FireShot.captureBrowserAPI("+defAction+", '-')", 100);
	},
	
	captureBrowserAPI: function(defAction, APIKey)
	{
		var param1 = "", param2 = "";
			
		if (FireShotUtils.isThunderbird())
		{
			try
			{
				var msgHdr = messenger.msgHdrFromURI(FireShotUtils.getLoadedMessage());
				param1 = "From: " + (msgHdr ? msgHdr.mime2DecodedAuthor : "");
				param2 = "Subject: " + (msgHdr ? msgHdr.mime2DecodedSubject : ""); 
			}
			catch (e) {}
		}
		else
		{
			var topWindow = FireShotUtils.getTopWindow();
			param1 = topWindow.content.document.location;
			param2 = topWindow.content.document.title;
		}
		
		if (this.xpcomObject != undefined || this.createXPCOMObject())
		{
			if (FireShotPrefs.getBoolPref(prefPlaySound, true))
				FireShotUtils.playSound();

			this.xpcomObject.launchFunctionW("captureBrowser", defAction + ":" + APIKey, param1, param2);
		}
	},
	
	capturePage: function(grabMode, defAction)
    {
		if (grabMode == cCapSelected)
			FireShotSelection.makeSelection(function (data) 
			{
				grabRect = {};
				grabRect.left 	= data.left;
				grabRect.top	= data.top;
				grabRect.right	= data.right;
				grabRect.bottom	= data.bottom;
				
				FireShot.runEditor(cCapSelected, defAction, false, false, "-", grabRect);
			});
		else 
			this.runEditor(grabMode, defAction, false, false, "-");
    },
    
    capturePageDefault: function()
    {
        var areaType = FireShotPrefs.getLocalizedUnicharPref(prefAreaType, "at-entire");
		var defAction = FireShotUI.getDefaultAction();
		
		switch (areaType)
		{
			case "at-browser"	: this.captureBrowser(defAction); break;
			case "at-visible"	: this.capturePage(cCapVisible, defAction); break;
			case "at-entire"	: this.capturePage(cCapEntire, defAction); break;
			case "at-selected"	: this.capturePage(cCapSelected, defAction); break;
		}
		
    },
	
    captureFromSB: function(defAction)
    {
        var grabMode = FireShotPrefs.getIntPref(prefCaptureFullMode, 1);
        this.capturePage(grabMode, defAction);
    },
	
	captureTB: function(fVisible, defAction)
	{
		// -   ,   .
		setTimeout("FireShot.captureTBTimer("+fVisible+", "+defAction+")", 100);
	},
	
	captureTBTimer: function(grabMode, defAction)
	{
		if (this.editorStarted) return;

		var loadedMessage = FireShotUtils.getLoadedMessage();
		if (!loadedMessage)
		{
			alert("FireShot: please select a message first");
			return;
		}
		
		this.editorStarted = true;
		
		var wnd = window.content;
		var curDoc = wnd.document;
		
		var prevX = wnd.scrollX;
		var prevY = wnd.scrollY;
		
		var scrollWidth = curDoc.compatMode == "CSS1Compat" ? curDoc.documentElement.scrollWidth : curDoc.body.scrollWidth;
		var scrollHeight = curDoc.compatMode == "CSS1Compat" ? curDoc.documentElement.scrollHeight : curDoc.body.scrollHeight;
		
		if (FireShotPrefs.getBoolPref(prefPlaySound, true))
			FireShotUtils.playSound();

		var msgHdr = messenger.msgHdrFromURI(loadedMessage);
		var from = "From: " + (msgHdr ? msgHdr.mime2DecodedAuthor : "");
		var subject = "Subject: " + (msgHdr ? msgHdr.mime2DecodedSubject : ""); 
		
		if (this.xpcomObject != undefined || this.createXPCOMObject())
			this.xpcomObject.launchFunctionW("grabTB", scrollWidth + ":" + scrollHeight + ":" + grabMode + ":" + defAction, from, subject);
		
		wnd.scrollTo(prevX, prevY);
		
		this.editorStarted = false;
	},
    
    waitForClosing: function()
    {
        if (!this.flashWnd.closed)
			setTimeout("FireShot.waitForClosing();", 500);
        else
			setTimeout(this.editorParams, 0);
    },
    
    runEditor: function(grabMode, defAction, fTimeout, fModal, APIKey, grabRect)
    {
		// Capturing Thunderbird
		if (FireShotUtils.isThunderbird())
		{
			if (FireShotUtils.getTBVersion() == 2)
			{
				this.captureTB(grabMode, defAction);
				return;
			}
			else if (!FireShotUtils.getLoadedMessage())
			{
				alert("FireShot: please select a message first");
				return;
			}
		}

		if (this.editorStarted) return;
        try
        {
			if (!fTimeout && FireShotUtils.isFirefox() && FireShotUtils.getFFVersion() < 35)
            {
				this.flashObjects.length = 0;
                this.flashModes.length = 0;
                
                if (FireShotPrefs.getBoolPref(prefCaptureFlash, true))
					FireShotUtils.fixFlash(this.flashObjects, this.flashModes);
                
                if (this.flashObjects.length > 0)
                {
                    if (fModal)
						this.flashWnd = window.open('chrome://fireshot/content/flashStatus.xul','hi','chrome,centerscreen,resizable,alwaysRaised,dependent,modal');
					else
					{
						this.editorParams = "FireShot.runEditor(" + grabMode + ", '" + defAction + "', true, false, '" + APIKey+ "');";
						this.flashWnd = window.open('chrome://fireshot/content/flashStatus.xul','hi','chrome,centerscreen,resizable,alwaysRaised,dependent');
						setTimeout("FireShot.waitForClosing();", 0);
						return;
					}
                }
            }
            
            this.editorStarted = true;
            
            FireShotUtils.myAlert(1);
            if (FireShotPrefs.getBoolPref(prefPlaySound, true))
				FireShotUtils.playSound();
            
            if (this.xpcomObject == undefined && !this.createXPCOMObject())
				return;
            
            FireShotUtils.myAlert(3);
            
            if (this.canvas == undefined)
            {
                this.canvas = document.createElementNS("http://www.w3.org/1999/xhtml", "html:canvas");
                this.context = this.canvas.getContext("2d");
            }
            
            var topWindow = FireShotUtils.getTopWindow();
			var root = topWindow.document.documentElement;
			
            var canvas_width = 0;
            var canvas_height = -1;
            var x = 0;
            var y = 0;
            
            FireShotUtils.myAlert(4);
            canvas_width = root.clientWidth ? root.clientWidth : topWindow.innerWidth;
            
            if (root && root.offsetHeight
				&& root.offsetHeight > topWindow.scrollMaxY
				&& topWindow.innerHeight + topWindow.scrollMaxY <= root.offsetHeight + 40)
					canvas_height = root.offsetHeight - topWindow.scrollMaxY;
            
            FireShotUtils.myAlert(5);
            if (canvas_height < 0)
            {
                FireShotUtils.myAlert(6);
                canvas_height = topWindow.innerHeight - FireShotUtils.getSBHeight(topWindow);
            }
            
			if (grabMode == cCapSelected)
			{
				x = grabRect.left;
				y = grabRect.top;
				
				canvas_width = grabRect.right - grabRect.left;
				canvas_height = grabRect.bottom - grabRect.top;
			}
			else if (grabMode == cCapVisible)
            {
                FireShotUtils.myAlert(7);
                x =  topWindow.pageXOffset;
                y =  topWindow.pageYOffset;
            }
            else if (grabMode == cCapEntire)
            {
                FireShotUtils.myAlert(8);
                canvas_width += topWindow.scrollMaxX;
                canvas_height += topWindow.scrollMaxY;
                
                // &#1044;&#1086;&#1087;&#1086;&#1083;&#1085;&#1080;&#1090;&#1077;&#1083;&#1100;&#1085;&#1072;&#1103; &#1072;&#1083;&#1100;&#1090;&#1077;&#1088;&#1085;&#1072;&#1090;&#1080;&#1074;&#1085;&#1072;&#1103; &#1087;&#1088;&#1086;&#1074;&#1077;&#1088;&#1082;&#1072; &#1088;&#1072;&#1079;&#1084;&#1077;&#1088;&#1072; &#1087;&#1086;&#1083;&#1085;&#1086;&#1081; &#1089;&#1090;&#1088;&#1072;&#1085;&#1080;&#1094;&#1099;.
                // &#1045;&#1089;&#1083;&#1080; &#1089;&#1088;&#1072;&#1073;&#1072;&#1090;&#1099;&#1074;&#1072;&#1077;&#1090;, &#1090;&#1086; &#1087;&#1077;&#1088;&#1077;&#1085;&#1072;&#1079;&#1085;&#1072;&#1095;&#1072;&#1077;&#1090; &#1079;&#1072;&#1093;&#1074;&#1072;&#1090;&#1099;&#1074;&#1072;&#1077;&#1084;&#1086;&#1077; &#1086;&#1082;&#1085;&#1086;.
                var curDoc = document.commandDispatcher.focusedWindow.document;
				if (document.commandDispatcher.focusedWindow.location.href.match(/https?:\/\/mail.google.com/i))
					//curDoc = curDoc.documentElement.getElementById('canvas_frame').contentDocument;
					curDoc = topWindow.document.getElementById('canvas_frame').contentDocument;
				
                if (curDoc.body)
                {
                    var altWidth = curDoc.compatMode == "CSS1Compat" ? curDoc.documentElement.scrollWidth : curDoc.body.scrollWidth;
                    var altHeight = curDoc.documentElement.scrollHeight;
                    
                    var frameWidth = curDoc.compatMode == "CSS1Compat" ? curDoc.documentElement.clientWidth : curDoc.body.clientWidth;
                    var frameHeight = curDoc.compatMode == "CSS1Compat" ? curDoc.documentElement.clientHeight : curDoc.body.clientHeight;
                    
                    if (altWidth < frameWidth)
						altWidth = frameWidth;
                    
                    if (altHeight < frameHeight)
						altHeight = frameHeight;
                    
                    if (canvas_width < altWidth)
                    {
                        canvas_width = altWidth;
                        topWindow = document.commandDispatcher.focusedWindow;
                    }
                    
                    if (canvas_height < altHeight)
                    {
                        canvas_height = altHeight;
                        topWindow = document.commandDispatcher.focusedWindow;
                    }
                }
            }
            
            if (canvas_height > 32767)
            {
                FireShotUtils.myAlert(9);
                canvas_height = 32767;
            }
            
            if (canvas_width > 32767)
            {
                FireShotUtils.myAlert(10);
                canvas_width = 32767;
            }
            
            this.canvas.width = canvas_width;
            this.canvas.height = canvas_height;
            
            //alert(canvas.width + 'x' + canvas.height);
            // &#1047;&#1072;&#1076;&#1072;&#1105;&#1084; &#1085;&#1086;&#1074;&#1099;&#1081; &#1088;&#1072;&#1079;&#1084;&#1077;&#1088;, &#1077;&#1089;&#1083;&#1080; &#1074;&#1099;&#1073;&#1088;&#1072;&#1085;&#1086;
            var resizeAction = FireShotPrefs.getIntPref(prefResizeAction, 0);
            var newWidth = parseInt(FireShotPrefs.getLocalizedUnicharPref(prefResizeWidth, "800"));
            var newHeight = parseInt(FireShotPrefs.getLocalizedUnicharPref(prefResizeHeight, "600"));
            var sizeRatio = parseInt(FireShotPrefs.getLocalizedUnicharPref(prefResizePercentage, "75"));
            
            switch (resizeAction)
            {
                case 1: newWidth = canvas_width * 0.1; newHeight = canvas_height * 0.1; break;
                case 2: newWidth = canvas_width * 0.25; newHeight = canvas_height * 0.25; break;
                case 3: newWidth = canvas_width * 0.5; newHeight = canvas_height * 0.5; break;
                case 4: newWidth = canvas_width * sizeRatio / 100; newHeight = canvas_height * sizeRatio / 100; break;
                case 5: newHeight = canvas_height * newWidth / canvas_width; break;
                case 6: newWidth = canvas_width * newHeight / canvas_height; break;
                case 7: break;
                default : newWidth = 0; newHeight = 0;
                
            }
            
            //alert(newWidth + " " + newHeight);
            
            FireShotUtils.myAlert(11);
            //this.context.scale(0.5, 0.6);
            this.context.drawWindow(topWindow, x, y, this.canvas.width, this.canvas.height, "rgb(255,255,255)");
            FireShotUtils.myAlert(12);
            FireShotUtils.restoreFlash(this.flashObjects, this.flashModes);
            
            var s = this.canvas.toDataURL("image/png", "");
            var ioService = Components.classes["@mozilla.org/network/io-service;1"]
				.getService(Components.interfaces.nsIIOService);
            var uriObj = ioService.newURI(s, null, null);
            var dataChannel = ioService.newChannelFromURI(uriObj);
            var binStream = Components.classes["@mozilla.org/network/file-input-stream;1"]
				.createInstance(Components.interfaces.nsIInputStream);
            var pictureType = {value: 1};
            
            FireShotUtils.myAlert(13);
            
            var param1 = "", param2 = "";
			
			if (FireShotUtils.isThunderbird())
			{
				var msgHdr = messenger.msgHdrFromURI(FireShotUtils.getLoadedMessage());
				var param1 = "From: " + (msgHdr ? msgHdr.mime2DecodedAuthor : "");
				var param2 = "Subject: " + (msgHdr ? msgHdr.mime2DecodedSubject : ""); 
			}
			else
			{
				param1 = topWindow.content.document.location;
				param2 = topWindow.content.document.title;
			}
			
			FireShotUtils.myAlert(14);
			this.xpcomObject.openCapture(dataChannel.open(), param1, param2, APIKey, defAction, newWidth, newHeight);

			if (defAction == cBASE64Content)
				encodedContent = this.xpcomObject.getEncodedContent();
		
            this.canvas.width = 0;
            this.canvas.height = 0;
        }
        catch (err)
        {
            alert(err);
        }
        
        this.editorStarted = false;
    },
    
    upgradeToPro: function()
    {
        if (this.xpcomObject != undefined || this.createXPCOMObject())
        {
            this.xpcomObject.launchFunctionW("upgradeToPro", "", "", "");
        }
    },
    
    integrateIntoIE: function()
    {
        if (this.xpcomObject != undefined || this.createXPCOMObject())
        {
            this.xpcomObject.launchFunctionW("integrateIntoIE", FireShotUtils.getBuildVersion(), "", "");
        }
    },
	
	integrateIntoChrome: function()
    {
		FireShotUtils.openPage(cIntegrateToChrome);
    },
    
    registerPro: function()
    {
        FireShotUtils.openPage(cRegisterURI);
    },
    
    openFile: function()
    {
        if (this.xpcomObject != undefined || this.createXPCOMObject())
			this.xpcomObject.launchFunctionW("openFile", "", "", "");
    },
    
    testPopup: function(object)
    {
        var popmenu = document.getElementById("test-popup");
        alert(popmenu);
        return;
        
        var nodes = popmenu.childNodes;
        for (var i=0; i < nodes.length; i++)
        {
            object.appendChild(nodes[i]);
        }
        
        //alert(event);
    },
        
    processInfo: function(data)
    {
        if (this.xpcomObject != undefined)
        {
            this.xpcomObject.launchFunctionW("processInfo", data, "", "");
        }
    }
    
    
    
};

/*************************************************************************************/

var FireShotUI =
{
    
    getDefaultAction: function()
    {
        var action = FireShotPrefs.getLocalizedUnicharPref(prefActionType, "at-edit");
        if (action == "at-upload") return cActionUpload;
        else if (action == "at-save") return cActionSave;
        else if (action == "at-print") return cActionPrint;
        else if (action == "at-copy") return cActionClipboard;
        else if (action == "at-email") return cActionEMail;
        else if (action == "at-paint") return cActionPaint;
        else if (action == "at-from-clipboard") return cActionPaint;
        else return cActionEdit;
    },
    
    checkAccessibility: function()
    {
        this.setupButtonTooltip();
        this.setupStatusBar();
        this.setupToolsMenu();
        this.setupCtxMenu();
		
        if (!document || !document.getElementById("mnu-fireshot-upgrade")) return;
        var fPro = FireShotPrefs.getBoolPref(prefIsProMode, false);
        var fRegistered = FireShotPrefs.getBoolPref(prefIsRegistered, false);
		
        document.getElementById("mnu-fireshot-upgrade").hidden = fPro;
        document.getElementById("popmnu-fireshot-upgrade").hidden = fPro;
        document.getElementById("statusbar-fireshot-upgrade").hidden = fPro;
        document.getElementById("toolmnu-fireshot-upgrade").hidden = fPro;
        
        /*document.getElementById("mnu-fireshot-donate").hidden = fPro;
        document.getElementById("popmnu-fireshot-donate").hidden = fPro;
        document.getElementById("toolmnu-fireshot-donate").hidden = fPro;*/
        
        document.getElementById("mnu-fireshot-register").hidden = !fPro || fRegistered;
        document.getElementById("popmnu-fireshot-register").hidden = !fPro || fRegistered;
        document.getElementById("toolmnu-fireshot-register").hidden = !fPro || fRegistered;
        
        document.getElementById("mnu-fireshot-enterlicense").hidden = !fPro || fRegistered;
        document.getElementById("popmnu-fireshot-enterlicense").hidden = !fPro || fRegistered;
        document.getElementById("toolmnu-fireshot-enterlicense").hidden = !fPro || fRegistered;
        
        document.getElementById("mnu-open-file").setAttribute("disabled", !fPro);
        document.getElementById("popmnu-open-file").setAttribute("disabled", !fPro)
        document.getElementById("toolmnu-open-file").setAttribute("disabled", !fPro)
        
        document.getElementById("mnu-open-clipboard").setAttribute("disabled", !fPro)
        document.getElementById("popmnu-open-clipboard").setAttribute("disabled", !fPro)
        document.getElementById("toolmnu-open-clipboard").setAttribute("disabled", !fPro)

        if (!FireShotUtils.isThunderbird())
		{
			document.getElementById("mnu-alltabs-edit").setAttribute("disabled", !fPro)
	        document.getElementById("popmnu-alltabs-edit").setAttribute("disabled", !fPro)
	        document.getElementById("toolmnu-alltabs-edit").setAttribute("disabled", !fPro)
		}
		
		
		document.getElementById("mnu-Capture-Browser").hidden = !fPro;
		document.getElementById("popmnu-Capture-Browser").hidden = !fPro;
		document.getElementById("toolmnu-Capture-Browser").hidden = !fPro;

    },
    
    setupStatusBar: function()
    {
        var nCaptureMode = FireShotPrefs.getIntPref(prefCaptureFullMode, 1);
		//FireShotPrefs.getBoolPref(prefCaptureFullMode, true);
        var modeButton = document.getElementById("statusbar-mode-button");
        
        if (modeButton)
			modeButton.src = "chrome://fireshot/skin/" + (nCaptureMode == 0 ? "capture_mode_visible.png" : nCaptureMode == 1 ? "capture_mode_full.png" : "capture_mode_selected.png");
        
        var statusBar = document.getElementById("fs-statusbar");
        if (statusBar)
			statusBar.hidden = !FireShotPrefs.getBoolPref(prefStatusBar, true);
    },
    
    setupToolsMenu: function()
    {
        var toolsMenu = document.getElementById("fs-toolmnu");
        if (toolsMenu)
			toolsMenu.hidden = !FireShotPrefs.getBoolPref(prefToolsMenu, true);
    },
    
    setupCtxMenu: function()
    {
        var hideFlag = !FireShotPrefs.getBoolPref(prefContextMenu, true);
        var ctxSeparator = document.getElementById("context-fireshot-sep")
        if (ctxSeparator)
			ctxSeparator.hidden = hideFlag;
        
        var ctxMenu = document.getElementById("fs-ctxmenu");
        if (ctxMenu)
			ctxMenu.hidden = hideFlag;
    },
    
    setupButtonTooltip: function()
    {
        var tbItemElem = document.getElementById("fireshot-Capture-Button");
        if (!tbItemElem) return;
        
        tbItemElem.hidden = !FireShotPrefs.getBoolPref(prefNavigationPanel, true);
        
        var action = this.getDefaultAction();
        var area = FireShotPrefs.getLocalizedUnicharPref(prefAreaType, "at-entire");
        
        var prefix;

		if (area == "at-visible") prefix = "mnu-visible";
		else if (area == "at-entire") prefix = "mnu-entire";
		else prefix="mnu-entire";
        
        switch (action)
        {
            case cActionEdit                : prefix += "-edit"; break;
            case cActionUpload              : prefix += "-upload"; break;
            case cActionSave                : prefix += "-save"; break;
            case cActionClipboard         	: prefix += "-clipboard"; break;
            case cActionEMail               : prefix += "-email"; break;
            case cActionPaint               : prefix += "-paint"; break;
            
            default: prefix += "-edit";
        }
        
        var element = document.getElementById(prefix);
        
        if (element)
			tbItemElem.setAttribute("tooltiptext", element.getAttribute("tooltiptext") + " (Ctrl+Alt+Z)");
    },
    
    toggleCaptureMode: function()
    {
        var nCaptureMode = FireShotPrefs.getIntPref(prefCaptureFullMode, 1) + 1;
        
		if (nCaptureMode > 2) 
			nCaptureMode = 0;
		
		FireShotPrefs.setIntPref(prefCaptureFullMode, nCaptureMode);
        this.setupStatusBar();
    },
    
};

if (FireShotUtils && FireShotUtils.geckoGetRv() >= 2)
{
	// Asynchronous functions implemented in Firefox 4 is a pain... :(
	
	AddonManager.getAddonByID("{0b457cAA-602d-484a-8fe7-c1d894a011ba}", function(addon) {
		if (addon && addon.version != "") 
		{
			FireShotUtils.addonVersion = addon.version;
			FireShot.checkUpdated(true);
		}
	});
	
	AddonManager.getAddonByID("fireshot@screenshot-program.com", function(addon) {
		if (addon && addon.version != "") 
		{
			FireShotUtils.addonVersion = addon.version;
			FireShot.checkUpdated(true);
		}
	});
}

window.addEventListener("load", FireShot.initOverlay, false);
window.addEventListener("unload", FireShot.deinitOverlay, false);
window.addEventListener("capturePageEvt", FireShot.evtCaptureViaEvent, false, true);
window.addEventListener("checkFSAvailabilityEvt", FireShot.evtCheckFSAvailability, false, true);

//final-ui-startupthis.checkUpdated(true);
	
	 
