<?xml version="1.0" encoding="utf-8"?>
<SPSSchema xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns="http://spsconsortium.net/schema/SPS.xsd">
  <ProgramName>IntelliJ IDEA Community portable</ProgramName>
  <Version>2021.2.2-48</Version>
  <ReleaseDate>2021-09-20</ReleaseDate>
  <Category>Programming - IDEs</Category>
  <Description>+++ Code-centric IDE, focused on your productivity +++

IntelliJ IDEA is a capable and ergonomic, Java written integrated development environment (IDE) for developing computer software.

◆ Enjoy productive Java ◆
~~~~~~~~~~~~~~~~~~
Every aspect of IntelliJ IDEA has been designed to maximize developer productivity. Together, intelligent coding assistance and ergonomic design make development not only productive but also enjoyable.

◆ Deep intelligence ◆
~~~~~~~~~~~~~~~
After IntelliJ IDEA has indexed your source code, it offers a blazing fast and intelligent experience by giving relevant suggestions in every context: instant and clever code completion, on-the-fly code analysis, and reliable refactoring tools. 

◆ Out-of-the-box experience ◆
~~~~~~~~~~~~~~~~~~~~~
Mission-critical tools such as integrated version control systems and a wide variety of supported languages and frameworks are all to hand — no plugin hassle included.

◆ Smart code completion ◆
~~~~~~~~~~~~~~~~~~~
While the basic completion suggests names of classes, methods, fields, and keywords within the visibility scope, the smart completion suggests only those types that are expected in the current context.

◆ Framework-specific assistance ◆
~~~~~~~~~~~~~~~~~~~~~~~~
While IntelliJ IDEA is an IDE for Java, it also understands and provides intelligent coding assistance for a large variety of other languages such as SQL, JPQL, HTML, JavaScript, etc., even if the language expression is injected into a String literal in your Java code.

◆ Productivity boosters ◆
~~~~~~~~~~~~~~~~~
The IDE predicts your needs and automates the tedious and repetitive development tasks, so you can stay focused on the big picture.

◆ Developer ergonomics ◆
~~~~~~~~~~~~~~~~~~
In every design and implementation decision that we make, we keep in mind the risk of interrupting the developer's flow and do our best to eliminate or minimize it. The IDE follows your context and brings up the corresponding tools automatically.

◆ Unobtrusive intelligence ◆
~~~~~~~~~~~~~~~~~~~
The coding assistance in IntelliJ IDEA is not about only the editor: it helps you stay productive when dealing with other aspects as well: e.g. filling a field, searching over a list of elements; accessing a tool window; or toggling a setting, etc.

For more information on IntelliJ IDEA please visit the official web site at
https://www.jetbrains.com/idea

******************************************************************

This portable version of the app is made by Portapps, Inc., an open source project, self-funded &amp; developed by CrazyMax, an experienced developer of open source software.

Compared to the original release it includes some modifications, which where made to ensure portability. Please follow the link to the publisher web site for details.

An overview of all applications published by Portapps, Inc. is available at
https://portapps.io/apps/</Description>
  <License>Apache License 2.0</License>
  <ProgramPublisherName>JetBrains s.r.o. &amp; Portapps Inc.</ProgramPublisherName>
  <ProgramPublisherWebSite>https://portapps.io/app/intellij-idea-community-portable/</ProgramPublisherWebSite>
  <PackerFormat>7z</PackerFormat>
  <InstallationArguments />
  <MainExeNames>
    <Exe>
      <ExeFullRelativePath>intellij-idea-community-portable.exe</ExeFullRelativePath>
      <ExeName>IntelliJ IDEA Community</ExeName>
    </Exe>
  </MainExeNames>
  <UpdateNoCopyFiles>data;log;*.yml</UpdateNoCopyFiles>
  <CleanUpdate>false</CleanUpdate>
  <BuiltInUpdater>false</BuiltInUpdater>
  <DownloadUrl>https://github.com/portapps/intellij-idea-community-portable/releases/download/2021.2.2-48/intellij-idea-community-portable-win64-2021.2.2-49.7z</DownloadUrl>
  <DownloadSizeKb>659376</DownloadSizeKb>
  <Note>VirusTotal analysis:

https://www.virustotal.com/gui/file-analysis/M2QyOWVlOGFiMDdiZDUwZjAzZWJjOTIzMTc1MWRkZTk6MTYzMjA5MjEyMw==/detection</Note>
  <ProgramIconBase64>iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOvAAADrwBlbxySQAAA9JJREFUOE89kFtMk3cYxv87GJdM4oCiuxlcVFIrhQHTAhOoXw98HIqcysm2qMvCkCGUr2W4IsJmKeU0BixAC4WCwjAmGkk2JLiQ6FjmcMLmCmVUERfRrW5RHEEK9tkHF3uTX56r55cnL1kT6zbhbFDam2viMtdzqX7677iqb5fiDV33E2uzZpKbXvug+DZJZ2ZFqVqHPpVx7GQh/99LiiHrYi3toUpXPBSDNcknWJZVwEVX42FCjetBYq1SXXonPJuxT2VoZ9dZSVeK1vH2Yd0cUbFiMpVsemWDYtpZAV5QJVihNHgq0eIv2Sn8QVfCmfCZq+nYZaey+BayNbeRXvqrh5WMspIgednvhKxKdHs84tK5VbbcGJOG/INxKIimURCbiPzYJHwYk4QjVAZk8Uchic8DrahGOnMHqTrHdIpuVk7cEqbEI9as/0udRIEoAZ/XGlFxphIRUVFb6E9XIDMrE0LhfkQI3wNFH99aotDZcbhs9glZl5T+wC7AMrvgmJDC4IUhtLe3IywsjC0JMTIyguLiYoSGhiI8PBQiSR5UJZNIZwWycucLsnFIm+hWK7sf5ys8mREH0GE2w2g0gsfjITg4GMPDwygsLASfz4dAsA/RohzkaG6BOnUPB/X3lwksu95Y/Yo3cK/pAFJiBbD19aOxsRFpaWnQ6/WYmJhATk4OuFwuAvdwEfZ+JkSfziHq7ANEGRafEHdrYOqz1pCn9oZYJMeGoPJMFRiGgVwuh8Vi2ZJsrvH3fwcBAQF4N4OB1DgOum0Ssq75h2Slha/6s0XomjQlICaED29vH/j4+LDpDV9fX3A4nK3027UbAoUGcfVX0dxpRVGDDdFtjgXiaeK+utAqUoydVi8KA0MRGRUJmqa32Hykl5cXggVBCEvLh7TzF8Sbp5Ff34+Muivg1y3Nkp8aFGQvGSfduSZTeEAI0jMz8PHJIhSxyGRSSMSHYLkwjOz+GcT1OkH3zkNmnYOgeQl+Z5enSY9ygAx89N02m6L9kpwnBc8vEHv9eOBxeBAGRaO8rhu5bddA2+6ygnlIe5wIanmEtwwr2GFY/ZH0Kfs28R/I7blryzbDkmX2dGZZHtUc7104Un7Vk1o/huSaS5BY7Mj72oETQ07sNK66txvc09tr3CWkV9nPruhPYnOpR3VuzKo6r7GpB4OU1dcCFS3j1usdVS9tdbWI/MIOy+hvz4uGFr/ZZlhXv16zsZuYQEiX8twm4V2q85RZPbBjMNdKmo9eJM++P0GWbxTse3y5aDjxy6l5UYfr+uiNnwv2m/5503hzhhAuWyaE/AfQdCOEeoRbZwAAAABJRU5ErkJggg==</ProgramIconBase64>
  <SPSPublisherName>mimic</SPSPublisherName>
  <SPSLicense>CC Attribution-NonCommercial-ShareAlike 4.0 International</SPSLicense>
  <SPSProgramReport>mailto:portapps@online.de</SPSProgramReport>
</SPSSchema>