unit UnitFramePopup;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls, UnitClipQueue,
  UnitMenuItemTagdata, unitMisc, Contnrs, UnitClipMenu, UnitTWideChar,
  UnitFrmTooltipNew;

const USE_POPUP_KEYBOARD_HOOK = FALSE;

const TUsesClipMenu = [IT_POPUPCLIP, IT_CLIPBOARD, IT_PERMANENT, IT_PINNED, IT_TEMP];
const TContainsAClip = [IT_POPUPCLIP, IT_CLIPBOARD, IT_PINNED];
const TPastesOnClickj = TUsesClipMenu;
const TClickableLeftIcons = TUsesClipMenu + [IT_FULL, IT_CLIPSET_HEADER];
const TDoubleSized = [IT_POPUPCLIP, IT_CLIPBOARD, IT_PINNED];

type
TACPopupItem = class;
TACPopupItemCollection = class;
TACPopupItemClass = class of TACPopupItem;
TACPopup = class;


TPopupItemPosition = (
    pipLeftIcon, pipRightIcon, pipCaption, pipNone
);

TPopupItemStyle = (
    psNormal, psLine, psBreak, psSubmenu, psExpandable, psCheckable, psGap
);

TPopupEraseFlag = (
    peCLipboard, pePopupClips, peRemovedClips, peEverything
);

TACOpenWindowFlag = (
    owConfiguration, owEditHistory, owRemovedClips, owPermanentClips,
    owPasteSelected, owSearch, owAbout, owEditClipboard
);
TPopupDisplayMode = (
    pdmAutoHide, pdmFormMode, pdmStayOpen
);

TCustomTransparentControl = class(TCustomControl)
  private
    FInterceptMouse: Boolean;
  protected
    procedure WMNCHitTest(var Message: TWMNCHitTest); message WM_NCHITTEST;
    procedure CreateParams(var Params: TCreateParams); override;
  public
    constructor Create(AOwner: TComponent); override;
    procedure Invalidate; override;
    property InterceptMouse: Boolean read FInterceptMouse write FInterceptMouse default False;
  end;
TACPopupPrototype = class(TCustomTransparentControl)

    procedure CreateParams(var Params: TCreateParams);  override;

private
    timMouseSelectDelay: TTimer;

	crit : RTL_CRITICAL_SECTION;
    scroll : THandle;
    timHover: TTimer;
    timShowSubmenu: TTimer;
    timHideSubmenu: TTimer;
    timLeftIconHover : TTimer;
    timIgnoreMouseMove : TTimer;
    timModifier : TTimer;
    //lastHitTest : integer;
    ignoreHitTestOnce : boolean;

    FirstPaint : boolean;
    FormMode : TPopupDisplayMode;

    LastMouseX, LastMouseY : integer;

    fItems : TACPopupItem;
    fLastVisible : TACPopupItem;

    fKeystrokes : TStringList;
    fAltKeyDown : boolean;
    fMaxItemWidth : integer;

    fFullMode : boolean;
    fHover : TACPopupItem;
    fDownShift : TShiftState;
    FLastPosition : TPopupItemPosition;
    fToolTipNew : TFrmTooltipNew;

    fAcceleratorCount : integer;
    fAccelCharsUsed : string;
    fReservedCount : integer;
    fLastSubmenu : TACPopupItem;
    fQueuedSubmenu : TACPopupItem;
    fMainRect : TRect;


    fPoint : TPoint;
    fTopFixed, fLeftFixed : boolean;
    fim : TClipMenu;
    region1, region2 : HRGN;
    fMouseDownOn : TACPopupItem;

    fNewCanvas : TCanvas;
    fDragStarted : boolean;
    fDragMenuItem : TACPopupItem;
    fDropMenuItem : TACPopupItem;
    fDragX, fDragY : integer;

    fOnHideEvent : TNotifyEvent;
    fShowing : boolean;
    fIncludeEmpty : boolean;

    fIsTooTall : boolean;
    fTopOffset : integer;
    fTopOffsetEnable : boolean;
    fIgnoreMouseMove : boolean;
    fIgnoreKeypresses : boolean;
    fLastKeyDown : word;
    fLastModiferDown : TShiftState;

    fBackgroundColor,
    fHighlightColor,
    fFontColor,
    fClickedColor,
    fDisabledColor,
    fExpandedBackgroundColor,
    fColumnColor,
    fBorderColor,
    fColumnEdgeColor,
    fBackgroundBase : TColor;

    fGroup : TObjectList;
    fUseGrouping : boolean;
    fGroupingCount : integer;
    fCurrentGroup : Integer;
    fUseGroupingOnce : boolean;
    fUseGroupingOnceFailed : boolean;
    fAutoExpandOnce : TItemType;

    fLastClipSequence : cardinal;
    fTempBitmap : TBitmap;

    fCaptionPoint : TPoint;

    fLastExpandedSet : set of TItemType;

    fKeyActivated : boolean;
    fShowExpandedShortcuts : Boolean;
    fShowExpandedType : TItemType;
    fExpandedKeystrokes : TStringList;

    fHasFiles : boolean;
    fPasteFiles : TACPopupItem;

    AddLineToNext : boolean;

    function GetClipHeader(ci : TClipItem) : string;
    procedure timMouseSelectDelayTimer(Sender: TObject);
    procedure timHoverTimer(Sender: TObject);
    procedure timShowSubmenuTimer(Sender: TObject);
    procedure timHideSubmenuTimer(Sender: TObject);
    procedure timLeftIconHoverTimer(Sender: TObject);
    procedure timIgnoreMouseMoveTimer(Sender: TObject);
    procedure timModiferTimer(Sender: TObject);

    procedure HideTooltip; virtual;
    procedure StartHoverTooltip;

    procedure WMGetDlgCode(var Msg: TMessage); message WM_GETDLGCODE;
    procedure WMActivate(Var msg:tMessage); message WM_ACTIVATE;
    procedure WMNCHitTest(var Message: TWMNCHitTest); message WM_NCHITTEST;
    procedure WMSetCursor(Var M: TWMSetCursor); message WM_SETCURSOR;
	procedure WMMove(var Msg: TMessage) ; message WM_MOVE;

    function CalcWidth(fpi : TACPopupItem; ClipIt : boolean=true) : integer; virtual;
    function CalcHeight(fpi : TACPopupItem) : integer;
    procedure CalcTotalSize(FixSubmenu:boolean=false);
    procedure EnsureVisibility(FixSubmenu:boolean=false);
    procedure WMKeyDown(var Message: TWMKeyDown);
    procedure MouseLeave(Sender: TObject);
    function IsLegalDrop(p : TACPopupItem) : boolean; virtual;
    function GetAccelerator(i: integer): char;
    function GetAcceleratorPopupClips(i: integer) : Char;
    procedure ReserveAccel;
    procedure AddAScrollbar;
    procedure DetectAutoScroll(top,bottom : integer);

    procedure CheckForAutoExpand(p : TACPopupItem);

    procedure SaveExpandedState;
    procedure LoadExpandedState;

    procedure AssignSubmenuShortcuts(p : TACPopupItem); virtual;

    function UseKeyboard : boolean;


    procedure MouseCursorReset;
    procedure RebuildPopup(AutoPopulate : boolean=true);
    procedure SetHoverUnderMouse;
    procedure SetFormMode(value : boolean);
    function GetFormMode : boolean;
protected
    procedure paint; override;
    procedure resize; override;

    procedure GatherModifierKeys(p : TACPopupItem);
    procedure DetectKeystroke(p : TACPopupItem); virtual;
    procedure DrawItem(p : TACPopupItem);
    procedure DrawCheckgroup(p : TACPopupItem);
    procedure FullRedraw;

    procedure DrawDragmark;

    procedure ClipMenuShow(rightclick : boolean = false); virtual;
    procedure ClipMenuHide;
    procedure ClipMenuReportKey(key : Char); overload;
    procedure ClipMenuReportKey(key : word); overload;
    function ClipMenuVisible : Boolean;
    procedure HoverUp;
    procedure HoverLeft;
    procedure HoverRight;

    procedure HandleOnClick(p : TACPopupItem);
    function HandleMouseClick(p : TACPopupItem):boolean; virtual;
    procedure HandleCaptionClick(p : TACPopupItem); virtual;
    procedure HoverClick;
    procedure ShowSubmenuDelayed(p : TACPopupItem);
    procedure CancelShowSubmenu;
    procedure MouseMove(Shift: TShiftState; X: Integer; Y: Integer); override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X: Integer; Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X: Integer; Y: Integer); override;

    function GetItemAt(x,y : integer) : TACPopupItem;
    function MouseInPopup : boolean;
    procedure SetHover(value : TACPopupItem; tooltip:boolean=true);  virtual;
    property Hover : TACPopupItem read fHover;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;

    procedure EditCallback(Sender : Tobject);
    procedure DeleteClipCallback(Sender : TObject);
    procedure DestroyCallback(Sender : Tobject);
    procedure PasteCallback(Sender : Tobject);
    procedure MakePermanentCallback(Sender : Tobject);
    procedure FormModeCallback(Sender : TObject);
    procedure HideCallback(Sender : TObject);

    procedure DragMouseDown(p : TACPopupItem);
    function DragMouseMove(p, last : TACPopupItem) : boolean;
    function DragMouseUp(p : TACPopupItem) : boolean;

    function GetCanvas : TCanvas;
    procedure SetShowExpandedShortcuts(value : Boolean);
    property ShowExpandedShortcuts : boolean read fShowExpandedShortcuts write SetShowExpandedShortcuts;
public

    { Creation }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy;  override;

    function Add : TACPopupItem;
    function AddLine : TACPopupItem;
    function AddBreak : TACPopupItem;

    procedure KeyUp(var Key: Word; Shift: TShiftState); override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;

    procedure AutoPopulate; virtual; abstract;
    procedure Clear;
    procedure ShowPopup(x,y : integer); overload; virtual;
    procedure ShowPopup(pt : TPoint); overload;
    procedure DodgePoint(pt : TPoint);
    procedure HoverDown;
    procedure Hide; virtual;

    {External Draw Routines}
    procedure SetCanvas(c : TCanvas);
    procedure DrawOnCanvas(fullmode : boolean=false);
    property UseCanvas : TCanvas read GetCanvas;
    property IncludeEmpty : boolean read fIncludeEmpty write fIncludeEmpty;

    { Cosmetics }
    //property Spacing : integer read fSPacing write fSpacing;
    property MaxItemWidth : integer read fMaxItemWidth write fMaxItemWidth;
    property OnHideEvent : TNotifyEvent read fOnHideEvent write fOnHideEvent;
    property Showing : boolean read fShowing;
    property FullMode : boolean read fFullMode write fFullMode;
    property UseGrouping : boolean read fUseGrouping write fUseGrouping;
    property GroupingCount : integer read fGroupingCount write fGroupingCount;
    property HasFiles : boolean read fHasFiles write fHasFiles;
    property UseFormMode : boolean read GetFormMode write SetFormMode;
end;
TACPopup = class(TACPopupPrototype)
    private
        filter : TEdit;
        fFilterTimer : TTimer;
        fFilterItem : TACPopupItem;

        fExplorerClickTimer : TTimer;
        fExplorerMode : boolean;
        fMouseReset : TTimer;

        searchRemoved : boolean;

        fGroupSwitchUsed : boolean;
        function IsLegalDrop(p : TACPopupItem) : boolean; override;
        procedure AssignSubmenuShortcuts(p : TACPopupItem); override;
        procedure FormMouseWheel(Sender: TObject; Shift: TShiftState;
                WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);

        procedure popupClipsChange;
    protected
        function CalcWidth(fpi : TACPopupItem; ClipIt : boolean=true) : integer; override;
        procedure KeyUp(var Key: Word; Shift: TShiftState); override;
        function HandleMouseClick(p : TACPopupItem) : boolean; override;
        procedure HandleCaptionClick(p : TACPopupItem); override;
        procedure DetectKeystroke(p : TACPopupItem); override;
        procedure SetHover(value : TACPopupItem; tooltip:boolean=true);  override;

        procedure SetPrefix(p : TACPopupItem);
        procedure AddSubmenu(p : TACPopupItem);

        procedure AddPopupClips;
        procedure AddCancel;
        procedure AddFullConfigured;
        procedure AddCurrentClipboard;
        procedure AddLast;
        procedure AddCurrentPermanentItems;
        procedure AddSearch;
        procedure AddPastingTools;
        procedure AddProgramOptions;
        procedure AddSwitchToItems;
        procedure AddSwitchToSubmenu;
        procedure AddAllItemsSubmenu;
        procedure AddSystem;


        procedure ClipMenuShow(rightclick : boolean = false);  override;

        procedure SearchRemovedClicked(Sender : TObject);

        procedure ShowFilter(P : TACPopupItem);
        procedure HideFilter(clear : boolean=true);
        procedure FilterKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
        procedure FilterKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
        procedure FIlterKeyPress(Sender: TObject; var Key: Char);
        procedure FilterTimer(Sender : TObject);
        procedure HandleFilter;

        function ClipSetCanExpand(Sender : TACPopupItem) : boolean;

        function HoverClipSetNext : boolean;
        function HoverClipSetPrevious : boolean;

        function PermGroupNext : boolean;
        function PermGroupPrev : boolean;

        procedure DeleteClip(i:integer);
        procedure MoveClip(oldindex,newindex:integer);

        procedure MouseReset(Sender: TObject);
        procedure ExplorerClickTimer(Sender: TObject);
    public
        procedure AutoPopulate;  override;
        constructor Create(AOwner: TComponent); override;
        procedure ShowPopup(x,y : integer); override;
        procedure Hide; override;

        property ExplorerMode : boolean read fExplorerMode write fExplorerMode;
end;

TACPopupItemCanExpand = function (Sender: TACPopupItem) : boolean of object;
TACPopupItem = class(TObject)
private
    fIcon : HICON;
    fIconBitmap : TBitmap;
    fLeftIconOpacity : byte;
    fLeftBitmap : TBitmap;
    fCliptypeBitmap : TBitmap;
    fCaptionTrailingBitmap : TBitmap;
    fCaptionIconOnlyOnHover : boolean;
    fCaption : string;
    fIconHoverCaption : string;
    fPrefix : string;
    fHasCliptypeIcon : boolean;
    fHasLeftIcon : boolean;
    fLeftIconOnlyOnHover : boolean;
    fLeftIconOnExpanded : boolean;
    fVisible : boolean;
    fSeparatorLine: boolean;
    fBottomLine: boolean;
    fSmallCaption: boolean;
    fStayOpenOnClick : boolean;

    fClip : TClipItem;
    fItemType : TItemType;
    fPermanentID, fPermanentGroupID : integer;
    fPermanentText : string;

    fMaxHeight : integer;
    fColWidth : TIntList;
    fSubMenu : TACPopupItemCollection;
    fCheckgroup : TObjectList;
    fParent : TACPopupItem;
    fMyColumn : integer;

    fSubShowing : TACPopupItem;

    fExpanded : boolean;
    fCollapseParentOnClick : boolean;
    fChecked : boolean;

    fStyle : TPopupItemStyle;
    fBoundsRect : TRect;
    fDoubleHeight : boolean;
    fDisabled : boolean;
    fShowCollapseIcon : Boolean;

    fCanExpand : TACPopupItemCanExpand;
protected
    fBottom : integer;
    fLeft : integer;
    fTop : integer;
    fRight : integer;
    fOnClick : TNotifyEvent;
    fOnRightClick : TNotifyEvent;
    fctrlpressed, fShiftPressed, fMiddleClicked, fTabPressed, fAltpressed : boolean;
    fIntegerData : integer;
    fHint : string;
    
    procedure SetCaption(value : string);
    procedure SetLeftIcon(value : hicon);
    procedure SetLeftBitmap(value : TBitmap);
    procedure SetCliptypeIcon(value : TBitmap);
    function CalcRight : integer;
    function GetIsInSubMenu : boolean;
    function GetIsInExpandedMenu : boolean;
    function GetColumnWidth : integer;
    function GetChecked : boolean;
    procedure SetChecked(value : boolean);

    function GetIsLine : boolean;
    procedure SetIsLine(value : boolean);
    function GetIsBreak : boolean;
    procedure SetIsBreak(value : boolean);
    function GetIsExpandable : boolean;
    procedure SetIsExpandable(value : boolean);
    function GetIsSubmenu : boolean;
    procedure SetIsSubmenu(value : boolean);
    function GetIsGap : boolean;
    procedure SetIsGap(value : boolean);

    function GetItem(Index : integer) : TACPopupItem;
    procedure SetItem(Index : integer; value : TACPopupItem);
    function GetExpanded : boolean;
    procedure SetExpanded(value : boolean);
    function GetIndex : integer;
    function GetOwnerIndex : integer;
    function GetVisibleParent : TACPopupItem;

    procedure SetBoundsRect(parenttop, parentleft : integer);
    function GetBoundsRect : TRect;
    procedure SetCaptionFromClip(value : TClipItem);


public

    constructor Create();
    destructor Destroy; override;
    function Add : TACPopupItem;
//    function AddLine : TACPopupITem;
    function AddBreak : TACPopupITem;
    procedure CheckGrouped;
    function IsCheckGrouped : boolean;
    procedure SetShowingSubMenu;
    function DesiredWidth(c : TCanvas) : integer;
    procedure DrawCaption(AC : TACPopupPrototype; c : TCanvas; r : TRect; IsHovered, IsIcon :  boolean);
    procedure DrawCaptionBackground(AC: TACPopupPrototype; c : TCanvas; r : TRect);

    property Right : integer read CalcRight;
    property Left : integer read fLeft;
    property Top : integer read fTOp;
    property Bottom : integer read fBottom;
    property BoundRect : TRect read GetBoundsRect;
    property Clip : TClipItem read fClip write fClip;
    property LeftIcon : HICON read fIcon write SetLeftIcon;
    property LeftBitmap : TBitmap write SetLeftBitmap;
    property Caption : String read fCaption write SetCaption;
    property CaptionFromClip : TClipItem write SetCaptionFromClip;
    property CliptypeIcon : TBitmap read fCliptypeBitmap write SetCliptypeIcon;

    property IsLine : boolean read GetIsLine write SetIsLine;
    property IsBreak : boolean read GetIsBreak write SetIsBreak;
    property IsExpandable : boolean read GetIsExpandable write SetIsExpandable;
    property IsSubmenu : boolean read GetIsSubmenu write SetIsSubmenu;
    property isGap : boolean read GetIsGap write SetIsGap;
    property Checked : boolean read GetChecked write SetChecked;
    property Expanded : boolean read GetExpanded write SetExpanded;
    property Style : TPopupItemStyle read fStyle;

    property OnClick : TNotifyEvent read fOnClick write fOnClick;
    property OnRightClick : TNotifyEvent read fOnRightClick write fOnRightClick;

    property Prefix : string read fPrefix write fPrefix;
    property ItemType : TItemType read fItemType write fItemType;
    property Visible : boolean read fVisible write fVisible;
    property IsInSubmenu : boolean read GetIsInSubMenu;
    property IsInExpandedMenu : boolean read GetIsInExpandedMenu;
    property ColumnWidth : integer read GetColumnWidth;
    property ColumnIndex : integer read fMyColumn;
    property Items[Index : integer] : TACPopupItem read GetItem write Setitem; default;
    property Index : integer read GetIndex;
    property OwnerIndex : integer read GetOwnerIndex;
    property VisibleParent : TACPopupItem read GetVisibleParent;
    property CtrlPressed : boolean read fCtrlPressed write fCtrlPressed;
    property ShiftPressed : boolean read fShiftPressed write fShiftPressed;
    property MiddleClicked : Boolean read fMiddleClicked write fMiddleClicked;
    property AltPressed : boolean read fAltpressed write fAltpressed;
    property TabPressed : Boolean read fTabPressed write fTabPressed;

    property IntegerData : integer read fIntegerData;
    property PermanentGroupID : integer read fPermanentGroupID;
    property PermanentID : integer read fPermanentID;
    property PermanentText : string read fPermanentText;
    property Hint : string read fHint write fHint;
    property DoubleHeight : boolean read fDoubleHeight write fDoubleHeight;
    property Disabled : boolean read fDisabled write fDisabled;

    property ShowCollapseIcon : Boolean read fShowCollapseIcon write fShowCollapseIcon;
    property CanExpand : TACPopupItemCanExpand read fCanExpand write fCanExpand;
    property StayOpenOnClick : boolean read fStayOpenOnClick write fStayOpenOnClick;
    property SeparatorLine : Boolean read fSeparatorLine write fSeparatorLine;
    property BottomLine : Boolean read fBottomLine write fBottomLine;
    property SmallCaption : Boolean read fSmallCaption write fSmallCaption;
end;
TACPopupItemCollection = class(TObjectList)
protected
    function GetItem(Index: Integer): TACPopupItem;
    procedure SetItem(Index: Integer; const Value: TACPopupItem);
public
    function Add : TACPopupItem; overload;
    property Items[Index: Integer]: TACPopupItem read GetItem write SetItem; default;
end;



implementation

uses Math, GraphUtil,  UnitFrmConfig, UnitPopupGenerate,
  UnitFrmClipboardManager, StrUtils, UnitToken, UnitFrmPermanentNew,
  UnitFrmMainPopup, UnitPaste, UnitFrmSysTrayMenu, UnitACPopupClicks,
  UnitKeyboardQuery, Clipbrd, UnitFrmEditTextExternal, UnitFrmEditItem,
  UnitFrmDummyClipboardBar, UnitFrmClipMenuNew, ShellAPi, UnitMyCursor,
  UnitFrmDebug, UnitFrmEditHistory, UnitClipDatabase;

{$R *.dfm}


{ TACPopupPrototype }
procedure TACPopupPrototype.CreateParams(var Params: TCreateParams);
begin
    inherited CreateParams(params);

   	Params.Style := WS_POPUP or (WS_CLIPCHILDREN or WS_CLIPSIBLINGS) ;
    Params.ExStyle := WS_EX_TOOLWINDOW or WS_EX_TOPMOST;

    //(clip) only paint an area once

    {WS_EX_COMPOSITED WS_EX_TRANSPARENT screws up in WinXP - causing a blank redraw
    WS_EXPOMPOSTIED cannot be used in Aero}
end;
constructor TACPopupPrototype.Create(AOwner: TComponent);
begin
    self.InterceptMouse := true;
    self.Visible := false;
    inherited;
    if Win32MajorVersion >= 6 then begin
    	self.DoubleBuffered := true; // CANT use this with transparent on XP
    end;



    self.OnExit := self.MouseLeave;

    self.Width := 1;
    self.Height := 1;
    
    fToolTipNew := TFrmTooltipNew.Create(application);
    timhover := TTimer.Create(self);
    timHover.Enabled := false;
    //timHover.Interval := 300;
    timHover.OnTimer := self.timHoverTimer;
    timHideSubmenu := TTimer.Create(self);
    timHideSubmenu.Enabled := false;
    timHideSubmenu.Interval := 300;
    timHideSubmenu.OnTimer := self.timHideSubmenuTimer;
    timShowSubmenu := TTimer.Create(self);
    timShowSubmenu.Enabled := false;
    timShowSubmenu.Interval := 300;
    timShowSubmenu.OnTimer := self.timShowSubmenuTimer;

    timLeftIconHover := TTimer.Create(self);
    timLeftIconHover.Enabled := false;
    timLeftIconHover.Interval := 190;
    timLeftIconHover.ontimer :=  timLeftIconHoverTimer;

    timIgnoreMouseMove := TTimer.Create(self);
    timIgnoreMouseMove.Enabled := false;
    timIgnoreMouseMove.Interval := 100;
    timIgnoreMouseMove.OnTimer := timIgnoreMouseMoveTimer;

    timMouseSelectDelay := TTimer.Create(self);
    timMouseSelectDelay.Enabled := false;
    timMouseSelectDelay.Interval := 300;
    timMouseSelectDelay.OnTimer := timMouseSelectDelayTimer;

    timModifier := TTimer.Create(self);
    timModifier.Enabled := false;
    timModifier.Interval := 300;
    timModifier.OnTimer := timModiferTimer;


    fItems := TACPopupItem.Create();
    fKeystrokes := TStringList.create;
    fExpandedKeystrokes := TStringList.Create;
    fExpandedKeystrokes.OwnsObjects := false;
    fExpandedKeystrokes.Duplicates := dupError;

    fTempBitmap := TBitmap.Create;

    fim := nil;

    self.fMaxItemWidth := 300;
    //fSpacing := 2;
    self.Width := 1;
    self.Height := 1;

    self.ParentColor := false;         /// MUST BE FALSE for transparent
    self.ParentBackground := false;    /// ditoo++

    timHover.Interval := Application.HintPause;
    fBorderColor := saturate(cl3DDkShadow,0.10);

    self.fGroup := TObjectList.Create;
    self.fGroup.OwnsObjects := false;

    Windows.InitializeCriticalSection(crit);

    scroll := 0;


end;
destructor TACPopupPrototype.Destroy;
begin
    fToolTipNew.Close;
    Windows.DeleteCriticalSection(crit);
    inherited;
end;




function TACPopupPrototype.GetClipHeader(ci : TClipItem) : string;
begin
	result := 'right-click for Clip Menu';
	if ci <> nil then begin
    	result := result + '    ('+IntToStr(ci.GetDataSize div 2)+' chars)';
    end;
end;



function TACPopupPrototype.Add: TACPopupItem;
begin
    result := fItems.add;
    if AddLineToNext then begin
        AddLineToNext := false;
        result.SeparatorLine := true;
    end;
end;



procedure TACPopupPrototype.ShowPopup(pt : TPoint);
begin
    self.ShowPopup(pt.x, pt.y);
end;
procedure TACPopupPrototype.ShowPopup(x, y: integer);
var t : Cardinal;
    procedure SetNoActivate;
    begin
        SetWindowLong(self.Handle, GWL_EXSTYLE,
            GetWindowLong(self.Handle, GWL_EXSTYLE) or WS_EX_NOACTIVATE);
    end;
    procedure ClearNoActivate;
    begin
        SetWindowLong(self.Handle, GWL_EXSTYLE,
            GetWindowLong(self.Handle, GWL_EXSTYLE) and not WS_EX_NOACTIVATE);
    end;
begin
	if fshowing then begin
    	FrmDebug.appendlog('ACPopup.ShowPopup called twice');
    	EXIT;
    end;


    windows.EnterCriticalSection(crit);
    try
        t := Windows.GetTickCount;
        fShowing := true;
        fIgnoreMouseMove := false;
        fIsTooTall := false;
        fLastKeyDown := 0;
        fToolTipNew.MaxWidth := frmConfig.UDToolWidth.Position;
        fToolTipNew.MaxHeight := frmConfig.UDToolHeight.Position;
        FrmDebug.AppendLog('acpopup start');

        self.fNewCanvas := self.Canvas;
        UseCanvas.Font := FrmConfig.GetFont;
        UseCanvas.Font.Size := FrmConfig.GetFont.Size;
        UseCanvas.Font.Style := FrmConfig.getfont.style;

        timHover.Interval := FrmConfig.tbTooltipDelay.Position;
        timHover.Enabled := false;

        fMaxItemWidth := FrmConfig.UDWidth.Position;
        fShowExpandedShortcuts := false;

        if fim = nil then begin
            fim := TClipMenu.Create(nil);
            self.ClipMenuHide;
            fim.OnRemoveClip := self.DeleteClipCallback;
            fim.OnDestroyClip := self.DeleteClipCallback;
            fim.OnFormMode := self.FormModeCallback;
            fim.OnHide := self.HideCallback;
            fim.OnPasteClip := self.PasteCallback;
        end;
//        fim.Font := UseCanvas.Font;

        fpoint.x := x;
        fpoint.y := y;
        self.Left := X;
        self.Top := Y;
        self.CalcTotalSize;
        self.fIgnoreKeypresses := true;



        if FrmMainPopup.GetNeedsFocus then begin
            ClearNoActivate;
        end else begin
            SetNoActivate;
        end;
        self.visible := true;
        Windows.SetWindowPos(
            self.Handle,HWND_TOPMOST,
            self.left,self.top,self.width,self.Height,
            SWP_SHOWWINDOW or SWP_NOZORDER or SWP_NOACTIVATE
        );
        Windows.WaitForInputIdle(Windows.GetCurrentProcess, INFINITE);

        If FrmMainPopup.GetNeedsFocus then begin
            ForceForeground(self.handle);
        end;

        self.HoverDown;
        FrmDebug.AppendLog('acpopup end - milliseconds=' + IntToStr(Windows.GetTickCount - t));

        self.AddAScrollbar;
    finally
        if fitems.fsubmenu.count = 0 then begin
            FrmDebug.AppendLog('acpopup error - empty popup, hiding');
            self.fShowing := true;
            self.Hide;
        end;

        self.fIgnoreKeypresses := False;
        windows.LeaveCriticalSection(crit);
    end;
end;
procedure TACPopupPrototype.DodgePoint(pt : TPoint);
var m : TMonitor;
begin
    m := screen.MonitorFromPoint(pt);
    self.Top := pt.Y - 10 - self.Height;
    if (m <> nil) then begin
        if self.Top < m.Top then begin
            self.Top := m.Top;
        end;
    end;
end;

function SetLeftIcon(p : TACPopupItem; ci : TClipItem; forceType : boolean = false) : HICON;
var
    cdf : TClipFormatType;
begin
    if (frmconfig.GetIconType = CBXICONTYPE_CLIPTYPE) or forcetype then begin
        cdf := ci.GetFormatType;
        case cdf of
            FT_PICTURE:		p.LeftBitmap := FrmClipboardManager.iPic.Picture.Bitmap;
            FT_HTML: 		p.LeftBitmap  := FrmClipboardManager.iFormat.Picture.Bitmap;
            FT_RICHTEXT:	p.LeftBitmap := FrmClipboardManager.iFormat.Picture.Bitmap;
            FT_FILE: 		p.LeftBitmap := FrmClipboardManager.iFiles.Picture.Bitmap;
            else
            	p.LeftBitmap := FrmClipboardManager.iText.Picture.Bitmap;
        end;
    end else begin

        p.LeftIcon := ci.CData.GetHICON;
    end;
end;

const LEFT_SPACE = 18 + 4;
const LEFT_BORDER = 1;
const LEFT_EDGE = 2;
const PREFIX_TRAILING_SPACE_MULTIPLE = 2;
const RIGHT_SPACE = 20;
const RIGHT_SPACE_PADDING_MULTIPLE = 3;
const RIGHT_BORDER = 1;
const TOP_BORDER = 1;
const BOTTOM_BORDER = 1;
const CAPTION_LEFT = LEFT_SPACE+LEFT_EDGE; {missing fSpacing}
const FSPACING = 2;

const LINE_HEIGHT = 6;

const RIGHT_MENU_GRADIENT_WIDTH = 35;

function ImgToBitmap(img : TImage) : TBitmap;
begin
    result := img.Picture.Bitmap;
end;


{TACPopup}
//
// Filter Related Routines
//
constructor TACPopup.Create(AOwner: TComponent);
begin
    inherited Create(AOwner);

    Filter := TEdit.Create(self);
    filter.ParentWindow := self.handle;
    filter.SetBounds(0,0,80,20);
    filter.visible := false;
    //filter.TabStop := false;
    filter.OnKeyUp := self.FilterKeyUp;
    filter.OnKeyDown := self.FilterKeyDown;
    filter.OnKeyPress := self.FIlterKeyPress;

    ffilterTimer := TTimer.Create(self);
    ffilterTimer.Enabled := false;
    ffiltertimer.OnTimer := self.filtertimer;
    fFilterTimer.Interval := 300;

    fMouseReset := TTimer.Create(self);
    fMouseReset.Enabled := false;
    fMouseReset.OnTimer := self.MouseReset;
    fMouseReset.Interval := 300;

    fExplorerClickTimer := TTimer.Create(self);
    fExplorerClickTimer.Enabled := false;
    fExplorerClickTimer.OnTimer := self.ExplorerClickTimer;
    fExplorerClickTimer.Interval := 40;


    self.OnMouseWheel := self.FormMouseWheel;
end;
procedure TACPopup.MouseReset(Sender: TObject);
begin
    fMouseReset.Enabled := false;
    screen.Cursor := crMyCursor;
end;

procedure TACPopup.popupClipsChange;
begin
    self.RebuildPopup;
end;

procedure TACPopup.ShowPopup(x,y : integer);
begin
    HideFilter;
    inherited ShowPopup(x,y);
    if frmconfig.cbFilterAlways.Checked then begin
        if assigned(fFilterItem) then self.ShowFilter(fFilterItem);
    end;

    if not self.UseKeyboard then begin
        fExplorerClickTimer.Enabled := true;
    end;

    ClipQueue.addListener(popupClipsChange);
end;
procedure TACPopup.ShowFilter(P : TACPopupItem);
begin
    if filter.Visible then begin
        self.HideFilter;
        self.HandleFilter;
    end else begin
        filter.Top := p.Top;
        filter.Left := CAPTION_LEFT + fSpacing;
        filter.Width := 80;
        filter.Visible := true;
        filter.Text := '';
        filter.Font := UseCanvas.Font;
        filter.Height := UseCanvas.TextHeight('HELO') + 2;

        filter.Top := filter.Top + max(0,((p.Bottom - p.top) - filter.Height) div 2) + 1;

        Windows.SetFocus(filter.Handle);

        self.fCurrentGroup := 0;
    end;
end;
procedure TACPopup.HideFilter;
begin
    if filter.Visible then begin
        filter.Visible := false;
        if clear then begin
            filter.Text := '';
        end;
        fFilterTimer.Enabled := false;

        Windows.SetFocus(self.Handle);

    end;
end;
procedure TACPopup.FilterKeyPress(Sender: TObject; var Key: Char);
begin
  case key of
    #9,#13,#27:// Tab,Enter,ESC
        begin
            key := #0;
            EXIT;
        end;
  end;
end;
procedure TACPopup.FilterKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
    case key of
    VK_DOWN:
        begin
            HideFilter(false);
            self.HandleFilter;

            self.SetHover(TACPopupItem(self.fGroup.Items[0]));
            self.HoverDown;

            EXIT;
        end;
    end;

    fFilterTimer.Enabled := false;
    fFilterTimer.Enabled := true;
    MouseCursorReset;
end;
procedure TACPopup.FilterKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    function AcceptFilter(c : TComboBox) : boolean;
    begin
        result := c.ItemIndex = 1;

        self.HideFilter(not result);
        if not result then begin
            self.HandleFilter;
        end;

        self.SetHover(TACPopupItem(self.fGroup.Items[0]));
    end;
begin
    if shift = [] then begin
        case key of
        VK_RETURN:
            begin
                AcceptFilter(frmconfig.cbxFilterEnter);
                key := 0;
            end;
        VK_ESCAPE:
            begin
                AcceptFilter(frmconfig.cbxFilterESC);
                key := 0;
            end;
        VK_TAB:
            begin
                AcceptFilter(frmconfig.cbxFilterTab);
                key := 0;
            end;
        end;
    end;
end;
procedure TACPopup.FilterTimer(Sender : TObject);
begin
    fFilterTimer.Enabled := false;
    self.HandleFilter;
end;
procedure TACPopup.HandleFilter;
begin
    fFilterTimer.Enabled := false;
    self.RebuildPopup;

    MouseCursorReset;
end;
procedure TACPopup.SetHover(value : TACPopupItem; tooltip:boolean=true);
begin
    inherited SetHover(value, tooltip);

    if filter.Visible then begin
        if value <> TACPopupItem(self.fGroup.Items[0]) then begin
            self.HideFilter(false);
            self.HandleFilter;
        end;
    end;


    fMouseReset.Enabled := false;
    if (value<>nil) and
        (value.ItemType in TContainsAClip) and (FLastPosition = pipCaption) and
        PtInRect(rect(value.left,value.top,value.Right+1,value.bottom+1), self.ScreenToClient(mouse.CursorPos)) then begin
        screen.Cursor := crMyCursor;
    end else begin
        screen.Cursor := crDefault;
    end;
end;

procedure TACPopup.SearchRemovedClicked(Sender : TObject);
begin
    searchRemoved := not searchRemoved;
    self.RebuildPopup;
end;

//
function TACPopup.ClipSetCanExpand(Sender : TACPopupItem) : boolean;
var
    i : integer;
    groupid : integer;
begin
    if sender.expanded then begin
        // handle Filter trigger
        if sender.fHasLeftIcon then begin
            self.ShowFilter(sender);
        end;
        self.SetHover(sender);
    end else begin
        // find the collapsed group and trigger a refresh

        self.fCurrentGroup :=  sender.fIntegerData;
        groupid := sender.fIntegerData;

        self.RebuildPopup;

        for i := 0 to self.fGroup.Count-1 do begin
            if i = groupid then begin
                self.SetHover( TACPopupItem(self.fGroup.Items[i]) );
                BREAK;
            end
        end;
    end;

    // expanding is done manually, cancel the automatic handling
    result := false;
end;


// ClipSet/PermClips Navigation Routines
//
procedure TACPopup.FormMouseWheel(Sender: TObject; Shift: TShiftState;
    WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
var b : boolean;
    ac : TACPopupItem;
    pt : TPoint;
begin
    case FrmConfig.GetMouseWheelAction of
    WA_CLIPSET:
        begin
            pt := ScreenToClient(mouse.CursorPos);
            ac := GetItemAt(pt.x,pt.Y);
            if wheeldelta > 0 then begin
                if (ac<>nil) and (ac.ItemType in [IT_POPUPCLIP, IT_CLIPSET_HEADER]) then begin
                    b := self.HoverClipSetPrevious;
                end else if (ac=nil) or (ac.ItemType in [IT_PERMANENT, IT_SWITCH]) then begin
                    self.PermGroupPrev;
                end;
            end else begin
                if (ac<>nil) and (ac.ItemType in [IT_POPUPCLIP, IT_CLIPSET_HEADER]) then begin
                    b := self.HoverClipSetNext;
                end else if (ac=nil) or (ac.ItemType in [IT_PERMANENT, IT_SWITCH]) then begin
                    self.PermGroupNext;
                end;
            end;
            timHover.Enabled := false;
        end;
    WA_HIGHLIGHT:
        begin
            if wheeldelta > 0 then begin
                self.HoverUp;
            end else begin
                self.HoverDown;
            end;
        end;
    end;
end;
procedure TACPopup.KeyUp(var Key: Word; Shift: TShiftState);
var
    ch : char;
    b : boolean;
begin

    if self.ClipMenuVisible then begin
        if key in [VK_UP, VK_DOWN, VK_LEFT,VK_RIGHT, VK_RETURN, VK_ESCAPE] then begin
            ClipMenuReportKey(key);
        end;
        EXIT;
    end;

    if (key=VK_LEFT) and ([ssCtrl]=shift) then begin

        HideTooltip;
        self.ClipMenuShow(false);
        exit;
    end;

    if ([ssShift]=shift) and (key in [VK_UP,VK_DOWN]) then begin
        if (hover<>nil) and (hover.ItemType=IT_POPUPCLIP) then begin
            case key of
            VK_UP:
                begin
                    self.MoveClip(hover.IntegerData, hover.IntegerData-1);
                end;
            VK_DOWN:
                begin
                    self.MoveClip(hover.IntegerData, hover.IntegerData+1);
                end;
            end;
        end;
        EXIT;
    end;

    if (key=VK_ESCAPE) then begin
        self.Hide;
        EXIT;
    end;

    inherited KeyUp(key, shift);
    b := false;
    case key of
    VK_PRIOR:
        begin
            HoverClipSetPrevious;
        end;
    VK_NEXT:
        begin
            HoverClipSetNext;
        end;
    VK_HOME:
        begin
            b := PermGroupPrev;
        end;
    VK_END:
        begin
            b := PermGroupNext;
        end;
    end;

    if hover = nil then EXIT;

    case key of
    VK_DELETE:
        begin
            case hover.ItemType  of
                IT_POPUPCLIP:
                    begin
                        self.DeleteClip(ClipQueue.IndexOf(hover.clip));
                    end;
                IT_CLIPBOARD: begin
                    frmClipboardManager.ClearClipboard;
                    self.DeleteClipCallback(nil);
                end;
            end;
        end;
    VK_APPS:
        begin
            self.ClipMenuShow(false);
        end;
    VK_TAB:
        begin
            if (hover.fItemType in TContainsAClip) then begin
                hover.TabPressed := true;
                self.HoverClick;
            end;
        end;
    end;

    if fLastKeyDown in [VK_MENU, VK_CONTROL, VK_SHIFT] then begin
        HideTooltip;
        timModifier.Enabled := true;
    end;

end;
function TACPopup.HoverClipSetNext : boolean;
var p : TACPopupItem;
    i : integer;
begin
    result := false;
    p := self.Hover;
    if p = nil then begin
        i := 0;
    end else begin
        i := p.Index + 1;
    end;
    if i >= self.fitems.fSubMenu.Count then EXIT;

    p := self.fItems.Items[i];
    while p.ItemType <> IT_CLIPSET_HEADER do begin
        inc(i);
        if i >= self.fitems.fSubMenu.Count then EXIT;
        p := self.fItems.Items[i];
    end;

    SetHover(p, false);
    if not p.Expanded then begin
        HoverClick;
    end;
    HoverDown;
    result := true;
end;
function TACPopup.HoverClipSetPrevious : boolean;
var P : TACPopupItem;
    i : integer;
begin
    result := false;
    p := self.Hover;
    if p = nil then p := self.fItems.fSubMenu.GetItem(self.fItems.fSubMenu.count-1);

    if p.IsInExpandedMenu and (p.fParent.ItemType = IT_CLIPSET_HEADER) then begin
        i := p.fParent.Index - 1;
    end else begin
        i := p.Index - 1;
    end;
    if i < 0 then EXIT;

    p := self.fItems.Items[i];
    while p.ItemType <> IT_CLIPSET_HEADER do begin
        dec(i);
        if i < 0 then EXIT;
        p := self.fItems.Items[i];
    end;

    SetHover(p, false);
    if not p.Expanded then begin
        HoverClick;
    end;
    HoverDown;
    result := true;
end;
function TACPopup.PermGroupNext : boolean;
var i : integer;
begin
    result := false;
    i := FrmPermanent.GetPermanentPathIndex;
    inc(i);
    if (i>=frmPermanent.PermFoldersGetCount) then EXIT;
    if FrmPermanent.PermFolderIsSystem(i) then inc(i);

    if (i>=frmPermanent.PermFoldersGetCount) then EXIT;
    FrmPermanent.SetPermanentGroup(i);
    self.RebuildPopup;
    FrmPermanent.AssignPIG(FrmMainPopup.TargetData.ExeName);
    result := true;
end;
function TACPopup.PermGroupPrev : boolean;
var i : integer;
begin
    result := false;
    i := FrmPermanent.GetPermanentPathIndex;
    dec(i);
    if (i<0) then EXIT;
    if FrmPermanent.PermFolderIsSystem(i) then dec(i);

    if (i<0) then EXIT;
    FrmPermanent.SetPermanentGroup(i);
    self.RebuildPopup;
    FrmPermanent.AssignPIG(FrmMainPopup.TargetData.ExeName);
    result := true;
end;
function TACPopup.CalcWidth(fpi : TACPopupItem; ClipIt : boolean=true) : integer;
begin
    result := inherited CalcWidth(fpi, ClipIt);

    if not ClipIt and (fpi.ItemType = IT_POPUPCLIP) then begin
        result := max(self.fMaxItemWidth, result);
    end;
end;


//
// Popup Clips edited while the popup is open
//
procedure TACPopup.DeleteClip(i:integer);
var x, j : integer;
    it : TItemType;
begin
    x := i;
    ClipQueue.DeleteItem(i);
    self.RebuildPopup;

    for j := 0 to fitems.fSubMenu.Count-1 do begin
        if (fitems[j].ItemType = IT_POPUPCLIP) and (fitems[j].integerdata=x) then begin
            sethover(fitems[j],false);
        end;
    end;
end;
procedure TACPopup.MoveClip(oldindex,newindex:integer);
var x, j : integer;
begin
    x := newindex;
    if not ClipQueue.Move(oldindex,newindex) then EXIT;

    self.RebuildPopup;

    for j := 0 to fitems.fSubMenu.Count-1 do begin
        if (fitems[j].ItemType = IT_POPUPCLIP) and (fitems[j].integerdata=x) then begin
            sethover(fitems[j],false);
        end;
    end;
end;


// Detect When user tries to "off-click" to hide the popup
procedure TACPopup.ExplorerClickTimer(Sender: TObject);
begin
    if KeyboardQuery.IsClicked(leftButton) then begin
        if not self.MouseInPopup then begin
            self.Hide;
            fExplorerClickTimer.Enabled := false;
        end;
    end;
end;
procedure TACPopup.Hide;
begin
    inherited Hide;

    ClipQueue.removeListener(popupClipsChange);
    if self.fshowing = false then EXIT;
    fExplorerClickTimer.Enabled := false;
end;

function TACPopup.IsLegalDrop(p: TACPopupItem): boolean;
begin
    result := false;
    if inherited IsLegalDrop(p) then begin
        case fdragmenuitem.itemtype of
            IT_POPUPCLIP, IT_PERMANENT, IT_TEMP, IT_PINNED: begin
                if fDragMenuItem.ItemType = p.ItemType then begin
                    result := true;
                end;
            end;
            else begin
                if fDragMenuItem.IsExpandable or
                    (fdragmenuitem.ItemType in [IT_CLIPBOARD, IT_SEARCH, IT_FULL,IT_POPUPCLIP,IT_PERMANENT]) then begin
                    if p.IsExpandable or
                    (p.ItemType in [IT_CLIPBOARD, IT_SEARCH, IT_FULL,IT_POPUPCLIP, IT_PERMANENT]) then begin
                        result := true;
                    end;
                end;
            end;
        end;
    end;
end;
function TACPopup.HandleMouseClick(p : TACPopupItem):boolean;
    procedure DoIt;
    begin
        FrmMainPopup.SkipFocusReturnOnce;
        self.hide;
    end;
begin
    result := false;

	{handle Icon clicks, pass of Caption cliks}
    {handle right clicks}
    if ([ssLeft, ssMiddle] * fDownShift) <> [] then begin
        if hover=nil then begin
            SetHover(p,false);
        end;
        case FLastPosition of
            pipLeftIcon: begin
                if (p.ItemType = IT_CLIPSET_HEADER) then begin
                    if p.fHasLeftIcon then begin
                        self.ShowFilter(p);
                    end;
                end else begin
                    case hover.itemtype of
                        IT_PERMANENT:
                            begin
                                DoIt;

                                FrmEditHistory.ShowPermanent(hover.fPermanentGroupID, hover.fPermanentID);
                            end;
                        IT_FULL:
                            begin
                                DoIt;
                                FrmConfig.pcPanels.ActivePage := FrmConfig.tsMenuOrder;
                                frmConfig.Show;
                                UnitMisc.ForceForeground(frmconfig.Handle);
                            end;
                        IT_LINE, IT_NONE:
                            begin
                                // do nothing, Lines have not icons
                            end
                    else
                        begin
                            if p.SmallCaption then EXIT;

                            fim.SetACPopupItem(hover);
                            fim.SetPopupClip(hover.Clip);
                            case FrmConfig.GetIconClickAction of
                            CBXICONCLICKACTION_EDIT:
                                begin
                                    DoIt;
                                    if frmConfig.cbEditClipWindow.checked then begin
                                        FrmEditItem.SetText(hover.clip.GetAsPlaintext, nil);
                                        FrmMainPopup.ShowPreviewEditForm;
                                    end else begin
                                        frmEditTextExternal.EditClip(hover.clip);
                                    end;
                                end;
                            CBXICONCLICKACTION_PIN:
                                fim.btnPin.Click;
                            CBXICONCLICKACTION_DELETE:
                                fim.btnDelete.Click;
                            CBXICONCLICKACTION_DESTROY:
                                fim.btnDestroy.Click;
                            CBXICONCLICKACTION_CLIPBOARD:
                                fim.btnClipboard.Click;
                            CBXICONCLICKACTION_MIMIC:
                                fim.btnMimic.Click;
                            CBXICONCLICKACTION_SHIFTINSERT:
                                fim.btnShiftInsert.Click;
                            CBXICONCLICKACTION_CTRLV:
                                fim.btnCtrlV.Click;
                            end;
                        end;
                    end;
                end;
            end;
//            pipRightIcon: begin
//                ACPopupClicks.ClipTypeClick(Hover);
//                self.Hide;
//            end;
            pipCaption: begin
                inherited HandleMouseClick(p);
            end;
            pipNone: ;
        end;
    end else if (ssRight in fDownShift) then begin
        if hover=nil then begin
            SetHover(p,false);
        end;

        self.CancelShowSubmenu;
        timHover.Enabled := false;
        timLeftIconHover.Enabled := false;
        if (p.Style = psNormal) and (p.ItemType in TUsesClipMenu) then begin
            self.ClipMenuShow(true);
//            FrmClipMenuNew.ShowForm;
        end;
    end;
end;
procedure TACPopup.HandleCaptionClick(p : TACPopupItem);
begin
    case p.Style of
    psNormal:;
    psLine:;
    psBreak:;
    psSubmenu:;
    psExpandable:
        begin

        end;
    psCheckable:;
    psGap:;
    end;

    inherited HandleCaptionClick(p);
end;
procedure TACPopup.DetectKeystroke(p: TACPopupItem);
var
	c : char;
    i : integer;
begin
    inherited DetectKeystroke(p);

    i := fkeystrokes.IndexOfObject(p);
    if i <> -1 then begin
        c := fKeystrokes.Strings[i][1];

        if p.ItemType = IT_PERMANENT then begin
            p.Prefix := '&' + c;
            if Pos('&'+c+' ', p.fCaption) = 1 then begin
                p.fCaption := UnitToken.clipManyChars(p.fCaption, 3);
            end;
        end;
    end;
end;
procedure TACPopup.AssignSubmenuShortcuts(p : TACPopupItem);
begin
    if p.ItemType = IT_CLIPSET_HEADER then EXIT;

    inherited AssignSubmenuShortcuts(p);
end;

procedure TACPopup.AddCancel;
var p : TACPopupItem;
begin
    p := self.Add;
    p.ItemType := IT_CANCEL;
    if FrmMainPopup.GetNeedsFocus then begin
        p.Caption := 'Cancel   (ESC)';
    end else begin
        p.Caption := 'Cancel';
    end;
    p.fIntegerData := Integer(MOT_CANCEL);
end;
procedure TACPopup.AddPastingTools;
var
    p, sub : TACPopupItem;
    s : string;
    sl : TStringList;
    i : integer;
begin
    p := self.Add;
    p.IsExpandable := true;

    p.Caption := 'Pasting Tools';
    p.LeftBitmap := ImgToBitmap(frmmainpopup.ImgMisc);
    SetPrefix(p);
    p.fIntegerData := Integer(MOT_PASTEUTILS);
    p.ItemType := IT_PASTING_TOOLS;
    {sub := p.Add;
    sub.Caption := 'Edit History...';
    sub.LeftIcon := GetIconFromBitmap(frmmainpopup.imgEdit.Picture.Bitmap);
    sub.fIntegerData := Integer(owEditHistory);
    sub.OnClick := ACPopupClicks.OpenWindowCommand;

    sub := p.addline;}

    sub := p.add;
    sub.caption := 'Paste All';
    sub.LeftBitmap := ImgToBitmap(frmmainpopup.imgPasteAll);
    sub.Hint := 'Pastes all Popup Clips as a single text clip';
    sub.fLeftIconOnlyOnHover := true;
    sub.OnClick  := ACPopupClicks.PasteAllClick;

    sub := p.add;
    sub.caption := 'Paste All Files';
    sub.LeftBitmap := ImgToBitmap(frmmainpopup.imgPasteAll);
    sub.Hint := 'Pastes all File Clips as a single clip';
    sub.fLeftIconOnlyOnHover := true;
    sub.OnClick  := ACPopupClicks.PasteAllFilesClick;
    sub.Disabled := not self.fHasFiles;
    self.fPasteFiles := sub;


    sub := p.add;
    sub.caption := 'Paste Selected Text...';
    sub.LeftBitmap := ImgToBitmap(frmmainpopup.imgPaste);
    sub.fIntegerData := Integer(owPasteSelected);
    sub.OnClick := ACPopupClicks.OpenWindowCommand;
    sub.Hint := 'Shows the ''Paste Selected'' Window';
    sub.fLeftIconOnlyOnHover := true;
    sub.fCaptionTrailingBitmap := ImgToBitmap(FrmMainPopup.imgNewWindow);

//    p.addLine;

    sub := p.add;
    sub.SeparatorLine := true;
    //frmmainpopup.UseFormMode;
    sub.Caption := 'Form Mode';

    //sub.LeftIcon := GetIconFromBitmap(frmmainpopup.imgEdit.Picture.Bitmap);
    sub.Checked := self.GetFormMode;
    sub.hint := 'Enabled pasting of multiple clips';
	sub.ItemType := IT_FORMMODE;


    sl := TStringList.Create;
    TClipDatabase.LoadPermanentNames(sl, FORM_MODE_FOLDER);
    i := 0;
    for s in sl do begin
        sub := p.add;
        sub.caption := s;
        sub.Hint := 'Simulates a keystrokes using a macro';
	    sub.ItemType := IT_NEXTFIELD;
        sub.fIntegerData := i;
        inc(i);
    end;
    myfree(sl);

    sub := p.Add;
    sub.SeparatorLine := true;
    sub.Caption := 'Form Mode Keystrokes...';
    sub.fCaptionTrailingBitmap := ImgToBitmap(FrmMainPopup.imgNewWindow);
    sub.OnClick := ACPopupClicks.OpenWindowCommand;
    sub.fIntegerData := Integer(owPermanentClips);
    sub.fPermanentGroupID := FrmPermanent.PermFolderToIndex(FORM_MODE_FOLDER);


    if self.GetFormMode then begin
        p.Expanded := true;
    end;

    self.CheckForAutoExpand(p);
    //sub.LeftIcon := GetIconFromBitmap(frmmainpopup.imgEdit.Picture.Bitmap);
end;
procedure TACPopup.AddAllItemsSubmenu;
var i, j : integer;
    m, main, sub, subm2 : TACPopupItem;

    s : string;
    wc : TWideChar;
    ci : TClipItem;
    cl : TClipList;
begin
    main := nil;

    if (not FrmConfig.cbShowAllAsSubmenus.checked) then begin
        main := self.Add;
        main.Caption := 'All Permanent';
        main.leftbitmap := ImgToBitmap(frmmainpopup.imgPermCasc);
        main.IsExpandable := true;
        main.fIntegerData := Integer(MOT_ALLPERMANENT);
        main.ItemType := IT_ALLPERM_MENU;
        SetPrefix(main);
    end;
    s := lowercase(frmPermanent.GetPermanentPath);

//    FrmPermanent.PermFolderPush;
    FrmDebug.AppendLog('PermFolders count='+IntToStr(frmPermanent.PermFoldersGetCount));
    for i := 0 to frmPermanent.PermFoldersGetCount - 1 do begin
        if FrmPermanent.PermFolderIsSystem(i) then CONTINUE;

        if (FrmConfig.cbShowAllAsSubmenus.checked) then begin
            m := self.add;
            m.LeftBitmap := ImgToBitmap(frmmainpopup.imgPermCasc);
            SetPrefix(m);
        end else begin
            m := main.Add;
        end;
        m.Caption := frmPermanent.PermFoldersGetItem(i);
        m.itemtype := IT_POPUP;
        AddSubmenu(m);
//        FrmPermanent.SetPermanentPath(m.Caption);

        cl := TClipList.Create(true);
        TClipDatabase.LoadPermanentClips(cl, m.Caption);
        FrmDebug.AppendLog('PermCount='+IntToSTr(cl.Count));
        for j := 0 to cl.count - 1 do begin

            ci := cl[j];
            subm2 := m.add;
            subm2.Caption := ci.getDisplayText;
            subm2.itemtype := IT_PERMANENT;
            subm2.fPermanentGroupID := i;
            subm2.fPermanentID  := j;
            subm2.fPermanentText := ci.GetAsPlaintext;

            subm2.leftbitmap := ImgToBitmap(FrmMainPopup.ImgEdit);
            subm2.fIconHoverCaption := 'Edit ...';
            subm2.fLeftIconOnlyOnHover := true;

            case ci.GetFormatType of
            FT_FILE: 		subm2.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgFile);
            FT_PICTURE: 	subm2.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgPic);
            FT_HTML:		subm2.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgHTML);
            FT_RICHTEXT:	subm2.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgRichText);
            FT_UNICODE: 	subm2.fHasCliptypeIcon := false;
            end;


            subm2.OnClick := ACPopupClicks.PermanentClipClick;
        end;
        cl.Clear;
        myfree(cl);
    end;

    if (not FrmConfig.cbShowAllAsSubmenus.checked) then begin
        if FrmConfig.cbPermanentItemsSubmenu.Checked then begin
            subm2 := main.Add;
            self.AddSubmenu(subm2);
            subm2.Caption := '[Switch Group]';
        end;
        for i := 0 to frmPermanent.PermFoldersGetCount - 1 do begin

            if FrmPermanent.PermFolderIsSystem(i) then CONTINUE;

            if FrmConfig.cbPermanentItemsSubmenu.Checked then begin
                sub := subm2.add;
            end else begin
                sub := main.add;
                if (i=0) then
                    sub.SeparatorLine := true;
            end;

            //sub.Caption := FrmPermanent.PermFoldersGetItem(i);
            sub.fPermanentGroupID := i;
            sub.itemtype := IT_SWITCH;
            sub.fCollapseParentOnClick := true;
            sub.OnClick := ACPopupClicks.PermanentGroupClick;
            wc := TWideChar.create;
            wc.Append(WideChar($2192)); {right arrow}
            if (lowercase(FrmPermanent.PermFoldersGetItem(i)) <> s) then begin
                sub.Checked := false;
                sub.CheckGrouped;
            end else begin
                sub.checked := true;
                sub.CheckGrouped;
            end;
            wc.AppendUnicode('[' +FrmPermanent.PermFoldersGetItem(i) + ']');
            sub.fcaption := wc.GetString;
            sub.hint := 'Changes the current Permanent Clips group';
        end;

	end;
//    FrmPermanent.PermFolderPop;

    if (not FrmConfig.cbShowAllAsSubmenus.checked) then begin
        if (main.fSubMenu.Count>0) then begin

            if (FrmConfig.cbShowAllAsSubmenus.checked) then begin
                self.AddLine;
            end else begin
                m := main.Add;
            end;
            m.Caption := 'Edit ...';
            m.SeparatorLine := true;
            m.fCaptionTrailingBitmap := ImgToBitmap(frmmainpopup.imgNewWindow);
            m.fIntegerData := Integer(owPermanentClips);
            m.fPermanentGroupID := -1;
            m.OnClick := ACPopupClicks.OpenWindowCommand;

            self.CheckForAutoExpand(main);
        end;
    end;
end;

procedure TACPopup.AddSwitchToSubmenu;
var i : integer;
    p, sub : TACPopupItem;
    s : string;
    wc : TWideChar;
begin
    p := self.add;
    p.Caption := 'Permanent Groups';
    p.LeftBitmap := ImgToBitmap(FrmMainPopup.imgPermCasc);
    p.IsExpandable := true;
    p.fIntegerData := Integer(MOT_SWITCH);
    p.ItemType := IT_SWITCH_MENU;
    SetPrefix(p);
    s := lowercase(frmPermanent.GetPermanentPath);


    for i := 0 to frmPermanent.PermFoldersGetCount - 1 do begin
        if FrmPermanent.PermFolderIsSystem(i) then CONTINUE;

        sub := p.add;
        //sub.Caption := FrmPermanent.PermFoldersGetItem(i);
        sub.fPermanentGroupID := i;
        sub.itemtype := IT_SWITCH;
        sub.fCollapseParentOnClick := true;
        sub.OnClick := ACPopupClicks.PermanentGroupClick;
        wc := TWideChar.create;
        wc.Append(WideChar($2192)); {right arrow}
        if (lowercase(FrmPermanent.PermFoldersGetItem(i)) <> s) then begin

            sub.Checked := false;
            sub.CheckGrouped;
        end else begin
            sub.checked := true;
            sub.CheckGrouped;
        end;
        wc.Append('[' +FrmPermanent.PermFoldersGetItem(i) + ']');
        sub.fcaption := wc.GetString;
        sub.hint := 'Changes the current Permanent Clips group';
    end;

//    p.addline;
    sub := p.add;
    sub.Caption := 'Edit ...';
    sub.SeparatorLine := true;
    sub.fIntegerData := Integer(owPermanentClips);
    sub.OnClick := ACPopupClicks.OpenWindowCommand;
    sub.fPermanentGroupID := -1;
    sub.fCaptionTrailingBitmap := ImgToBitmap(frmmainpopup.imgNewWindow);

    self.CheckForAutoExpand(p);
end;
procedure TACPopup.AddCurrentClipboard;
var
    p : TACPopupItem;
begin
    CurrentClipboard.GetClipboardItem(0);
    if CurrentClipboard.GetDataSize <> 0 then begin
        p := self.Add;
        p.ItemType := IT_CLIPBOARD;

        p.Clip := CurrentClipboard;
        self.SetPrefix(p);
        p.fIntegerData := Integer(MOT_CURRENT);

        p.CaptionFromClip := p.clip;


        p.OnClick := ACPopupClicks.PopupClipClick;
        p.OnRightClick := ACPopupClicks.PopupClipRightClip;

        SetLeftIcon(p, p.clip, true);
    end else begin
        p := self.Add;
        p.ItemType := IT_CLIPBOARD;
        self.SetPrefix(p);
        p.fIntegerData := Integer(MOT_CURRENT);
        p.fcaption := '[empty]';
        p.LeftBitmap := FrmClipboardManager.iText.Picture.Bitmap;
        p.Disabled := true;
    end;

end;
procedure TACPopup.AddCurrentPermanentItems;
var i : integer;
    p, sub : TACPopupItem;
    ci : TClipItem;
    cl : TClipList;
    procedure AddSmallSwitchSubmenu;
    var i : integer;
        wc : TWideChar;
        s : string;
    begin
        // Default/_System
        if FrmPermanent.PermFoldersGetCount <= 2 then EXIT;

        p := self.add;
        p.IsSubmenu := true;
        p.ItemType := IT_SWITCH;
        p.SmallCaption := true;
        p.BottomLine := true;
        s := FrmPermanent.GetPermanentPath;
        p.fCaption := s;
        s := lowercase(s);
        for i := 0 to frmPermanent.PermFoldersGetCount - 1 do begin
            if FrmPermanent.PermFolderIsSystem(i) then CONTINUE;

            sub := p.add;
            //sub.Caption := FrmPermanent.PermFoldersGetItem(i);
            sub.fPermanentGroupID := i;
            sub.itemtype := IT_SWITCH;
            sub.fCollapseParentOnClick := true;
            sub.OnClick := ACPopupClicks.PermanentGroupClick;
            wc := TWideChar.create;
            wc.Append(WideChar($2192)); {right arrow}
            if (lowercase(FrmPermanent.PermFoldersGetItem(i)) <> s) then begin

                sub.Checked := false;
                sub.CheckGrouped;
            end else begin
                sub.checked := true;
                sub.CheckGrouped;
            end;
            wc.Append('[' +FrmPermanent.PermFoldersGetItem(i) + ']');
            sub.fcaption := wc.GetString;
            sub.hint := 'Changes the current Permanent Clips group';
        end;
    end;
begin
    if frmPermanent.GetCount = 0 then EXIT;

    if not fGroupSwitchUsed then begin
        AddSmallSwitchSubmenu;
    end;

    cl := TClipList.Create(true);
    TClipDatabase.LoadPermanentClips(cl, FrmPermanent.GetPermanentPath);
	for i := 0 to cl.Count - 1 do begin
    	p := self.add;
        ci := cl[i];
        p.fCaption := ci.getDisplayText; {bypass the clip cleaning routings}

		p.LeftBitmap  := ImgToBitmap(FrmMainPopup.ImgEdit);
        p.fIconHoverCaption := 'Edit ...';

        p.fLeftIconOnlyOnHover := true;
        p.itemtype := IT_PERMANENT;
        p.fPermanentGroupID := -1;
        p.fPermanentID := i;
        p.fPermanentText := FrmPermanent.GetItemText(i);
        p.OnClick := ACPopupClicks.PermanentClipClick;
        p.OnRightClick := ACPopupClicks.PopupClipRightClip;


        case ci.GetFormatType of
        FT_FILE: 		p.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgFile);
        FT_PICTURE: 	p.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgPic);
        FT_HTML:		p.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgHTML);
        FT_RICHTEXT:	p.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgRichText);
        FT_UNICODE: 	p.fHasCliptypeIcon := false;
        end;

        SetPrefix(p);
	end;
    cl.Clear;
    myfree(cl);
end;
procedure TACPopup.AddFullConfigured;
var p : TACPopupItem;
begin
    p := self.Add;
    p.ItemType := IT_FULL;
    if self.UseKeyboard then begin
    	p.Prefix := '&' +FrmConfig.GetAccelSymbols[length(frmconfig.GetAccelSymbols)]+  ' ';
    end;
    if fFullMode then begin
        p.Caption := 'Show Less';
        p.Hint := 'Show only configured items';
        p.LeftBitmap := ImgToBitmap(FrmMainPopup.imgConfMode);
    end else begin
        p.Caption := 'Show More';
        p.Hint := 'Show all possible items';
        p.LeftBitmap := ImgToBitmap(frmmainpopup.imgFull);
    end;
    SetPrefix(p);
    p.fIconHoverCaption := 'Edit Menu Order ...';
end;
procedure TACPopup.AddLast;

begin
{
    if PData.LastClickedText <> '' then begin
        p := self.add;
        p.Caption := 'Last: ' + PData.LastClickedText;
        self.AddPrefix(p);
    end else begin
        if fFullMode = false then
            inc(fReservedCount);
    end;
}
end;
procedure TACPopup.SetPrefix(p: TACPopupItem);
var accel : char;
	i, j  : integer;
    s : string;
begin
	if self.UseKeyboard = false then EXIT;

    s := stringreplace(p.Caption,'&&','',[rfReplaceAll]);
    if (Pos('&', s)=0) and (pos('&', p.Prefix)=0)  then begin

        j := 0;
        repeat
//        	if j <> 0 then appendlog('Accel key take: ' + accel);

        	accel := GetAccelerator(j);
            if accel = ' ' then begin
                FrmDebug.AppendLog('out of accelerator keys');
                EXIT;
            end;

            i := fKeystrokes.IndexOf(accel);
            if (i=-1) then begin
                i := Pos(accel, fAccelCharsUsed);
                if i=0 then i:=-1;
            end;
            inc(j);
        until i = -1;
		inc(fAcceleratorCount);

        p.Prefix := '&' + accel  + ' ';
        fKeystrokes.AddObject(accel, p);
    end else begin
		if (p.ItemType in [IT_POPUPCLIP, IT_PERMANENT, IT_FULL])  then begin
            DetectKeystroke(p);
        end;
    end;
end;
procedure TACPopup.AddProgramOptions;
var p, sub, sub2 : TACPopupItem;
    i : integer;
    s : string;
begin
    p := self.Add;
    s := lowercase(FrmMainPopup.TargetData.ExeName);
    p.caption := '['+TokenString(s,'.exe') + '] Options';
    p.fCaption[2] := Uppercase(p.fCaption[2])[1];
    p.IsExpandable := true;
    p.LeftIcon := FrmMainPopup.TargetData.icon;
    if p.LeftIcon = 0 then p.LeftIcon := UnitClipQueue.ClipDataDefaultIcon;
    p.LeftBitmap := ImgToBitmap(FrmMainPopup.imgAICon);

    p.ItemType := IT_PROGRAM_MENU;
    p.fIntegerData := Integer(MOT_PROGRAM);
    SetPrefix(p);
    p.Hint := 'Per-program options for Pasting and Monitoring';
    i := Integer(Paste.GetPasteMethod(FrmMainPopup.TargetData.ExeName));


    sub2 := p.Add;
    sub2.Caption := 'Paste Method';
    sub2.ItemType := IT_POPUP;
    AddSubmenu(sub2);

        sub := sub2.add;
        sub.Caption := '( Use Default )';
        sub.ItemType := IT_PASTE_METHOD;
        sub.Checked := (i = 4);
        sub.fIntegerData := 4;
        sub.CheckGrouped;
        sub.OnClick := ACPopupClicks.PasteMethodClick;

        sub := sub2.add;
        sub.Caption := 'Mimic Typing';
        sub.ItemType := IT_PASTE_METHOD;
        sub.Checked := (i = 2);
        sub.fIntegerData := 2;
        sub.CheckGrouped;
        sub.OnClick := ACPopupClicks.PasteMethodClick;

        sub := sub2.add;
        sub.Caption := 'Clipboard Only';
        sub.ItemType := IT_PASTE_METHOD;
        sub.Checked := (i = 3);
        sub.fIntegerData := 3;
        sub.CheckGrouped;
        sub.OnClick := ACPopupClicks.PasteMethodClick;

        sub := sub2.add;
        sub.Caption := 'keypress [CTRL+V]';
        sub.ItemType := IT_PASTE_METHOD;
        sub.Checked := (i = 0);
        sub.fIntegerData :=0;
        sub.CheckGrouped;
        sub.OnClick := ACPopupClicks.PasteMethodClick;


        sub := sub2.add;
        sub.Caption := 'keypress [SHIFT+Insert]';
        sub.ItemType := IT_PASTE_METHOD;
        sub.Checked := (i = 1);
        sub.fIntegerData := 1;
        sub.CheckGrouped;
        sub.OnClick := ACPopupClicks.PasteMethodClick;

        sub := sub2.add;
        sub.Caption := 'Custom Macro';
        sub.SeparatorLine := true;
        sub.ItemType := IT_PASTE_METHOD;
        sub.Checked := (i = 6);
        sub.fIntegerData := 6;
        sub.CheckGrouped;
        sub.Disabled := frmSysTrayMenu.GetProgramMacro(FrmMainPopup.TargetData.ExeName) = '';
        sub.OnClick := ACPopupClicks.PasteMethodClick;


    sub := p.add;
    sub.caption := 'Disable Monitoring';
    sub.SeparatorLine := true;
    sub.ItemType := IT_PASTE_METHOD;
    sub.Checked := FrmSysTrayMenu.IsDisabledEXE(FrmMainPopup.TargetData.ExeName);
    sub.OnClick := ACPopupClicks.ProgramOptionDisableMonitoring;

    sub := p.add;
    sub.caption := 'Disable ''Mouse Button Trigger''';
    sub.ItemType := IT_PASTE_METHOD;
    sub.Checked := FrmSysTrayMenu.IsNoRightClickEXE(FrmMainPopup.TargetData.ExeName);
    sub.OnClick := ACPopupClicks.ProgramOptionDisableRightClickPopup;

    sub := p.add;
    sub.caption := 'Explorer Compatibility';
    sub.ItemType := IT_PASTE_METHOD;
    sub.Checked := FrmSysTrayMenu.IsExplorerCompatEXE(FrmMainPopup.TargetData.ExeName);
    sub.OnClick := ACPopupClicks.ProgramOptionExplorerCompat;

    sub := p.add;
    sub.caption := 'More ...';
    sub.SeparatorLine := true;
    sub.ItemType := IT_PASTE_METHOD;
    sub.fIntegerData := Integer(owConfiguration);
    sub.OnClick := ACPopupClicks.ConfigurationPerProgram;
    sub.fCaptionTrailingBitmap := ImgToBitmap(frmmainpopup.imgNewWindow);

    self.CheckForAutoExpand(p);
end;
procedure TACPopup.AddSearch;
var p : TACPopupItem;
begin
    p := self.Add;
    p.Caption := 'Search and Paste ...';
    p.fCaptionTrailingBitmap := ImgToBitmap(FrmMainPopup.imgSearch);
    p.ItemType := IT_SEARCH;
    p.fIntegerData := Integer(owSearch);
    p.OnClick := ACPopupClicks.OpenWindowCommand;
    p.hint := 'Shows the ''Search'' Window';
    SetPrefix(p);
end;
procedure TACPopup.AddSubmenu(p: TACPopupItem);
begin
    p.IsSubMenu := true;
    p.Disabled := true;
    p.ItemType := IT_POPUP;
    p.fLeftIconOnlyOnHover := true;
end;
procedure TACPopup.AddSwitchToItems;
var i : integer;
    sub : TACPopupItem;
    s : string;
    wc : TWideChar;
begin
    s := lowercase(frmPermanent.GetPermanentPath);
    for i := 0 to frmPermanent.PermFoldersGetCount - 1 do begin
    	if (lowercase(frmPermanent.PermFoldersGetItem(i)) = s) then CONTINUE;
        if FrmPermanent.PermFolderIsSystem(i) then CONTINUE;

        sub := self.add;
        sub.fPermanentGroupID := i;
        sub.itemtype := IT_SWITCH;
        sub.OnClick := ACPopupClicks.PermanentGroupClick;
        wc := TWideChar.create;
        if (lowercase(FrmPermanent.PermFoldersGetItem(i)) <> s) then begin
            wc.Append(WideChar($2192)); {right arrow}
        end;
        wc.AppendUnicode('[' +FrmPermanent.PermFoldersGetItem(i) + ']');
        sub.fcaption := wc.GetString;
        sub.hint := 'Changes the current Permanent Clips group';
        sub.LeftBitmap := ImgToBitmap(frmmainpopup.imgPermCasc);
        SetPrefix(sub);
    end;
end;
procedure TACPopup.AddSystem;
var p, sub, sub2 : TACPopupItem;
begin
    p := self.add;
    p.Caption := 'System';
    p.LeftBitmap := ImgToBitmap(frmmainpopup.imgAICon);
    p.IsExpandable := true;
    SetPrefix(p);
    p.fIntegerData := Integer(MOT_SYSTEM);
    p.ItemType := IT_SYSTEM_MENU;


    sub := p.Add;
    sub.Caption := 'Configuration ...';
    sub.fCaptionTrailingBitmap := ImgToBitmap(frmmainpopup.imgNewWindow);
    sub.fLeftBitmap := ImgToBitmap(FrmMainPopup.imgA);
    sub.fLeftIconOnlyOnHover := true;
    sub.ItemType := IT_SYSTEM;
    sub.fIntegerData := Integer(owConfiguration);
    sub.OnClick := ACPopupClicks.OpenWindowCommand;
    sub.hint := 'Shows the ''Configuration'' Window';
    sub.fCaptionIconOnlyOnHover := true;

//    p.addline;

//    sub := p.Add;
//    sub.Caption := 'Permanent Clips/Macros ...';
//    sub.SeparatorLine := true;
//    sub.fCaptionTrailingBitmap := ImgToBitmap(frmmainpopup.imgNewWindow);
//    sub.fLeftBitmap := ImgToBitmap(FrmMainPopup.imgPermCasc);
//    sub.fLeftIconOnlyOnHover := true;
//    sub.ItemType := IT_SYSTEM;
//    sub.fIntegerData := Integer(owPermanentClips);
//    sub.OnClick := ACPopupClicks.OpenWindowCommand;
//    sub.hint := 'Shows the ''Permanent Clips'' Window';
//    sub.fCaptionIconOnlyOnHover := true;

    sub := p.Add;
    sub.Caption := 'Edit Clips/Macros ...';
    sub.fCaptionTrailingBitmap := ImgToBitmap(frmmainpopup.imgNewWindow);
    sub.fLeftBitmap := ImgToBitmap(FrmMainPopup.imgEdit);
    sub.fLeftIconOnlyOnHover := true;
    sub.ItemType := IT_SYSTEM;
    sub.fIntegerData := Integer(owEditHistory);
    sub.OnClick := ACPopupClicks.OpenWindowCommand;
    sub.hint := 'Shows the ''Edit Clips'' Window';
    sub.fCaptionIconOnlyOnHover := true;

    sub := p.Add;
    sub.Caption := 'Edit Clipboard ...';
    sub.fCaptionTrailingBitmap := ImgToBitmap(frmmainpopup.imgNewWindow);
    sub.fLeftBitmap := ImgToBitmap(FrmMainPopup.imgPaste);
    sub.fLeftIconOnlyOnHover := true;
    sub.ItemType := IT_SYSTEM;
    sub.fIntegerData := Integer(owEditClipboard);
    sub.OnClick := ACPopupClicks.OpenWindowCommand;
    sub.fClip := CurrentClipboard;
    sub.hint := 'Edits the clipboard using an external program';
    sub.fCaptionIconOnlyOnHover := true;

//    p.AddLine;

    sub := p.Add;
    sub.caption := 'Flush History';
    sub.SeparatorLine := true;
    sub.ItemType := IT_POPUP;
    AddSubmenu(sub);
//    sub.Hint := 'Erase Clipboad History';

    sub2 := sub.add;
    sub2.Caption := 'Erase Clipboard';
    sub2.fIntegerData := Integer(peClipboard);
    sub2.OnClick := ACPopupClicks.EraseHistory;
    sub2 := sub.add;
    sub2.Caption := 'Erase Popup Clips';
    sub2.fIntegerData := Integer(pePopupClips);
    sub2.OnClick := ACPopupClicks.EraseHistory;
    sub2 := sub.add;
    sub2.Caption := 'Erase Removed Clips';
    sub2.fIntegerData := Integer(peRemovedClips);
    sub2.OnClick := ACPopupClicks.EraseHistory;
//    sub.AddLine;
    sub2 := sub.add;
    sub2.Caption := 'Erase Everything';
    sub2.SeparatorLine := true;
    sub2.fIntegerData := Integer(peEverything);
    sub2.OnClick := ACPopupClicks.EraseHistory;


    sub := p.Add;
    sub.Caption := 'Toggle Clipboard Bar';
    sub.LeftBitmap := ImgToBitmap(frmmainpopup.imgPaste);
    sub.ItemType := IT_SYSTEM;
    sub.Checked := frmClipboardBar.IsVisible;
    sub.OnClick := ACPopupClicks.OpenWindowCommand;
    sub.hint := 'Shows or hides the Clipboard Bar';
    sub.fLeftIconOnlyOnHover := true;
    sub.onclick := ACPopupClicks.ToggleClipboardBar;

//    p.addline;

    sub := p.Add;
    sub.Caption := 'About ...';
    sub.SeparatorLine := true;
    sub.fCaptionTrailingBitmap := ImgToBitmap(frmmainpopup.imgNewWindow);
    sub.ItemType := IT_SYSTEM;
    sub.fIntegerData := Integer(owAbout);
    sub.OnClick := ACPopupClicks.OpenWindowCommand;
    sub.hint := 'Shows the ''About'' Window';

    sub := p.Add;
    sub.Caption := 'Exit';
    sub.ItemType := IT_SYSTEM;
    sub.OnClick := frmSysTrayMenu.ExitMenuItemClickEvent;
    sub.hint := 'Closes the program';

    self.CheckForAutoExpand(p);
end;
procedure TACPopup.AddPopupClips;
var i, groupcnt, clipcnt, lastClipcnt : integer;
    lastIcon : HICON;
    lastBM : TBitmap;
    p : TACPopupItem;
    group : TACPopupItem;
    clp : TClipItem;
    str, text : string;
    sl : TStringList;
CONST LEFT_OPACITY = 200;
    procedure SetRightIcon(p : TACPopupItem);
    begin
        case p.fclip.GetFormatType of
        FT_FILE:
            begin
                self.fHasFiles := true;
                p.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgFile);
            end;
//        FT_PICTURE: 	p.RightIcon := ImgToBitmap(FrmMainPopup.imgPic);
        FT_PICTURE:
            begin

                p.fHasCliptypeIcon := false;
                if p.ItemType = IT_PERMANENT then begin
                    p.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgPic);
                end;
            end;
        FT_HTML:		p.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgHTML);
        FT_RICHTEXT:	p.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgRichText);
        FT_UNICODE: 	p.fHasCliptypeIcon := false;
        end;

        if p.fCliptypeBitmap <> nil then
        	p.fCliptypeBitmap.TransparentColor := $AAAAAA;
    end;
    procedure SetPopupPrexif(p : TACPopupItem);
    begin
        if FrmConfig.cbPinnedShortcuts.Checked then begin
            p.prefix :=  '&' + GetAcceleratorPopupClips(clipcnt+PinnedClipQueue.GetQueueCount) +' ';
        end else begin
            p.prefix :=  '&' + GetAcceleratorPopupClips(clipcnt) +' ';
        end;
    end;
    procedure AddPinnedClips;
    var i : integer;
    begin
        if PinnedClipQueue.GetQueueCount > 0 then begin
            for i := (PinnedClipQueue.GetQueueCount - 1) downto 0 do begin
                p := self.add;
                p.Clip := PinnedClipQueue.GetClipItem(i);
                p.CaptionFromClip := p.clip;
                //p.Prefix := '  ';
                if self.UseKeyboard and frmconfig.cbPinnedShortcuts.checked then begin
                    p.prefix := '&' + GetAcceleratorPopupClips((PinnedClipQueue.GetQueueCount-1)-i) +' ';
                end;
                p.ItemType := IT_PINNED;
                SetLeftIcon(p, p.Clip);
                p.fLeftIconOpacity := LEFT_OPACITY;
                p.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgUnkown);
                p.OnClick := ACPopupClicks.PopupClipClick;
                p.OnRightClick := ACPopupClicks.PopupClipRightClip;
                p.fIntegerData := i;

                SetRightIcon(p);
                DetectKeystroke(p);
            end;
            Self.AddLine;
        end;
    end;
    procedure HandleGroupingSetup;
    begin
         //
        // use group when enabled and history > set size
        // use group ONCE when popup too tall and a large enough history
        // use group when a filter is present

        if frmconfig.rbClipSetsAlways.Checked then begin
            self.fUseGrouping := true;
        end else begin
            self.fUseGrouping := (ClipQueue.GetQueueCount > FrmConfig.udClipsPerSet.Position)
                and FrmConfig.cbEnableClipSets.Checked;
            if self.fUseGroupingOnce then begin
                Self.fUseGroupingOnce := false;
                self.fUseGrouping := (ClipQueue.GetQueueCount > FrmConfig.udClipsPerSet.Position);
                self.fUseGroupingOnceFailed := not self.fUseGrouping;
            end;
        end;
        self.GroupingCount := FrmConfig.udClipsPerSet.Position;

        if Filter.Text <> '' then self.fUseGrouping := true;
        fFilterItem := nil;
    end;
    procedure HandleGroupingDetection;
    begin
        if (clipcnt<>0) and (lastclipcnt = clipcnt) then EXIT;

        if (clipcnt mod self.fGroupingCount = 0) and
            not ((clipcnt=0) and (groupcnt<>0)) then begin
            lastIcon := 0;
            lastBM := nil;
            lastClipcnt := clipcnt;
            group := self.Add;
            group.IsExpandable := true;
            group.ItemType := IT_CLIPSET_HEADER;
            if (clipcnt < 10) and (ClipQueue.GetQueueSize>9) then begin
                group.Caption := '  Clip Set  ( 0'+IntToStr(clipcnt+1)+'-'+
                    IntToStr(min(clipcnt+self.fGroupingCount, ClipQueue.GetQueueSize)) +' )';
            end else begin
                group.Caption := '  Clip Set  ( '+IntToStr(clipcnt+1)+'-'+
                    IntToStr(min(clipcnt+self.fGroupingCount, ClipQueue.GetQueueSize)) +' )';
            end;
            group.Expanded := false;
            group.ShowCollapseIcon := false;
            group.CanExpand := self.ClipSetCanExpand;
            group.fIntegerData := groupcnt;

            SetPrefix(group);
            Dec(Self.fAcceleratorCount);   // kludge to keep the shortcut key for the first submenu right

            fGroup.Add(group);

            if (groupcnt = 0) and self.UseKeyboard then begin
                group.LeftBitmap := ImgToBitmap(FrmMainPopup.imgSearch2);
                group.fLeftIconOnlyOnHover := false;
                group.fLeftIconOnExpanded := false;
                if self.filter.Text <> '' then begin
                    group.Caption := group.Caption + ' (filter: '+filter.text+')';
                end;
                group.fIconHoverCaption := 'Filter';
            end;
            if (groupcnt=0) then fFilterItem := group;

            Inc(groupcnt);
        end;
    end;
    procedure HandleIconVisual;
    begin
        p.fLeftIconOpacity := LEFT_OPACITY;
        case frmconfig.GetIconType of
        CBXICONTYPE_PROGRAM:
            begin
                SetLeftIcon(p, p.Clip);
                case FrmConfig.GetRepeatIcons of
                CBXREPEATICONS_DIMMED:
                    begin
                        if (p.fIcon = lasticon) and (lasticon<>0) then begin
                            p.fLeftIconOpacity := 25;

                        end;
                        lasticon := p.fIcon;
                    end;
                CBXREPEATICONS_NORMAL:
                    begin
                    end;
                CBXREPEATICONS_HIDDEN:
                    begin
                        if (p.fIcon = lasticon) and (lasticon<>0) then begin
                            p.fLeftIconOpacity := 0;
                        end;
                        lasticon := p.fIcon;
                    end;
                end;
            end;
        CBXICONTYPE_CLIPTYPE:
            begin
                SetLeftIcon(p, p.Clip);
                case FrmConfig.GetRepeatIcons of
                CBXREPEATICONS_DIMMED:
                    begin
                        if (p.fLeftBitmap = lastBM) and (lastBM<>nil) then begin
                            p.fLeftIconOpacity := 25;
                        end;
                        lastBM := p.fLeftBitmap;
                    end;
                CBXREPEATICONS_NORMAL:
                    begin

                    end;
                CBXREPEATICONS_HIDDEN:
                    begin
                        if (p.fLeftBitmap = lastBM) and (lastBM<>nil) then begin
                            p.fLeftBitmap := nil;
                        end else begin
                            lastBM := p.fLeftBitmap;
                        end;
                    end;
                end;

            end;
        CBXICONTYPE_NONE:
            begin

            end;
        end;

    end;
begin
    CurrentClipboard.GetClipboardItem(0);

    self.fHasFiles := false;

    AddPinnedClips;
    HandleGroupingSetup;

    self.fGroup.Clear;




    groupcnt := 0;
    clipcnt := 0;
    lastClipcnt := 0;
    // extract Clip, Caption, Prefix, and 2 possible icons
    for i := 0 to ClipQueue.GetQueueCount - 1 do begin
        clp := ClipQueue.GetClipItem(i);
        if self.fUseGrouping then begin
            HandleGroupingDetection;
            if filter.Text <> '' then begin
                if not ContainsText(clp.GetAsPlaintext, filter.Text)then begin
                    CONTINUE;
                end;
            end;

            p := group.Add;
        end else begin
            p := self.add;
        end;

        p.Clip := clp;
        p.CaptionFromClip := p.clip;
        if self.UseKeyboard then begin
            if (not FrmConfig.cbPopupCharLimit.Checked) or
                (clipcnt < frmconfig.udPopupKeysLimit.Position) then begin
                SetPopupPrexif(p);
            end;
        end;
        inc(clipcnt);
        p.ItemType := IT_POPUPCLIP;
        HandleIconVisual;
        p.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgUnkown);
        p.OnClick := ACPopupClicks.PopupClipClick;
        p.fIntegerData := i; // ClipQueue Index - not a mistake

        SetRightIcon(p);
        DetectKeystroke(p);
    end;


    if (filter.Text <> '') or (filter.Visible)  then begin
        p := self.Add;
        p.Caption := 'Search Removed';
        p.ItemType := IT_SYSTEM;
        p.OnClick := self.SearchRemovedClicked;
        p.StayOpenOnClick := true;
        p.Checked := self.searchRemoved;
        p.SeparatorLine := true;
    end;


    if ((self.fUseGrouping and (groupcnt > 1)) or
        (clipqueue.GetQueueSize=ClipQueue.GetQueueCount)) and
        (filter.Text = '') then begin
        if groupcnt>=1 then begin
            p := TACPopupItem(fgroup.items[groupcnt-1]).Add;
            p.Caption := 'Removed Clips ...';
            p.SeparatorLine := true;
            p.fCaptionTrailingBitmap := ImgToBitmap(frmmainpopup.imgNewWindow);
            p.fLeftBitmap := ImgToBitmap(FrmMainPopup.imgRemoved);
            p.fLeftIconOnlyOnHover := true;
            p.ItemType := IT_SYSTEM;
            p.OnClick := ACPopupClicks.OpenWindowCommand;
            p.fIntegerData := integer(owRemovedClips);
        end;
    end;




    try
        if self.UseGrouping and (fgroup.Count <>0) then begin
            TACPopupItem(fGroup.Items[self.fCurrentGroup]).Expanded := true;
        end;
    except
        self.fCurrentGroup := 0;
    end;




    if (searchRemoved) then begin
        TClipDatabase.StartTextOnlyData;
        i := 0;
        str := filter.Text;
        str := StringReplace(str, chr($20), chr($a0),[rfReplaceAll]);
        while (TClipDatabase.LoadNextText(text)) do begin
            if ContainsText(text, str) then begin
                clp := RemovedQueue.GetItemClip(i);


                p := self.Add;
                p.Clip := clp;
                p.Caption := text;
                if self.UseKeyboard then begin
                    if (not FrmConfig.cbPopupCharLimit.Checked) or
                        (clipcnt < frmconfig.udPopupKeysLimit.Position) then begin
                        SetPopupPrexif(p);
                    end;
                end;
                inc(clipcnt);
                p.ItemType := IT_TEMP;
                HandleIconVisual;
                p.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgUnkown);
                p.OnClick := ACPopupClicks.RemovedClicked;
                p.fIntegerData := i; // ClipQueue Index - not a mistake

                SetRightIcon(p);
                DetectKeystroke(p);
                inc(clipcnt);

                p.clip := nil;
                myfree(clp);
            end;
            inc(i);
        end;
        TClipDatabase.EndTextOnlyData;
    end;


     if self.fUseGrouping and (clipcnt=0) then begin
        if groupcnt = 0 then
            HandleGroupingDetection;
        p := self.Add;
        p.Caption := '[No Clips]';
        p.ItemType := IT_NONE;
        p.Disabled := true;
    end;
end;

procedure TACPopup.AutoPopulate;
var i, x, cnt : integer;
	c : char;
    linebefore : boolean;
    mot : TMenuOrderType;
    s : string;
    b : boolean;

    procedure EmptyMenuOrderWorkaround;
    begin
        if (FrmConfig.lvOrder.items.Count=0) then begin
            FrmConfig.lvOrder.HandleNeeded;
            if (FrmConfig.lvOrder.items.Count=0) then begin
                raise Exception.Create('Error: [Configuration>Popup>Menu Order] is empty.');
                EXIT;
            end;
        end;
    end;
    procedure SetupColor;
    begin
        // default colors
        fBackgroundColor := clBtnFace;
        fHighlightColor := ColorToRGB(clHighlight);
        fFontColor := ColorToRGB(clBtnText);
        fClickedColor := $00790079;

        // config colors
        if FrmConfig.cbFontColor.Checked then begin
            fFontColor := ColorToRGB(FrmConfig.pnlFontColor.color);
        end;
        if FrmConfig.cbHighlightColor.Checked then begin
            fHighlightColor := ColorToRGB(FrmConfig.pnlHighlightColor.color);
        end;
        if FrmConfig.cbBackgroundColor.Checked then begin
            fBackgroundColor := ColorToRGB(FrmConfig.pnlBackgroundColor.color);
        end;
        if frmconfig.cbClickedColor.Checked then begin
            fClickedColor := ColorToRGB(FrmConfig.pnlClickedColor.color);
        end;

        // derived colors
//        fExpandedBackgroundColor := Blend(fBackgroundColor, fBackgroundColor xor $FFFFFF, 85);
        fExpandedBackgroundColor := Blend(fBackgroundColor, clWhite, 92);
        fColumnColor := Blend(fBackgroundColor, $000000, 95);
        fColumnEdgeColor := DimColorOrReverse(fBackgroundColor,0.86);
        fDisabledColor := DimColorOrReverse(fFontColor, 0.90);
    end;
    procedure ReserveUserSetPermanentKeys;
    var i,j : integer;
    begin
        fGroupSwitchUsed := false;
        // reserve user set permanent keys
        for i := 0 to FrmConfig.lvOrder.items.Count - 1 do begin
            mot := TMenuOrderType(frmConfig.lvOrder.Items[i].data);
            if frmConfig.lvOrder.Items[i].Checked or
                fFullMode or
                ((mot = MOT_PASTEUTILS) and self.GetFormMode)  then begin
                case mot of
                    MOT_PERMANENT: begin
                        for j := 0 to FrmPermanent.GetCount - 1 do begin
                            s := FrmPermanent.GetItemName(j);
                            s := StringReplace(s,'&&','',[rfReplaceAll]);
                            x := pos('&', s);
                            if (x<>0) then begin
                                if x<length(s) then begin
                                    c := upcase(s[x+1]);
                                    fAccelCharsUsed := fAccelCharsUsed + c;
                                end;
                            end;
                        end;
                    end;
                    MOT_SWITCH:
                        begin
                            fGroupSwitchUsed := true;
                        end;
                end;
            end;
        end;
        FrmDebug.AppendLog('PermKeys= '+fAccelCharsUsed);
        FrmDebug.AppendLog('FrmConfig.lvOrder.items.Count='+IntToStr(FrmConfig.lvOrder.items.Count));
    end;
    procedure HandleExplorerMode;
    var
        p : TACPopupItem;
    begin
        if not self.fExplorerMode then begin
            if Paste.GetClipboardOnlyOnce and not Paste.GetClipboardOnly then begin
                p := self.Add;
                p.isGap := true;
                p.SmallCaption := true;
                p.fCaption := '(Clipboard Only)';
                p.BottomLine := true;
            end;
            EXIT;
        end;

        p := self.Add;
        p.isGap := true;
        p.SmallCaption := true;
        p.fCaption := '(Explorer Compatibility)';
        p.BottomLine := true;
    end;
begin
    FrmDebug.AppendLog('Clear Popup');
    EmptyMenuOrderWorkaround;
    self.Clear;
    fitems.fSubShowing := nil;

    SetupColor;

    timHover.Enabled := false;
    fKeystrokes.Clear;
    fExpandedKeystrokes.Clear;

    fHover := nil; {the ONLY exception for touching the fHover value}
    fReservedCount := 0;

    if FrmConfig.cbPopupCharLimit.Checked then begin
        if frmConfig.cbPinnedShortcuts.Checked then begin
            fAcceleratorCount := Min(ClipQueue.GetQueueSize, FrmConfig.udPopupKeysLimit.position) +
                 PinnedClipQueue.GetQueueCount;
        end else begin
            fAcceleratorCount := Min(ClipQueue.GetQueueSize, FrmConfig.udPopupKeysLimit.position);
        end;
    end else begin
        if frmConfig.cbPinnedShortcuts.Checked then begin
            fAcceleratorCount := ClipQueue.GetQueueSize + PinnedClipQueue.GetQueueCount;
        end else begin
            fAcceleratorCount := ClipQueue.GetQueueSize;
        end;
    end;
    fAccelCharsUsed := '';

    HandleExplorerMode;
    if frmConfig.cbFilterSimplified.Checked and
        (filter.Text <> '')  then begin
        self.AddPopupClips;
        if not self.UseKeyboard then begin
            self.AddLine;
            self.AddCancel;
        end;
    end else begin
        ReserveUserSetPermanentKeys;

        for i := 0 to FrmConfig.lvOrder.items.Count - 1 do begin
            linebefore := (FrmConfig.lvOrder.items[i].SubItems[0] = 'Yes');

            mot := TMenuOrderType(frmConfig.lvOrder.Items[i].data);
            b := fFullMode;
            if MOT = MOT_CANCEL then begin
                // always show CANCEL when forced keyboard off detected
                if (not FrmMainPopup.GetNeedsFocus) then begin
                    fFullMode := true;
                end;
            end;

            if frmConfig.lvOrder.Items[i].Checked or
                fFullMode or
                ((mot = MOT_PASTEUTILS) and self.GetFormMode)  then begin
                if linebefore and (fitems.fSubMenu.Count > 0) then begin
                   self.AddLine;
                end;
                cnt := fItems.fSubMenu.Count;
                case mot of
                    MOT_MENU : self.AddPopupClips; {
                    MOT_OTHER : if frmConfig.cbSeparateNontextList.checked then self.AddOtherItems;  }
                    MOT_CANCEL : self.AddCancel;
                    {MOT_LAST : self.AddLast;}
                    MOT_CURRENT : self.AddCurrentClipboard;
                    {MOT_SELECTED : self.AddSelected;}
                    //MOT_REMOVED : self.AddRecentlyRemoved;
                    MOT_PROGRAM : self.AddProgramOptions;
                    MOT_SYSTEM : self.AddSystem;
                    MOT_PASTEUTILS : self.AddPastingTools;
                    MOT_PERMANENT : begin
                        // don't show in full mode, unless configured to show normally
                        if not (fFullMode and (not frmConfig.lvOrder.Items[i].Checked)) then begin
                            self.AddCurrentPermanentItems;
                        end;
                    end;
                    MOT_SWITCH :
                        if frmconfig.cbPermanentItemsSubmenu.checked then
                            self.AddSwitchToSubmenu
                        else
                            self.AddSwitchToItems;
                    MOT_FULL : self.AddFullConfigured;
                    MOT_ALLPERMANENT : self.AddAllItemsSubmenu;
    //              This is being depricated
    //                MOT_CLICKED: self.AddRecentlyClicked;
                    MOT_SEARCH: self.AddSearch;
                    MOT_BREAK:  if not (ffullMode and (not frmConfig.lvOrder.Items[i].Checked)) then begin
                         self.AddBreak; // don't add breaks in Full Mode
                    end;

                end;
                // remove lines for items that generate no new menuitems
                if linebefore and (cnt = fItems.fSubMenu.count) then begin
                    if cnt <> 0 then begin
                        AddLineToNext := false;
                        //fItems.fsubmenu.Delete(fitems.fsubmenu.count-1);
                    end;
                end;
            end;
            fFullMode := b;
        end;

    end;

    fAutoExpandOnce := IT_NONE;

    if fPasteFiles <> nil then begin
        fPasteFiles.Disabled := not self.fHasFiles;
    end;


    FrmDebug.AppendLog('End of AutoPopulate = '+ IntToStr(fitems.fsubmenu.count));
    fIncludeEmpty := false;
end;


procedure TACPopup.ClipMenuShow(rightclick : boolean = false);
    procedure CheckForVisibility;
    begin
        fim.Top := max(screen.DesktopRect.top, fim.top);
        fim.Left := max(screen.DesktopRect.left, fim.Left);

        if fim.Width + fim.Left > screen.DesktopRect.right  then begin
            fim.left := screen.DesktopRect.right - fim.Width;
        end;
        if fim.Height + fim.Top > screen.DesktopRect.bottom then begin
            fim.top := screen.DesktopRect.bottom - fim.Height;
        end;
    end;
    procedure ShowIt;
    var fm : TPopupDisplayMode;
    begin
        CheckForVisibility;
        fm := FormMode;
        FormMode := pdmStayOpen;
        fim.show;

        if not self.fExplorerMode then begin
            ForceForeground(fim.handle);
        end;
        FormMode := fm;
    end;
begin
	if hover = nil then EXIT;
    if (hover = fim.GetACPopupItem) and fim.showing then exit;

    self.MouseCursorReset;
    {under or leftside}
    if rightclick then begin
        fim.Top := self.Top + hover.top;
        fim.Left := mouse.CursorPos.X - 40;
    end else begin
        if (fim.Top <> hover.ftop) then begin
            fim.Top := self.Top + hover.ftop-2;
            fim.Left := self.left + hover.fleft -  fim.Width;
        end;
    end;

    self.ClipMenuHide;
    case hover.ItemType of
        IT_PERMANENT:
            begin
                fim.SetPermanentClipMode;
                fim.SetPermanentClip(hover.fPermanentGroupID, hover.fPermanentID);
                fim.SetACPopupItem(hover);
                ShowIt;
            end;
        IT_POPUPCLIP,
        IT_TEMP,
        IT_CLIPBOARD,
        IT_PINNED:
            begin
                fim.SetPopupClipMode;
                fim.SetACPopupItem(hover);
                fim.SetPopupClip(Hover.Clip);
                ShowIt;
            end;
    else
        begin
        end;
    end;

end;


{Popuplate Menu}

procedure TACPopupPrototype.RebuildPopup(AutoPopulate : boolean=true);
begin
    if AutoPopulate then begin
        self.AutoPopulate;
    end;
    self.CalcTotalSize;
    self.Invalidate;
end;
procedure TACPopupPrototype.DetectKeystroke(p: TACPopupItem);
var s : string;
	c : char;
    i : integer;
begin
    // detect non-literal '&' accelerators

    s := p.Prefix + p.Caption;
    s := StringReplace(s,'&&','',[rfReplaceAll]);
    i := Pos('&', s);
    if i <> 0 then begin
        c := s[i+1];
        c := upcase(c);
        p.fcaption := StringReplace(p.fcaption, '&'+c,'&'+c,[rfIgnoreCase]);
        fKeystrokes.AddObject(c, p);
    end;
end;
function TACPopupPrototype.GetAcceleratorPopupClips(i: integer) : Char;
begin
    if FrmConfig.cbPopupCharLimit.Checked then begin
        Result := self.GetAccelerator(
            i - (fAcceleratorCount+fReservedCount)
        );
    end else begin
        if FrmConfig.cbPinnedShortcuts.checked then begin
            Result := self.GetAccelerator(
                i - (ClipQueue.GetQueueSize+PinnedClipQueue.GetQueueCount+fReservedCount)
            );
        end else begin
            Result := self.GetAccelerator(
                i - (ClipQueue.GetQueueSize+fReservedCount)
            );
        end;
    end;
end;
function TACPopupPrototype.GetAccelerator(i: integer): char;
{ const
 	other : array[37..46] of char = (
        '-', '=', '[', ']', '\', ';', '''', ',', '.', '/' );}
var other : string;
	alphanumeric : string;
begin
    result := ' ';
    inc(i, fAcceleratorCount+fReservedCount);
    if (i<=35) then begin
        alphanumeric := frmconfig.GetAccelAlphaNumeric;
    	result := alphanumeric[i+1];
    end else begin
    	other := FrmConfig.GetAccelSymbols;
        if (i-35) < length(other) then begin {exclude the last character}
        	result := other[i-35]; {start with 1 as an index}
        end;
    end;
end;
procedure TACPopupPrototype.CheckForAutoExpand(p : TACPopupItem);
begin
    if p.ItemType = fAutoExpandOnce then begin
        p.Expanded := true;
    end;
end;

procedure TACPopupPrototype.SaveExpandedState;
var i : integer;
begin
    fLastExpandedSet := [];

    for i := 0 to self.fItems.fSubMenu.count - 1 do begin
        with fItems.fSubMenu.Items[i] as TACPopupItem do begin
            if IsExpandable and Expanded then begin
                fLastExpandedSet := fLastExpandedSet + [ItemType];
            end;
        end;
    end;
end;
procedure TACPopupPrototype.LoadExpandedState;
var i : Integer;
begin
    for i := (self.fItems.fSubMenu.count - 1) downto 0 do begin
        with fItems.fSubMenu.Items[i] as TACPopupItem do begin
            if (IsExpandable) and (ItemType in fLastExpandedSet) then begin
                Expanded := true;
            end;
        end;
    end;
end;

function TACPopupPrototype.AddBreak: TACPopupItem;
begin
    result := fItems.AddBreak;
end;
function TACPopupPrototype.AddLine: TACPopupItem;
begin
//    result := fitems.AddLine;
    AddLineToNext := true;
end;
procedure TACPopupPrototype.Clear;
begin
    fitems.fsubmenu.Clear;
    self.fPasteFiles := nil;
end;



{utility routines}
function TACPopupPrototype.IsLegalDrop(p: TACPopupItem): boolean;
begin
	result := false;

	if p = nil then EXIT;
    if fDragMenuItem = nil then EXIT;
	if p = fDragMenuItem then EXIT;

    result := true;
end;
function TACPopupPrototype.GetItemAt(x, y: integer): TACPopupItem;
var i : integer;
    p : TACPopupItem;

    function CheckSubmenus(p : TACPopupItem) : TACPopupItem;
    var i : integer;
        sub : TACPopupItem;
    begin
        result := nil;
        if p = nil then EXIT;

        if (p.fSubShowing <> nil) then begin
            // check nested submenu first
            result := CheckSubmenus(p.fSubShowing);
            if result <> nil then EXIT;
        end;
        for i := 0 to p.fsubmenu.count-1 do begin
            sub := p.fSubMenu[i];

            if (x >= sub.fLeft) and (x <= sub.fRight) then begin
                if (y <= sub.fBottom) and (y >= sub.fTop) then begin
                    result := sub;
                    EXIT;
                end;
            end;
        end;
    end;
begin
    // check submenus first
    result := CheckSubmenus(fitems.fSubShowing);
    if result <> nil then EXIT;

    for i := 0 to fitems.fsubmenu.count-1 do begin
        p := fitems.fsubmenu.Items[i];
        {same column}
        if (x >= p.fLeft) and (x <= p.fRight) then begin
            if (y <= p.fBottom) then begin
            	if p.isbreak then EXIT;

                result := p;
                EXIT;
            end;
        end;
    end;
end;
function TACPopupPrototype.MouseInPopup : boolean;
var r : TRect;
begin
    r := Rect(self.left, self.Top,self.Left+self.Width,self.Top+self.Height);

    result := PtInRect(r, mouse.CursorPos);
    if not result then begin
        if fitems.fSubShowing <> nil then begin
            r := Rect(
                fitems.fSubShowing.Left,fitems.fSubShowing.Top,
                fitems.fSubShowing.right, fitems.fSubShowing.bottom);
            result := PtInRect(r, mouse.CursorPos);
        end;
    end;
end;
procedure TACPopupPrototype.AssignSubmenuShortcuts(p : TACPopupItem);
var i,j : integer;
begin
    if self.fKeyActivated and fShowExpandedShortcuts then begin
        if p.IsSubmenu or p.IsExpandable then begin
            self.fShowExpandedType := p.ItemType;
            j := 0;
            fExpandedKeystrokes.Clear;
            for i := 0 to p.fSubMenu.Count - 1 do begin
                with p.fSubMenu.Items[i] do begin
                    if not IsLine and not IsGap then begin
                        Prefix := '&' +self.GetAcceleratorPopupClips(j);
                        fExpandedKeystrokes.AddObject(Prefix[2], p.fSubMenu.Items[i]);
                        Inc(j);
                    end;
                end;
            end;
        end;
    end else begin
        if p.IsSubmenu or p.IsExpandable then begin
            for i := 0 to p.fSubMenu.Count - 1 do begin
                with p.fSubMenu.Items[i] do begin
                    if not IsLine and not IsGap then begin
                        Prefix := '';
                    end;
                end;
            end;
        end;
    end;
end;
procedure TACPopupPrototype.SetShowExpandedShortcuts(value : Boolean);
begin
    fShowExpandedShortcuts := value;
end;
procedure TACPopupPrototype.SetHoverUnderMouse;
var pt : TPoint;
    ac : TACPopupItem;
begin
    Application.ProcessMessages;
    pt := ScreenToClient(mouse.CursorPos);
    ac := self.GetItemAt(pt.X,pt.y);
    SetHover(ac, false);
end;
function TACPopupPrototype.UseKeyboard : boolean;
begin
    result := frmconfig.cbUseKeyboard.Checked and (FrmMainPopup.GetNeedsFocus);
end;

procedure TACPopupPrototype.SetFormMode(value : boolean);
begin
    if value then begin
        FormMode := pdmFormMode
    end else begin
        FormMode := pdmAutoHide
    end;
end;
function TACPopupPrototype.GetFormMode : boolean;
begin
    result := FormMode = pdmFormMode;
end;

{Drawing Routines}
procedure TACPopupPrototype.SetCanvas(c: TCanvas);
begin
    fNewCanvas := c;
end;
function TACPopupPrototype.GetCanvas: TCanvas;
begin
    //result := pnlMain.Canvas;
    if fNewCanvas = nil then begin
    	result := self.Canvas;
    end else begin
        result := fNewCanvas;
    end;
end;
function TACPopupPrototype.CalcHeight(fpi: TACPopupItem): integer;
var i : integer;
    s : string;
    tempr : TRect;
begin
    result := max(
        UseCanvas.TextHeight('AZW'),
        frmconfig.udMinHeight.Position
    );

    if fpi.SmallCaption then begin
        i := UseCanvas.Font.Size;
        UseCanvas.Font.Size := i-1;

        result := UseCanvas.TextHeight('AZW');

        UseCanvas.Font.Size := i;
    end;
    if fpi.DoubleHeight then begin
        s := 'AZ'#13#10'AZ';
        DrawTextW(UseCanvas.Handle, pwidechar(s), length(s),
            tempr, DT_CALCRECT);
        result := max(result,tempr.Bottom-tempr.Top)
    end;

    if fpi.SeparatorLine then inc(result,LINE_HEIGHT);
end;
function TACPopupPrototype.CalcWidth(fpi: TACPopupItem; ClipIt : boolean=true): integer;
var
    s : string;
const
    MIN_WIDTH = 120;
begin
    result := LEFT_BORDER + LEFT_SPACE +LEFT_EDGE + fpi.DesiredWidth(UseCanvas) +RIGHT_BORDER;

    if fpi.IsExpandable or fpi.IsSubmenu then begin
        inc(result, RIGHT_SPACE);
    end;

    if ClipIt then begin
    	result := min(result, self.fMaxItemWidth);
    end;
    result := max(MIN_WIDTH, result);
end;
procedure TACPopupPrototype.CalcTotalSize(FixSubmenu:boolean=false);
    function CalcRect(p : TACPopupItem; top,left : integer) : TRect;
    const GAP_SIZE = 20;
    var wd,ht,i,col, totalwd, maxht, originaltop : integer;
        sub : TACPopupItem;
        r : TRect;
        pop : TACPopupItem;
        procedure TallyColumn;
        begin
            FrmDebug.AppendLog('New Column');
            inc(totalwd, wd);
            p.fColWidth[col] := wd;
            wd := 0;
            inc(col);
            ht := 0;
        end;
        procedure CalcItem(sub : TACPopupItem);
        var
            twd, itemht : integer;
            drawablePic : boolean;
            IsPic : boolean;
            isWide : boolean;
        begin
           if sub.isBreak then begin
                sub.ftop := top+ht + TOP_BORDER;
                sub.fBottom := sub.fTop;
                sub.fleft := left + totalwd;
                sub.fMyColumn := col;
                TallyColumn;
            end else begin
                sub.ftop := top+ht + TOP_BORDER;
                if sub.IsLine then begin
                    ht := ht + fSpacing + 5;
                end else begin
                	twd := CalcWidth(sub, false);
                	wd := max(wd, min(self.fMaxItemWidth,twd));
                    IsPic := (sub.Clip <> nil) and
                        (sub.Clip.GetFormatType = FT_PICTURE);
                    drawablePic := IsPic and
                        (FrmConfig.cbNoThumbnails.Checked=false);

                    isWide := ((twd+CAPTION_LEFT) > trunc(fMaxItemWidth*1.3));
                	if (sub.ItemType in TDoubleSized) and
                    	(drawablePic or ((not IsPic) and frmConfig.cbDoubleHeight.checked and isWide)) then begin
                        sub.DoubleHeight := true;
//                        itemht :=  (CalcHeight(sub)*2-fspacing*2);
                        itemht :=  CalcHeight(sub) + 2;
//                        if itemht >= (frmconfig.udMinHeight.Position * 2) then begin
//                            inc(itemht,2);
//                        end;

                    end else begin
                        sub.DoubleHeight := false;
                    	itemht := CalcHeight(sub); //adding spacing screws up the aesthetics

                    end;

                    if (sub.DoubleHeight) then begin
                        if (sub.Clip.GetFormatType = FT_PICTURE) and
                            (sub.Clip.GetPicHeight < itemht)then begin
                            sub.DoubleHeight := false;
                            itemht := CalcHeight(sub); //adding spacing screws up the aesthetics
                        end;
                    end;
                    inc(ht, itemht);
                    if sub.Expanded then begin
                        inc(ht, 4); {expanded items are taller}
                    end;
                end;
                sub.fBottom := top+ht + TOP_BORDER;
                sub.fleft := left + totalwd;
                sub.fMyColumn := col;
            end;
            maxht := max(ht, maxht);
            inc(ht); // otherwise the next "top" will be the exact same as the previous bottom
        end;

    begin
        wd := 0;
        ht := 0;
        originaltop := top;
        col := 0;
        totalwd := 0; maxht := 0;
        p.fColWidth[col] := 0;

        for i := 0 to p.fSubMenu.count - 1 do begin
            sub := p.fSubMenu.Items[i];
            CalcItem(sub);
        end;

        TallyColumn;
        result.top := originaltop;
        result.Left := left;
        result.Bottom := originaltop + maxht + TOP_BORDER+BOTTOM_BORDER + 1;
        result.Right := left + (totalwd);
        p.fMaxHeight := maxht;

        if top=0 then begin
            fMainRect.Top := result.Top;
            fMainRect.left := result.Left;
            fMainRect.Right := result.Right;
            fMainRect.bottom := result.bottom;
        end;

        {no regions, no shadows}
       	if CheckWin32Version(6, 0) then
        if region1 = 0 then begin
            region1 := Windows.CreateRectRgnIndirect(result);
        end else begin
            region2 := Windows.CreateRectRgnIndirect(result);
            windows.CombineRgn(region1,region1,region2, RGN_OR);
            Windows.DeleteObject(region2);
        end;



        if p.fSubShowing <> nil then begin
            {lower the menu so the mouse won't hover it}
            if FixSubmenu then begin
                if fTopFixed and ((p.fSubShowing.fMaxHeight+p.fSubShowing.top)>fitems.fMaxHeight) then begin
                	{move the submenu up to be even with the bottom of the main popup}
                    {this prevents a recursvise shift-newhover loop}
                    r := CalcRect(p.fSubShowing,
                    	max(0,fitems.fMaxHeight - (p.fSubShowing.fMaxHeight+fspacing)),
                        //fitems.fMaxHeight - (p.fSubShowing.fMaxHeight+fspacing),
                        p.fsubshowing.right+1
                    );
                end else begin
                    if (p.fSubShowing.fSubMenu.Count <> 0) and
                        (not p.fSubShowing.fSubMenu.Items[0].isGap) then begin
                        pop := p.fSubShowing.add;
                        pop.SetIsGap(true);
                        p.fSubShowing.fSubMenu.Move(p.fSubShowing.fSubMenu.Count-1, 0);
                    end;

                    r := CalcRect(p.fSubShowing, p.fSubShowing.fTop, p.fSubShowing.right+1);
                end;
            end else begin
                r := CalcRect(p.fSubShowing,p.fSubShowing.ftop, p.fSubShowing.right+1);
            end;

            inc(r.Bottom);
            inc(r.Right);
            result := System.Types.UnionRect(result, r);
            dec(r.Right);
            dec(r.Bottom);
        end;
    end;
var r : TRect;

    p : TACPopupItem;
    i : integer;
    procedure FixEmptySpace(sub : TACPopupItem);
    var sub2 : TACPopupItem;
    begin
        if (top+p.fmaxheight+1) - sub.fBottom > BOTTOM_BORDER then begin
            sub2 := TACPopupItem.create;
            sub2.ftop := sub.fbottom;
            sub2.fleft := sub.fleft;
            sub2.fRight := sub.fRight;
            sub2.fMyColumn := sub.fMyColumn;
            sub2.fParent := sub.fParent;
            sub2.fBottom := top+p.fmaxheight+2;
            sub2.IsBreak := true;
            sub2.ItemType := IT_POPUPCLIP;
            dec(sub2.fBottom);

            r.top := sub2.ftop;
            r.left := sub2.fleft;
            r.Right := sub2.fRight;
            r.Bottom := sub2.Bottom;
            usecanvas.Brush.color := fBackgroundColor;
            inc(r.bottom);
            UseCanvas.FillRect(r);
            dec(r.bottom);

            self.DrawItem(sub2);
        end;
    end;
begin
    FrmDebug.AppendLog('calcsize start');
    region1 := 0;
    r := CalcRect(fitems, 0, 0);

    self.Width := r.Right;
    self.Height := r.Bottom;
   	if CheckWin32Version(6, 0) then
		Windows.SetWindowRgn(self.Handle,region1,false);

    FrmDebug.AppendLog('Find the last visible item');
    i := fitems.fSubMenu.count-1;
    if i >= 0 then begin
        repeat
            p := fitems.fSubMenu.GetItem(i);
            dec(i);
        until not p.IsBreak or (i=0);
    end;
    fLastVisible := p;
//    FixEmptySpace;

    {Windows.DeleteObject(region1);} // Windows owns this handle now
    self.EnsureVisibility(FixSubmenu);
    FrmDebug.AppendLog('calcsize end');
end;
procedure TACPopupPrototype.EnsureVisibility(FixSubmenu:boolean=false);
var x,y : integer;
	m : TMonitor;
    expandedset : set of TItemType;
begin
    {Fudge it up or left to keep it on the screen}
    x := fpoint.X;
    y := fpoint.y;


    fTopFixed := false;
    fLeftFixed := false;
    if (x + self.Width > screen.DesktopRect.right) then begin
        x := x - ((x+self.width+fspacing) - screen.desktoprect.right);
        fLeftFixed := true;
    end;

    // try turning on Clip Sets before altering the top position, if it's too tall
    // - make sure any previously expanded menus are re-expanded

    expandedset := [];
    if not self.fUseGrouping and (self.Height > screen.DesktopRect.Bottom) then begin
        if FrmConfig.cbEnableClipsSetsWhenTall.Checked then begin
            if (ClipQueue.GetQueueCount > FrmConfig.udClipsPerSet.Position) then begin
                self.SaveExpandedState;
                    Self.fUseGroupingOnce := True;
                    self.Clear;
                    self.AutoPopulate;
                self.LoadExpandedState;

                self.CalcTotalSize(FixSubmenu);
                Self.Invalidate;
            end;
        end;
    end;

    if (y + self.Height > screen.DesktopRect.Bottom) then begin
        if fTopOffsetEnable then begin
            inc(y, fTopOffset);
        end else begin
            y := y - ((y+self.height+fspacing) - screen.desktoprect.bottom);
        end;
        fTopFixed := true;
        fIsTooTall := true;
    end;

    {update for mismatched monitor resolutions}
    m := screen.MonitorFromWindow(self.Handle);
    if (m <> nil) then begin
        if (y+self.Height) > m.BoundsRect.Bottom then begin
            //y := y - (m.BoundsRect.Bottom- (y+self.Height));
            fIsTooTall := true;
        end;
    end;



    {Recursive Call to fix visibility problems caused by submenus}
    if not FixSubmenu then begin
    	{Detect a submenu and a position change}
		FixSubmenu := fitems.fSubShowing <> nil;
        if FixSubmenu and (fLeftFixed or fTopFixed) then begin
            self.CalcTotalSize(FixSubmenu);
        end else begin
        	fIgnoreMouseMove := true;
            timIgnoreMouseMove.Enabled := true;
            self.Left := x;
            self.Top := y;
        end;
    end else begin
    	{Override the popup point until the popup is closed}
        fIgnoreMouseMove := true;
        timIgnoreMouseMove.Enabled := true;
        self.Left := x;
        self.Top := y;
        fpoint.x := x; {neither option is great, but this is the lesser evil}
       // fpoint.y := y; {this causes a shift due to a side submenu to stay after}
                        {the submenu closes}
    end;
end;
procedure TACPopupPrototype.DrawCheckgroup(p: TACPopupItem);
var i : integer;
begin
    for i := 0 to p.fParent.fCheckgroup.count  - 1 do begin
        DrawItem( TACPopupItem(p.fParent.fCheckgroup[i]));
    end;
end;
procedure TACPopupPrototype.DrawDragmark;
var
	pa : Array of TPoint;
    r : TRect;
const wd = 7;
begin
	with UseCanvas do begin
        brush.Color := clActiveCaption;
        pen.color := fFontColor;
        r := fmainrect;
        InflateRect(r,-1,-1);
        setlength(pa,3);
        pa[0] := point(r.Right-wd,r.bottom);
        pa[1] := point(r.Right, r.bottom-wd);
        pa[2] := point(r.Right, r.Bottom);
        polygon(pa);
    end;
end;

procedure TACPopupPrototype.DrawItem(p: TACPopupItem);
var r : Trect;
    wc : TWideChar;
    s : string;
    len: integer;
    c : TColor;

    mainr : TRect;
    sd : TScrollDirection;
    prefixwidth : integer;
    clipboardleft : integer;
    programname : string;
const
    BLEND_CLICKED = 97;
    BLEND_CLICKED_ORIGINAL = 99;
    DESATURATE_PERCENT = 60;

    function CaptionLeft : integer;
    begin
        if (p.ItemType = IT_POPUPCLIP) and (FrmConfig.GetIconType = CBXICONTYPE_NONE) then begin
            result := mainr.left + LEFT_EDGE-1;
        end else begin
            result := mainr.left + LEFT_SPACE+LEFT_EDGE-1;
        end;
    end;
    procedure MyFillRect(r : TRect);
    begin
        inc(r.bottom);
        inc(r.Right);
        UseCanvas.FillRect(r);
    end;
    procedure MyGradientFill(c1, c2 : TColor; r : TRect; d : TGradientDirection);
    begin
        inc(r.Bottom);
        inc(r.Right);
        GraphUtil.GradientFillCanvas(UseCanvas,c1,c2,r,d);
    end;
    procedure VerticalLines;
    begin
//        if (p.ItemType = IT_POPUPCLIP) and (FrmConfig.GetIconType = CBXICONTYPE_NONE) then EXIT;
        // outside boundary line
        // reserve this space
        CopyRect(r,mainr);
        inc(r.Bottom);
        UseCanvas.pen.Color := fBorderColor;
        UseCanvas.MoveTo(r.Left,r.top);
        UseCanvas.LineTo(r.left,r.bottom+1);
        inc(r.Left);
        UseCanvas.pen.Color := dimColor(fBackgroundColor,1.02);
        UseCanvas.MoveTo(r.Left,r.top);
        UseCanvas.LineTo(r.left,r.bottom+1);

        {reserve this space}
        inc(mainr.Left);
    end;
    procedure LeftIconBackground(nohover : boolean=false);
        function ClickableHoveredIcon : boolean;
        begin
            result := (not nohover) and(hover = p) and
                (p.ItemType in TClickableLeftIcons) and p.fHasLeftIcon;
        end;
    var r : trect;
    begin
        {icon column}
        CopyRect(r,mainr);
        r.Right := CaptionLeft;
        UseCanvas.brush.Style := bsSolid;
        UseCanvas.Brush.Color := fColumnColor;
        if p.IsInExpandedMenu then begin
            UseCanvas.Brush.Color := fExpandedBackgroundColor;
        end;
        myFillRect(r);

        if ClickableHoveredIcon and not p.IsExpandable then begin
            UseCanvas.Brush.Color := Blend(UseCanvas.Brush.Color,fFontColor,93);
        end;
        dec(r.right,1);
        dec(r.Bottom);
        MyFillRect(r);

        {focus rectangle}
        if ClickableHoveredIcon then begin
            if FLastPosition = pipLeftIcon then begin
                UseCanvas.Pen.Color := fFontColor;
                UseCanvas.Pen.style := psDot;
                UseCanvas.Rectangle(r);
                UseCanvas.Pen.style := psSolid;
            end else begin
                UseCanvas.Pen.Color := blend(UseCanvas.Brush.Color,clWhite, 70);
                UseCanvas.MoveTo(r.Left, r.top);
                UseCanvas.LineTo(r.Right, r.top);

                UseCanvas.Pen.Color := blend(UseCanvas.Brush.Color,clBlack, 75);
                UseCanvas.MoveTo(r.Left, r.bottom+1);
                UseCanvas.LineTo(r.Right, r.bottom+1);
            end;
        end;
    end;
    procedure CaptionBackground(forceplain : boolean=false);
        procedure Fill(r : TRect);
        var b : boolean;
            c, c1,c2 : TColor;
            procedure BaseColor;
            begin
                c := UseCanvas.Brush.Color;
                UseCanvas.Brush.Color := DimColorOrReverse(c, 0.98);
                fbackgroundBase := UseCanvas.Brush.Color;
                MyFillRect(r);
            end;
            procedure BottomColor;
            begin
                Inc(r.Top,(r.Bottom-r.Top) div 2);
                c1 := UseCanvas.Brush.Color;
                c2 :=  DimColorOrReverse(UseCanvas.Brush.Color, 0.96);
                GraphUtil.GradientFillCanvas(UseCanvas,c1,c2,r,gdVertical);
                if p.Index <> (p.fParent.fSubMenu.Count-1) then begin
                    with UseCanvas do begin
                        pen.Color := DimColorOrReverse(c2, 0.94);
                        MoveTo(r.Left+(fspacing+5), r.bottom-1);
                        LineTo(r.right-(fspacing+5), r.bottom-1);
                    end;
                end;
            end;
        begin
            b := false;

            if (frmConfig.cbDoubleHeight.checked) and
                not ((p.fClip <> nil)and(p.fClip.CData.Clicked)) then begin
                if (p.fclip <> nil) and (p.ItemType = IT_POPUPCLIP) and (p.fclip.GetFormatType <> FT_PICTURE) and
                    p.DoubleHeight then begin
                    BaseColor;
                    BottomColor;
                end else begin
                    MyFillRect(r);
                end;
            end else begin
                MyFillRect(r);
            end;

        end;
    var c1, c2 : TColor;
        liner : TRect;
    begin
        CopyRect(r,mainr);
        r.Left := CaptionLeft;

        UseCanvas.Brush.Style := bsSolid;
        UseCanvas.brush.Color := fBackgroundColor;
        MyFillRect(r);
        fbackgroundBase := 0;

        if forceplain then begin
            fBackgroundBase := UseCanvas.Brush.Color;
            p.DrawCaptionBackground(self,usecanvas,r);
            EXIT;
        end;

        if p.IsExpandable then begin
            if p.Expanded then begin
                fbackgroundBase := dimColor(fColumnColor, 0.95);
                fbackgroundBase := Blend(fbackgroundBase, clGray, 97);
            end else begin
                fbackgroundBase := dimcolor(fColumnColor,1.02);
            end;
        end else begin
            fbackgroundBase := fBackgroundColor;
        end;

        if p.IsExpandable then begin
            if p.Expanded then begin
                c1 := fBackgroundBase;
                c2 := Blend(c1, clBlack, 90);

                UseCanvas.brush.Color := c1;
                MyFillRect(r);

                copyrect(liner, r);
                liner.Left := liner.right - RIGHT_MENU_GRADIENT_WIDTH;
                MyGradientFill(c1,c2,liner,gdHorizontal);
            end else begin
                c1 := fBackgroundBase;
                UseCanvas.brush.Color := c1;
                MyFillRect(r);

                c2 := Blend(c1, clBlack, 90);
                copyrect(liner, r);
                liner.Left := liner.right - RIGHT_MENU_GRADIENT_WIDTH;
                MyGradientFill(c1,c2,liner,gdHorizontal);

                // box light
                UseCanvas.Pen.Color := blend(fBackgroundColor,clWhite, 80);
                UseCanvas.MoveTo(r.Left, r.top);
                UseCanvas.LineTo(r.Right, r.top);
                UseCanvas.MoveTo(r.Left, r.top);
                UseCanvas.LineTo(r.Left, r.bottom);

                UseCanvas.Pen.Color := blend(fBackgroundColor,clBlack, 90);
                UseCanvas.MoveTo(r.Left, r.bottom);
                UseCanvas.LineTo(r.Right, r.bottom);
                UseCanvas.MoveTo(r.Right-1, r.top);
                UseCanvas.LineTo(r.Right-1, r.bottom);
            end;
        end else begin
            p.DrawCaptionBackground(self, UseCanvas, r);
        end;

        if p.BottomLine then begin
            UseCanvas.Pen.Color := blend(fFontColor, fBackgroundBase, 18);
            UseCanvas.MoveTo(r.Left+6,r.bottom-1);
            UseCanvas.LineTo(r.Right-6,r.bottom-1);
        end;
    end;
    procedure LeftColumnEdge;
    begin
//        if (p.ItemType = IT_POPUPCLIP) and (FrmConfig.GetIconType = CBXICONTYPE_NONE) then EXIT;

        CopyRect(r, mainr);
        inc(r.bottom); // off-by-one drawing
        r.Right :=  r.left + LEFT_SPACE;
        UseCanvas.pen.Color := fColumnEdgeColor;
        if p.IsInExpandedMenu then begin
            UseCanvas.pen.Color := Blend(fColumnEdgeColor, fBackgroundColor, 10);
        end;
        UseCanvas.MoveTo(r.right,r.top);
        UseCanvas.LineTo(r.right,r.bottom);
    end;
    procedure SeparatorLine;
    var y : integer;
    begin
        if p.SeparatorLine then begin
            y := r.Top + ((LINE_HEIGHT-2) div 2);
            LeftIconBackground(true);
            LeftColumnEdge;
            CaptionBackground(true);

    //        UseCanvas.Pen.Color := blend(fFontColor, fBackgroundBase, 28);
            UseCanvas.Pen.Color := blend(clwhite, fBackgroundBase, 50);
            UseCanvas.MoveTo(r.Left+6,y);
            UseCanvas.LineTo(r.Right-6,y);

    //        UseCanvas.Pen.Color := blend(fFontColor, fBackgroundBase, 10);
            UseCanvas.Pen.Color := blend(clGray, fBackgroundBase, 40);
            UseCanvas.MoveTo(r.Left+6,y+1);
            UseCanvas.LineTo(r.Right-6,y+1);

            inc(mainr.Top,LINE_HEIGHT);
        end;
    end;
    procedure DrawLine;
    begin
        {edge in between the rows}
        Copyrect(r, mainr);
        dec(r.Right);
        r.Left := CaptionLeft;
        r.Top := p.fTop + fSpacing+1;
        r.Bottom := r.top+1;
        UseCanvas.Brush.Color := 0;
        UseCanvas.pen.Color := dimColor(fBackgroundColor,0.95);
        UseCanvas.MoveTo(r.Left, r.top);
        UseCanvas.LineTo(r.Right, r.top);
        UseCanvas.pen.Color := dimColor(fBackgroundColor,1.10);
        UseCanvas.MoveTo(r.Left, r.Bottom);
        UseCanvas.LineTo(r.Right, r.bottom);
    end;
    procedure DrawHoverHilite;
    var startc : TColor;
        back : TColor;
    begin
        // Since it's only called once, there's no need to optimized the
        // colors

        copyrect(r,mainr);
        r.Left := CaptionLeft;
        dec(r.right, RIGHT_BORDER-1);

        back := fBackgroundColor;
        if p.IsInExpandedMenu then begin
            back := DimColorOrReverse(fBackgroundColor, 1.04);
        end;
        back := unitMisc.Blend(back, fHighlightColor, 90);


        {focus rectangle}
        if (p.ItemType in TPastesOnClickj) then begin
            c := fHighlightColor;
            c := Blend(c, fFontColor, 80);
            UseCanvas.pen.Color := c;
            UseCanvas.RoundRect(
                r.left,r.top,r.Right,r.bottom,
                2,2
            );
        end;

        {inner gradient}
        inc(r.Top);
        inc(r.left);
        if (p.ItemType in TPastesOnClickj) then begin
            dec(r.right);
        end;
        dec(r.bottom);
        if (p.fClip <> nil) and
            (p.fclip.CData.Hash = CurrentClipboard.CData.hash) and
            (p.ItemType = IT_POPUPCLIP) then begin

            startc := dimcolor(fBackgroundBase,0.92);
            c := UnitMisc.Blend(startc,fHighlightColor,65); // was 85
        end else begin
            startc := dimcolor(fBackgroundBase,0.98);
            c := UnitMisc.Blend(startc,fHighlightColor,40); // was 85
        end;

        GraphUtil.GradientFillCanvas(
            UseCanvas,startc,c,
            r,gdVertical
        );
        inc(r.Bottom);
        dec(r.Top);
        dec(r.Left);

    end;
    procedure LeftIcon;
    var ht : integer;
        wd : integer;

        doicon : boolean;
        procedure DrawBox(checked : boolean);
        var
            center, chevronwd, chevronht : integer;
        begin
            copyrect(r,mainr);

            r.right := r.left+LEFT_SPACE;
            center := (r.Right+r.left) div 2;
            chevronwd := 14;
            chevronht := 14;
            inc(r.top, ((r.Bottom-r.Top) - chevronht) div 2);
            r.bottom := r.top + chevronht;
            r.left := (center - chevronwd div 2);
            r.Right := (center + chevronwd div 2);
            inc(r.right);

            UseCanvas.brush.Color := dimColor(fBackgroundColor,1.01);
            UseCanvas.Brush.Style := bsSolid;
            UseCanvas.pen.Color := saturate(clActiveCaption, 0.10);
            UseCanvas.Rectangle(r);

            UseCanvas.pen.Color := clBtnText;
            UseCanvas.Brush.Style := bsSolid;
            inc(r.Top, chevronht div 2);
            inc(r.Left, chevronwd div 2 - 3);
            if checked then begin
                GraphUtil.DrawCheck(UseCanvas,point(r.left,r.top),2);
            end;
        end;
        procedure DrawHIcon(wd,ht : integer; opacity:byte=255);
        var
            BlendFunc: TBlendFunction;
            clr : TColor;
        begin
            if (opacity=0) and not (p=hover) then EXIT;

            if (opacity=255) or (p=hover) then begin
                DrawIconEx(UseCanvas.handle,
                    r.left, r.top,
                    p.ficon, wd,ht, 0, 0, DI_NORMAL);
            end else begin
                if (p.fIconBitmap = nil) then begin
                    p.fIconBitmap := TBitmap.Create;
                    p.fIconBitmap.PixelFormat := pf24bit;
                    p.fIconBitmap.Width := 16;
                    p.fIconBitmap.Height := 16;
                    p.fIconBitmap.canvas.Brush.Color := fColumnColor;
                    if p.IsInExpandedMenu then begin
                        p.fIconBitmap.canvas.Brush.Color := fExpandedBackgroundColor;
                    end;
                    p.fIconBitmap.Canvas.FillRect(p.fIconBitmap.Canvas.ClipRect);

                    DrawIconEx(p.fIconBitmap.Canvas.Handle,
                        0, 0,
                        p.ficon, wd,ht, 0, 0, DI_NORMAL);

                    UnitMisc.desaturate(p.fIconBitmap, DESATURATE_PERCENT, p.fIconBitmap.canvas.Brush.Color);

                    BlendFunc.BlendOp := AC_SRC_OVER;
                    BlendFunc.BlendFlags := 0;
                    BlendFunc.SourceConstantAlpha := opacity;
//                    BlendFunc.SourceConstantAlpha := 255;
                    BlendFunc.AlphaFormat := 0;
                    Windows.AlphaBlend(UseCanvas.Handle, r.left,r.top, 16,16, p.fIconBitmap.Canvas.Handle,
                        0,0, 16,16, BlendFunc);

                    p.fIconBitmap.Canvas.CopyRect(rect(0,0,16,16),UseCanvas, rect(r.Left,r.Top,r.Left+16,r.Top+16));
                end else begin
                    UseCanvas.Draw(r.Left,r.Top, p.fIconBitmap);
                end;
            end;
        end;
        procedure DrawBitmap(x,y,wd,ht : integer; opacity:byte=255);
        var
            BlendFunc: TBlendFunction;
            clr : TColor;
        begin
            if (opacity=0) and not (p=hover) then EXIT;

            if (opacity=255) or (p=hover) then begin
                UseCanvas.StretchDraw(rect(x,y,x+wd,y+ht), p.fLeftBitmap);
            end else begin
                if (p.fIconBitmap = nil) then begin
                    p.fIconBitmap := TBitmap.Create;
                    p.fIconBitmap.PixelFormat := pf24bit;
                    p.fIconBitmap.Width := 16;
                    p.fIconBitmap.Height := 16;
                    p.fIconBitmap.canvas.Brush.Color := fColumnColor;
                    if p.IsInExpandedMenu then begin
                        p.fIconBitmap.canvas.Brush.Color := fExpandedBackgroundColor;
                    end;
                    p.fIconBitmap.Canvas.FillRect(p.fIconBitmap.Canvas.ClipRect);

                    p.fIconBitmap.Canvas.Draw(0,0,p.fLeftBitmap);

                    UnitMisc.desaturate(p.fIconBitmap, DESATURATE_PERCENT, p.fIconBitmap.canvas.Brush.Color);

                    BlendFunc.BlendOp := AC_SRC_OVER;
                    BlendFunc.BlendFlags := 0;
                    BlendFunc.SourceConstantAlpha := opacity;
//                    BlendFunc.SourceConstantAlpha := 255;
                    BlendFunc.AlphaFormat := 0;
                    Windows.AlphaBlend(UseCanvas.Handle, r.left,r.top, 16,16, p.fIconBitmap.Canvas.Handle,
                        0,0, 16,16, BlendFunc);

                    p.fIconBitmap.Canvas.CopyRect(rect(0,0,16,16),UseCanvas, rect(r.Left,r.Top,r.Left+16,r.Top+16));
                end else begin
                    UseCanvas.Draw(r.Left,r.Top, p.fIconBitmap);
                end;
            end;
        end;
    begin
        if (p.ItemType = IT_POPUPCLIP) and (FrmConfig.GetIconType = CBXICONTYPE_NONE) then EXIT;
        copyrect(r,mainr);
        r.right := r.left + left_space;

        case p.Style of
        psNormal, psExpandable, psSubmenu : begin
            doicon := false;
            if not (p.fLeftIconOnlyOnHover or p.fLeftIconOnExpanded) then begin
                doicon := true;
            end;
            if p.fLeftIconOnlyOnHover and (p = Hover) then begin
                doicon := true;
            end;
            if p.fLeftIconOnExpanded and (p.Expanded = true) then begin
                doicon := true;
            end;
            if doicon then begin
                wd := r.Right-r.left;
                ht := r.bottom-r.top;
                if ((p.ItemType = IT_PINNED) or (p.fHasCliptypeIcon)) and
                    not ((p=hover) and (FLastPosition=pipLeftIcon)) then begin
                    dec(r.Left, 2);
                end;
                if (hover=p) and (p.ItemType in TContainsAClip) and (self.FLastPosition = pipLeftIcon) then begin
                    // Edit Icon Hover
                    if (ht > 18)  then begin
                        {center it vertically}
                        r.Top := r.top + (ht - 16) div 2;
                        r.Left := r.left + (wd - 16) div 2;
                    end else begin
                        r.Top := r.top + (ht-(ht-2)) div 2;
                        r.Left := r.left + (wd -(ht-2)) div 2;
                    end;
                    UseCanvas.Draw(r.Left,r.Top, ImgToBitmap(FrmMainPopup.ImgEdit));
                end else begin
                    if (ht > 18)  then begin
                        {center it vertically}
                        r.Top := r.top + (ht - 16) div 2;
                        r.Left := r.left + (wd - 16) div 2;
                        if p.fLeftBitmap <> nil then begin
                            r.right := r.Left + p.fLeftBitmap.Width;
                            r.bottom := r.top + p.fLeftBitmap.Height;

                            //UseCanvas.draw(r.left, r.Top, p.fLeftBitmap);
                            DrawBitmap(r.Left,r.Top,p.fLeftBitmap.Width,p.fLeftBitmap.Height,
                                p.fLeftIconOpacity);
                        end else if (p.fHasLeftIcon) and(p.ficon <> 0) then begin
                            DrawHIcon(16,16, p.fLeftIconOpacity);
                        end;
                    end else begin
                        r.Top := r.top + (ht-(ht-2)) div 2;
                        r.Left := r.left + (wd -(ht-2)) div 2;
                        {scale it to the menu height}
                        if p.fLeftBitmap <> nil then begin
                            r.right := r.Left + p.fLeftBitmap.Width;
                            r.bottom := r.top + p.fLeftBitmap.Height;
//                            UseCanvas.StretchDraw(r,p.fLeftBitmap);
                            DrawBitmap(r.Left,r.Top,p.fLeftBitmap.Width,p.fLeftBitmap.Height,
                                p.fLeftIconOpacity);
                        end else if (p.fHasLeftIcon) and(p.ficon <> 0) then begin
                            DrawHIcon(ht-2,ht-2, p.fLeftIconOpacity);
                        end;
                    end;

                    if p.ItemType = IT_PINNED then begin
                        r.Left := r.Left + LEFT_SPACE -  frmClipboardManager.iPin.Width; //8x8 icon
//                        r.Top := mainr.Bottom - frmClipboardManager.iPin.Height;
                        Inc(r.Top,4);
                        dec(r.left);
                        UseCanvas.Draw(r.Left, r.Top, FrmClipboardManager.iPin.Picture.Graphic);
                    end;
                end;
            end;
        end;
        psCheckable: begin
            if not p.IsCheckGrouped  then begin
                DrawBox(p.checked);
            end else if p.Checked then begin
                DrawBox(p.checked);
            end;
        end;
        end;
    end;
    procedure Caption;
    begin
        CopyRect(r,mainr);
        r.Left := CaptionLeft;

        case p.Style of
        psExpandable, psSubmenu:
            begin
                r.Right := r.Right - (RIGHT_SPACE+RIGHT_BORDER);
            end;
        else
            r.right := r.Right - fspacing;
        end;

        p.DrawCaption(self, UseCanvas, r, p=Hover, FLastPosition = pipLeftIcon);
    end;
    procedure CliptypeIcon;
    var center, cm : integer;
        chevronwd, chevronht, wd, ht : integer;
        bm : TBitmap;
        chev : TRect;
        pc : TColor;
    begin
        if (p.ItemType = IT_POPUPCLIP) and (FrmConfig.GetIconType = CBXICONTYPE_NONE) then EXIT;

        copyrect(r,mainr);
        UseCanvas.brush.Style := bsSolid;
        case p.Style of
        psNormal:
            begin
                if p.fHasCliptypeIcon and (frmconfig.GetIconType=CBXICONTYPE_PROGRAM) and
                    not ((hover = p) and (Self.FLastPosition = pipLeftIcon))  then begin
                    wd := r.Right-r.left;
                    ht := r.bottom-r.top;

                    UseCanvas.Brush.Color := fBackgroundColor;

                    if p.ItemType = IT_PERMANENT then begin
                        r.top := r.top + (ht-p.fCliptypeBitmap.Height) div 2;
                    end else begin
                        r.Top := r.Top + ((ht-16) div 2) + 2;
                        // same top as program icon - moved down a little
                    end;
                    r.left := mainr.Left + CAPTION_LEFT;
                    r.Left := r.Left- 2 - p.fCliptypeBitmap.Width;

                    UseCanvas.Draw(r.left, r.top, p.fCliptypeBitmap);
                end;
            end;
        end;
    end;

    procedure RightIcon;
    var center : integer;
        chevronwd, chevronht, wd : integer;
        bm : TBitmap;
        chev : TRect;
        pc : TColor;
    begin
        copyrect(r,mainr);
        r.Left := r.Right - (RIGHT_SPACE+RIGHT_BORDER);

        UseCanvas.brush.Style := bsSolid;
        case p.Style of
        psSubmenu:
            begin
                if p.Disabled then begin
                    UseCanvas.pen.Color := fDisabledColor;
                end else begin
                    UseCanvas.pen.Color := fFontColor;
                end;
                GraphUtil.DrawArrow(UseCanvas,sdRight,
                    point(r.right-fspacing*2-RIGHT_BORDER-3,(r.top+r.bottom)div 2 -4),3);
            end;
        psExpandable:
            begin
                if p.Expanded  then begin
                    sd := sdUp;
                    bm := ImgToBitmap(FrmMainPopup.ImgUp);
                end else begin
                    sd := sdDown;
                    bm := ImgToBitmap(FrmMainPopup.imgDown);
                end;

                if not ((sd=sdup) and not p.ShowCollapseIcon) then begin

                    copyrect(r,mainr);
                    dec(r.right);
                    r.left := (r.right - RIGHT_SPACE) and not 1;
                    center := (r.Right+r.left) div 2;
                    chevronwd := 14;
                    chevronht := 14;
                    inc(r.top, ((r.Bottom-r.Top) - chevronht) div 2);
                    r.bottom := r.top + chevronht;
                    r.left := (center - chevronwd div 2)+1;
                    r.Right := (center + chevronwd div 2);
                    inc(r.right,2);

                    UseCanvas.brush.Color := clNone;
                    UseCanvas.Brush.Style := bsClear;

                    UseCanvas.pen.Color := blend(fbackgroundBase, fFontColor, 80);
                    UseCanvas.Rectangle(r);

                    CopyRect(chev, r);
                    inc(chev.Top, chevronht div 2 - 1);
                    inc(chev.Left, chevronwd div 2 - 3);
                    UseCanvas.Brush.Style := bsSolid;
                    if (p = hover) or (p.Expanded) then begin
                        pc := UseCanvas.Pen.Color;
                        UseCanvas.pen.Color := clBtnText;
                        UseCanvas.Brush.Color := clBtnFace;
                        UseCanvas.FillRect(r);
                        {if p.expanded then begin
                            UseCanvas.FillRect(r);
                        end else begin
                            inc(r.Right,1);
                            inc(r.Bottom,2);
                            UseCanvas.FillRect(r);
                            DrawEdge(
                                UseCanvas.Handle,
                                r,BDR_RAISEDOUTER or EDGE_RAISED,
                                BF_RECT or BF_SOFT
                            );
                        end;}
                    end else begin
                        if p.Disabled then begin
                            UseCanvas.pen.Color := clGrayText;
                        end;
                    end;
                    GraphUtil.DrawChevron(UseCanvas,sd,point(chev.left,chev.top),3);
                end;
            end;
        end;
    end;
    procedure DrawHoverLine;
    begin
    	copyrect(r,mainr);
        inc(r.Top);
        r.Left := CaptionLeft;
        dec(r.Right, fSpacing);
    	if (fDragStarted) and (p=fDropMenuItem)  then begin
            if (fDragMenuItem.ItemType = IT_POPUPCLIP) or (p.ItemType = IT_POPUPCLIP) then begin
             	if (fDragMenuItem.ItemType = IT_POPUPCLIP) and (p.ItemType = IT_POPUPCLIP) then begin
                    UseCanvas.pen.Color := fFontColor;
                    UseCanvas.MoveTo(r.Left,r.top);
                    UseCanvas.LineTo(r.right,r.top);
                end;
            end else if (fDragMenuItem.ItemType = IT_PERMANENT) or (p.ItemType = IT_PERMANENT) then begin
             	if (fDragMenuItem.ItemType = IT_PERMANENT) and (p.ItemType = IT_PERMANENT) then begin
                    UseCanvas.pen.Color := fFontColor;
                    UseCanvas.MoveTo(r.Left,r.top);
                    UseCanvas.LineTo(r.right,r.top);
                end;
            end else begin
            	if not (p.Style = psLine) and not (p.ItemType in [IT_NONE])  then begin
                    UseCanvas.pen.Color := fFontColor;
                    UseCanvas.MoveTo(r.Left,r.top);
                    UseCanvas.LineTo(r.right,r.top);
                end;
            end;
        end;
    end;
var
    i : integer;
    clr : TColor;
begin
    p.SetBoundsRect(self.Top, self.left);

    {main item rect}
    mainr.Top := p.fTop;
    mainr.Left := p.fLeft;
    mainr.Right := p.Right;
    mainr.Bottom := p.fbottom;
    p.fRight := mainr.Right;  // TODO remember why this strange case was needed


    VerticalLines;
    SeparatorLine;

    UseCanvas.Brush.Style := bsSolid;
    UseCanvas.Brush.Color := fBackgroundColor;

    i := UseCanvas.Font.Size;
    if p.SmallCaption then begin
        UseCanvas.Font.Size := i-1;
    end;



    LeftIconBackground;
    LeftColumnEdge;
    CaptionBackground;

    if (p.IsBreak)  then begin
        {nothing needed}
    end else if (p.IsLine) then begin
        DrawLine;
    end else begin

        if (p = hover) and (not p.isGap) then begin
            DrawHoverHilite
        end;
        LeftIcon;
        CliptypeIcon;

        Caption;
        RightIcon;

    end;
    DrawHoverLine;

    if p = fLastVisible then begin
    	DrawDragmark; 
    end;

    UseCanvas.Font.Size := i;
end;
procedure TACPopupPrototype.DrawOnCanvas(fullmode : boolean=false);
begin
	self.fFullMode := fullmode;

    UseCanvas.Font := FrmConfig.GetFont;
    UseCanvas.Font.Size := FrmConfig.GetFont.Size;
    UseCanvas.Font.Style := FrmConfig.getfont.style;

    self.CalcTotalSize;
    self.Paint;
end;
procedure TACPopupPrototype.FullRedraw;
    procedure DrawMenu(p : TACPopupItem; const top,left : integer);
    var i : integer;
        sub, sub2 : TACPopupItem;
        r : TRect;
    begin
        if p.fSubMenu.Count = 0 then EXIT;

        r.top := top;
        r.Left := left;
        r.Right := p.fSubMenu[p.fSubMenu.Count-1].right+1;
        r.Bottom := p.fSubMenu[p.fSubMenu.Count-1].Bottom+1;

        usecanvas.Brush.color := fBackgroundColor;
        inc(r.Bottom,3);
        UseCanvas.FillRect(r);
        dec(r.Bottom,3);
        //UseCanvas.FillRect(UseCanvas.ClipRect);

        {top line}
        UseCanvas.pen.color := fBorderColor;
        UseCanvas.Pen.Width := 1;
        UseCanvas.MoveTo(r.left, r.top);
        UseCanvas.lineto(r.right, r.top);
        {bottom line}
        UseCanvas.pen.color := fBorderColor;
        UseCanvas.MoveTo(r.left, UseCanvas.ClipRect.Bottom-1);
        UseCanvas.lineto(r.right, UseCanvas.ClipRect.Bottom-1);
        {right line}
        UseCanvas.pen.color := fBorderColor;
        UseCanvas.MoveTo(r.right, r.top);
        UseCanvas.lineto(r.right, r.bottom);
        {left line}
//        UseCanvas.pen.color := fBorderColor;
//        UseCanvas.MoveTo(r.left, r.top);
//        UseCanvas.lineto(r.left, r.bottom);


        // draw individual items
        for i := 0 to p.fsubmenu.count - 1 do begin
            sub := p.fsubmenu.Items[i];
            if sub.IsBreak  then begin
                // handle blank space
                if r.bottom - sub.fBottom > BOTTOM_BORDER then begin
                    sub.fBottom := r.Bottom;
                    self.DrawItem(sub);
                end;
            end else begin
                self.DrawItem(sub);
            end;
        end;
        // handle blank space
        if (top+p.fmaxheight+1) - sub.fBottom > BOTTOM_BORDER then begin
            sub2 := TACPopupItem.create;
            sub2.ftop := sub.fbottom;
            sub2.fleft := sub.fleft;
            sub2.fRight := sub.fRight;
            sub2.fMyColumn := sub.fMyColumn;
            sub2.fParent := sub.fParent;
            if sub2.fParent.fParent <> nil then begin
                sub2.fParent := sub2.fParent.fParent;
            end;
            sub2.fBottom := top+p.fmaxheight+2;
            sub2.IsBreak := true;
            sub2.ItemType := IT_PERMANENT;
            dec(sub2.fBottom);

            r.top := sub2.ftop;
            r.left := sub2.fleft;
            r.Right := sub2.fRight;
            r.Bottom := sub2.Bottom;
            usecanvas.Brush.color := fBackgroundColor;
            inc(r.bottom);
            UseCanvas.FillRect(r);
            dec(r.bottom);

            self.DrawItem(sub2);
        end;

        if p.fSubShowing <> nil then begin
            DrawMenu(p.fSubShowing, p.fSubShowing.fTop, p.fSubShowing.Right+1);
        end;
    end;
begin

    drawmenu(fitems, 0,0);
    FirstPaint := true;

    DrawDragmark;


    if self.GetFormMode then begin
        SetWindowLong(self.Handle,GWL_EXSTYLE, GetWindowLong(self.handle, GWL_EXSTYLE) or WS_EX_LAYERED);
        SetLayeredWindowAttributes(self.handle,0,trunc(255 * 0.80), LWA_ALPHA);
    end else begin
		SetWindowLong(self.Handle,GWL_EXSTYLE, GetWindowLong(self.handle, GWL_EXSTYLE) and not WS_EX_LAYERED);
    end;
end;

procedure TACPopupPrototype.AddAScrollbar;
begin
   { r := self.fMainRect;
	i := GetSystemMetrics(SM_CYVTHUMB);

    self.Width := self.Width + i*2;
    inc(r.Right,i);

	scroll := CreateWindow('SCROLLBAR', nil,
    WS_CHILD or WS_VISIBLE or SBS_VERT or SBS_RIGHTALIGN,
    r.left,r.top,r.right-i,r.bottom,
    self.Handle,
     IDC_VSCROLL,
     hInstance,
     nil);

	SetScrollRange(scroll, SB_CTL, 0, self.Height, FALSE);
    }

end;

procedure TACPopupPrototype.ReserveAccel;
var c : char;
begin
	//inc(fReservedCount);
    c := self.GetAccelerator(0);
    while pos(c, fAccelCharsUsed) <> 0 do begin
        inc(fReservedCount);
    	c := self.GetAccelerator(0);
    end;
    inc(fReservedCount);
end;

{Clip Menu Routines}
function TACPopupPrototype.ClipMenuVisible : Boolean;
begin
    result := fim.Visible;
end;
procedure TACPopupPrototype.ClipMenuReportKey(key : Char);
begin
    fim.ReportKeypress(key);
end;
procedure TACPopupPrototype.ClipMenuReportKey(key : word);
begin
    fim.ReportKeypress(key);
end;
procedure TACPopupPrototype.ClipMenuHide;
begin
    if fim.showing then begin
        fim.Hide;
    end;
end;
procedure TACPopupPrototype.ClipMenuShow(rightclick : boolean = false);
begin

end;

procedure TACPopupPrototype.DeleteClipCallback(Sender: TObject);
begin
    self.RebuildPopup;
end;
procedure TACPopupPrototype.MakePermanentCallback(Sender: Tobject);
begin
    self.hide;
end;
procedure TACPopupPrototype.EditCallback(Sender: Tobject);
begin
    self.Hide;
end;
procedure TACPopupPrototype.PasteCallback(Sender: Tobject);
begin
    self.hide;
end;
procedure TACPopupPrototype.FormModeCallback(Sender : TObject);
begin
    if FormMode = pdmStayOpen then begin
        FormMode := pdmAutoHide;
    end else begin
        FormMode := pdmStayOpen;
    end;

    if (not self.UseFormMode) and FrmMainPopup.GetNeedsFocus then
            ForceForeground(self.Handle);
end;
procedure TACPopupPrototype.DestroyCallback(Sender: Tobject);
begin
    self.RebuildPopup;
end;
procedure TACPopupPrototype.HideCallback(Sender : TObject);
begin
    self.ClipMenuHide;
end;
{//User Input//}
{Mouse Events}
procedure TACPopupPrototype.MouseCursorReset;
begin
    screen.Cursor := crDefault;
end;
procedure TACPopupPrototype.CMMouseLeave(var Message: TMessage);
begin
    HideTooltip;
    FLastPosition := pipNone;
end;
procedure TACPopupPrototype.MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var p : TACPopupItem;

begin
    inherited;
    p := GetItemAt(x, y);

    if DragMouseUp(p) then EXIT;



    if p <> nil then  begin
        if (p = fMouseDownOn) then begin
            //if lastHitTest = HTCAPTION then EXIT;
            if p.Disabled  then EXIT;

            if (ssLeft in fDownShift) or (ssMiddle in fDownShift) then begin
                if (ssMiddle in fDownShift) then begin
                   p.MiddleClicked := true;
                end;
            end;

            self.fKeyActivated := false;
            HandleMouseClick(p);
        end;
    end else begin

    end;
end;
procedure TACPopupPrototype.MouseDown(Button: TMouseButton; Shift: TShiftState; X,Y: Integer);
begin
    inherited;

    timHover.Enabled := false;

    fDownShift := shift;
//    if Hover = nil then begin
//    	fMouseDownOn := GetItemAt(x,y);
//    end else begin
//    	fMouseDownOn := Hover;
//    end;
    fMouseDownOn := GetItemAt(x,y);



    self.DragMouseDown(Hover);
end;
procedure TACPopupPrototype.MouseLeave(Sender: TObject);
begin
    HideTooltip;
end;
procedure TACPopupPrototype.MouseMove(Shift: TShiftState; X, Y: Integer);
var last : TACPopupItem;
    lastpos : TPopupItemPosition;
    pt : TPoint;

    procedure ClearSubmenus(pc : TACPopupItem);
    begin
        repeat
             pc.fSubShowing := nil;
             pc := pc.fParent;
        until pc = nil;
    end;
    function IsChild(parent, pc : TACPopupItem) : boolean;
    begin

        result := false;
        if pc = nil then EXIT;

        repeat
             if Parent = pc.fparent then begin
                //result := true;
                 BREAK;
             end;

             pc := pc.fParent;
        until pc.fParent = nil;

        result := not (pc = fItems);
    end;
    function IsAutoScroll : boolean;
    var
        m : TMonitor;
    begin
        result := false;
        if (fIsTooTall) then begin
            pt := mouse.CursorPos;
            m := screen.MonitorFromPoint(pt);
            if m <> nil then begin
                pt.Y := pt.Y + m.top;
                if (pt.y = m.boundsrect.Top) or
                    (pt.y = m.BoundsRect.bottom+m.boundsrect.top-1) then begin
                    if (pt.y = m.boundsrect.Top) then begin
                        self.top := m.top;
                        fTopOffset := 0;
                    end else begin
                        fTopOffset := (self.Height - m.Height)*-1;
                    end;
                    self.Top := m.top + fTopOffset;
                    self.fTopOffsetEnable := true;
                    result := true;
                end;
            end;
        end;
    end;
var
    p : TACPopupItem;
begin
    inherited;

    if fIgnoreMouseMove then begin
        lastmousex := x;
        lastmousey := y;
    	EXIT;
    end;
    last := Hover;
    if IsAutoScroll then EXIT;

    if (Lastmousex=x) and (lastmousey=y) then begin
        {Mouse Move gets triggers after showing a tooltip, even though
        nothing has changed}
        EXIT;
    end;

    if self.fKeyActivated then begin
        self.fKeyActivated := false;
        self.ShowExpandedShortcuts := false;
        self.Invalidate;
    end;

    if not fDragStarted and (fDragMenuItem <> nil) then begin
        if (abs(fDragX - mouse.cursorpos.x) > mouse.DragThreshold) or
            (abs(fdragy - mouse.cursorpos.y) > mouse.DragThreshold) then begin
            fDragStarted := true;
            screen.Cursor := crDrag;
        end;
    end;

    LastMouseX := x;
    LastMouseY := y;

    p := GetItemAt(x,y);
    if (p <> nil) and p.IsLine then begin
        HideTooltip;
        SetHover(p); // Windows will show no hover over a line
        if not p.IsInSubmenu  then begin
            timHideSubmenu.Enabled := true;
        end;
        if last <> nil then
            DrawItem(last);

        EXIT;
    end;
    if self.DragMouseMove(p, last) then EXIT;

    { perform hit test }
    lastpos := FLastPosition;
    FLastPosition := pipNone;
    if (p <> nil) then begin
        FLastPosition := pipCaption;
        if (x - p.fLeft) < LEFT_SPACE then begin
            if (p.ItemType in TClickableLeftIcons) and
                not ((p.ItemType=IT_POPUPCLIP)and(FrmConfig.GetIconType=CBXICONTYPE_NONE)) then begin
                FLastPosition := pipLeftIcon;
            end;
        end;
    end;
    if (FLastPosition = pipNone) then begin
        timHideSubmenu.Enabled := true;
    end;
    if (lastPos <> FLastPosition) then begin
        if (hover<>nil) then begin
            {update to show or remove focus rectangle}
            DrawItem(hover);
        end;
        HideTooltip;
        StartHoverTooltip;
    end;
    if FLastPosition=pipLeftIcon then begin
        //ClipMenuShow
        if (hover <> nil) then begin
            //DrawItem(hover);
            timLeftIconHover.Enabled := false;
            timLeftIconHover.Enabled := true;
        end else begin

        end;
    end else begin
        timLeftIconHover.Enabled := false;
        self.ClipMenuHide;
    end;

    // update hover timers and set hover
    if (last <> p) then begin
        if (p <> nil) then begin
            self.CancelShowSubmenu;
            self.timMouseSelectDelay.Enabled := true;
            {current is a submenu, nested submenu}
            if (p.IsSubmenu) then begin
                if (p.IsInSubmenu)  then begin
                    {nested submenu}
                    {may not be possible}
                end else begin
                    {show me, if not showing}
                    if p <> p.fParent.fSubShowing then begin
                        self.ShowSubmenuDelayed(p);
                    end;
                end;
            end;
            if (not p.IsInSubmenu) then begin
                if (fLastSubmenu <> nil) and (fLastSubMenu <> p) then begin
                    timHideSubmenu.Enabled := true;
                end;
            end else begin
                if IsChild(p, fLastSubmenu) then begin
                    timHideSubmenu.Enabled := false;
                end else begin
                    // TODO: Figure out what the intent was here
                    {if (p <> fLastSubmenu) then begin
                        self.ShowSubmenuDelayed(p);
                    end;}
                end;
            end;

            SetHover(p);
        end;
    end;

    if not (FLastPosition = pipCaption) and (screen.Cursor > 0) then begin
        self.MouseCursorReset;
    end;
end;
procedure TACPopupPrototype.timMouseSelectDelayTimer(Sender: TObject);
begin
    timMouseSelectDelay.Enabled := false;
end;
{Keyboard Events}
procedure TACPopupPrototype.KeyDown(var Key: Word; Shift: TShiftState);

begin
    inherited KeyDown(key, shift); // was KeyUp - was this a mistake?

    fLastKeyDown := key;
    fLastModiferDown := Shift;
    if (key in [VK_SHIFT, VK_MENU, VK_CONTROL]) and
        (hover<>nil) and (hover.ItemType in TUsesClipMenu) then begin
        if not (fToolTipNew.Showing and (ftooltipnew.lblHeader.Visible=false)) then begin
            timModifier.Enabled := true;
        end;
    end;


    if self.ClipMenuVisible then begin
        // consume the keystroke
        key := 0;
    end else begin
        // allow for auto-repeat using the Down message
        if (shift=[]) then begin
            fKeyActivated := true;

            case key  of
            VK_DOWN:    self.HoverDown;
            VK_UP:      self.HoverUp;
            VK_RIGHT:   self.HoverRight;
            VK_LEFT:    self.HoverLeft;
            else
                fKeyActivated := false;
            end;
        end;
    end;
end;
procedure TACPopupPrototype.KeyUp(var Key: Word; Shift: TShiftState);
var ch : char;
    i : integer;
    p : TACPopupItem;
begin
    inherited KeyUp(key, shift);
    if key = VK_ESCAPE then begin
        self.Hide;
        EXIT;
    end;
    if hover = nil then EXIT;

    case key of
    VK_MENU, VK_CONTROL, VK_SHIFT:
        begin
            // detect when only a modifier was pressed and released
            HideTooltip;
            timModifier.Enabled := true;
        end;
    VK_RETURN, VK_SPACE:
        begin
            self.fKeyActivated := true;
            self.HoverClick;
        end;
    end;

    if (fLastModiferDown <> []) and (fLastKeyDown <> 0) then begin
        i := fkeystrokes.IndexOf(string(char(fLastKeyDown)));
        if (i<>-1) then begin
            p := TACPopupItem(fkeystrokes.Objects[i]);
            p.fAltpressed := (ssAlt in fLastModiferDown);
            p.fShiftPressed := (ssShift in fLastModiferDown);
            p.fctrlpressed := (ssCtrl in fLastModiferDown);

            setHover(p);
            self.FLastPosition := pipCaption;
            self.HandleCaptionClick(p);
        end;
    end;
end;
procedure TACPopupPrototype.KeyPress(var Key: Char);
var i, j : integer;
    p, p2 : TACPopupItem;

    it : TItemType;
begin
    inherited;
    if self.fIgnoreKeypresses then EXIT;

    if self.ClipMenuVisible then begin
        Self.ClipMenuReportKey(key);
        key := #0;
        EXIT;
    end;


    if (self.fShowExpandedShortcuts) then begin
        i := fExpandedKeystrokes.IndexOf(string(key));
        if i <> -1 then begin
            self.fKeyActivated := True;
            p := TACPopupItem(fExpandedKeystrokes.Objects[i]);
            self.GatherModifierKeys(p);
            self.FLastPosition := pipCaption;
            if Assigned(p.OnClick) then
                while KeyboardQuery.IsPressed(VK_SHIFT) do begin
                    Application.ProcessMessages;
                    Sleep(50);
                end;

            if p.IsSubmenu then begin
                SetHover(p);
                self.HandleCaptionClick(p);
            end else begin
                self.HandleCaptionClick(p);
            end;
            EXIT;
        end;
    end;

    windows.EnterCriticalSection(crit);

    i := fKeystrokes.IndexOf(string(key));
    if i <> -1 then begin
        self.fKeyActivated := true;
        p := TACPopupItem(fKeystrokes.Objects[i]);

        self.FLastPosition := pipCaption;
        if p.ItemType = IT_PERMANENT then begin
            if AnsiStartsText(KEYS_STR, p.fPermanentText) or
                AnsiStartsText(KEYS_IGNORENL_STR, p.fPermanentText) then begin
				KeyboardQuery.WaitUntilRelease( VkKeyScan(key) );
            end;
        end;

        it := IT_NONE;
        if p.IsExpandable or p.IsSubmenu  then
        	it := p.ItemType;

        {highlight expandable items}
        if it = IT_POPUP then begin
            SetHover(p);
            self.CancelShowSubmenu;
            Self.HandleCaptionClick(p);
        end else begin
            if Assigned(p.OnClick) then
                while KeyboardQuery.IsPressed(VK_SHIFT) do begin
                    Application.ProcessMessages;
                    Sleep(50);
                end;
            self.HandleCaptionClick(p);
            if it <> IT_CLIPSET_HEADER then
                for j := 0 to fitems.fSubMenu.count - 1 do begin
                    p2 := fitems.fSubMenu[j];
                    if p2.IsExpandable and (p2.ItemType = it) then begin
                        SetHover(p2);
                        BREAK;
                    end;
                end;
        end;
    end;

    windows.LeaveCriticalSection(crit);
end;

{Click Event Processing}
procedure TACPopupPrototype.GatherModifierKeys(p : TACPopupItem);
begin
    p.fCtrlPressed := KeyboardQuery.IsPressed(VK_CONTROL);
    p.fShiftPressed := KeyboardQuery.IsPressed(VK_SHIFT);
    p.fAltpressed := KeyboardQuery.IsPressed(VK_MENU);
end;
function TACPopupPrototype.HandleMouseClick(p: TACPopupItem) : boolean;
begin
    result := false;
	{handle Icon clicks, pass of Caption cliks}
    {handle right clicks}

    if ([ssLeft,ssMiddle] * fDownShift) <> [] then begin
        case FLastPosition of
            pipCaption: begin
                result := true;

                GatherModifierKeys(p);
                self.HandleCaptionClick(p);
            end;
        end;
    end;
end;
procedure TACPopupPrototype.HandleCaptionClick(p: TACPopupItem);
var wasChecked, wasExpanded, wasGrouped : boolean;
	i : integer;
    p2 : TACPopupItem;
    it : TItemType;
    ci : TClipITem;
begin
    {handle special controls ourselves, pass off everything else to the click handler}
    case p.Style  of
    psLine: ;
    psBreak: ;
    psSubmenu: begin
        p.SetShowingSubMenu;

        fExpandedKeystrokes.Clear;
        fShowExpandedType := it;
        ShowExpandedShortcuts := self.fKeyActivated;
        self.AssignSubmenuShortcuts(p);

        self.RebuildPopup(false);
    end;
    psExpandable: begin
    	timHover.Enabled := false;
        it := p.ItemType;
        fAutoExpandOnce := IT_NONE;
        fShowExpandedShortcuts := false;


        if assigned(p.fCanExpand) then begin
            if not p.fCanExpand(p) then EXIT;
        end;



        FrmDebug.AppendLog('Normal Expand');
        wasExpanded := p.Expanded;
        fShowExpandedType := it;

        if p.fDisabled then EXIT;

        if (FrmConfig.cbAutoCollapse.checked ) and (not p.Expanded)
             then begin
//        	simulate a show and an expand event - a known 'working' method for expanding
			self.AutoPopulate;
            p2 := nil;
            for i := 0 to fitems.fSubMenu.count - 1 do begin
                p2 := fitems.fSubMenu[i];
                if p2.ItemType = it then begin
                    BREAK;
                end;
            end;
            if p2<>nil then begin
            	p2.Expanded := true;
                ShowExpandedShortcuts := self.fKeyActivated;

                self.RebuildPopup(false);
                self.SetHover(p2);
                p := p2;
            end;
        end else begin
        	p.Expanded := not p.Expanded;
            ShowExpandedShortcuts := self.fKeyActivated and p.Expanded;
            self.RebuildPopup(false);
        end;

        fExpandedKeystrokes.Clear;
        self.AssignSubmenuShortcuts(p);
        fAutoExpandOnce := IT_NONE;
    end;
    psCheckable: begin
    	wasChecked := p.Checked;
        p.Checked := not p.Checked;
        DrawItem(p);
        DrawCheckgroup(p);
        if p.ItemType = IT_FORMMODE then begin
            self.UseFormMode := p.Checked;
            self.Invalidate;
        end else begin
            if assigned(p.OnClick) then begin
                p.OnClick(p);
            end;
            if p.ItemType = IT_SWITCH then begin
            	if (waschecked = true) and (p.checked) then begin
                end else begin
                    self.RebuildPopup;
                end;
            end;
        end;
        DrawItem(p);
    end;
    psNormal: begin
        case FLastPosition of
        pipLeftIcon: begin
            case p.ItemType of
            IT_FULL:
                begin
                    self.Hide;
                    FrmConfig.pcPanels.ActivePage := FrmConfig.tsMenuOrder;
                    frmConfig.Show;
                    UnitMisc.ForceForeground(frmconfig.Handle);
                    FrmMainPopup.SkipFocusReturnOnce;
                end;
            IT_CLIPSET_HEADER:
                begin

                end;
            end;
        end;
        pipNone: ;
        pipCaption: begin
            self.fCaptionPoint.X := self.left + p.Left;
            self.fCaptionPoint.Y := self.top + p.Top;

            if p.IsInExpandedMenu and p.fCollapseParentOnClick then begin
                if assigned(p.onclick) then begin
                    p.OnClick(p);
                    p.fParent.Expanded := false;
                    self.RebuildPopup;
                end;
            end else begin
                case p.ItemType  of
                IT_NEXTFIELD:begin
                    ci := TClipItem.Create;
                    TClipDatabase.LoadPermanent(ci, p.IntegerData, FORM_MODE_FOLDER);
                    ForceForeground(FrmMainPopup.TargetData.ForegroundWindow);
                    Paste.SendTextWithKeystrokes(ci.GetAsPlaintext);
                    myfree(ci);
                    mysleep(30);
                end;
                IT_FULL: begin
                    if FLastPosition=pipCaption then begin
                        fFullMode := not fFullMode;
                        if fFullMode then begin
                            p.Caption := 'Configured Mode';
                        end else begin
                            p.Caption := 'Full Mode'
                        end;
                        self.RebuildPopup;
                    end else begin
                    end;
                end;
                IT_CANCEL: begin
                    self.Hide;
                end;
                else
                    HandleOnClick(p);
                end;
            end;
        end;

        end;
    end;
    end;
end;
procedure TACPopupPrototype.HandleOnClick(p: TACPopupItem);
    function SafeClick(p : TACPopupItem) : boolean;
    begin
        result := false;
        if assigned(p.OnClick) then begin
            result := true;
            p.OnClick(p);
        end;
    end;
begin
    HideTooltip;

    if p.ItemType = IT_POPUPCLIP then begin
        if p.Clip <> nil then
            p.Clip.CData.Clicked := true;
    end;

    if ACPopupClicks.PinClick(p) then begin
        if SafeClick(p) then begin
            self.RebuildPopup;
        end;
        EXIT;
    end;
	if ACPopupClicks.StayOpenOnClick(p) then begin
    	self.UseFormMode := true;

    	ACPopupClicks.StayOpenClick(p);

        self.UseFormMode := false;
        if FrmMainPopup.GetNeedsFocus then
            ForceForeground(self.Handle);
        self.RebuildPopup;
        EXIT;
    end;
	if UseFormMode then begin
    	if (p.ItemType in TPastesOnClickj) then begin
            p.OnClick(p);
            {move to cursor?}
            self.UseFormMode := true;
            self.RebuildPopup;
        end;
    	EXIT;
    end;
    if ACPopupClicks.RightClickAction(p) then begin
        self.ClipMenuShow;
        EXIT;
    end;

    case p.ItemType  of
    IT_POPUPCLIP,IT_PINNED,IT_PERMANENT, IT_CLIPBOARD,IT_TEMP,IT_SYSTEM,IT_SEARCH,
    IT_PASTE_METHOD, IT_SELECTED{,IT_LAST} : begin
        case FLastPosition  of
        pipLeftIcon: ;
        pipCaption: begin
            if assigned(p.fOnClick) then begin
                if not p.fStayOpenOnClick then self.Hide;
                ACPopupClicks.SetMenuPoint(self.fCaptionPoint);
                SafeClick(p);
            end;
        end;
        pipNone: ;
        end;
    end;
    IT_NONE: begin {TODO thinkg about this}
        if assigned(p.fOnClick) then begin
            self.Hide;
            SafeClick(p);
        end;
    end;
    IT_SWITCH: begin
        if SafeClick(p) then begin
            if p.IsInExpandedMenu then
            	p.fParent.Expanded := false;

            self.RebuildPopup;
        end;
    end;
    end;
end;

{Drag-and-Drop routines}
procedure TACPopupPrototype.DragMouseDown(p: TACPopupItem);
begin
    if (p <> nil) and (fDragMenuItem = nil) then begin
        if not (p.ItemType in [IT_NONE, IT_LINE]) then begin
            fDragMenuItem := p;
            if p <> nil then begin
            	fDragX := mouse.cursorpos.x; fDragY := mouse.cursorpos.y;
            end;
        end;
    end;
end;
function TACPopupPrototype.DragMouseMove(p, last: TACPopupItem) : boolean;
var temp : TACPopupItem;
begin
	result := false;
    if (p <> nil) and fDragStarted then  begin
    	temp := fDropMenuItem;
        fDropMenuItem := p;
        //last := fDropMenuItem;
        if (p <> last) then begin
            DrawItem(p);
            if IsLegalDrop(p) then begin


                screen.Cursor := crDrag;
                //appendlog('legaldrop');
            end else begin
                screen.Cursor := crNoDrop;
                FrmDebug.appendlog('no legaldrop');
            end;

            //if last <> nil then DrawItem(last);
            if temp <> nil then DrawItem(temp);
        end else begin
            if p = fDragMenuItem then begin
            	screen.Cursor := crNoDrop;
            end;
            if temp <> nil then DrawItem(temp);
            DrawItem(p);

        end;

        result := true;
    end else if fDragStarted  then begin
       	screen.Cursor := crNoDrop;
        temp := fDropMenuItem;
        fDropMenuItem := p;
		if temp <> nil then DrawItem(temp);
    end;
end;
function TACPopupPrototype.DragMouseUp(p: TACPopupItem) : boolean;
var m1, m2 : TMenuOrderType;
begin
	result := false;

    if fDragStarted then
        MouseCursorReset;


    if fDragStarted and (p<>nil) then begin
        fDragStarted := false;
        if IsLegalDrop(p) then begin
            if fDragMenuItem.IsExpandable then begin
                m1 := TMenuOrderType(fdragmenuitem.integerdata);
            end else begin
                case fdragmenuitem.ItemType  of
                IT_POPUPCLIP:	m1 := MOT_MENU;
                IT_PERMANENT: m1 := MOT_PERMANENT;
                IT_CLIPBOARD:	m1 := MOT_CURRENT;
                //IT_LAST: 	m1 := MOT_LAST;
                IT_SEARCH: 	m1 := MOT_SEARCH;
                IT_FULL: 	m1 := MOT_FULL;
                end;
            end;
            if p.IsExpandable then begin
            	m2 := TMenuOrderType(p.integerdata);
            end else begin
                case p.ItemType  of
                IT_POPUPCLIP:	m2 := MOT_MENU;
                IT_PERMANENT: m2 := MOT_PERMANENT;
                IT_CLIPBOARD: m2 := MOT_CURRENT;
                //IT_LAST: 	m2 := MOT_LAST;
                IT_SEARCH: 	m2 := MOT_SEARCH;
                IT_FULL: 	m2 := MOT_FULL;
                end;
            end;
            if (m1 = MOT_MENU) then begin
                ClipQueue.Move(fDragMenuItem.IntegerData,p.IntegerData)
            end else if (m1 = MOT_PERMANENT) then begin
            	if fDragMenuItem.fPermanentGroupID = -1 then begin
                	FrmPermanent.MoveClip(fDragMenuItem.fPermanentID, p.fPermanentID);
                end;
            end else if (p.ItemType = IT_PINNED) then begin
                PinnedClipQueue.Move(fDragMenuItem.IntegerData,p.IntegerData)
            end else begin
        		FrmConfig.MoveItem(m1, m2);
            end;
            self.RebuildPopup;
        end else begin
        	DrawItem(p);
        end;
        fDragMenuItem := nil;
        fdragx := 0; fdragy := 0;

    	result := true;
    end else begin
    	fDragStarted := false;
        fDragMenuItem := nil;
        fDropMenuItem := nil;
    end;
end;

{Timed Hide/Show Events}
procedure TACPopupPrototype.ShowSubmenuDelayed(p: TACPopupItem);
begin
    fQueuedSubmenu := p;
    timShowSubmenu.interval := 300;
    if timMouseSelectDelay.Enabled then begin
        timShowSubmenu.interval := 600;
    end;
    timShowSubmenu.Enabled := true;
end;
procedure TACPopupPrototype.timShowSubmenuTimer(Sender: TObject);
begin
    timShowSubmenu.Enabled  := false;

    if fQueuedSubmenu <> nil then begin
        fLastSubmenu := fQueuedSubmenu;
        fQueuedSubmenu.SetShowingSubMenu;
        if not fKeyActivated then
            fShowExpandedShortcuts := false;
        self.AssignSubmenuShortcuts(fQueuedSubmenu);
        fQueuedSubmenu := nil;



        self.RebuildPopup(false);
    end;
end;
procedure TACPopupPrototype.timHideSubmenuTimer(Sender: TObject);
    procedure ClearSubmenus(pc : TACPopupItem);
    begin
        if pc = nil then EXIT;

        repeat
             pc.fSubShowing := nil;
             pc := pc.fParent;
        until pc = nil;
    end;
var P : TACPopupItem;
begin
    timHideSubmenu.Enabled := false;
    timHideSubmenu.Interval := 300;

    p := fItems;
    if p.fSubShowing = nil then begin

    end else begin
        while p.fSubShowing <> nil do begin
            p := p.fSubShowing;
        end;
        fLastSubmenu := p;
        if fLastSubmenu <> nil then begin
            ClearSubmenus(fLastSubmenu);
            fLastSubmenu := nil;
            self.RebuildPopup(false);
        end;
    end;
end;
procedure TACPopupPrototype.timHoverTimer(Sender: TObject);
var pt : TPoint;
    cix : TClipItem;
    r : TRect;
    s : string;
    hotkeyname : string;

    procedure SingleMode;
    begin
        fToolTipNew.HideHeader;
        fToolTipNew.SingleLineOnce := true;
        fToolTipNew.SmallFontOnce := true;
    end;
    procedure showClipTooltip(clip : TClipItem; useTimestamp : boolean);
    begin
        s := '';
        if (Clip <> nil) and (clip.GetFormatType = FT_PICTURE) then begin
            s := Clip.GetFormatName;
        end;

        fToolTipNew.ShowTooltip(clip, pt, GetClipHeader(clip),'',
            useTimestamp);
    end;
begin
    timHover.Enabled := false;

    if hover = nil then EXIT;
    if FLastPosition = pipNone then EXIT;
	if fDragStarted then EXIT;

    r := hover.BoundRect;
    pt := point(r.Right - trunc((r.Right-r.Left) / 3.5), r.bottom + 2);
    
    if hover.IsExpandable and FrmConfig.cbAutoExpand.checked then begin
    	if not hover.expanded then begin
        	self.HoverClick;
        end;
        timHover.Enabled := false;
    	EXIT;
    end;


    case hover.ItemType  of
        IT_PERMANENT: begin
            case FLastPosition  of
            pipCaption: begin
                cix := TClipItem.Create;
                s := FrmPermanent.GetPermanentPath;
                if Hover.fPermanentGroupID <> -1 then begin
                    s := FrmPermanent.PermFoldersGetItem(Hover.fPermanentGroupID);
//                    hotkeyname := FrmPermanent.GetItemHotkeyName(Hover.fPermanentID);
//                    cix := FrmPermanent.GetItemClip(hover.fPermanentID);
                end;
                hotkeyname := TClipDatabase.LoadPermanentHotkey(hover.fPermanentID, s);
                TClipDatabase.LoadPermanent(cix, hover.fPermanentID, s );
                fToolTipNew.ShowTooltip(cix, pt, GetClipHeader(cix), hotkeyname);
                myfree(cix);
            end;
            end;
        end;
        IT_POPUPCLIP,IT_PINNED,
        IT_PERMANENT_GROUP,
        IT_TEMP,
        IT_CLIPBOARD,
        IT_SELECTED,
        IT_FULL: begin
            case FLastPosition of
            pipCaption: begin
                if hover.Hint <> '' then begin
                    SingleMode;
                    fTooltipNew.ShowTooltip(Hover.hint,pt);
                end else if hover.fClip <> nil then begin
                    showClipTooltip(hover.fclip, (hover.ItemType in [IT_POPUPCLIP]) and (hover.clip.CData.CreationDateUsed));
                end else begin
                    if (hover.ItemType = IT_TEMP) then begin
                        cix := RemovedQueue.GetItemClip(hover.IntegerData);
                        showClipTooltip(cix, false);
                        myfree(cix);
                    end;

                end;
            end;
            pipLeftIcon: begin
                if hover.ItemType = IT_FULL then begin
                	SingleMode;
                    fToolTipNew.ShowTooltip('Edit Menu Order', pt);
                end;
            end;
            end;
        end else begin
            if hover.Hint <> '' then begin
                SingleMode;
                fTooltipNew.ShowTooltip(Hover.hint,pt);
            end;
        end;
    end;
end;
procedure TACPopupPrototype.timIgnoreMouseMoveTimer(Sender: TObject);
begin
	fIgnoreMouseMove := false;
    timIgnoreMouseMove.Enabled := false;
end;
procedure TACPopupPrototype.timLeftIconHoverTimer(Sender: TObject);
begin
    timLeftIconHover.Enabled := false;

    if FLastPosition = pipLeftIcon then
    	self.ClipMenuShow;
end;
procedure TACPopupPrototype.timModiferTimer(Sender: TObject);
var
    r : TRect;
    pt : TPoint;
    i : integer;
begin
    timModifier.Enabled := false;
    r := hover.BoundRect;
    pt := point(r.Right - trunc((r.Right-r.Left) / 3.5), r.bottom + 2);
    i := fToolTipNew.MinWidth;

    fToolTipNew.MinWidth := 40;

    if KeyboardQuery.IsPressed(VK_SHIFT) then begin
        fToolTipNew.HideHeader;
        fTooltipNew.ShowTooltip( frmConfig.cbxShiftClickAction.text ,pt);
        timHover.Enabled := false;
        EXIT;
    end else if KeyboardQuery.IsPressed(VK_MENU) then begin
        fToolTipNew.HideHeader;
        fTooltipNew.ShowTooltip( frmConfig.cbxAltClickAction.text,pt);
        timHover.Enabled := false;
        EXIT;
    end else if KeyboardQuery.IsPressed(VK_CONTROL) then begin
        fToolTipNew.HideHeader;
        fTooltipNew.ShowTooltip( frmConfig.cbxCtrlClickAction.text,pt);
        timHover.Enabled := false;
        EXIT;
    end else begin
        fToolTipNew.HideHeader;
    end;

    fToolTipNew.MinWidth := i;
end;

procedure TACPopupPrototype.CancelShowSubmenu;
begin
    fQueuedSubmenu := nil;
    timShowSubmenu.Enabled := false;
end;
procedure TACPopupPrototype.HideTooltip;
begin
    timHover.Enabled := false;
    timModifier.Enabled := false;
    fToolTipNew.Hide;
end;
procedure TACPopupPrototype.StartHoverTooltip;
begin
    timModifier.Enabled := false;
    timHover.Enabled := false;
    timHover.Enabled := true;
end;
{Highlight routines}
procedure TACPopupPrototype.DetectAutoScroll(top,bottom : integer);
var
	pt : TPoint;
    m : TMonitor;
begin
	if fIsTooTall then begin
    	if top <> -1 then begin
           	pt.y := top;
            pt.x := 0;
            pt := self.ClientToScreen(pt);

            m := screen.MonitorFromWindow(self.handle);
            if (m <> nil) then begin
                if pt.y < m.top then begin
                	fIgnoreMouseMove := true;
                    timIgnoreMouseMove.Enabled := true;
                    self.Top := m.Top;
                    EXIT;
                end;
            end;
        end;

        if bottom <> -1 then begin
            pt.Y := bottom;
            pt.x := 0;
            pt := self.ClientToScreen(pt);


            m := screen.MonitorFromWindow(self.handle);
            if (m <> nil) then begin
                pt.Y := pt.y + m.top;
                if pt.y > m.BoundsRect.Bottom  then begin
                	fIgnoreMouseMove := true;
                    timIgnoreMouseMove.Enabled := true;
                    self.Top := m.top - (self.Height - m.Height);
                end;
            end;
        end;
    end;
end;

procedure TACPopupPrototype.SetHover(value: TACPopupItem; tooltip:boolean=true);
var last : TACPopupItem;
begin
    // this is the must be the ONLY method that sets fhover directly

	if fShowing = false then EXIT;
    {hotkey pasting will call this method, even if the PopupItem hide the popup}
    
    last := fHover;
    fHover := value;
    HideTooltip;
    if tooltip and
        (last <> fHover) and (fHover <> nil) and (last <> nil) then begin
        StartHoverTooltip;
    end;


    if FLastPosition <> pipLeftIcon then begin
        self.ClipMenuHide;
    end;

    if (value <> nil) then begin
        // Detect when Shortcut Keys need to shift up a level
        if (fKeyActivated) and
            (last<>nil) and (last.IsSubmenu) then begin
            if fHover.IsInExpandedMenu and not fhover.IsSubmenu and last.IsSubmenu then begin
                fShowExpandedType := fHover.ItemType;
                fShowExpandedShortcuts := True;
                Self.AssignSubmenuShortcuts(fhover.fparent);
                self.Invalidate;
            end;
        end;

        if last<>nil then DrawItem(Last);
        if fhover <> nil then DrawItem(fHover);

        // detect the mouse moving from a submenu to a child - don't
        // close the submenu when mouse selected
        if fLastSubmenu <> nil then begin
            if timMouseSelectDelay.Enabled then begin
                if fLastSubmenu.IsSubmenu and (fhover.VisibleParent = fLastSubmenu) then begin
                    self.timHideSubmenu.Enabled := false;
                end;
            end else begin
                // don't close the submenu when moving from parent to child (via keyboard)
                if not (fLastSubmenu.IsSubmenu and (fhover.VisibleParent = fLastSubmenu)) then begin
                    self.timHideSubmenuTimer(self);
                end;
            end;
        end;
        if fhover.IsSubmenu then begin
            if (last<>nil) and (last.IsSubmenu) then begin
                if timMouseSelectDelay.Enabled then begin
                    self.CancelShowSubmenu;
                    self.timHideSubmenu.Enabled := false;
                    self.timHideSubmenu.Enabled := true;
                end else begin
                    self.CancelShowSubmenu;
                    self.timHideSubmenuTimer(self);
                end;
            end;

            self.ShowSubmenuDelayed(fHover);
        end else if fhover.IsInSubmenu then begin

        end else begin
            if timMouseSelectDelay.Enabled then begin
                self.CancelShowSubmenu;
                self.timHideSubmenu.Enabled := false;
                self.timHideSubmenu.Enabled := true;
            end else begin
                self.CancelShowSubmenu;
                self.timHideSubmenuTimer(self);
            end;
        end;
    end;
end;
procedure TACPopupPrototype.HoverClick;
begin
    if Hover <> nil then begin
        FLastPosition := pipCaption;
        GatherModifierKeys(Hover);
        HandleCaptionClick(Hover);
    end;
end;
procedure TACPopupPrototype.HoverDown;
var i : integer;
    daddy, p : TACPopupItem;
begin
    if fItems.fSubMenu.Count = 0 then begin
        FrmDebug.AppendLog('HoverDown: Empty Popup');
        EXIT;
    end;

    // init or select next item, no matter what it is
    if Hover = nil then begin
        i := 0;
        p := fItems.fSubMenu[i];
        daddy := fItems;
    end else begin
        daddy := Hover.VisibleParent;

        i := Hover.Index;
        i := (i + 1) mod daddy.fSubMenu.Count;
        p := daddy[i];
    end;

    while (p.Style in [psLine, psBreak, psGap]) do begin
        i := (i + 1) mod daddy.fSubMenu.Count;
        p := daddy.fSubMenu[i];
    end;


    FLastPosition := pipCaption;
    SetHover(p);
    self.DetectAutoScroll(p.top,p.bottom);
end;
procedure TACPopupPrototype.HoverLeft;
var p : TACPopupItem;
    i : integer;
    procedure CheckForExpandable(p : TACPopupItem);
    begin
        if (p.IsInExpandedMenu) then begin
            ShowExpandedShortcuts := self.fKeyActivated;
            fShowExpandedType := p.ItemType;
        end;
    end;
begin

    if hover = nil then EXIT;
    {close submenu, if in submenu}
    if Hover.IsInSubmenu then begin
        ShowExpandedShortcuts := False;

        SetHover(Hover.fparent);
        self.CancelShowSubmenu;
        timHideSubmenuTimer(self);

        CheckForExpandable(Hover);
        if Hover.fParent.IsExpandable then
            self.AssignSubmenuShortcuts(hover.fparent);
        self.Invalidate;
    end else if Hover.IsSubmenu and (fitems.fSubShowing <> nil) and (hover.fSubMenu.Count <> 0)  then begin
        // close submenu only
        ShowExpandedShortcuts := False;
        CheckForExpandable(Hover);

        SetHover(hover);
        self.CancelShowSubmenu;
        timHideSubmenuTimer(self);

        Self.AssignSubmenuShortcuts(hover.fparent);
        self.Invalidate;

    end else begin
        if hover.ColumnIndex = 0  then EXIT;

        p := getItemAt(hover.fLeft - 5, (hover.fTop+ hover.fBottom)div 2);
        if p = nil then begin
            p := hover;
            i := p.Index;
            while (p.ColumnIndex = hover.ColumnIndex) or p.IsBreak do begin
            	dec(i);
                p := p.visibleparent[i];
            end;
        end;

        i := p.Index;
        while p.isline and (i > 0)do begin
            dec(i);
            p := p.VisibleParent[i];
        end;
        if p <> nil then begin
        	FLastPosition := pipCaption;
            SetHover(p);
        end;
    end;
end;
procedure TACPopupPrototype.HoverRight;
var i : integer;
    p : TACPopupItem;
begin
    if hover = nil then EXIT;

    if hover.IsSubmenu then begin
        if (Hover.fSubMenu.Count > 0) then begin
            hover.SetShowingSubMenu;
            fLastSubmenu := Hover;
            self.AssignSubmenuShortcuts(hover);
            self.RebuildPopup(false);
            i := 0;

            while (hover.fSubMenu[i].isGap) do begin
                inc(i);
            end;
            SetHover( hover.fSubMenu[i] );
        end;
    end else begin
        p := getItemAt(hover.right + 5, (hover.fTop+ hover.fBottom)div 2);
        if p = nil then begin
            if fitems.fColWidth.Count > 1 then begin
                p := fitems.fSubMenu[fitems.fsubmenu.count-1];
            end else begin
                EXIT;
            end;
        end;

        i := p.Index;
        while (p.isline or p.isGap) and (i > 0)do begin
            inc(i);
            p := p.VisibleParent[i];
        end;
        if p <> nil then begin
        	FLastPosition := pipCaption;
            SetHover(p);
        end;
    end;

end;
procedure TACPopupPrototype.HoverUp;
var i : integer;

    daddy, p : TACPopupItem;

begin

    // init or select next item, no matter what it is
    if Hover = nil then begin
        i := 0;
        daddy  := fItems;
        p := fItems.fSubMenu[daddy.fSubMenu.Count - 1];
    end else begin
        daddy := Hover.VisibleParent;
        i := Hover.index;
        dec(i);
        if i < 0 then i := daddy.fSubMenu.Count - 1;
        p := daddy[i];
    end;

    while (p.Style in [psLine, psBreak, psGap]) do begin
        dec(i);
        if i < 0 then i := daddy.fSubMenu.Count - 1;
        p := daddy.fSubMenu[i];
    end;



    FLastPosition := pipCaption;
    SetHover(p);
    self.DetectAutoScroll(p.top,p.bottom);
end;


{Control Events}
procedure TACPopupPrototype.paint;
var c : Cardinal;
begin
    c := WIndows.GetTickCount;
	inherited;
    self.FullRedraw;
    FrmDebug.AppendLog('paint ms=' + IntToStr(Windows.GetTickCount - c));
end;
procedure TACPopupPrototype.resize;
begin
    //inherited;
    {not handling gets rid of flicker}
    FrmDebug.AppendLog('resize');
end;
procedure TACPopupPrototype.Hide;
begin
	if fShowing = false then begin
    	FrmDebug.AppendLog('acpopup.hide called twice');
        EXIT;
    end;
    fShowing := false;

    //inherited;
    FrmDebug.AppendLog('acpopup hide start');
    Windows.ShowWindow(self.Handle, SW_HIDE);

    timHover.Enabled := false;
    timShowSubmenu.Enabled := false;
    timHideSubmenu.Enabled := false;
    timLeftIconHover.Enabled := false;


    if assigned(fTooltipNew) then HideTooltip;
    self.ClipMenuHide;

    fFullMode := false;

    self.visible := false;
    FirstPaint := false;
    self.MouseCursorReset;
    self.fTopOffsetEnable := false;
    FrmDebug.AppendLog('acpopup hide end');
end;
procedure TACPopupPrototype.WMActivate(var msg: tMessage);
begin
    {ignore all the inactive messages that appear until we've had a chance
    to paint and be visible to the user}
	if Msg.WParam = WA_INACTIVE then begin
    	if self.FirstPaint then begin
        	if (FormMode=pdmAutoHide) then begin
        		self.hide;
            end;
        end;
    end;
end;
procedure TACPopupPrototype.WMGetDlgCode(var Msg: TMessage);
begin
	{Tell Windows we want arrow keys}
    inherited;
    Msg.Result:= Msg.Result or DLGC_WANTARROWS;
end;
procedure TACPopupPrototype.WMKeyDown(var Message: TWMKeyDown);
begin
	{TODO - what does this do again?}
    if message.CharCode in [VK_UP, VK_DOWN, VK_LEFT, VK_RIGHT] then begin
    end else begin
        inherited;
    end;
end;
procedure TACPopupPrototype.WMNCHitTest(var Message: TWMNCHitTest);
var pt : tpoint;
    r : TRect;
    i : integer;
const THRESHOLD = 6;
begin
	inherited;

    message.result := HTCLIENT;
    if not self.fDragStarted then begin
        // Detect mouse over Drag Point
        pt := point(message.XPos, message.YPos);
        pt := self.ScreenToClient(pt);
        CopyRect(r,fMainRect);
        r.Left := r.Right - THRESHOLD;
        r.Top := r.Bottom - THRESHOLD;

        if PtInRect(r, pt) then message.Result := HTCAPTION;
    end;

end;
procedure TACPopupPrototype.WMSetCursor(var M: TWMSetCursor);
begin
	if m.CursorWnd = self.Handle then begin
        if m.HitTest = HTCAPTION then begin
            screen.Cursor := crSizeAll;
            m.Result := 1;
        end else begin
            if screen.Cursor <= 0 then begin
                screen.Cursor := crArrow;
                m.result := 1;
            end;
        end;
    end;
end;
procedure TACPopupPrototype.WMMove(var Msg : TMessage);
begin
   fpoint.X := self.Left;
   fpoint.Y := self.Top;
end;

{ TACPopupItemCollection }
function TACPopupItemCollection.Add: TACPopupItem;
begin
    result := TACPopupItem.Create;
    result.Visible := true;

    self.add(result);
end;
function TACPopupItemCollection.GetItem(Index: Integer): TACPopupItem;
begin
    result := TACPopupItem(inherited GetItem(Index));
end;
procedure TACPopupItemCollection.SetItem(Index: Integer; const Value: TACPopupItem);
begin
    inherited SetItem(Index, Value);
end;

{ TACPopupItem }
constructor TACPopupItem.Create();
begin
    inherited;

    fSubMenu := TACPopupItemCollection.Create();
    fCheckgroup := TObjectList.Create;
    fCheckgroup.OwnsObjects := false;
    fColWidth := TIntList.Create;
    fStyle := psNormal;

    fLeftIconOpacity := 255;
    fShowCollapseIcon := True;
    fLeftBitmap := nil;
end;
destructor TACPopupItem.Destroy;
begin
    fColWidth.Free;
    fCheckgroup.Free;

    if (fStyle = psExpandable) and (fexpanded = false) then begin
        fSubMenu.Free;
    end;

    inherited;
    if (fIconBitmap<>nil) then begin
        myfree(fIconBitmap);
    end;
end;


{Drawing Routines}
function TACPopupItem.DesiredWidth(c : TCanvas) : integer;
var s : string;
    i : integer;
begin
    result := fspacing + c.TextWidth( fPrefix ) + fspacing*PREFIX_TRAILING_SPACE_MULTIPLE
        + (fSpacing*RIGHT_SPACE_PADDING_MULTIPLE);

    if fCaptionTrailingBitmap <> nil then
        inc(result, fCaptionTrailingBitmap.Width);

    if (ItemType = IT_PROGRAM_MENU) then begin
        result := result + 16 + fSpacing;
    end;
    if (ItemType in TContainsAClip) and
        (fClip<>nil) and (fClip.GetFormatType = FT_PICTURE) then begin
        // dib AAAxYYYY
        try
            s := fClip.GetFormatName;
            UnitToken.TokenString(s,')');
            s := UnitToken.TokenString(s,'x');
            result := result +  StrToInt(s);
        except
        end;
    end else begin
        if SmallCaption then begin
            i := c.Font.Size;
            c.Font.Size := i-1;
        end;
        inc(result, c.TextWidth(fCaption));
        if SmallCaption then begin
            c.Font.Size := i;
        end;
    end;
end;
procedure TACPopupItem.DrawCaption(ac:TACPopupPrototype; c : TCanvas; r : TRect; IsHovered, IsIcon :  boolean);
    var
        ClipboardLeft, prefixwidth : integer;
        wc : TWideChar;
    procedure DrawDIB(canvas : TCanvas; pnt : Pointer; dest: TRect);  overload;
        var
            bi : PBitmapInfo;
            buf : Pointer;
            r, originalr : Trect;
            wd, ht : integer;
            needsScale : boolean;
            tinywd, tinyht : boolean;
        begin
            with fClip.CData do begin
            if Assigned(thumb) then begin
                if (thumb.Width = dest.Width) and (thumb.Height = dest.Height) then begin
                    canvas.Draw(dest.Left,dest.Top, thumb);
                end else begin
                    canvas.StretchDraw(dest, thumb);
                end;
                EXIT;
            end;
            end;

            bi := pnt;
            buf := Pointer(Integer(bi) + SizeOf(Windows.BITMAPINFO));

            originalr := r;
            r.Left := 0;
            r.Top := max(0, bi^.bmiHeader.biHeight-dest.height);
            r.Height := bi^.bmiHeader.biHeight;
            r.Width := bi^.bmiHeader.biWidth;

            needsScale := false;
            if r.Height > dest.Height then begin
                r.Height := dest.Height;
            end;
            if r.Width > dest.Width then begin
                r.width := dest.Width;
                needsScale := true;
            end;
            if r.height < dest.height then begin
                // center a small picture in the middle of the destination box
                dest.top := dest.Top + (dest.height-r.height) div 2;
            end;

            tinywd := false;
            tinyht := false;
            if bi^.bmiHeader.biWidth < dest.Width then begin
                dest.Width := bi^.bmiHeader.biWidth;
                tinywd := true;
            end;
            if bi^.bmiHeader.biHeight < dest.Height then begin
                dest.top := dest.Top + (dest.height-r.height) div 2;
                dest.Height := bi^.bmiHeader.biHeight;
                tinyht := true;
            end;

            with fClip.CData do begin
                if true then begin
                    // performs slightly faster
                    // on my fast machine, it's 16ms without caching and 0ms with caching
                    if not Assigned(thumb) and not (tinywd and tinyht) then begin
                        thumb := TBitmap.Create;
                        thumb.PixelFormat := pf24bit;
                        thumb.Canvas.Brush.Style := bsSolid;
                        thumb.Canvas.Brush.Color := clNone;
                    end;
                    if assigned(thumb) and
                        ((thumb.Width <> dest.Width) or (thumb.Height <> dest.Height)) then begin
                        thumb.Width := dest.Width;
                        thumb.Height := dest.Height;
                        if (needsScale) then begin
                            // scale the destination box up to the size of the original
                            // compare the widths to caculate the percent growth needed
                            // apply this percent to the box's height
                            wd := bi^.bmiHeader.biWidth;
                            ht := trunc( (wd/dest.Width ) * dest.Height ) ;
                            r.top := bi^.bmiHeader.biHeight-ht;
                            r.Width := wd;
                            r.Height := ht;
                        end;
                        SetStretchBltMode(thumb.Canvas.Handle, STRETCH_HALFTONE);
                        StretchDIBits(thumb.Canvas.Handle,
                        0,0,dest.Width,dest.Height,
                        r.Left,r.Top,r.Width,r.Height,
                        buf, bi^, DIB_RGB_COLORS, SRCCOPY
                        );
                    end;
                    SetStretchBltMode(Canvas.Handle, STRETCH_DELETESCANS);
                    if (thumb<>nil) then begin
                        canvas.Draw(dest.Left,dest.Top, thumb);
                    end else begin
                        StretchDIBits(Canvas.Handle,
                            dest.left, dest.top, dest.width, dest.Height,
                            r.left, r.top, r.width, r.height,
                            buf, bi^, DIB_RGB_COLORS, SRCCOPY
                        );
                    end;
                end else begin
                    StretchDIBits(Canvas.Handle,
                        dest.left, dest.top, dest.width, dest.Height,
                        r.left, r.top, r.width, r.height,
                        buf, bi^, DIB_RGB_COLORS, SRCCOPY
                    );
                end;
            end;
        end;
    procedure TextColorSet;
    begin
        c.brush.Style := bsClear;
        c.pen.Color := 0;
        if fDisabled then begin
            c.pen.Color := ac.fDisabledColor;
        end else begin
            c.pen.Color := ac.fFontColor;
            if (fClip <> nil) and fClip.CData.Clicked then begin
                c.pen.Color := ac.fClickedColor;
            end;
        end;

        SetTextColor(c.Handle, ColorToRGB(c.pen.Color));
    end;
    procedure DrawPic;
    var
        st : TStream;
        pnt : Pointer;
        sz : Int64;
        tempr : TRect;
    begin
        if not assigned(Clip.CData.thumb) then begin
            Clip.BuildMenuCaption;
        end;

        if assigned(Clip.CData.thumb) then begin
            //
            // Detect already scaled thumbs
            // Otherwise, just draw the entire picture or a crop of
            // the picture
            //
            with Clip.CData do begin
                if (thumb.Width = r.Width) and (thumb.Height = r.Height) then begin
                    c.Draw(r.Left,r.Top, thumb);
                end else if ((thumb.Width + fSpacing) = r.Width) and
                    (thumb.Height = r.Height) then begin
                    c.Draw(r.Left,r.Top, thumb);
                end else begin
                    tempr.Top := r.top;
                    tempr.Left := r.left;
                    tempr.Width := min(thumb.Canvas.ClipRect.Width, r.Width);
                    tempr.Height := min(thumb.Canvas.ClipRect.Height, r.Height);
                    if (tempr.Height < r.Height) then begin
                        tempr.Top := tempr.Top + ((r.Height-tempr.Height) div 2);
                    end;

                    c.CopyRect(tempr, thumb.Canvas, rect(0,0,tempr.width, tempr.Height));
                end;
            end;
        end else begin
            st := clip.getstream;
            sz := st.Size;
            pnt := GetMemory(sz);
            st.Read(pnt^, sz);
            Clip.FinishedWithStream;
            DrawDIb(c, pnt, r);
            freemem(pnt);
        end;

        // Windows is doing something shady. Unless the BitmapInfo and the bit
        // buffer are continguous, the StretchDIBits call is failing
//            DrawDib(usecanvas, p.Clip.GetStream, r);
    end;
    procedure DrawClipboardMark;
    begin
        with FrmMainPopup.imgPasteMini.Picture do begin

            c.Draw(
                clipboardleft - 4,
                Max(r.Top + (r.Height - Bitmap.height) div 2, 0),
                Bitmap
            );
            r.Left := r.left + Bitmap.Width-2;
        end;
    end;
    procedure HandlePrefix(r:TRect);
    var
        i : integer;
        ch : Char;
        function IsSkippedPrefix : boolean;
        begin
            result := (IsInSubmenu or IsInExpandedMenu) and (ItemType <> IT_POPUPCLIP);
        end;
        procedure DrawPrefix;
        var
            c1 : TColor;
            bs : TBrushStyle;
            c2 : TColor;
            square : TRect;
            ht : integer;
            atop : integer;
            len : integer;
        begin
            bs := c.Brush.Style;
            c2 := c.Brush.Color;
            c1 := c.Pen.Color;

            c.Brush.Style := bsSolid;
            c.Pen.Style := psSolid;
            wc.Appendunicode(trim(fPrefix));
            len := wc.StrLength;


            prefixwidth := c.TextWidth('W');
            CopyRect(square, r);
            inc(square.Left, fspacing);
            square.right := square.left + prefixwidth;
            inc(square.Right,1);
            dec(square.Left,1);
            ht := c.TextHeight('WZ');
            atop := max(0,(((square.Bottom-square.Top)-(ht)) div 2));
            inc(square.top, atop);
            square.bottom := square.Top + ht + 1;
            if IsHovered then begin
                c.Brush.Color := DimColorOrReverse(ac.fbackgroundBase, 0.86);
            end else begin
                c.Brush.Color := DimColorOrReverse(ac.fbackgroundBase, 0.92);
            end;
            c.FrameRect(square);
            prefixwidth := square.right-square.left;


            c.Brush.Color := c2;

            if c1 <> clGrayText then begin
                c.Pen.Color := DimColorOrReverse(ac.fFontColor, 1.05);
            end else begin
                c.Pen.Color := c1;
            end;


            SetTextColor(c.Handle, ColorToRGB(c.pen.Color));
            //prefixwidth := max(UseCanvas.TextWidth('W'), UseCanvas.TextWidth(ReplaceStr(p.prefix,'&','')))+fspacing*2;
            r.Right := r.Left + prefixwidth;
            c.Brush.Style := bsClear;
            square.Top := r.Top-1;
            square.Bottom := r.Bottom+1;
            DrawTextW(c.Handle, PWideChar(wc.Memory), len,
                square, DT_VCENTER or DT_SINGLELINE or DT_CENTER );

            SetTextColor(c.Handle, ColorToRGB(c.pen.Color));
            c.Pen.Color := c1;
            c.Brush.Style := bs;
        end;
    begin
        prefixwidth := 0;
        if (fPrefix <> '') then begin
            wc := TWideChar.Create;

            if (ac.fShowExpandedShortcuts) then begin
                if IsSkippedPrefix then begin
                    // draw normally skipped prefix, if it's referenced
                    ch := fprefix[2];
                    i := ac.fExpandedKeystrokes.IndexOf(string(ch));
                    if (i<>-1) and (ac.fExpandedKeystrokes.IndexOfObject(self) = i)
                         then begin
                        DrawPrefix;
                    end;
                end else begin
                    // draw "always drawn" prefix, only if not overriden
                    ch := fprefix[2];
                    i := ac.fExpandedKeystrokes.IndexOf(string(ch));
                    if (i=-1) then begin
                        DrawPrefix;
                    end;
                end;
            end else if not IsSkippedPrefix then begin
                DrawPrefix;
            end;
            myfree(wc);
        end;
    end;
    procedure HandlePosssibleIcon;
    var ht : integer;
        y : integer;
        left : integer;
        icon : TIcon;
        bm : TBitmap;
        BlendFunc: TBlendFunction;
    begin
        if fCaptionIconOnlyOnHover and (not IsHovered) then EXIT;

        if (fItemType = IT_PROGRAM_MENU) or (fCaptionTrailingBitmap <> nil) then begin
            ht := r.Bottom-r.Top;
            if ht < 16 then begin
                y := r.top;
            end else begin
                y := r.Top + max(0, ((ht)-16)div 2);
            end;

            left := r.Left + c.TextWidth(wc.GetString) + fspacing*2;

            if (ItemType <> IT_PROGRAM_MENU) then begin
                c.Draw(left, y, fCaptionTrailingBitmap);
            end else begin
                inc(y);
                left := r.Left;

                icon := TIcon.Create;
                icon.Handle := DuplicateIcon(0, fIcon);
                bm := TBitmap.Create;
                bm.Width := 16;
                bm.Height := 16;
                bm.PixelFormat := pf24bit;
                bm.TransparentColor := clWhite;

                bm.Canvas.CopyRect(rect(0,0,16,16), c, rect(left,y,left+16,y+16));
                //c.Draw(left, y, icon);
                DrawIconEx(c.handle,
                    left, y+1,
                    ficon, 16,16, 0, 0, DI_NORMAL);

                BlendFunc.BlendOp := AC_SRC_OVER;
                BlendFunc.BlendFlags := 0;
                BlendFunc.SourceConstantAlpha := 120;
                BlendFunc.AlphaFormat := 0;
                Windows.AlphaBlend(c.Handle, left,y, 16,16, Bm.Canvas.Handle,
                    0,0, 16,16, BlendFunc);


                bm.Free;
                icon.Free;
            end;
        end;
    end;
    procedure HandleClipPasteCue(bm : TBitmap);
    var
        pt : Tpoint;
    begin
        if IsHovered and not IsIcon and (fItemType in TPastesOnClickj) then begin
            pt := ac.ScreenToClient(Mouse.CursorPos);

            c.Draw(
                r.left,
                r.Top+max(0,((r.Bottom-r.Top)-bm.Height) div 2) ,
                bm
            );
        end;
    end;
var
    options : integer;
    fs : TFontStyles;
    s : string;
    len : integer;
    bm : TBitmap;
    tempr : TRect;
    ht : integer;
begin
    TextColorSet;

    HandlePrefix(r);
    inc(r.Left, fspacing*PREFIX_TRAILING_SPACE_MULTIPLE);
    if prefixwidth <> 0 then begin
        inc(r.left, fspacing+ prefixwidth);
    end;

    if ((fItemType = IT_CLIPBOARD)
        or
        (
            (fItemType = IT_POPUPCLIP) and (fClip.CData.Hash = CurrentClipboard.CData.Hash)
        ))
        then begin

        clipboardleft := r.left;
        if not ((fClip <> nil) and (fClip.GetFormatType = FT_PICTURE)) then begin
            DrawClipboardMark;
        end;
    end;

    r.right := r.Right - (fSpacing*RIGHT_SPACE_PADDING_MULTIPLE);
    wc := TWideChar.Create;
    if (fClip = nil) or (fcaption <> '') or (fClip.GetFormat <> CF_UNICODETEXT) then begin
        if (fClip = nil) or (fcaption <> '') then begin
            s := fcaption;
        end else begin
            if fClip.GetFormat = CF_DIB then begin
                s := fClip.GetFormatName;
            end else begin
                s := fclip.GetAsPlaintext;
            end;
        end;
        wc.AppendUnicode(s);
        wc.Replace(WideChar(' '),{NO BREAK SPACE}WideChar($00A0));
    end else begin
        wc.AppendUnicode(fClip.GetAsPlaintext);
    end;

    fs := c.Font.Style;
    if (IsHovered) and (fIconHoverCaption <> '') and (IsIcon) then begin
        // icon hover override
        wc.Clear;
        wc.Append(fIconHoverCaption);
        c.Font.Style := c.Font.Style + [fsBold];

        if fItemType in [IT_FULL, IT_PERMANENT] then begin
            fCaptionTrailingBitmap := ImgToBitmap(FrmMainPopup.imgNewWindow);
        end;
    end else begin
        if fItemType in [IT_FULL, IT_PERMANENT] then begin
            fCaptionTrailingBitmap := nil;
        end;
    end;

    len := min(100, wc.StrLength);
    SetBkMode(c.Handle, TRANSPARENT) ;


    options := 0;
    if fItemType in TContainsAClip then begin
        options := options or DT_NOPREFIX;
    end;
    if SmallCaption then begin
        options := options or DT_CENTER;
    end;

    // rect2 is either the size of the caption, or smaller if the picture is smaller

    TextColorSet;
    if (FrmConfig.cbNoThumbnails.Checked=false) and
        ((fClip<>nil) and (fClip.GetFormatType = FT_PICTURE)) and
        (fItemType in TContainsAClip) then begin
        DrawPic;
        if (fItemType = IT_CLIPBOARD)
            or
        ((fItemType = IT_POPUPCLIP) and
            (fClip.CData.Hash = CurrentClipboard.CData.Hash)) then begin
            r.Left := clipboardleft-4;
            DrawClipboardMark;
        end;
    end else begin
        if fItemType = IT_PROGRAM_MENU then begin
            inc(r.Left, 16+fspacing);
        end;

        if DoubleHeight then begin
            // DT_VCENTER only works for single line text
            dec(r.bottom,2);
            DrawTextW(c.Handle, PWideChar(wc.Memory), len,
                r, DT_VCENTER or DT_WORDBREAK or DT_EDITCONTROL or options  );
        end else begin
            inc(r.Bottom);
                DrawTextW(c.Handle, PWideChar(wc.Memory), len,
                    r, DT_VCENTER or DT_SINGLELINE or options);
            dec(r.Bottom);
        end;

    end;




    if fItemType = IT_PROGRAM_MENU then begin
        dec(r.Left, 16+fspacing);
    end;
    HandlePosssibleIcon;



    myfree(wc);

    SetBkMode(c.Handle, OPAQUE);
    c.Font.Style := fs;
end;
procedure TACPopupItem.DrawCaptionBackground(AC: TACPopupPrototype; c : TCanvas; r : TRect);
const
    BLEND_CLICKED = 97;
    BLEND_CLICKED_ORIGINAL = 99;
    DIVIDER_HALF_WIDTH = 60;
var
    c1,c2 : TColor;
    liner : TREct;
    m : integer;
    procedure MyFillRect(r : TRect);
    begin
        inc(r.bottom);
        inc(r.Right);
        c.FillRect(r);
    end;
    procedure MyGradientFill(c1, c2 : TColor; r : TRect; d : TGradientDirection);
    begin
        inc(r.Bottom);
        inc(r.Right);
        GraphUtil.GradientFillCanvas(c,c1,c2,r,d);
    end;
begin
    CopyRect(liner, r);
    if  (fItemType in [IT_CANCEL,IT_FULL,IT_SEARCH]) then begin
        c.brush.Color := ac.fColumnColor;
        ac.fBackgroundBase := c.brush.Color;
        MyFillRect(r);

        c1 := ac.fColumnColor;
        c2 := dimColor(ac.fColumnColor, 0.94);
        liner.Left := liner.right - RIGHT_MENU_GRADIENT_WIDTH;
        MyGradientFill(c1,c2,liner,gdHorizontal);
    end else if IsInExpandedMenu then begin
        c.brush.Color := ac.fExpandedBackgroundColor;
        if (fClip <> nil) and fClip.CData.Clicked then begin
            c.Brush.Color := unitMisc.Blend(c.brush.Color, ac.fClickedColor, BLEND_CLICKED);
        end;
        ac.fBackgroundBase := c.brush.Color;
        MyFillRect(r);
    end else begin
        if (fItemType = IT_PINNED) then begin
            c.brush.Color := DimColorOrReverse(ac.fBackgroundColor,1.03);
            ac.fBackgroundBase := c.brush.Color;
        end;

        MyFillRect(r);
    end;

    if (fItemType in [IT_POPUPCLIP, IT_PINNED]) and (frmConfig.cbDoubleHeight.checked) then begin
        if (fClip<>nil) and (fClip.GetFormatType <> FT_PICTURE) then begin
            with c do begin
                pen.Color := blend(brush.Color, ac.fFontColor, 96);
                m := (r.Left+r.Right) div 2;
                if false then begin
                    MoveTo(m-(40), r.bottom-1);
                    LineTo(m+(40), r.bottom-1);
                end else begin
                    liner.Top := r.Bottom-1;
                    liner.Left := m-DIVIDER_HALF_WIDTH;
                    liner.Right := m;
                    MyGradientFill(brush.Color, pen.Color, liner, gdHorizontal);
                    liner.Left := m;
                    liner.Right := m+DIVIDER_HALF_WIDTH;
                    MyGradientFill(pen.Color, brush.Color, liner, gdHorizontal);
                end;
            end;
        end;
    end;
end;



function TACPopupItem.GetBoundsRect: TRect;
begin
    result := fBoundsRect;
end;

function TACPopupItem.GetChecked: boolean;
begin
    result := fChecked;
end;
function TACPopupItem.GetColumnWidth: integer;
begin
    result := fParent.fColWidth[fMyColumn];
end;
function TACPopupItem.GetExpanded: boolean;
begin
    result := fExpanded;
end;

function TACPopupItem.GetIndex: integer;
begin
    {The index refers to the visible parent, not the owner}
    result := GetVisibleParent.fSubMenu.IndexOf(self);
end;

function TACPopupItem.GetOwnerIndex : integer;
begin
    result := fParent.fSubMenu.IndexOf(self);
end;

function TACPopupItem.GetIsBreak: boolean;
begin
    result := fStyle = psBreak;
end;
function TACPopupItem.GetIsExpandable: boolean;
begin
    result := fStyle = psExpandable;
end;
function TACPopupItem.GetIsInExpandedMenu: boolean;
begin
    result := fParent.IsExpandable;
end;
function TACPopupItem.GetIsInSubMenu: boolean;
begin
    result := (fparent.fParent <> nil) and not fparent.IsExpandable;
end;
function TACPopupItem.GetIsLine: boolean;
begin
    result := fStyle = psLine;
end;
function TACPopupItem.GetIsSubmenu: boolean;
begin
    result := fStyle = psSubmenu;
end;
function TACPopupItem.GetIsGap : boolean;
begin
    result := fStyle = psGap;
end;

function TACPopupItem.GetItem(Index : integer): TACPopupItem;
begin
    result := fSubMenu[index];
end;

function TACPopupItem.GetVisibleParent: TACPopupItem;
begin
    {In an expanded menu, the visible parent will be twice removed}
    result := fParent;
    if self.IsInExpandedMenu  then
        result := fParent.fParent;
end;


procedure TACPopupItem.CheckGrouped;
begin
    fParent.fCheckgroup.Add(self);
end;
function TACPopupItem.IsCheckGrouped : boolean;
begin
    result := fparent.fCheckgroup.IndexOf(self) <> -1;
end;
function TACPopupItem.Add: TACPopupItem;
begin
    result := self.fSubMenu.Add;
    result.fParent := self;

    if self.IsSubmenu then begin
        self.Disabled := false;
    end;
end;


function TACPopupItem.AddBreak: TACPopupITem;
begin
    result := self.add;
    result.IsBreak := true;
end;
{function TACPopupItem.AddLine: TACPopupITem;
begin
    result := self.Add;
    result.IsLine := true;
end;}
function TACPopupItem.CalcRight: integer;
begin
    if self.fParent.IsExpandable  then begin
        result := self.fLeft + self.fParent.fparent.fColWidth[self.fMyColumn] - RIGHT_BORDER;
    end else begin
        result := self.fLeft + self.fParent.fColWidth[self.fMyColumn] - RIGHT_BORDER;
    end;
    self.fRight := result;
end;
procedure TACPopupItem.SetBoundsRect(parenttop, parentleft: integer);
begin
    with fBoundsRect do begin
        top := ftop + parenttop;
        bottom := fbottom + parenttop;
        left := fleft + parentleft;
        right := self.right + parentleft;
    end;
end;

procedure TACPopupItem.SetCaption(value: string);
begin
    fCaption := value;
    if (length(fCaption) > 300) then begin
        fCaption := leftstr(fCaption, 300) + '...';
    end;
    // tabs make the windows too damn long
    // the #10 will make a funky box in the tab's place
    while pos(#9#9, fCaption) > 0 do begin
        fCaption := stringreplace(fCaption, #9#9, #9, [rfreplaceall]);
    end;
    fCaption := stringreplace(fCaption, #9,chr($B0), [rfReplaceAll]); {unicode middle dot}

    {escape the special hotkey character}
    fCaption := stringreplace(fCaption, '&', '&&', [rfReplaceAll]);
end;
procedure TACPopupItem.SetCaptionFromClip(value: TClipItem);
begin
    if value.CData.displaytext <> '' then begin
        fCaption := value.CData.displaytext;
        EXIT;
    end;
    case value.GetFormatType of
    FT_UNICODE, FT_RICHTEXT, FT_HTML:
        begin
            value.BuildMenuCaption;
            fCaption := value.CData.displaytext;
        end;
    FT_PICTURE:
        begin
            fCaption := value.GetFormatName()
        end;
    else
        begin
            SetCaption(value.GetAsPlaintext);
        end;
    end;
    value.CData.displaytext := fCaption;
end;

procedure TACPopupItem.SetChecked(value: boolean);
var i : integer;
    p : TACPopupItem;
begin
    if (fParent.fCheckgroup.IndexOf(self) <> -1) then begin
        if (self.fChecked = false) and value then begin
            for i := 0 to fParent.fCheckgroup.Count - 1 do begin
                p := TACPopupItem(fParent.fCheckgroup[i]);
                p.fChecked := false;
            end;
            self.fChecked := true;
        end;
    end else begin
        self.fChecked := value;
    end;

    self.fStyle := psCheckable;
    self.fStayOpenOnClick := true;
end;
procedure TACPopupItem.SetExpanded(value: boolean);
var i : integer;
begin
    fExpanded := value;

    if value then begin
        for i := fSubMenu.count - 1 downto 0 do begin
            fparent.fSubMenu.Insert(self.index+1,fsubmenu[i]);
        end;
    end else begin
        for i := fSubMenu.count - 1 downto 0 do begin
            fparent.fSubMenu.Extract(fSubmenu[i]); // Don't Free the object
        end;
    end;
end;

procedure TACPopupItem.SetIsBreak(value: boolean);
begin
    if value then
        fStyle := psBreak;
end;
procedure TACPopupItem.SetIsExpandable(value: boolean);
begin
    if value then begin
        fStyle := psExpandable;
        fLeftIconOnlyOnHover := false;
        fLeftIconOnExpanded := true;
        fStayOpenOnClick := true;
    end;
end;
procedure TACPopupItem.SetIsLine(value: boolean);
begin
    if value then begin
        fStyle := psLine;
        fStayOpenOnClick := true;
    end;
end;
procedure TACPopupItem.SetIsSubmenu(value: boolean);
begin
    if value then begin
        fStyle := psSubmenu;
        fStayOpenOnClick := true;
    end;
end;
procedure TACPopupItem.SetIsGap(value : boolean);
begin
    if value then begin
        fStyle := psGap;
        fStayOpenOnClick := true;
    end;

end;
procedure TACPopupItem.SetItem(Index: integer; value: TACPopupItem);
begin
    fSubMenu[index] := value;
end;

procedure TACPopupItem.SetLeftBitmap(value: TBitmap);
begin
    self.fHasLeftIcon := true;
    self.fLeftBitmap := value;
end;
procedure TACPopupItem.SetLeftIcon(value: hicon);
begin
    self.fHasLeftIcon := value <> 0;
    fIcon := value;
end;
procedure TACPopupItem.SetCliptypeIcon(value: TBitmap);
begin
    self.fCliptypeBitmap := value;
    self.fHasCliptypeIcon := true;
end;
procedure TACPopupItem.SetShowingSubMenu;
begin
    if self.IsInExpandedMenu  then begin
        fParent.fParent.fSubShowing := self;
    end else begin
        fParent.fSubShowing := self;
    end;

end;

//
// Handling transparency
//
constructor TCustomTransparentControl.Create(AOwner: TComponent);
begin
    inherited Create(AOwner);
    ControlStyle := ControlStyle + [csOpaque];
    Brush.Style := bsClear; {required for XP to make backgroun transparent}
end;
procedure TCustomTransparentControl.CreateParams(var Params: TCreateParams);
begin
    inherited CreateParams(Params);

    // dropshadow
    if CheckWin32Version(5, 1) then
       params.WindowClass.Style := params.WindowClass.style or CS_DROPSHADOW;
end;
procedure TCustomTransparentControl.WMNCHitTest(var Message: TWMNCHitTest);
begin
    if not FInterceptMouse then begin
        Message.Result := HTTRANSPARENT
    end else begin
        inherited;
    end;
end;
procedure TCustomTransparentControl.Invalidate;
begin
    FrmDebug.AppendLog('invalidate');
	inherited Invalidate;
end;

initialization
begin

end;
end.
