{Unit CRC-Maker}

unit UnitCRC32;

{///////////////}
{//}interface{//}
{///////////////}

uses Windows, SysUtils, Classes;

type TCRC32 = class(TObject)
    private
        seed : cardinal;
        test : array[0..255] of cardinal;
    public
        constructor Create;
        procedure ReInit;
        procedure setseed(s : cardinal);
        function Update(w : word) : cardinal; overload;
        function Update(buffer : array of byte) : cardinal; overload;
        function Update(st : TStream) : Cardinal; overload;

end;

type TCRC16 = class(TObject)
    private
        seed : word;

    public
        constructor Create;
        procedure ReInit;
        procedure setseed(s : word);
        function Update(b : byte) : word; overload;
        function Update(w : word) : word; overload;
        function Update(buffer : array of byte) : word; overload;

end;


var CRC32 : TCRC32;

{////////////////////}
{//}implementation{//}
{////////////////////}


const crc16table : array[0..255] of word = (
	$0000,	$1021,	$2042,	$3063,	$4084,	$50a5,	$60c6,	$70e7,
	$8108,	$9129,	$a14a,	$b16b,	$c18c,	$d1ad,	$e1ce,	$f1ef,
	$1231,	$0210,	$3273,	$2252,	$52b5,	$4294,	$72f7,	$62d6,
	$9339,	$8318,	$b37b,	$a35a,	$d3bd,	$c39c,	$f3ff,	$e3de,
	$2462,	$3443,	$0420,	$1401,	$64e6,	$74c7,	$44a4,	$5485,
	$a56a,	$b54b,	$8528,	$9509,	$e5ee,	$f5cf,	$c5ac,	$d58d,
	$3653,	$2672,	$1611,	$0630,	$76d7,	$66f6,	$5695,	$46b4,
	$b75b,	$a77a,	$9719,	$8738,	$f7df,	$e7fe,	$d79d,	$c7bc,
	$48c4,	$58e5,	$6886,	$78a7,	$0840,	$1861,	$2802,	$3823,
	$c9cc,	$d9ed,	$e98e,	$f9af,	$8948,	$9969,	$a90a,	$b92b,
	$5af5,	$4ad4,	$7ab7,	$6a96,	$1a71,	$0a50,	$3a33,	$2a12,
	$dbfd,	$cbdc,	$fbbf,	$eb9e,	$9b79,	$8b58,	$bb3b,	$ab1a,
	$6ca6,	$7c87,	$4ce4,	$5cc5,	$2c22,	$3c03,	$0c60,	$1c41,
	$edae,	$fd8f,	$cdec,	$ddcd,	$ad2a,	$bd0b,	$8d68,	$9d49,
	$7e97,	$6eb6,	$5ed5,	$4ef4,	$3e13,	$2e32,	$1e51,	$0e70,
	$ff9f,	$efbe,	$dfdd,	$cffc,	$bf1b,	$af3a,	$9f59,	$8f78,
	$9188,	$81a9,	$b1ca,	$a1eb,	$d10c,	$c12d,	$f14e,	$e16f,
	$1080,	$00a1,	$30c2,	$20e3,	$5004,	$4025,	$7046,	$6067,
	$83b9,	$9398,	$a3fb,	$b3da,	$c33d,	$d31c,	$e37f,	$f35e,
	$02b1,	$1290,	$22f3,	$32d2,	$4235,	$5214,	$6277,	$7256,
	$b5ea,	$a5cb,	$95a8,	$8589,	$f56e,	$e54f,	$d52c,	$c50d,
	$34e2,	$24c3,	$14a0,	$0481,	$7466,	$6447,	$5424,	$4405,
	$a7db,	$b7fa,	$8799,	$97b8,	$e75f,	$f77e,	$c71d,	$d73c,
	$26d3,	$36f2,	$0691,	$16b0,	$6657,	$7676,	$4615,	$5634,
	$d94c,	$c96d,	$f90e,	$e92f,	$99c8,	$89e9,	$b98a,	$a9ab,
	$5844,	$4865,	$7806,	$6827,	$18c0,	$08e1,	$3882,	$28a3,
	$cb7d,	$db5c,	$eb3f,	$fb1e,	$8bf9,	$9bd8,	$abbb,	$bb9a,
	$4a75,	$5a54,	$6a37,	$7a16,	$0af1,	$1ad0,	$2ab3,	$3a92,
	$fd2e,	$ed0f,	$dd6c,	$cd4d,	$bdaa,	$ad8b,	$9de8,	$8dc9,
	$7c26,	$6c07,	$5c64,	$4c45,	$3ca2,	$2c83,	$1ce0,	$0cc1,
	$ef1f,	$ff3e,	$cf5d,	$df7c,	$af9b,	$bfba,	$8fd9,	$9ff8,
	$6e17,	$7e36,	$4e55,	$5e74,	$2e93,	$3eb2,	$0ed1,	$1ef0
);




 const CRC32Table: Array[0..255] of cardinal = (
       $000000000, $077073096, $0ee0e612c, $0990951ba,
       $0076dc419, $0706af48f, $0e963a535, $09e6495a3,
       $00edb8832, $079dcb8a4, $0e0d5e91e, $097d2d988,
       $009b64c2b, $07eb17cbd, $0e7b82d07, $090bf1d91,

       $01db71064, $06ab020f2, $0f3b97148, $084be41de,
       $01adad47d, $06ddde4eb, $0f4d4b551, $083d385c7,
       $0136c9856, $0646ba8c0, $0fd62f97a, $08a65c9ec,
       $014015c4f, $063066cd9, $0fa0f3d63, $08d080df5,

       $03b6e20c8, $04c69105e, $0d56041e4, $0a2677172,
       $03c03e4d1, $04b04d447, $0d20d85fd, $0a50ab56b,
       $035b5a8fa, $042b2986c, $0dbbbc9d6, $0acbcf940,
       $032d86ce3, $045df5c75, $0dcd60dcf, $0abd13d59,

       $026d930ac, $051de003a, $0c8d75180, $0bfd06116,
       $021b4f4b5, $056b3c423, $0cfba9599, $0b8bda50f,
       $02802b89e, $05f058808, $0c60cd9b2, $0b10be924,
       $02f6f7c87, $058684c11, $0c1611dab, $0b6662d3d,

       $076dc4190, $001db7106, $098d220bc, $0efd5102a,
       $071b18589, $006b6b51f, $09fbfe4a5, $0e8b8d433,
       $07807c9a2, $00f00f934, $09609a88e, $0e10e9818,
       $07f6a0dbb, $0086d3d2d, $091646c97, $0e6635c01,

       $06b6b51f4, $01c6c6162, $0856530d8, $0f262004e,
       $06c0695ed, $01b01a57b, $08208f4c1, $0f50fc457,
       $065b0d9c6, $012b7e950, $08bbeb8ea, $0fcb9887c,
       $062dd1ddf, $015da2d49, $08cd37cf3, $0fbd44c65,

       $04db26158, $03ab551ce, $0a3bc0074, $0d4bb30e2,
       $04adfa541, $03dd895d7, $0a4d1c46d, $0d3d6f4fb,
       $04369e96a, $0346ed9fc, $0ad678846, $0da60b8d0,
       $044042d73, $033031de5, $0aa0a4c5f, $0dd0d7cc9,

       $05005713c, $0270241aa, $0be0b1010, $0c90c2086,
       $05768b525, $0206f85b3, $0b966d409, $0ce61e49f,
       $05edef90e, $029d9c998, $0b0d09822, $0c7d7a8b4,
       $059b33d17, $02eb40d81, $0b7bd5c3b, $0c0ba6cad,

       $0edb88320, $09abfb3b6, $003b6e20c, $074b1d29a,
       $0ead54739, $09dd277af, $004db2615, $073dc1683,
       $0e3630b12, $094643b84, $00d6d6a3e, $07a6a5aa8,
       $0e40ecf0b, $09309ff9d, $00a00ae27, $07d079eb1,

       $0f00f9344, $08708a3d2, $01e01f268, $06906c2fe,
       $0f762575d, $0806567cb, $0196c3671, $06e6b06e7,
       $0fed41b76, $089d32be0, $010da7a5a, $067dd4acc,
       $0f9b9df6f, $08ebeeff9, $017b7be43, $060b08ed5,

       $0d6d6a3e8, $0a1d1937e, $038d8c2c4, $04fdff252,
       $0d1bb67f1, $0a6bc5767, $03fb506dd, $048b2364b,
       $0d80d2bda, $0af0a1b4c, $036034af6, $041047a60,
       $0df60efc3, $0a867df55, $0316e8eef, $04669be79,

       $0cb61b38c, $0bc66831a, $0256fd2a0, $05268e236,
       $0cc0c7795, $0bb0b4703, $0220216b9, $05505262f,
       $0c5ba3bbe, $0b2bd0b28, $02bb45a92, $05cb36a04,
       $0c2d7ffa7, $0b5d0cf31, $02cd99e8b, $05bdeae1d,

       $09b64c2b0, $0ec63f226, $0756aa39c, $0026d930a,
       $09c0906a9, $0eb0e363f, $072076785, $005005713,
       $095bf4a82, $0e2b87a14, $07bb12bae, $00cb61b38,
       $092d28e9b, $0e5d5be0d, $07cdcefb7, $00bdbdf21,

       $086d3d2d4, $0f1d4e242, $068ddb3f8, $01fda836e,
       $081be16cd, $0f6b9265b, $06fb077e1, $018b74777,
       $088085ae6, $0ff0f6a70, $066063bca, $011010b5c,
       $08f659eff, $0f862ae69, $0616bffd3, $0166ccf45,

       $0a00ae278, $0d70dd2ee, $04e048354, $03903b3c2,
       $0a7672661, $0d06016f7, $04969474d, $03e6e77db,
       $0aed16a4a, $0d9d65adc, $040df0b66, $037d83bf0,
       $0a9bcae53, $0debb9ec5, $047b2cf7f, $030b5ffe9,

       $0bdbdf21c, $0cabac28a, $053b39330, $024b4a3a6,
       $0bad03605, $0cdd70693, $054de5729, $023d967bf,
       $0b3667a2e, $0c4614ab8, $05d681b02, $02a6f2b94,
       $0b40bbe37, $0c30c8ea1, $05a05df1b, $02d02ef8d);




{ TCRC32 }

constructor TCRC32.Create;
//const p : cardinal = $EDB88320;
 const p : cardinal = $04c11db7;
var c : cardinal;
    i : integer;
    j : integer;
begin
    self.ReInit;

    for i := 0 to 255 do begin
        c := i;
        for j := 8 downto 1 do begin
            if (c and 1) <> 0 then begin
                c := (c shr 1) xor p;
            end else begin
                c := (c shr 1);
            end;
        end;
        test[i] := c;
    end;
//EDB88320
//    DWORD dwPolynomial = $EDB88320;
//DWORD* CRC32Table = NULL;
//
//CRC32Table = new DWORD[256];
//
//DWORD dwCRC;
//for(int i = 0; i < 256; i++)
//{
//      dwCRC = i;
//
//for(int j = 8; j > 0; j--)
//      {
//            if(dwCRC & 1)
//                  dwCRC = (dwCRC >> 1) ^ dwPolynomial;
//            else
//                  dwCRC >>= 1;
//      }
//
//CRC32Table[i] = dwCRC;
//}
//}

end;

procedure TCRC32.ReInit;
begin
    seed := $FFFFFFFF;
   //seed := $0;
end;

procedure TCRC32.setseed(s: cardinal);
begin
    self.seed := s;
end;
function TCRC32.Update(buffer : array of byte): cardinal;
var i, index : longint;
begin
    result:= seed;
    for i := low(buffer) to high(buffer) do begin


        index := ((result and $000000FF) xor buffer[i]);
        result := ((result shr 8) and $00FFFFFF) xor CRC32Table[index];
    end;
    //result := not result;
    seed :=  result;
end;
function TCRC32.Update(w : word): cardinal;
var buffer : array[0..1] of byte;
begin
    buffer[0] := lo(w);
    buffer[1] := hi(w);

    result := self.Update(buffer);
end;
function TCRC32.Update(st : TStream) : Cardinal;
type b = array of byte;
    pb = ^b;
var i, index : longint;
    bt : array [0..0] of byte;

    sz : Int64;
begin
    st.Position := 0;
    result:= seed;
    try
        st.Seek(0, soFromBeginning);
        sz := st.Size;
        for i := 0 to sz - 1 do begin
            st.Read(bt,1);
            index := ((result and $000000FF) xor bt[0]);
            result := ((result shr 8) and $00FFFFFF) xor CRC32Table[index];
        end;
        //result := not result;
        seed :=  result;
    finally
    end;
end;
{ TCRC16 }

constructor TCRC16.Create;
begin

end;

procedure TCRC16.ReInit;
begin
    seed := $ffff;
end;





function TCRC16.Update(b: byte): word;
begin

end;

function TCRC16.Update(w: word): word;
begin

end;

procedure TCRC16.setseed(s: word);
begin
    seed := s;
end;

function TCRC16.Update(buffer: array of byte): word;
var i, index : longint;
begin
    result:= seed;
    for i := low(buffer) to high(buffer) do begin


        index := ((result and $000000FF) xor buffer[i]);
        result := ((result shr 8) and $00FF) xor crc16table[index];
    end;
    //result := not result;
    seed :=  result;
end;



initialization
begin
    CRC32 := TCRC32.Create;
end;

end.
