/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.parser;

import java.awt.Color;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;

public class DefaultParserNotice
implements ParserNotice {
    private Parser parser;
    private int level;
    private int line;
    private int offset;
    private int length;
    private boolean showInEditor;
    private Color color;
    private String message;
    private String toolTipText;

    public DefaultParserNotice(Parser parser, String string, int n) {
        this(parser, string, n, -1, -1);
    }

    public DefaultParserNotice(Parser parser, String string, int n, int n2, int n3) {
        this.parser = parser;
        this.message = string;
        this.line = n;
        this.offset = n2;
        this.length = n3;
        this.setLevel(0);
        this.setShowInEditor(true);
    }

    public int compareTo(Object object) {
        ParserNotice parserNotice;
        int n = -1;
        if (object instanceof ParserNotice && (n = this.level - (parserNotice = (ParserNotice)object).getLevel()) == 0 && (n = this.line - parserNotice.getLine()) == 0) {
            n = this.message.compareTo(parserNotice.getMessage());
        }
        return n;
    }

    public boolean containsPosition(int n) {
        return this.offset <= n && n < this.offset + this.length;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public Color getColor() {
        return this.color;
    }

    public int getLength() {
        return this.length;
    }

    public int getLevel() {
        return this.level;
    }

    public int getLine() {
        return this.line;
    }

    public String getMessage() {
        return this.message;
    }

    public int getOffset() {
        return this.offset;
    }

    public Parser getParser() {
        return this.parser;
    }

    public boolean getShowInEditor() {
        return this.showInEditor;
    }

    public String getToolTipText() {
        return this.toolTipText != null ? this.toolTipText : this.getMessage();
    }

    public int hashCode() {
        return this.line << 16 | this.offset;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setLevel(int n) {
        if (n > 2) {
            n = 2;
        } else if (n < 0) {
            n = 0;
        }
        this.level = n;
    }

    public void setShowInEditor(boolean bl) {
        this.showInEditor = bl;
    }

    public void setToolTipText(String string) {
        this.toolTipText = string;
    }

    public String toString() {
        return "Line " + this.getLine() + ": " + this.getMessage();
    }
}

