/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.xmltools;

import de.uwemock.tools.LoggingManager;
import de.uwemock.xmltools.Attribute;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XmlTools {
    private XmlTools() {
    }

    public static void writeXmlElement(XMLStreamWriter writer, String name, String text, Attribute ... attr) throws XMLStreamException {
        if (text == null || "".equals(text)) {
            writer.writeEmptyElement(name);
        } else {
            writer.writeStartElement(name);
        }
        if (attr != null) {
            Attribute[] attributeArray = attr;
            int n = attr.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute a = attributeArray[n2];
                writer.writeAttribute(a.getName(), a.getValue());
                ++n2;
            }
        }
        if (text != null && !"".equals(text)) {
            writer.writeCharacters(text);
            writer.writeEndElement();
        }
    }

    public static void writeXmlElement(XMLStreamWriter writer, String name, boolean contents, Attribute ... attr) throws XMLStreamException {
        XmlTools.writeXmlElement(writer, name, Boolean.toString(contents), attr);
    }

    public static void writeXmlElement(XMLStreamWriter writer, String name, int contents, Attribute ... attr) throws XMLStreamException {
        XmlTools.writeXmlElement(writer, name, Integer.toString(contents), attr);
    }

    public static boolean isStartElement(XMLStreamReader reader, String name) {
        return reader.isStartElement() && reader.hasName() && reader.getName().toString().equals(name);
    }

    public static boolean isEndElement(XMLStreamReader reader, String name) {
        return reader.isEndElement() && reader.hasName() && reader.getName().toString().equals(name);
    }

    public static String getOneSingleAttributeValue(XMLStreamReader reader, String name) {
        int attrCount = reader.getAttributeCount();
        int i = 0;
        while (i < attrCount) {
            if (reader.getAttributeName(i).toString().equals(name)) {
                return reader.getAttributeValue(i);
            }
            ++i;
        }
        return null;
    }

    public static Map<String, String> getAttributes(XMLStreamReader reader) {
        int attrCount = reader.getAttributeCount();
        HashMap<String, String> res = new HashMap<String, String>(attrCount);
        int i = 0;
        while (i < attrCount) {
            res.put(reader.getAttributeName(i).toString(), reader.getAttributeValue(i));
            ++i;
        }
        return Collections.unmodifiableMap(res);
    }

    public static XMLStreamReader getXMLStreamReaderFromResource(URL resource) {
        XMLStreamReader reader = null;
        InputStreamReader inputStreamReader = null;
        XMLInputFactory inputFactory = null;
        try {
            inputFactory = XMLInputFactory.newInstance();
        }
        catch (Exception e) {
            return null;
        }
        try {
            inputStreamReader = new InputStreamReader(resource.openStream(), "UTF-8");
            reader = inputFactory.createXMLStreamReader(inputStreamReader);
        }
        catch (Exception e) {
            LoggingManager.logException(XmlTools.class, e);
            return null;
        }
        return reader;
    }
}

