/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.tools;

import de.uwemock.tools.LoggingManager;
import de.uwemock.tools.Version;
import de.uwemock.xmltools.XmlTools;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class VersionManager {
    public static final String VERSION_MANAGER_PRODUCT = "product";
    public static final String VERSION_MANAGER_PRODUCT_NAME = "name";
    public static final String VERSION_MANAGER_PRODUCT_DESCRIPTION = "description";
    private static final long TIMEOUT_MILLISECONDS = 30000L;
    private static String thisProgramVersionString;
    private static Version thisProgramVersion;
    private static String serverProgramVersionString;
    private static Version serverProgramVersion;
    private static String versionUrl;
    private static Object monitor;

    static {
        monitor = new Object();
    }

    private VersionManager() {
    }

    public static int getThisProgramVersionMajor() {
        return thisProgramVersion.getMajor();
    }

    public static int getThisProgramVersionMinor() {
        return thisProgramVersion.getMinor();
    }

    public static int getThisProgramVersionRevision() {
        return thisProgramVersion.getRevision();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getServerProgramVersionString() {
        Object object = monitor;
        synchronized (object) {
            if (VersionManager.hasRetrievedLatestProgramVersion()) {
                return serverProgramVersionString;
            }
            return thisProgramVersionString;
        }
    }

    public static Version getServerProgramVersion() {
        return serverProgramVersion;
    }

    public static int getServerProgramVersionMajor() {
        return serverProgramVersion.getMajor();
    }

    public static int getServerProgramVersionMinor() {
        return serverProgramVersion.getMinor();
    }

    public static int getServerProgramVersionRevision() {
        return serverProgramVersion.getRevision();
    }

    public static String getThisProgramVersionString() {
        return thisProgramVersionString;
    }

    public static Version getThisProgramVersion() {
        return thisProgramVersion;
    }

    public static synchronized void setThisProgramVersion(int major, int minor, int revision) {
        if (major < 0 || minor < 0 || revision < 0) {
            return;
        }
        if (thisProgramVersion == null) {
            Logger logger = Logger.getLogger(VersionManager.class.getName());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Program is version " + major + "." + minor + "." + revision);
            }
            thisProgramVersion = new Version(major, minor, revision);
            thisProgramVersionString = thisProgramVersion.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setServerProgramVersion(int major, int minor, int revision) {
        if (major < 0 || minor < 0 || revision < 0) {
            return;
        }
        Object object = monitor;
        synchronized (object) {
            if (serverProgramVersion == null) {
                VersionManager.setServerProgramInformation(new Version(major, minor, revision));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setServerProgramVersion(Version version) {
        Object object = monitor;
        synchronized (object) {
            if (serverProgramVersion == null) {
                VersionManager.setServerProgramInformation(version);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setServerProgramInformation(Version version) {
        Object object = monitor;
        synchronized (object) {
            serverProgramVersion = version;
            serverProgramVersionString = serverProgramVersion.toString();
        }
    }

    public static void setVersionUrl(String url) {
        versionUrl = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getServerVersion() {
        Object object = monitor;
        synchronized (object) {
            return serverProgramVersionString;
        }
    }

    public static boolean checkForUpdate(boolean wait) {
        UpdateCheck checkForUpdate = new UpdateCheck();
        checkForUpdate.start();
        if (wait) {
            try {
                checkForUpdate.join(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (wait) {
            return checkForUpdate.isUpdateCheckSuccessful();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasRetrievedLatestProgramVersion() {
        Object object = monitor;
        synchronized (object) {
            return serverProgramVersionString != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUpdateAvailable() {
        Object object = monitor;
        synchronized (object) {
            try {
                if (serverProgramVersion == null || thisProgramVersion == null) {
                    return false;
                }
                if (serverProgramVersion.getMajor() > thisProgramVersion.getMajor()) {
                    return true;
                }
                if (serverProgramVersion.getMajor() == thisProgramVersion.getMajor()) {
                    if (serverProgramVersion.getMinor() > thisProgramVersion.getMinor()) {
                        return true;
                    }
                    if (serverProgramVersion.getMinor() == thisProgramVersion.getMinor()) {
                        return serverProgramVersion.getRevision() > thisProgramVersion.getRevision();
                    }
                }
            }
            finally {
                Throwable throwable;
                throw throwable;
            }
        }
    }

    static class UpdateCheck
    extends Thread {
        private boolean updateCheckSuccessful = false;

        UpdateCheck() {
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            Logger logger = Logger.getLogger("de.uwemock.tools.VersionManager.UpdateCheck");
            InputStream stream = null;
            XMLStreamReader reader = null;
            Version version = null;
            try {
                try {
                    URL url = new URL(versionUrl);
                    stream = url.openStream();
                    XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                    reader = inputFactory.createXMLStreamReader(stream, "UTF-8");
                    block19: while (reader.hasNext()) {
                        reader.next();
                        if (!XmlTools.isStartElement(reader, VersionManager.VERSION_MANAGER_PRODUCT)) continue;
                        while (reader.hasNext()) {
                            reader.next();
                            if (XmlTools.isEndElement(reader, VersionManager.VERSION_MANAGER_PRODUCT)) continue block19;
                            if (!XmlTools.isStartElement(reader, "version")) continue;
                            version = Version.readFromXML(reader);
                        }
                    }
                }
                catch (MalformedURLException e) {
                    logger.finer("Could not retrieve information about latest program version: Malformed URI!");
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (XMLStreamException e2) {
                            LoggingManager.logException(this.getClass(), e2);
                            return;
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    block26: {
                        logger.finer("Could not retrieve information about latest program version: IO Error!");
                        if (reader == null) break block26;
                        try {
                            reader.close();
                        }
                        catch (XMLStreamException e3) {
                            LoggingManager.logException(this.getClass(), e3);
                            return;
                        }
                    }
                    return;
                }
                catch (XMLStreamException e) {
                    block27: {
                        logger.finer("Could not retrieve information about latest program version: XML Error!");
                        if (reader == null) break block27;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        try {
                            reader.close();
                        }
                        catch (XMLStreamException e4) {
                            LoggingManager.logException(this.getClass(), e4);
                            return;
                        }
                    }
                    return;
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (XMLStreamException e) {
                        LoggingManager.logException(this.getClass(), e);
                        return;
                    }
                }
            }
            if (version != null) {
                VersionManager.setServerProgramInformation(version);
                this.updateCheckSuccessful = true;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Latest program version is " + VersionManager.getServerVersion());
                }
            }
        }

        public boolean isUpdateCheckSuccessful() {
            return this.updateCheckSuccessful;
        }
    }
}

