/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.tools;

import de.uwemock.tools.Numbers;
import de.uwemock.xmltools.XmlTools;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public final class Version {
    public static final String XML_VERSION_VERSION = "version";
    public static final String XML_VERSION_MAJOR = "major";
    public static final String XML_VERSION_MINOR = "minor";
    public static final String XML_VERSION_REVISION = "revision";
    private static final char CHAR_POINT = '.';
    private static final char CHAR_ZERO = '0';
    private int major;
    private int minor;
    private int revision;

    public Version(int major, int minor, int revision) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.major);
        builder.append('.');
        if (this.minor < 10) {
            builder.append('0');
        }
        builder.append(this.minor);
        builder.append('.');
        if (this.revision < 10) {
            builder.append('0');
        }
        builder.append(this.revision);
        return builder.toString();
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public void writeToXml(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEmptyElement(XML_VERSION_VERSION);
        writer.writeAttribute(XML_VERSION_MAJOR, Integer.toString(this.major));
        writer.writeAttribute(XML_VERSION_MINOR, Integer.toString(this.minor));
        writer.writeAttribute(XML_VERSION_REVISION, Integer.toString(this.revision));
    }

    public static Version readFromXML(XMLStreamReader reader) {
        if (XmlTools.isStartElement(reader, XML_VERSION_VERSION)) {
            Map<String, String> attributes = XmlTools.getAttributes(reader);
            int major = Numbers.getIntFromString(attributes.get(XML_VERSION_MAJOR), -1);
            int minor = Numbers.getIntFromString(attributes.get(XML_VERSION_MINOR), -1);
            int revision = Numbers.getIntFromString(attributes.get(XML_VERSION_REVISION), -1);
            if (major >= 0 && minor >= 0 && revision >= 0) {
                return new Version(major, minor, revision);
            }
        }
        return null;
    }
}

