/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.tools;

import java.util.Collection;

public class ToStringHelper {
    private final CollectionToString collectionToString;

    public ToStringHelper() {
        this(", ", "", "", "", "");
    }

    public ToStringHelper(String separator) {
        this(separator, "", "", "", "");
    }

    public ToStringHelper(String separator, String start, String end) {
        this.collectionToString = new CollectionToStringPlain(separator, start, end);
    }

    public ToStringHelper(String separator, String start, String end, String prefix, String postfix) {
        this.collectionToString = prefix != null && !prefix.isEmpty() || postfix != null && !postfix.isEmpty() ? new CollectionToStringPrefixPostfix(separator, start, end, prefix, postfix) : new CollectionToStringPlain(separator, start, end);
    }

    public String toString(Collection<?> c) {
        return this.collectionToString.toString(c);
    }

    public StringBuilder toStringBuilder(Collection<?> c) {
        return this.collectionToString.toStringBuilder(c);
    }

    public StringBuffer toStringBuffer(Collection<?> c) {
        return this.collectionToString.toStringBuffer(c);
    }

    public String toString(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Collection) {
            return this.toString((Collection)o);
        }
        return o.toString();
    }

    private abstract class CollectionToString {
        protected final String separator;
        protected final String start;
        protected final String end;
        private int initialBufferSize = 16;

        public CollectionToString(String separator, String start, String end) {
            this.separator = separator != null ? separator : "";
            this.start = start != null ? start : "";
            this.end = end != null ? end : "";
        }

        protected void setInititalBufferSize(int bufferSize) {
            if (bufferSize > this.initialBufferSize) {
                this.initialBufferSize = bufferSize;
            }
        }

        protected void setInitialBufferSize(CharSequence c) {
            this.setInititalBufferSize(c.length());
        }

        protected int getInitialBufferSize() {
            return this.initialBufferSize;
        }

        public String toString(Collection<?> c) {
            return this.toStringBuilder(c).toString();
        }

        public abstract StringBuilder toStringBuilder(Collection<?> var1);

        public StringBuffer toStringBuffer(Collection<?> c) {
            return new StringBuffer(this.toStringBuilder(c));
        }
    }

    private class CollectionToStringPlain
    extends CollectionToString {
        public CollectionToStringPlain(String separator, String start, String end) {
            super(separator, start, end);
        }

        @Override
        public StringBuilder toStringBuilder(Collection<?> c) {
            StringBuilder builder = new StringBuilder(this.getInitialBufferSize()).append(this.start);
            if (c != null) {
                for (Object o : c) {
                    if (o == null) continue;
                    builder.append(o.toString());
                    builder.append(this.separator);
                }
                int finalBuilderLength = builder.length() - this.separator.length();
                if (finalBuilderLength >= 0) {
                    builder.setLength(finalBuilderLength);
                }
            }
            builder.append(this.end);
            this.setInitialBufferSize(builder);
            return builder;
        }
    }

    private class CollectionToStringPrefixPostfix
    extends CollectionToString {
        private final String prefix;
        private final String postfix;

        public CollectionToStringPrefixPostfix(String separator, String start, String end, String prefix, String postfix) {
            super(separator, start, end);
            this.prefix = prefix != null ? prefix : "";
            this.postfix = postfix != null ? postfix : "";
        }

        @Override
        public StringBuilder toStringBuilder(Collection<?> c) {
            StringBuilder builder = new StringBuilder(this.getInitialBufferSize()).append(this.start);
            if (c != null) {
                for (Object o : c) {
                    if (o == null) continue;
                    builder.append(this.prefix);
                    builder.append(o.toString());
                    builder.append(this.postfix);
                    builder.append(this.separator);
                }
                int finalBuilderLength = builder.length() - this.separator.length();
                if (finalBuilderLength >= 0) {
                    builder.setLength(finalBuilderLength);
                }
            }
            builder.append(this.end);
            this.setInitialBufferSize(builder);
            return builder;
        }
    }
}

