/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.tools;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.logging.Logger;

public class Numbers {
    public static final BigDecimal BIG_DECIMAL_ONEHUNDRED = new BigDecimal(100);
    public static final BigDecimal BIG_DECIMAL_ZERO = new BigDecimal(0);
    public static final BigDecimal BIG_DECIMAL_ONE = new BigDecimal(1);
    public static final BigInteger INTEGER_ONEHUNDRED = new BigInteger("100");
    public static final BigInteger INTEGER_ZERO = new BigInteger("0");
    public static final BigInteger INTEGER_ONE = new BigInteger("1");
    private static final char DECIMAL_POINT = '.';
    private static final char DECIMAL_COMMA = ',';
    private static final long FACTOR_KIBI = 1024L;
    private static final long FACTOR_MIBI = 0x100000L;
    private static Logger logger = Logger.getLogger("de.uwemock.tools.Numbers");

    private Numbers() {
    }

    public static byte getByteFromString(String text, byte defaultValue) {
        byte res = defaultValue;
        try {
            res = Byte.parseByte(text);
        }
        catch (Exception e) {
            logger.severe("Exception during Conversion to byte: " + text);
        }
        return res;
    }

    public static short getShortFromString(String text, short defaultValue) {
        short res = defaultValue;
        try {
            res = Short.parseShort(text);
        }
        catch (Exception e) {
            logger.severe("Exception during Conversion to short: " + text);
        }
        return res;
    }

    public static int getIntFromString(String text, int defaultValue) {
        if (text == null) {
            return defaultValue;
        }
        int res = defaultValue;
        try {
            res = Integer.parseInt(text);
        }
        catch (Exception e) {
            logger.severe("Exception during Conversion to int: " + text);
        }
        return res;
    }

    public static long getLongFromString(String text, long defaultValue) {
        long res = defaultValue;
        try {
            res = Long.parseLong(text);
        }
        catch (Exception e) {
            logger.severe("Exception during Conversion to long: " + text);
        }
        return res;
    }

    public static float getFloatFromString(String text, float defaultValue) {
        float res = defaultValue;
        if (text != null) {
            if (text.indexOf(44) > 0) {
                text = text.replace(',', '.');
            }
            try {
                res = Float.parseFloat(text);
            }
            catch (Exception e) {
                logger.severe("Exception during Conversion to float: " + text);
            }
        }
        return res;
    }

    public static double getFloatFromString(String text, double defaultValue) {
        double res = defaultValue;
        try {
            res = Double.parseDouble(text);
        }
        catch (Exception e) {
            logger.severe("Exception during Conversion to double: " + text);
        }
        return res;
    }

    public static boolean getBooleanFromString(String text, boolean defaultValue) {
        if ("true".equals(text)) {
            return true;
        }
        if ("false".equals(text)) {
            return false;
        }
        logger.severe("Exception during Conversion to Byte: " + text);
        return defaultValue;
    }

    public static char getCharFromString(String text, char defaultValue) {
        char res = defaultValue;
        if (text.length() > 0) {
            res = text.charAt(0);
        }
        return res;
    }

    public static BigDecimal getBigDecimalFromString(String text, BigDecimal defaultValue) {
        BigDecimal res = defaultValue;
        if (text != null) {
            if (text.indexOf(44) > 0) {
                text = text.replace(',', '.');
            }
            try {
                res = new BigDecimal(text);
            }
            catch (Exception e) {
                logger.severe("Exception during Conversion to BigDecimal: " + text);
            }
        }
        return res;
    }

    public static BigInteger getBigIntegerFromString(String text, BigInteger defaultValue) {
        BigInteger res = defaultValue;
        try {
            res = new BigInteger(text);
        }
        catch (Exception e) {
            logger.severe("Exception during Conversion to BigInteger: " + text);
        }
        return res;
    }

    public static boolean isPositive(BigDecimal number) {
        return BIG_DECIMAL_ZERO.compareTo(number) < 0;
    }

    public static boolean isNegative(BigDecimal number) {
        return BIG_DECIMAL_ZERO.compareTo(number) > 0;
    }

    public static boolean isZero(BigDecimal number) {
        return BIG_DECIMAL_ZERO.compareTo(number) == 0;
    }

    public static boolean isPositive(BigInteger number) {
        return INTEGER_ZERO.compareTo(number) < 0;
    }

    public static boolean isNegative(BigInteger number) {
        return INTEGER_ZERO.compareTo(number) > 0;
    }

    public static boolean isZero(BigInteger number) {
        return INTEGER_ZERO.compareTo(number) == 0;
    }

    public static String getMiBString(long value, int decimals) {
        int mibis = (int)(value / 0x100000L);
        int kibis = (int)((value - (long)mibis * 0x100000L) / 1024L);
        String decimalsString = kibis >= 100 ? "." + Integer.toString(kibis) : (kibis >= 10 ? ".0" + Integer.toString(kibis) : ".00" + Integer.toString(kibis));
        StringBuilder result = new StringBuilder(32);
        result.append(mibis);
        result.append(decimalsString, 0, decimals + 1);
        result.append(" MiB");
        return result.toString();
    }

    public static String getKiBString(long value) {
        int kibis = (int)(value / 1024L);
        return String.valueOf(Integer.toString(kibis)) + " KiB";
    }
}

