/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.tools;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LoggingManager {
    private static Level[] levels = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.FINE, Level.FINER, Level.FINEST, Level.CONFIG, Level.INFO, Level.ALL};
    public static final String[] LEVEL_NAMES = new String[levels.length];
    private static volatile Logger logger = null;
    private static volatile Handler handler = null;

    static {
        int i = 0;
        while (i < levels.length) {
            LoggingManager.LEVEL_NAMES[i] = levels[i].getLocalizedName();
            ++i;
        }
    }

    private LoggingManager() {
    }

    public static void stopLogging() {
        if (handler != null) {
            if (logger != null) {
                logger.removeHandler(handler);
            }
            handler.close();
            handler = null;
        }
        logger = null;
    }

    public static void setupLogging(String filename, Level level, String scope) {
        LoggingManager.stopLogging();
        logger = Logger.getLogger(scope);
        try {
            handler = new FileHandler(filename, true);
            handler.setFormatter(new SimpleFormatter());
            logger.addHandler(handler);
            logger.setLevel(level);
            handler.setLevel(level);
        }
        catch (IOException e) {
            logger = null;
            e.printStackTrace();
        }
    }

    public static Level getLogLevelFromName(String name) {
        Level[] levelArray = levels;
        int n = levels.length;
        int n2 = 0;
        while (n2 < n) {
            Level level = levelArray[n2];
            if (level.getName().equals(name)) {
                return level;
            }
            ++n2;
        }
        return Level.OFF;
    }

    public static Level getLogLevelFromLocalizedName(String name) {
        Level[] levelArray = levels;
        int n = levels.length;
        int n2 = 0;
        while (n2 < n) {
            Level level = levelArray[n2];
            if (level.getLocalizedName().equals(name)) {
                return level;
            }
            ++n2;
        }
        return Level.OFF;
    }

    public static void logException(Class<?> sourceClass, Throwable exception) {
        Logger logger = Logger.getLogger(sourceClass.getName());
        StackTraceElement[] st = exception.getStackTrace();
        String res = String.valueOf(exception.getClass().getName()) + " thrown in " + sourceClass.getName() + ":\n";
        StringBuilder stackTrace = new StringBuilder(res);
        stackTrace.append(exception.getMessage());
        stackTrace.append('\n');
        StackTraceElement[] stackTraceElementArray = st;
        int n = st.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement ste = stackTraceElementArray[n2];
            stackTrace.append('\t');
            stackTrace.append(ste.toString());
            stackTrace.append('\n');
            ++n2;
        }
        logger.severe(stackTrace.toString());
    }
}

