/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.tools;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 8051841815824716075L;
    private final int MAX_CACHED_ELEMENTS;
    private String cacheTitle = "";
    private final boolean logging;
    private int calls = 0;
    private int hit = 0;
    private int miss = 0;
    private int loggingGranularity = 1000;

    public LRUCache(int maxElements) {
        this(maxElements, false);
    }

    public LRUCache(int maxElements, boolean logging) {
        super(maxElements, 1.0f, true);
        this.logging = logging;
        this.MAX_CACHED_ELEMENTS = maxElements;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() >= this.MAX_CACHED_ELEMENTS;
    }

    @Override
    public V get(Object key) {
        if (this.logging) {
            return this.loggingGet(key);
        }
        return super.get(key);
    }

    private V loggingGet(Object key) {
        Object result = super.get(key);
        if (result == null) {
            ++this.miss;
        } else {
            ++this.hit;
        }
        if (++this.calls % this.loggingGranularity == 0) {
            StringBuilder s = new StringBuilder(this.cacheTitle);
            s.append(": ");
            s.append(this.calls);
            s.append(" calls to get(), ");
            s.append(this.hit);
            s.append(" hits, ");
            s.append(this.miss);
            s.append(" misses, hit/miss-ratio: ");
            s.append((double)this.hit / (double)this.miss);
            Logger logger = Logger.getLogger(LRUCache.class.getName());
            logger.fine(s.toString());
        }
        return result;
    }

    public String getCacheTitle() {
        return this.cacheTitle;
    }

    public void setCacheTitle(String cacheTitle) {
        this.cacheTitle = cacheTitle;
    }

    public int getLoggingGranularity() {
        return this.loggingGranularity;
    }

    public void setLoggingGranularity(int loggingGranularity) {
        this.loggingGranularity = loggingGranularity;
    }
}

