/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.settings;

import de.uwemock.settings.Setting;
import de.uwemock.xmltools.XmlTools;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class SettingsCluster
extends Observable
implements Observer {
    public static final String XML_SETTINGS_CLUSTER = "settingscluster";
    public static final String XML_SETTINGS_CLUSTER_NAME = "name";
    private Map<String, Setting<?>> settings = new HashMap();
    private String clusterName;

    public SettingsCluster(String name) {
        this.clusterName = name;
    }

    public void putSetting(Setting<?> setting) {
        this.settings.put(setting.getName(), setting);
        setting.addObserver(this);
    }

    public void deleteSetting(Setting<?> setting) {
        if (setting != null) {
            setting.deleteObserver(this);
            this.settings.remove(setting.getName());
        }
    }

    public Collection<String> getSettingKeys() {
        return this.settings.keySet();
    }

    public Setting<?> getSetting(String name) {
        return this.settings.get(name);
    }

    public Object getSettingValue(String name) {
        Setting<?> setting = this.getSetting(name);
        if (setting != null) {
            return setting.getCurrentValue();
        }
        return null;
    }

    public <T> void setSettingValue(String name, T value) {
        Setting<?> setting = this.getSetting(name);
        if (setting != null) {
            if (!value.getClass().equals(setting.getCurrentValue().getClass())) {
                throw new IllegalArgumentException("Setting " + name + " in cluster " + this.clusterName + " is not of type " + value.getClass().getName());
            }
            setting.setCurrentValue(value);
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void writeToXml(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(XML_SETTINGS_CLUSTER);
        writer.writeAttribute(XML_SETTINGS_CLUSTER_NAME, this.getClusterName());
        Set<String> keys = this.settings.keySet();
        for (String key : keys) {
            Setting<?> setting = this.getSetting(key);
            if (setting == null) continue;
            setting.writeToXml(writer);
        }
        writer.writeEndElement();
    }

    /*
     * Unable to fully structure code
     */
    public void readFromXml(XMLStreamReader reader) throws XMLStreamException {
        if (!(reader.isStartElement() && reader.hasName() && reader.getName().toString().equals("settingscluster"))) {
            return;
        }
        if (this.getClusterName().equals(XmlTools.getOneSingleAttributeValue(reader, "name"))) ** GOTO lbl13
        return;
lbl-1000:
        // 1 sources

        {
            reader.next();
            if (XmlTools.isEndElement(reader, "settingscluster")) break;
            if (!reader.isStartElement()) continue;
            settingName = XmlTools.getOneSingleAttributeValue(reader, "name");
            settingValue = reader.getElementText();
            if (settingName == null || (setting = this.getSetting(settingName)) == null) continue;
            setting.setCurrentValue(settingValue);
lbl13:
            // 4 sources

            ** while (reader.hasNext())
        }
lbl14:
        // 2 sources

    }

    public void getFromCluster(SettingsCluster cluster) {
        this.settings = cluster.settings;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setChanged();
        this.notifyObservers();
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("Settings cluster for ");
        res.append(this.clusterName);
        res.append('\n');
        for (Map.Entry<String, Setting<?>> entry : this.settings.entrySet()) {
            res.append(entry.getKey());
            res.append(" -> ");
            res.append(entry.getValue().getCurrentValue());
            res.append('\n');
        }
        return res.toString();
    }
}

