/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.settings;

import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.settings.Setting;
import java.awt.FlowLayout;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class SettingPanel
extends AbstractStandardDialogPanel {
    private Setting<?> setting;
    private JComponent inputComponent = null;

    public SettingPanel(Setting<?> setting) {
        Logger logger = Logger.getLogger(SettingPanel.class.getSimpleName());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Creating setting panel for setting " + setting.getName());
        }
        this.setting = setting;
        this.setLayout(new FlowLayout(0));
        if (this.setting.getCurrentValue() instanceof Number) {
            Class<?> currentValueClass = this.setting.getCurrentValue().getClass();
            Number stepSize = 1;
            if (BigDecimal.class.equals(currentValueClass)) {
                stepSize = Double.valueOf("0.1");
            }
            if (BigInteger.class.equals(currentValueClass)) {
                stepSize = 1;
            }
            if (Integer.class.equals(currentValueClass)) {
                stepSize = 1;
            }
            Number currentValue = (Number)this.setting.getCurrentValue();
            if (BigDecimal.class.equals(currentValueClass)) {
                currentValue = Double.valueOf(this.setting.getCurrentValue().toString());
            }
            if (BigInteger.class.equals(currentValueClass)) {
                currentValue = Integer.valueOf(this.setting.getCurrentValue().toString());
            }
            Number minValue = (Number)this.setting.getMinValue();
            if (BigDecimal.class.equals(currentValueClass)) {
                minValue = Double.valueOf(this.setting.getMinValue().toString());
            }
            if (BigInteger.class.equals(currentValueClass)) {
                minValue = Integer.valueOf(this.setting.getMinValue().toString());
            }
            Number maxValue = (Number)this.setting.getMaxValue();
            if (BigDecimal.class.equals(currentValueClass)) {
                maxValue = Double.valueOf(this.setting.getMaxValue().toString());
            }
            if (BigInteger.class.equals(currentValueClass)) {
                maxValue = Integer.valueOf(this.setting.getMaxValue().toString());
            }
            SpinnerNumberModel model = new SpinnerNumberModel(currentValue, (Comparable)((Object)minValue), (Comparable)((Object)maxValue), stepSize);
            this.inputComponent = new JSpinner(model);
        }
        if (Boolean.class.equals(this.setting.getClass())) {
            this.inputComponent = new JCheckBox();
        }
        if (this.inputComponent != null) {
            if (this.setting.getDescriptionTextPrefix() != null) {
                this.add(new JLabel(this.setting.getDescriptionTextPrefix()));
            }
            this.add(this.inputComponent);
            if (this.setting.getDescriptionTextPostfix() != null) {
                this.add(new JLabel(this.setting.getDescriptionTextPostfix()));
            }
        }
    }

    @Override
    public void dialogOpens() {
        Class<?> currentValueClass = this.setting.getCurrentValue().getClass();
        Number componentValue = null;
        String currentValueAsString = this.setting.getCurrentValue().toString();
        if (BigDecimal.class.equals(currentValueClass)) {
            componentValue = Double.valueOf(currentValueAsString);
        }
        if (BigInteger.class.equals(currentValueClass)) {
            componentValue = Integer.valueOf(currentValueAsString);
        }
        if (Integer.class.equals(currentValueClass)) {
            componentValue = Integer.valueOf(currentValueAsString);
        }
        if (componentValue != null) {
            ((JSpinner)this.inputComponent).setValue(componentValue);
        }
        if (this.setting.getCurrentValue() instanceof Boolean) {
            Boolean value = (Boolean)this.setting.getCurrentValue();
            ((JCheckBox)this.inputComponent).setSelected(value);
        }
    }

    @Override
    public void saveDialogData() {
        Serializable value;
        if (this.setting.getCurrentValue() instanceof Number) {
            value = (Number)((JSpinner)this.inputComponent).getValue();
            this.setting.setCurrentValue(value.toString());
        }
        if (this.setting.getCurrentValue() instanceof Boolean) {
            value = (Boolean)this.setting.getCurrentValue();
            this.setting.setCurrentValue(((Boolean)value).toString());
        }
    }

    @Override
    public String getTitle() {
        return this.setting.getDescriptionTextPrefix();
    }
}

