/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.settings;

import de.uwemock.tools.LoggingManager;
import de.uwemock.xmltools.XmlTools;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Observable;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class Setting<T>
extends Observable {
    private static final String XML_SETTING = "setting";
    private static final String XML_SETTING_NAME = "name";
    private String descriptionTextPrefix;
    private String descriptionTextPostfix;
    private String name;
    private T currentValue;
    private T minValue;
    private T maxValue;
    private T defaultValue;

    public Setting(String name, T minValue, T maxValue, T defaultValue, String descriptionTextPrefix, String descriptionTextPostfix) {
        this.name = name;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defaultValue = defaultValue;
        this.currentValue = defaultValue;
        this.descriptionTextPrefix = descriptionTextPrefix;
        this.descriptionTextPostfix = descriptionTextPostfix;
    }

    private Setting(String name, T value) {
        this.name = name;
        this.currentValue = value;
    }

    public String getDescriptionTextPrefix() {
        return this.descriptionTextPrefix;
    }

    public String getDescriptionTextPostfix() {
        return this.descriptionTextPostfix;
    }

    public String getName() {
        return this.name;
    }

    public T getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(T newValue) {
        this.currentValue = newValue;
        this.setChanged();
        this.notifyObservers();
    }

    public void setCurrentValue(String newValue) {
        Class<?> c = null;
        if (this.minValue != null) {
            c = this.minValue.getClass();
        }
        if (this.maxValue != null) {
            c = this.maxValue.getClass();
        }
        if (this.defaultValue != null) {
            c = this.defaultValue.getClass();
        }
        if (c == null) {
            throw new IllegalArgumentException("Could not get class for setting " + this.getName());
        }
        Constructor<?> constructor = null;
        try {
            constructor = c.getConstructor(String.class);
        }
        catch (Exception e) {
            LoggingManager.logException(this.getClass(), e);
            return;
        }
        T newValueInstance = null;
        try {
            newValueInstance = (T)constructor.newInstance(newValue);
        }
        catch (InvocationTargetException e) {
            LoggingManager.logException(this.getClass(), e.getTargetException());
        }
        catch (Exception e) {
            LoggingManager.logException(this.getClass(), e);
        }
        if (newValueInstance != null) {
            this.setCurrentValue(newValueInstance);
        }
    }

    public T getMinValue() {
        return this.minValue;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void writeToXml(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(XML_SETTING);
        writer.writeAttribute(XML_SETTING_NAME, this.getName());
        writer.writeCharacters(this.getCurrentValue().toString());
        writer.writeEndElement();
    }

    static Object readFromXml(XMLStreamReader reader, Class c) throws XMLStreamException {
        if (!(reader.isStartElement() && reader.hasName() && reader.getName().toString().equals(XML_SETTING))) {
            return null;
        }
        String name = XmlTools.getOneSingleAttributeValue(reader, XML_SETTING_NAME);
        String contents = reader.getElementText();
        Setting<String> result = new Setting<String>(name, contents);
        return result;
    }
}

