/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.kernel;

import de.uwemock.kernel.Kernel;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractKernel<T>
implements Kernel<T> {
    private Map<String, Object> dataTable = new HashMap<String, Object>();
    private AtomicBoolean calculationRunning = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, Object value) {
        if (!this.calculationRunning.get()) {
            Map<String, Object> map = this.dataTable;
            synchronized (map) {
                this.dataTable.put(key, value);
                return;
            }
        }
        throw new ConcurrentModificationException();
    }

    protected void putData(String key, Object value) {
        this.dataTable.put(key, value);
    }

    @Override
    public Object get(String key) {
        return this.dataTable.get(key);
    }

    @Override
    public final T executeWork() throws Exception {
        T result = null;
        if (this.calculationRunning.compareAndSet(false, true)) {
            try {
                result = this.work();
            }
            finally {
                this.calculationRunning.set(false);
            }
            return result;
        }
        throw new ConcurrentModificationException();
    }
}

