/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.idbuilder;

import java.util.HashMap;
import java.util.Map;

public class IDPool<T> {
    private Map<Integer, T> idMap = new HashMap<Integer, T>();
    private Map<T, Integer> objectMap = new HashMap<T, Integer>();

    private Integer calculateId(T obj) {
        boolean again;
        if (obj == null) {
            return null;
        }
        int newId = 0;
        block0: do {
            again = false;
            for (Integer i : this.idMap.keySet()) {
                if (i != newId) continue;
                ++newId;
                again = true;
                continue block0;
            }
        } while (again);
        Integer id = newId;
        this.idMap.put(id, obj);
        this.objectMap.put(obj, id);
        return id;
    }

    public Integer getID(T obj) {
        if (obj == null) {
            return null;
        }
        Integer id = this.objectMap.get(obj);
        if (id == null) {
            id = this.calculateId(obj);
        }
        return id;
    }

    public T find(Integer id) {
        return this.idMap.get(id);
    }

    public void add(T obj, Integer id) {
        if (obj == null || id == null) {
            return;
        }
        T current = this.idMap.get(id);
        if (current != null && obj != current) {
            throw new IllegalArgumentException("ID value " + id.toString() + " already used for object of type " + obj.getClass().getCanonicalName());
        }
        if (current == null) {
            this.idMap.put(id, obj);
            this.objectMap.put(obj, id);
        }
    }

    public void remove(T obj) {
        Integer id;
        if (obj != null && (id = this.objectMap.get(obj)) != null) {
            this.idMap.remove(id);
            this.objectMap.remove(obj);
        }
    }
}

