/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.htmltools;

public class HtmlTools {
    public static String htmlHeadStart(String title, String css) {
        StringBuilder s = new StringBuilder(1024);
        s.append("<html>\n<head>\n<title>");
        s.append(title);
        s.append("</title>\n");
        s.append("<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\n");
        if (css != null && !css.isEmpty()) {
            s.append("<style type=\"text/css\">\n<!--\n");
            s.append(css);
            s.append("\n//-->\n</style>\n");
        }
        return s.toString();
    }

    public static String htmlHeadEnd() {
        return "</head>\n";
    }

    public static String htmlBodyStart(String bodyAtts) {
        StringBuilder s = new StringBuilder(1024);
        s.append("<body");
        if (bodyAtts != null && !bodyAtts.isEmpty()) {
            s.append(' ');
            s.append(bodyAtts);
        }
        s.append(">\n");
        return s.toString();
    }

    public static String htmlBodyEnd() {
        return "\n</body>\n</html>";
    }

    public static String htmlStyleSheet(String contents, String media) {
        StringBuilder s = new StringBuilder(1024);
        s.append("<style type=\"text/css\"");
        if (media != null && !media.isEmpty()) {
            s.append(" media=\"");
            s.append(media);
            s.append('\"');
        }
        s.append(">\n<!--\n");
        s.append(contents);
        s.append("\n//-->\n</style>\n");
        return s.toString();
    }

    public static String surroundWith(String contents, String tagName, String className, String style) {
        return "<" + tagName + (className.isEmpty() ? "" : " class=\"" + className + "\"") + (style.isEmpty() ? "" : " style=\"" + style + "\"") + ">" + contents + "</" + tagName + ">";
    }

    public static String bold(String contents) {
        return "<b>" + contents + "</b>";
    }

    public static String italic(String contents) {
        return "<i>" + contents + "</i>";
    }

    public static String link(String text, String url, String target) {
        StringBuilder s = new StringBuilder(text.length() + url.length() + 16);
        s.append("<a href=\"");
        s.append(url);
        s.append('\"');
        if (target != null && !target.isEmpty()) {
            s.append(" target=\"");
            s.append(target);
            s.append('\"');
        }
        s.append('>');
        s.append(text);
        s.append("</a>");
        return s.toString();
    }

    public static String link(String text, String url) {
        return HtmlTools.link(text, url, null);
    }

    public static void useEntities(StringBuffer s) {
        int pos = 0;
        while (pos < s.length()) {
            String replacement;
            char charAt = s.charAt(pos);
            switch (charAt) {
                case '\u00e4': {
                    replacement = "&auml;";
                    break;
                }
                case '\u00f6': {
                    replacement = "&ouml;";
                    break;
                }
                case '\u00fc': {
                    replacement = "&uuml;";
                    break;
                }
                case '\u00c4': {
                    replacement = "&Auml;";
                    break;
                }
                case '\u00d6': {
                    replacement = "&Ouml;";
                    break;
                }
                case '\u00dc': {
                    replacement = "&Uuml;";
                    break;
                }
                case '\u00df': {
                    replacement = "&szlig;";
                    break;
                }
                case '\u20ac': {
                    replacement = "&euro;";
                    break;
                }
                case '\u00a7': {
                    replacement = "&sect;";
                    break;
                }
                default: {
                    replacement = null;
                }
            }
            if (replacement != null) {
                s.replace(pos, pos + 1, replacement);
                pos += replacement.length() - 1;
            }
            ++pos;
        }
    }
}

