/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.htmltools;

import de.uwemock.htmltools.CssClass;
import de.uwemock.htmltools.HtmlBodyElement;
import de.uwemock.htmltools.HtmlContext;
import de.uwemock.htmltools.HtmlText;
import java.util.HashMap;
import java.util.Map;

public class HtmlTable
extends HtmlBodyElement {
    private static final String CSS_BORDER_SPACING = "border-spacing";
    private static final Cell emptyCell = new Cell();
    private int maxRowNumber;
    private int maxColNumber;
    private Map<Integer, Row> rows = new HashMap<Integer, Row>(1024);
    private int numHeaderRows = 0;
    private int numFooterRows = 0;
    private boolean sortable;
    private String cellpadding;
    private HtmlContext context;

    static {
        emptyCell.setContents(new HtmlText("&nbsp;"));
    }

    public HtmlTable() {
        this(null, false);
    }

    public HtmlTable(HtmlContext context) {
        this(context, false);
    }

    public HtmlTable(HtmlContext context, boolean sortable) {
        this.context = context;
        if (sortable && context != null) {
            this.sortable = sortable;
            this.context.addJavaScriptLib("TableSortLib");
            if (this.sortable) {
                super.addCssClass("sortable");
            }
        }
    }

    public void setContents(int x, int y, String contents) {
        this.getCellAt(x, y).setContents(new HtmlText(contents));
    }

    public void setContents(int x, int y, HtmlBodyElement contents) {
        this.getCellAt(x, y).setContents(contents);
    }

    public void setBgColor(int x, int y, String bgColor) {
        this.getCellAt(x, y).setBgColor(bgColor);
    }

    public String getBorder() {
        return this.getCssStyle("border-left");
    }

    public void setBorder(String border) {
        this.addCssStyle("border-left", border);
        this.addCssStyle("border-top", border);
    }

    public void setCssClass(int x, int y, String cssClass) {
        this.getCellAt(x, y).setCssClass(cssClass);
    }

    public void addCssClass(int x, int y, String cssClass) {
        this.getCellAt(x, y).addCssClass(cssClass);
    }

    public void setCssStyle(int x, int y, String cssStyle) {
        this.getCellAt(x, y).setCssStyle(cssStyle);
    }

    public void setAlign(int x, int y, String align) {
        this.getCellAt(x, y).setAlign(align);
    }

    public void setVAlign(int x, int y, String valign) {
        this.getCellAt(x, y).setVAlign(valign);
    }

    public void setHeadline(int x, int y, boolean headline) {
        this.getCellAt(x, y).setHeadline(headline);
    }

    public void setNoWrap(int x, int y, boolean noWrap) {
        this.getCellAt(x, y).setNoWrap(noWrap);
    }

    public void setColspan(int x, int y, int colspan) {
        this.getCellAt(x, y).setColspan(colspan);
    }

    public String getCellpadding() {
        return this.cellpadding;
    }

    public void setCellpadding(String cellpadding) {
        this.cellpadding = cellpadding;
    }

    public String getCellspacing() {
        return this.getCssStyle(CSS_BORDER_SPACING);
    }

    public void setCellspacing(String cellspacing) {
        this.addCssStyle(CSS_BORDER_SPACING, cellspacing);
    }

    public void setRowAsHeader(int rowIndex, boolean isHeader) {
        Row row = this.getRow(rowIndex);
        if (!row.isHeader() && isHeader) {
            ++this.numHeaderRows;
        }
        if (row.isHeader() && !isHeader) {
            --this.numHeaderRows;
        }
        row.setHeader(isHeader);
    }

    public void setRowAsFooter(int rowIndex, boolean isFooter) {
        Row row = this.getRow(rowIndex);
        if (!row.isFooter() && isFooter) {
            ++this.numFooterRows;
        }
        if (row.isFooter() && !isFooter) {
            --this.numFooterRows;
        }
        row.setFooter(isFooter);
    }

    public void setRowCssClass(int rowIndex, String cssClass) {
        this.getRow(rowIndex).setCssClass(cssClass);
    }

    public void addRowCssClass(int rowIndex, String cssClass) {
        this.getRow(rowIndex).addCssClass(cssClass);
    }

    public boolean isRowHeader(int rowIndex) {
        return this.getRow(rowIndex).isHeader();
    }

    public Row getRow(int y) {
        Integer rowIndex;
        Row row;
        if (y > this.maxRowNumber) {
            this.maxRowNumber = y;
        }
        if ((row = this.rows.get(rowIndex = Integer.valueOf(y))) == null) {
            row = new Row();
            this.rows.put(rowIndex, row);
        }
        return row;
    }

    public Cell getCellAt(int x, int y) {
        if (x > this.maxColNumber) {
            this.maxColNumber = x;
        }
        Row row = this.getRow(y);
        return row.get(x);
    }

    @Override
    public CharSequence toHtmlString() {
        Row row;
        int y;
        StringBuilder s = this.getStartTag("table");
        if (this.numHeaderRows > 0) {
            s.append("\n<thead>\n");
            y = 0;
            while (y <= this.maxRowNumber) {
                row = this.getRow(y);
                if (row.isHeader()) {
                    s.append(row.createHtmlRow(this.maxColNumber + 1, this.getBorder(), this.cellpadding));
                }
                ++y;
            }
            s.append("</thead>\n");
        }
        s.append("<tbody>\n");
        y = 0;
        while (y <= this.maxRowNumber) {
            row = this.getRow(y);
            if (!row.isHeader() && !row.isFooter) {
                s.append(row.createHtmlRow(this.maxColNumber + 1, this.getBorder(), this.cellpadding));
            }
            ++y;
        }
        s.append("</tbody>\n");
        if (this.numFooterRows > 0) {
            s.append("\n<tfoot>\n");
            y = 0;
            while (y <= this.maxRowNumber) {
                row = this.getRow(y);
                if (row.isFooter()) {
                    s.append(row.createHtmlRow(this.maxColNumber + 1, this.getBorder(), this.cellpadding));
                }
                ++y;
            }
            s.append("</tfoot>\n");
        }
        s.append(this.getEndTag());
        return s;
    }

    public String toString() {
        return this.toHtmlString().toString();
    }

    @Override
    public boolean isHtml5() {
        return true;
    }

    private static class Cell {
        private static final String CSS_PADDING_WITH_COLON = "padding:";
        private static final String CSS_VERTICAL_ALIGN_WITH_COLON = "vertical-align:";
        private static final String CSS_TEXT_ALIGN_WITH_COLON = "text-align:";
        private static final String CSS_BACKGROUND_COLOR_WITH_COLON = "background-color:";
        private static final char SEMICOLON = ';';
        private static final String CSS_NOWRAP = "white-space:nowrap;";
        private int colspan = 1;
        private HtmlBodyElement contents;
        private CssClass cssClass = new CssClass();
        private String cssStyle = "";
        private String bgColor = "";
        private String align = "";
        private String valign = "";
        private boolean noWrap;
        private boolean headline;

        private Cell() {
        }

        public int getColspan() {
            return this.colspan;
        }

        public void setColspan(int colspan) {
            if (colspan > 0) {
                this.colspan = colspan;
            }
        }

        public String getBgColor() {
            return this.bgColor;
        }

        public void setBgColor(String bgColor) {
            if (bgColor != null) {
                this.bgColor = bgColor;
            }
        }

        public boolean isNoWrap() {
            return this.noWrap;
        }

        public void setNoWrap(boolean noWrap) {
            this.noWrap = noWrap;
        }

        public boolean isHeadline() {
            return this.headline;
        }

        public void setHeadline(boolean headline) {
            this.headline = headline;
        }

        public HtmlBodyElement getContents() {
            return this.contents;
        }

        public void setContents(HtmlBodyElement contents) {
            if (contents != null) {
                this.contents = contents;
            }
        }

        public String getCssClass() {
            return this.cssClass.toString();
        }

        public void setCssClass(String cssClass) {
            this.cssClass.setClass(cssClass);
        }

        public void addCssClass(String cssClass) {
            this.cssClass.addClass(cssClass);
        }

        public void setCssStyle(String cssStyle) {
            if (cssStyle != null) {
                this.cssStyle = cssStyle;
            }
        }

        public String getAlign() {
            return this.align;
        }

        public void setAlign(String align) {
            if (align != null) {
                this.align = align;
            }
        }

        public String getVAlign() {
            return this.valign;
        }

        public void setVAlign(String valign) {
            if (valign != null) {
                this.valign = valign;
            }
        }

        public CharSequence toHtmlString(String border, String padding) {
            CharSequence contentsAsHtml = this.contents.toHtmlString();
            StringBuilder s = new StringBuilder(contentsAsHtml.length() + this.bgColor.length() + this.cssClass.length() + 32);
            s.append(this.isHeadline() ? "<th" : "<td");
            if (this.colspan > 1) {
                s.append(" colspan=\"");
                s.append(this.colspan);
                s.append('\"');
            }
            if (!this.cssClass.isEmpty()) {
                s.append(" class=\"" + this.cssClass + "\"");
            }
            StringBuilder style = new StringBuilder(this.cssStyle);
            if (this.noWrap) {
                style.append(CSS_NOWRAP);
            }
            if (!this.bgColor.isEmpty()) {
                style.append(CSS_BACKGROUND_COLOR_WITH_COLON);
                style.append(this.bgColor);
                style.append(';');
            }
            if (!this.align.isEmpty()) {
                style.append(CSS_TEXT_ALIGN_WITH_COLON);
                style.append(this.align);
                style.append(';');
            }
            if (!this.valign.isEmpty()) {
                style.append(CSS_VERTICAL_ALIGN_WITH_COLON);
                style.append(this.valign);
                style.append(';');
            }
            if (border != null && !border.isEmpty()) {
                style.append("border-bottom:");
                style.append(border);
                style.append(';');
                style.append("border-right:");
                style.append(border);
                style.append(';');
            }
            if (padding != null && !padding.isEmpty()) {
                style.append(CSS_PADDING_WITH_COLON);
                style.append(padding);
                style.append(';');
            }
            if (style.length() > 0) {
                s.append(" style=\"");
                s.append((CharSequence)style);
                s.append('\"');
            }
            s.append(">");
            s.append(contentsAsHtml);
            s.append(this.isHeadline() ? "</th>" : "</td>");
            return s;
        }
    }

    private static class Row {
        private Map<Integer, Cell> cells = new HashMap<Integer, Cell>(128);
        private boolean isHeader = false;
        private boolean isFooter = false;
        private CssClass cssClass = new CssClass();

        private Row() {
        }

        public boolean isHeader() {
            return this.isHeader;
        }

        public void setHeader(boolean isHeader) {
            this.isHeader = isHeader;
        }

        public boolean isFooter() {
            return this.isFooter;
        }

        public void setFooter(boolean isFooter) {
            this.isFooter = isFooter;
        }

        public String getCssClass() {
            return this.cssClass.toString();
        }

        public void setCssClass(String cssClass) {
            this.cssClass.setClass(cssClass);
        }

        public void addCssClass(String cssClass) {
            this.cssClass.addClass(cssClass);
        }

        public Cell get(int x) {
            Integer index = x;
            Cell c = this.cells.get(index);
            if (c == null) {
                c = new Cell();
                this.cells.put(index, c);
            }
            return c;
        }

        public CharSequence createHtmlRow(int cols, String border, String padding) {
            StringBuilder s = new StringBuilder(cols * 128);
            int colsUsed = 0;
            if (!this.cssClass.isEmpty()) {
                s.append("<tr class=\"");
                s.append(this.cssClass);
                s.append("\">\n");
            } else {
                s.append("<tr>\n");
            }
            int x = 0;
            while (x < cols) {
                Cell cell = this.get(x);
                if (cell != null && cell.getContents() != null) {
                    s.append(cell.toHtmlString(border, padding));
                    colsUsed += cell.getColspan();
                } else {
                    s.append(emptyCell.toHtmlString(border, padding));
                    ++colsUsed;
                }
                if (colsUsed >= cols) break;
                ++x;
            }
            s.append("\n</tr>\n");
            return s;
        }
    }
}

