/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.htmltools;

import de.uwemock.htmltools.HtmlBodyElement;
import de.uwemock.tools.LoggingManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class HtmlJavaScriptLibs
extends HtmlBodyElement {
    public static final String LIB_TABLESORT = "TableSortLib";
    public static final String LIB_JQUERY = "jQuery";
    public static final String LIB_FORMAT_WRITE = "FormatWrite";
    private static final String JS_START_HTML4 = "<script type=\"text/javascript\">";
    private static final String JS_START_HTML5 = "<script>";
    private static final String JS_END = "</script>";
    private static final Map<String, String> AVAILABLE_LIBS = new HashMap<String, String>();
    private ArrayList<String> libsLinear = new ArrayList();
    private Map<String, String> libs = new HashMap<String, String>();

    static {
        AVAILABLE_LIBS.put(LIB_TABLESORT, HtmlJavaScriptLibs.libFromResource("/de/uwemock/htmltools/libs/TableSorterLib.js").toString());
        AVAILABLE_LIBS.put(LIB_JQUERY, HtmlJavaScriptLibs.libFromResource("/de/uwemock/htmltools/libs/jQuery.js").toString());
        AVAILABLE_LIBS.put(LIB_FORMAT_WRITE, HtmlJavaScriptLibs.libFromResource("/de/uwemock/htmltools/libs/formatWrite.js").toString());
    }

    public void addJavaScriptLibrary(String id, String lib) {
        this.removeJavaScriptLibrary(id);
        this.libs.put(id, lib);
        this.libsLinear.add(lib);
    }

    public void addJavaScriptLibrary(String id) {
        String lib = AVAILABLE_LIBS.get(id);
        if (lib != null) {
            this.addJavaScriptLibrary(id, lib);
        }
    }

    public void removeJavaScriptLibrary(String id) {
        String oldValue = this.libs.get(id);
        if (oldValue != null) {
            this.libs.remove(id);
            this.libsLinear.remove(oldValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertLibs(StringBuffer html, boolean html5) {
        Map<String, String> map = this.libs;
        synchronized (map) {
            if (this.libs.size() == 0) {
                return;
            }
            int pos = html.indexOf("</head>");
            if (pos < 0) {
                pos = html.indexOf("<body>");
            }
            if (pos < 0) {
                pos = html.indexOf("<html>") + 6;
            }
            if (pos < 0) {
                pos = 0;
            }
            html.insert(pos, this.getLibsText(html5));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertLibs(StringBuilder html, boolean html5) {
        Map<String, String> map = this.libs;
        synchronized (map) {
            if (this.libs.size() == 0) {
                return;
            }
            int pos = html.indexOf("</head>");
            if (pos < 0) {
                pos = html.indexOf("<body>");
            }
            if (pos < 0) {
                pos = html.indexOf("<html>") + 6;
            }
            if (pos < 0) {
                pos = 0;
            }
            html.insert(pos, this.getLibsText(html5));
        }
    }

    private StringBuffer getLibsText(boolean html5) {
        int size = this.libs.size() * 2 + JS_START_HTML4.length() + JS_END.length() + 4;
        for (String lib : this.libs.values()) {
            size += lib.length();
        }
        StringBuffer libsText = new StringBuffer(size);
        if (html5) {
            libsText.append(JS_START_HTML5);
        } else {
            libsText.append(JS_START_HTML4);
        }
        libsText.append('\n');
        for (String lib : this.libsLinear) {
            libsText.append(lib);
            libsText.append('\n');
        }
        libsText.append(JS_END);
        libsText.append('\n');
        return libsText;
    }

    private static StringBuffer libFromResource(String name) {
        StringBuffer contents;
        block13: {
            contents = null;
            URL resource = HtmlJavaScriptLibs.class.getResource(name);
            URLConnection con = null;
            BufferedReader b = null;
            try {
                try {
                    String line;
                    con = resource.openConnection();
                    int size = con.getContentLength();
                    contents = new StringBuffer(size > 0 ? size : 4096);
                    b = new BufferedReader(new InputStreamReader((InputStream)con.getContent()));
                    while ((line = b.readLine()) != null) {
                        contents.append(line);
                        contents.append('\n');
                    }
                }
                catch (IOException e) {
                    LoggingManager.logException(HtmlJavaScriptLibs.class, e);
                    if (b == null) break block13;
                    try {
                        b.close();
                    }
                    catch (IOException e2) {
                        LoggingManager.logException(HtmlJavaScriptLibs.class, e2);
                    }
                }
            }
            finally {
                if (b != null) {
                    try {
                        b.close();
                    }
                    catch (IOException e) {
                        LoggingManager.logException(HtmlJavaScriptLibs.class, e);
                    }
                }
            }
        }
        return contents;
    }

    public CharSequence toHtmlString(boolean html5) {
        return this.getLibsText(html5);
    }

    @Override
    public CharSequence toHtmlString() {
        return this.getLibsText(false);
    }

    @Override
    public boolean isHtml5() {
        return true;
    }
}

