/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.htmltools;

import de.uwemock.htmltools.CssStyleSheet;
import de.uwemock.htmltools.HtmlBodyElement;
import de.uwemock.htmltools.HtmlFactory;
import de.uwemock.htmltools.HtmlHeadElement;
import de.uwemock.htmltools.HtmlJavaScriptLibs;
import de.uwemock.htmltools.HtmlSimpleElement;
import de.uwemock.htmltools.HtmlTools;
import java.util.ArrayList;

public class HtmlContext {
    private static final String DOCTYPE_HTML5 = "<!DOCTYPE html>\n";
    private static final String DOCTYPE_HTML4_TRANSITIONAL = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n";
    private HtmlJavaScriptLibs jsLibs = new HtmlJavaScriptLibs();
    private String title;
    private ArrayList<HtmlHeadElement> headElements = new ArrayList();
    private ArrayList<HtmlBodyElement> bodyElements = new ArrayList();

    public void setTitle(String title) {
        this.title = title;
    }

    public void addStyleSheet(String media, String contents) {
        this.headElements.add(new CssStyleSheet(media, contents));
    }

    public void addStyleSheet(CssStyleSheet styleSheet) {
        this.headElements.add(styleSheet);
    }

    public void addElement(HtmlBodyElement element) {
        this.bodyElements.add(element);
    }

    public void addElement(String tagName, String id, String className, String style, String textContents) {
        this.bodyElements.add(new HtmlSimpleElement(tagName, id, className, style, textContents));
    }

    public void addElement(String tagName, String id, String className, String style, HtmlBodyElement htmlContents) {
        this.addElement(tagName, id, className, style, htmlContents.toHtmlString().toString());
    }

    public void addLineBreak() {
        this.bodyElements.add(HtmlFactory.BR);
    }

    public void addJavaScriptLib(String id, String lib) {
        this.jsLibs.addJavaScriptLibrary(id, lib);
    }

    public void addJavaScriptLib(String id) {
        this.jsLibs.addJavaScriptLibrary(id);
    }

    public StringBuffer toStringBuffer() {
        StringBuffer s = new StringBuffer(this.getDoctype());
        s.append("<html>\n<head>\n<title>");
        if (this.title != null && !this.title.isEmpty()) {
            s.append(this.title);
        }
        s.append("</title>\n");
        s.append("<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\n");
        for (HtmlHeadElement styleSheet : this.headElements) {
            s.append(styleSheet.toHtmlString());
            s.append('\n');
        }
        s.append(this.jsLibs.toHtmlString(this.isHtml5()));
        s.append("</head>\n");
        s.append("<body>");
        for (HtmlBodyElement element : this.bodyElements) {
            s.append(element.toHtmlString());
            s.append('\n');
        }
        s.append("</body>\n</html>\n");
        HtmlTools.useEntities(s);
        return s;
    }

    public String getDoctype() {
        if (this.isHtml5()) {
            return DOCTYPE_HTML5;
        }
        return DOCTYPE_HTML4_TRANSITIONAL;
    }

    public boolean isHtml5() {
        for (HtmlHeadElement htmlHeadElement : this.headElements) {
            if (htmlHeadElement.isHtml5()) continue;
            return false;
        }
        for (HtmlBodyElement htmlBodyElement : this.bodyElements) {
            if (htmlBodyElement.isHtml5()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toStringBuffer().toString();
    }
}

