/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.htmltools;

import de.uwemock.htmltools.CssClass;
import de.uwemock.htmltools.HtmlElement;
import java.util.HashMap;
import java.util.Map;

public abstract class HtmlBodyElement
implements HtmlElement {
    private String id;
    private CssClass cssClass = new CssClass();
    private Map<String, String> cssStyle = new HashMap<String, String>();
    private String endTag;

    public HtmlBodyElement() {
    }

    public HtmlBodyElement(String id, CharSequence cssClass) {
        this.id = id;
        this.cssClass.setClass(cssClass.toString());
    }

    public HtmlBodyElement(String id, String cssClass) {
        this.id = id;
        this.cssClass.setClass(cssClass);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public StringBuffer getCssClass() {
        return this.cssClass.toStringBuffer();
    }

    public void setCssClass(String cssClass) {
        this.cssClass.setClass(cssClass);
    }

    public void addCssClass(String cssClass) {
        this.cssClass.addClass(cssClass);
    }

    public void removeCssClass(String cssClass) {
        this.cssClass.removeClass(cssClass);
    }

    public String getCssStyle(String key) {
        return this.cssStyle.get(key);
    }

    public CharSequence getCssStyle() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : this.cssStyle.entrySet()) {
            result.append(entry.getKey());
            result.append(':');
            result.append(entry.getValue());
            result.append(';');
        }
        return result;
    }

    public void addCssStyle(String key, String value) {
        if (value == null || value.isEmpty()) {
            this.removeCssStyle(key);
        } else {
            this.cssStyle.put(key, value);
        }
    }

    public void removeCssStyle(String key) {
        this.cssStyle.remove(key);
    }

    public void clearCssClass() {
        this.cssClass.clearCssClass();
    }

    public StringBuilder getAttributeString() {
        StringBuilder result = new StringBuilder();
        HtmlBodyElement.appendAttribute(result, "id", this.id);
        HtmlBodyElement.appendAttribute(result, "class", this.cssClass.toString());
        HtmlBodyElement.appendAttribute(result, "style", this.getCssStyle().toString());
        return result;
    }

    public StringBuilder getStartTag(String tagname) {
        StringBuilder endTag = new StringBuilder(tagname.length() + 3);
        endTag.append("</");
        endTag.append(tagname);
        endTag.append('>');
        this.endTag = endTag.toString();
        StringBuilder result = new StringBuilder();
        result.append('<');
        result.append(tagname);
        result.append((CharSequence)this.getAttributeString());
        result.append('>');
        return result;
    }

    public String getEndTag() {
        if (this.endTag != null) {
            return this.endTag;
        }
        return "";
    }

    protected static void appendAttribute(StringBuilder appendable, String key, String value) {
        if (key != null && !key.isEmpty() && value != null && !value.isEmpty()) {
            appendable.append(' ');
            appendable.append(key);
            appendable.append("=\"");
            appendable.append(value);
            appendable.append('\"');
        }
    }
}

