/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools.validators;

import de.uwemock.guitools.validators.Validator;
import de.uwemock.guitools.validators.ValidatorContext;
import de.uwemock.guitools.validators.ValidatorException;
import de.uwemock.guitools.validators.ValidatorOnlyComplainsException;
import java.util.Observable;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;

public class ValidatorHook
extends Observable
implements Document {
    private final JTextField textField;
    private final Document document;
    private final Validator validator;
    private final ValidatorContext context;

    public ValidatorHook(JTextField textField, Validator validator) {
        this.document = textField.getDocument();
        this.textField = textField;
        this.validator = validator;
        this.context = new ValidatorContext(this.document, this.textField);
        this.textField.setDocument(this);
    }

    public Document getDocument() {
        return this.document;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet as) throws BadLocationException {
        try {
            this.context.init(offset, str, str.length());
            this.validator.insert(this.context);
        }
        catch (ValidatorOnlyComplainsException e) {
            this.setChanged();
            this.notifyObservers(e);
        }
        catch (ValidatorException e) {
            this.setChanged();
            this.notifyObservers(e);
            return;
        }
        this.document.insertString(offset, this.context.str, as);
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        try {
            this.context.init(offset, null, length);
            this.validator.remove(this.context);
        }
        catch (ValidatorOnlyComplainsException e) {
            this.setChanged();
            this.notifyObservers(e);
        }
        catch (ValidatorException e) {
            this.setChanged();
            this.notifyObservers(e);
            return;
        }
        this.document.remove(offset, length);
    }

    @Override
    public void addDocumentListener(DocumentListener listener) {
        this.document.addDocumentListener(listener);
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener listener) {
        this.document.addUndoableEditListener(listener);
    }

    @Override
    public Position createPosition(int offs) throws BadLocationException {
        return this.document.createPosition(offs);
    }

    @Override
    public Element getDefaultRootElement() {
        return this.document.getDefaultRootElement();
    }

    @Override
    public Position getEndPosition() {
        return this.document.getEndPosition();
    }

    @Override
    public int getLength() {
        return this.document.getLength();
    }

    @Override
    public Object getProperty(Object key) {
        return this.document.getProperty(key);
    }

    @Override
    public Element[] getRootElements() {
        return this.document.getRootElements();
    }

    @Override
    public Position getStartPosition() {
        return this.document.getStartPosition();
    }

    @Override
    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        this.document.getText(offset, length, txt);
    }

    @Override
    public String getText(int offset, int length) throws BadLocationException {
        return this.document.getText(offset, length);
    }

    @Override
    public void putProperty(Object key, Object value) {
        this.document.putProperty(key, value);
    }

    @Override
    public void removeDocumentListener(DocumentListener listener) {
        this.document.removeDocumentListener(listener);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.document.removeUndoableEditListener(listener);
    }

    @Override
    public void render(Runnable r) {
        this.document.render(r);
    }
}

