/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools.validators;

import de.uwemock.guitools.validators.AbstractValidator;
import de.uwemock.guitools.validators.ValidatorContext;
import de.uwemock.guitools.validators.ValidatorException;
import java.math.BigDecimal;
import javax.swing.text.BadLocationException;

public class FloatValidator
extends AbstractValidator {
    private int decimals = -1;
    private BigDecimal minInput = null;
    private BigDecimal maxInput = null;

    public FloatValidator() {
        super(2);
    }

    public FloatValidator(int type) {
        super(type);
    }

    public FloatValidator(int type, int decimals) {
        this(type);
        this.decimals = decimals;
    }

    public FloatValidator(int type, BigDecimal minInput) {
        this(type);
        this.minInput = minInput;
    }

    public FloatValidator(int type, BigDecimal minInput, BigDecimal maxInput) {
        this(type);
        this.minInput = minInput;
        this.maxInput = maxInput;
    }

    public FloatValidator(int type, double minInput) {
        this(type);
        this.minInput = new BigDecimal(minInput);
    }

    public FloatValidator(int type, double minInput, double maxInput) {
        this(type);
        this.minInput = new BigDecimal(minInput);
        this.maxInput = new BigDecimal(maxInput);
    }

    public FloatValidator(int type, int decimals, BigDecimal minInput) {
        this(type, decimals);
        this.minInput = minInput;
    }

    public FloatValidator(int type, int decimals, BigDecimal minInput, BigDecimal maxInput) {
        this(type, decimals);
        this.minInput = minInput;
        this.maxInput = maxInput;
    }

    public FloatValidator(int type, int decimals, double minInput) {
        this(type, decimals);
        this.minInput = new BigDecimal(minInput);
    }

    public FloatValidator(int type, int decimals, double minInput, double maxInput) {
        this(type, decimals);
        this.minInput = new BigDecimal(minInput);
        this.maxInput = new BigDecimal(maxInput);
    }

    @Override
    public void insert(ValidatorContext context) throws ValidatorException {
        int pos;
        StringBuilder sb;
        try {
            sb = new StringBuilder(context.document.getText(0, context.document.getLength()));
        }
        catch (BadLocationException b) {
            sb = new StringBuilder();
        }
        context.str = context.str.replace(",", ".");
        sb.insert(context.offset, context.str);
        String stringToTest = sb.toString();
        if (stringToTest.length() == 0 || "-".equals(stringToTest) || "+".equals(stringToTest)) {
            return;
        }
        try {
            Double.parseDouble(stringToTest);
            BigDecimal value = new BigDecimal(stringToTest);
            if (this.minInput != null && value.compareTo(this.minInput) < 0) {
                throw new Exception();
            }
            if (this.maxInput != null && value.compareTo(this.maxInput) > 0) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.throwException();
        }
        if (this.decimals >= 0 && (pos = stringToTest.indexOf(".")) >= 0 && pos + this.decimals + 1 < stringToTest.length()) {
            this.throwException();
        }
    }
}

