/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;

public class TableColumnsSizer {
    public int getColumnPreferredWidthToFit(JTable table, int columnIndex, boolean includeColumnHeader, boolean includeCellEditor) {
        int columnWidth = includeColumnHeader ? this.getColumnHeaderPreferredWidth(table, columnIndex) : 0;
        int rowIndex = 0;
        while (rowIndex < table.getRowCount()) {
            columnWidth = Math.max(this.getColumnPreferredWidthAtRow(table, rowIndex, columnIndex, includeCellEditor), columnWidth);
            ++rowIndex;
        }
        return columnWidth;
    }

    private int getColumnHeaderPreferredWidth(JTable table, int columnIndex) {
        return table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)table, (Object)table.getModel().getColumnName((int)columnIndex), (boolean)false, (boolean)false, (int)0, (int)columnIndex).getPreferredSize().width + 2;
    }

    private int getColumnPreferredWidthAtRow(JTable table, int rowIndex, int columnIndex, boolean includeCellEditor) {
        Component editor;
        int width = table.getCellRenderer((int)rowIndex, (int)columnIndex).getTableCellRendererComponent((JTable)table, (Object)table.getModel().getValueAt((int)rowIndex, (int)this.getModelColumnIndex((JTable)table, (int)columnIndex)), (boolean)false, (boolean)false, (int)rowIndex, (int)this.getModelColumnIndex((JTable)table, (int)columnIndex)).getPreferredSize().width + 4;
        if (includeCellEditor && table.isCellEditable(rowIndex, columnIndex) && (editor = table.getCellEditor(rowIndex, columnIndex).getTableCellEditorComponent(table, table.getModel().getValueAt(rowIndex, this.getModelColumnIndex(table, columnIndex)), false, rowIndex, this.getModelColumnIndex(table, columnIndex))) != null) {
            width = Math.max(width, editor.getPreferredSize().width);
        }
        return width;
    }

    private int getModelColumnIndex(JTable table, int columnIndex) {
        return table.getColumnModel().getColumn(columnIndex).getModelIndex();
    }

    public Dimension getPreferredScrollableViewportSize(JTable table, int visibleRowCount) {
        Dimension result = new Dimension(0, 0);
        int columnIndex = 0;
        int columnCount = this.getMaxColumnCountForSizingColumns(table);
        while (columnIndex < columnCount) {
            result.width = result.width + this.getColumnPreferredWidthToFit(table, columnIndex, true, table.getRowCount() > 0 ? table.getModel().isCellEditable(0, columnIndex) : false);
            ++columnIndex;
        }
        result.height = visibleRowCount * table.getRowHeight();
        return result;
    }

    public void setColumnsWidthToFit(JTable table, boolean includeColumnHeader, boolean includeCellEditor) {
        int columnIndex = 0;
        int columnCount = this.getMaxColumnCountForSizingColumns(table);
        while (columnIndex < columnCount) {
            if (this.preferredWidthIsSettable(table, columnIndex)) {
                this.setColumnPreferredWidth(table, columnIndex, this.getColumnPreferredWidthToFit(table, columnIndex, includeColumnHeader, includeCellEditor));
            }
            ++columnIndex;
        }
    }

    private int getMaxColumnCountForSizingColumns(JTable table) {
        return Math.min(table.getColumnModel().getColumnCount(), table.getModel().getColumnCount());
    }

    private boolean preferredWidthIsSettable(JTable table, int columnIndex) {
        return table.getColumnModel().getColumn(columnIndex).getMaxWidth() != 0;
    }

    private void setColumnPreferredWidth(JTable table, int column, int columnWidth) {
        table.getColumnModel().getColumn(column).setPreferredWidth(columnWidth);
    }
}

