/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import chrriis.dj.swingsuite.SwingSuiteUtilities;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;

public class TableColumnOrderManager
implements TableColumnModelListener,
MouseListener {
    private List<JTable> tables = new ArrayList<JTable>();
    private int numColumns = -1;
    private int fromColumn = -1;
    private int toColumn = -1;

    public void add(JTable table) {
        if (this.tables.contains(table)) {
            return;
        }
        if (this.numColumns < 0) {
            this.numColumns = table.getColumnCount();
        } else if (this.numColumns != table.getColumnCount()) {
            throw new RuntimeException("Table structure differs in TableColumnOrderManager");
        }
        table.getColumnModel().addColumnModelListener(this);
        table.getTableHeader().addMouseListener(this);
        if (this.tables.size() > 0) {
            this.setColumnOrder(table, this.getCurrentOrder());
        }
        this.tables.add(table);
    }

    public void remove(JTable table) {
        if (this.tables.remove(table) && this.tables.size() == 0) {
            this.numColumns = -1;
        }
    }

    private void fireColumnMoved(JTable source, int from, int to) {
        for (JTable table : this.tables) {
            if (table == source) continue;
            table.getColumnModel().moveColumn(from, to);
        }
    }

    private int[] getCurrentOrder(JTable table) {
        if (this.numColumns > 0) {
            int[] result = new int[this.numColumns];
            int i = 0;
            while (i < this.numColumns) {
                result[i] = table.convertColumnIndexToModel(i);
                ++i;
            }
            return result;
        }
        return null;
    }

    private int[] getCurrentOrder() {
        if (this.tables.size() > 0) {
            JTable table = this.tables.get(0);
            return this.getCurrentOrder(table);
        }
        return null;
    }

    public void resetColumnOrder() {
        int[] canonicalOrder = new int[this.numColumns];
        int i = 0;
        while (i < canonicalOrder.length) {
            canonicalOrder[i] = i;
            ++i;
        }
        this.setColumnOrder(canonicalOrder);
    }

    public void setColumnOrder(JTable table, int[] targetColumnOrder) {
        if (table.getColumnCount() != targetColumnOrder.length) {
            return;
        }
        int i = 0;
        while (i < this.numColumns) {
            if (table.convertColumnIndexToModel(i) != targetColumnOrder[i]) {
                int from = -1;
                int j = 0;
                while (j < this.numColumns) {
                    if (table.convertColumnIndexToModel(j) == targetColumnOrder[i]) {
                        from = j;
                        break;
                    }
                    ++j;
                }
                int to = i;
                table.getColumnModel().moveColumn(from, to);
            }
            ++i;
        }
    }

    public void setColumnOrder(JTable table, Collection<Integer> columnOrder) {
        int[] columnsByNumber = new int[columnOrder.size()];
        int index = 0;
        Iterator<Integer> i = columnOrder.iterator();
        while (i.hasNext()) {
            columnsByNumber[index++] = i.next();
        }
        this.setColumnOrder(table, columnsByNumber);
    }

    public void setColumnOrder(int[] targetColumnOrder) {
        if (this.tables.size() == 0) {
            return;
        }
        boolean[] found = new boolean[targetColumnOrder.length];
        int i = 0;
        while (i < targetColumnOrder.length) {
            if (targetColumnOrder[i] < 0 || targetColumnOrder[i] >= targetColumnOrder.length) {
                throw new RuntimeException(String.valueOf(targetColumnOrder[i]) + " not in range");
            }
            found[targetColumnOrder[i]] = true;
            ++i;
        }
        i = 0;
        while (i < targetColumnOrder.length) {
            if (!found[i]) {
                throw new RuntimeException(String.valueOf(i) + " not in list");
            }
            ++i;
        }
        JTable firstTable = this.tables.get(0);
        int i2 = 0;
        while (i2 < this.numColumns) {
            if (i2 < targetColumnOrder.length && firstTable.convertColumnIndexToModel(i2) != targetColumnOrder[i2]) {
                int from = -1;
                int j = 0;
                while (j < this.numColumns) {
                    if (firstTable.convertColumnIndexToModel(j) == targetColumnOrder[i2]) {
                        from = j;
                        break;
                    }
                    ++j;
                }
                int to = i2;
                for (JTable table : this.tables) {
                    table.getColumnModel().moveColumn(from, to);
                }
            }
            ++i2;
        }
        for (JTable table : this.tables) {
            SwingSuiteUtilities.autoFitTableColumns(table, Integer.MAX_VALUE);
        }
    }

    public void setColumnOrder(List<Integer> columnOrder) {
        int[] columnsByNumber = new int[columnOrder.size()];
        int index = 0;
        Iterator<Integer> i = columnOrder.iterator();
        while (i.hasNext()) {
            columnsByNumber[index++] = i.next();
        }
        this.setColumnOrder(columnsByNumber);
    }

    public void setColumnOrder(String columnOrder) {
        String[] columns = columnOrder.split(",");
        int[] columnsByNumber = new int[columns.length];
        int i = 0;
        while (i < columns.length) {
            columnsByNumber[i] = Integer.parseInt(columns[i]);
            ++i;
        }
        this.setColumnOrder(columnsByNumber);
    }

    public String getColumnsList() {
        StringBuilder buffer = new StringBuilder();
        if (this.tables.size() > 0) {
            JTable table = this.tables.get(0);
            int numColumns = table.getColumnCount();
            int i = 0;
            while (i < numColumns) {
                buffer.append(table.convertColumnIndexToModel(i));
                if (i < numColumns - 1) {
                    buffer.append(',');
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.fromColumn = -1;
        this.toColumn = -1;
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (this.fromColumn >= 0 && this.toColumn >= 0 && this.fromColumn != this.toColumn) {
            JTableHeader sourceTableHeader = (JTableHeader)arg0.getSource();
            JTable sourceTable = sourceTableHeader.getTable();
            this.fireColumnMoved(sourceTable, this.fromColumn, this.toColumn);
        }
        this.fromColumn = -1;
        this.toColumn = -1;
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        int from = e.getFromIndex();
        int to = e.getToIndex();
        if (this.fromColumn < 0) {
            this.fromColumn = from;
        }
        this.toColumn = to;
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }
}

