/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import de.uwemock.guitools.PushUpPanel;
import de.uwemock.guitools.StandardDialogPanel;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class StandardDialogStackPanel
implements StandardDialogPanel {
    private String title;
    private PushUpPanel pushUpPanel;
    private JPanel contentsPanel;
    private Collection<StandardDialogPanel> panels = new LinkedList<StandardDialogPanel>();

    public StandardDialogStackPanel() {
        this.contentsPanel = new JPanel();
        this.pushUpPanel = new PushUpPanel(this.contentsPanel);
        this.contentsPanel.setLayout(new BoxLayout(this.contentsPanel, 1));
    }

    public StandardDialogStackPanel(String title) {
        this();
        this.title = title;
    }

    public void addPanel(StandardDialogPanel panel) {
        this.panels.add(panel);
        this.contentsPanel.add(panel.getComponent());
    }

    public void removePanel(StandardDialogPanel panel) {
        this.panels.remove(panel);
        this.contentsPanel.remove(panel.getComponent());
    }

    @Override
    public void dialogOpens() {
        for (StandardDialogPanel panel : this.panels) {
            panel.dialogOpens();
        }
    }

    @Override
    public void saveDialogData() {
        for (StandardDialogPanel panel : this.panels) {
            panel.saveDialogData();
        }
    }

    @Override
    public JPanel getComponent() {
        return this.pushUpPanel;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setOkAction(Action okAction) {
        for (StandardDialogPanel panel : this.panels) {
            panel.setOkAction(okAction);
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean mayBeCancelled() {
        return true;
    }
}

