/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.StandardDialogPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public class StandardDialog
extends JDialog {
    public static final int OK_RESULT = 1;
    public static final int CANCEL_RESULT = 2;
    public static final int BUTTONS_OK_CANCEL = 1;
    public static final int BUTTONS_OK = 2;
    public static final int ARRANGE_STACKED = 1;
    public static final int ARRANGE_TABBED = 2;
    private List<StandardDialogPanel> panels = new ArrayList<StandardDialogPanel>();
    private JButton okButton;
    private Action okAction;
    private int arrangement = 1;
    private int buttons = 1;
    private int result = 2;
    private boolean dialogSetupDone;
    private boolean stackedArrangementUsesTabs;
    private Frame parent;

    public StandardDialog(Frame parent, String title) {
        this(parent, title, 1);
        this.parent = parent;
    }

    public StandardDialog(Frame parent, String title, int buttons) {
        super(parent, title);
        this.setModal(true);
        this.buttons = buttons;
        this.createComponentTree();
        this.addCancelByEscapeKey();
        this.getRootPane().setDefaultButton(this.okButton);
    }

    public StandardDialog(Frame parent, String title, StandardDialogPanel panel) {
        this(parent, title);
        this.panels.add(panel);
    }

    public StandardDialog(Frame parent, String title, int buttons, StandardDialogPanel panel) {
        this(parent, title, buttons);
        this.panels.add(panel);
    }

    public StandardDialog(Frame parent, String title, List<StandardDialogPanel> panels) {
        this(parent, title);
        this.panels.addAll(panels);
    }

    public StandardDialog(Frame parent, String title, int buttons, List<StandardDialogPanel> panels) {
        this(parent, title, buttons);
        this.panels.addAll(panels);
    }

    private void createComponentTree() {
        this.setLayout(new BorderLayout(0, 10));
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.okAction = new AbstractAction(TextPool.getString("buttonOk")){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (StandardDialogPanel sdp : StandardDialog.this.panels) {
                    sdp.saveDialogData();
                }
                StandardDialog.this.result = 1;
                StandardDialog.this.setVisible(false);
            }
        };
        this.okButton = new JButton(this.okAction);
        buttonPanel.add(this.okButton);
        if (this.buttons == 1) {
            buttonPanel.add(new JButton(new AbstractAction(TextPool.getString("buttonCancel")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StandardDialog.this.closeDialog();
                }
            }));
        }
        this.add("South", buttonPanel);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StandardDialog.this.closeDialog();
            }
        });
    }

    public int getArrangement() {
        return this.arrangement;
    }

    public void setArrangement(int arrangement) {
        this.arrangement = arrangement;
    }

    public void addPanel(StandardDialogPanel panel) {
        this.panels.add(panel);
    }

    public void startNewTab(String title) {
        this.panels.add(new StartNewTabPanel(title));
        this.stackedArrangementUsesTabs = true;
    }

    @Override
    public void setVisible(boolean visibility) {
        for (StandardDialogPanel sdp : this.panels) {
            sdp.setOkAction(this.okAction);
        }
        if (!this.dialogSetupDone) {
            JTabbedPane tabbedPane;
            if (this.arrangement == 1) {
                if (this.stackedArrangementUsesTabs) {
                    tabbedPane = new JTabbedPane();
                    tabbedPane.setTabLayoutPolicy(1);
                    GridBagLayout gbl = new GridBagLayout();
                    JPanel currentPanelStack = new JPanel(gbl);
                    int y = 0;
                    Object title = "";
                    for (StandardDialogPanel sdp : this.panels) {
                        if (sdp instanceof StartNewTabPanel) {
                            if (y > 0) {
                                GuiTools.addComponent(currentPanelStack, gbl, Box.createGlue(), 0, y++, 1, 1, 1.0, 1.0);
                                tabbedPane.addTab((String)title, currentPanelStack);
                                gbl = new GridBagLayout();
                                currentPanelStack = new JPanel(gbl);
                                y = 0;
                            }
                            title = sdp.getTitle();
                            continue;
                        }
                        GuiTools.addComponent(currentPanelStack, gbl, sdp.getComponent(), 0, y++, 1, 1, 1.0, 0.0);
                        if (y != 1 || title != null) continue;
                        title = sdp.getTitle();
                    }
                    if (y > 0) {
                        GuiTools.addComponent(currentPanelStack, gbl, Box.createGlue(), 0, y++, 1, 1, 1.0, 1.0);
                        tabbedPane.addTab((String)title, currentPanelStack);
                    }
                    this.add("Center", tabbedPane);
                } else {
                    GridBagLayout gbl = new GridBagLayout();
                    JPanel panelStack = new JPanel(gbl);
                    int y = 0;
                    for (StandardDialogPanel sdp : this.panels) {
                        GuiTools.addComponent(panelStack, gbl, sdp.getComponent(), 0, y++, 1, 1, 1.0, 1.0);
                    }
                    this.add("Center", panelStack);
                }
            }
            if (this.arrangement == 2) {
                tabbedPane = new JTabbedPane();
                for (StandardDialogPanel sdp : this.panels) {
                    if (sdp instanceof StartNewTabPanel) continue;
                    GridBagLayout gbl = new GridBagLayout();
                    JPanel panel = new JPanel(gbl);
                    GuiTools.addComponent(panel, gbl, sdp.getComponent(), 0, 0, 1, 1, 1.0, 0.0);
                    GuiTools.addComponent(panel, gbl, Box.createGlue(), 0, 1, 1, 1, 1.0, 1.0);
                    tabbedPane.addTab(sdp.getTitle(), panel);
                }
                this.add("Center", tabbedPane);
            }
            this.pack();
            this.setMinimumSize(this.getSize());
            this.setLocationRelativeTo(this.parent);
            this.dialogSetupDone = true;
        }
        if (visibility) {
            for (StandardDialogPanel sdp : this.panels) {
                sdp.dialogOpens();
            }
        }
        super.setVisible(visibility);
    }

    public int getResult() {
        return this.result;
    }

    private void addCancelByEscapeKey() {
        String CANCEL_ACTION_KEY = "CANCEL_ACTION_KEY";
        int noModifiers = 0;
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, noModifiers, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(escapeKey, CANCEL_ACTION_KEY);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardDialog.this.result = 2;
                StandardDialog.this.closeDialog();
            }
        };
        this.getRootPane().getActionMap().put(CANCEL_ACTION_KEY, cancelAction);
    }

    private void closeDialog() {
        for (StandardDialogPanel sdp : this.panels) {
            if (sdp.mayBeCancelled()) continue;
            return;
        }
        this.setVisible(false);
    }

    public void finalize() throws Throwable {
        if (this.isDisplayable()) {
            this.dispose();
        }
        super.finalize();
    }

    @Override
    public void dispose() {
        for (StandardDialogPanel sdp : this.panels) {
            sdp.dispose();
        }
        super.dispose();
    }

    private static class StartNewTabPanel
    implements StandardDialogPanel {
        private String title;

        public StartNewTabPanel(String title) {
            this.title = title;
        }

        @Override
        public void dialogOpens() {
        }

        @Override
        public void saveDialogData() {
        }

        @Override
        public Component getComponent() {
            return null;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public void setOkAction(Action okAction) {
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean mayBeCancelled() {
            return true;
        }
    }
}

